/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/************************************************************************/
/* Programm starten                                                     */
/*----------------------------------------------------------------------*/
void ccpstart()
{
  if (issyso()) {
    tnnexec((char *)clipoi);
#ifndef MC68302                     /* da gibs mehrere Fehlermeldungen */
    putmsg("Invalid program!\r");
#endif
  }
}

/************************************************************************/
/* Parameter anzeigen/aendern                                           */
/*----------------------------------------------------------------------*/
void ccppar()
{
  ccp_par("Parms:\r", partab, partablen);
}

/**************************************************************************/
/* RESET                                                                  */
/*------------------------------------------------------------------------*/
void ccpres()
{
  MBHEAD *mbp;
  WORD    port;

  if (issyso()) {
    if (strnicmp((char *)clipoi,"SYSTEM",6) == 0)
      HALT("sysop");
    if (getport(&clicnt, &clipoi, &port)) {
      mbp = putals("RESET Port ");
      putnum(port, mbp);
      putchr('\r', mbp);
      prompt(mbp);
      seteom(mbp);
      l1ctl(L1CRES, port);
    } else
      putmsg("Invalid Port!\r");
  } else
    invmsg();
}

/************************************************************************/
/* PROMPT                                                               */
/*----------------------------------------------------------------------*/
void ccpprompt()
{
  MBHEAD *mbp;
  WORD i;

  if (issyso() && *clipoi == '=') {
    if (clicnt > 0)
    {
      clicnt--;
      clipoi++;
    }
    for (i = 0; i < 79 && clicnt--; promptstr[i++] = *clipoi++);
    promptstr[i] = 0;
  }
  mbp = putals("Prompt: ");
  putstr(promptstr, mbp);
  putchr('\r', mbp);
  prompt(mbp);
  seteom(mbp);
}

#ifdef MC68302
/************************************************************************/
/* DELETE - Befehl (Dateien loeschen)                                   */
/*----------------------------------------------------------------------*/
void ccpdelete()
{
  MBHEAD *mbp;
  char file[128];

  if(issyso()) {
    strcpy(file, clipoi);
    mbp = putals(file);
    if (remove(file))
      putstr(" not deleted!\r", mbp);
    else
    {
      compact();
      putstr(" deleted.\r", mbp);
    }
    prompt(mbp);
    seteom(mbp);
  }
  else
    invmsg();
}

/************************************************************************/
/* ccpcopy                                                              */
/************************************************************************/
void ccpcopy()
{
  FILE *f1;
  FILE *f2;
  size_t n;
  char buf[512];
  char buf2[40];
  char file1[80];
  char file2[80];
  MBHEAD *mbp;

  if(issyso())
  {
    if(clicnt > 0)
    {
      skipsp(&clicnt, &clipoi);
      *file1 = *file2 = '\0';
      sscanf(clipoi, "%s %s", file1, file2);

      if(*file1 && *file2)
      {
        mbp = getmbp();
        strcpy(buf2, "OK\r");
        if((f1 = fopen(file1, "rb")) != NULL)
        {
          if((f2 = fopen(file2, "wb")) != NULL)
          {
            while ((n = fread(buf, 1, 512, f1)) > 0)
            {
              if (fwrite(buf, 1, n, f2) != n)
              {
                strcpy(buf2, "write error !\r");
                remove(file2);
                break;
              }
            }
            fclose(f1);
            fclose(f2);
            compact();
          }
          else
          {
            sprintf(buf2, "can't create %s !\r", file2);
          }
        }
        else
        {
          sprintf(buf2, "can't open %s !\r", file1);
        }
        putstr(buf2, mbp);
        prompt(mbp);
        seteom(mbp);
      }
    }
  }
  else
    invmsg();
}

/************************************************************************/
/* ccpdir                                                               */
/************************************************************************/
void ccpdir()
{
  char file[128];
  MBHEAD *mbp;
  struct ffblk fblock;
  int lastentry;
  struct tm *ftime;
  int einfach, cnt;

  einfach = FALSE;
  if(userpo->sysflg != 0) {             /* Benutzer ist Sysop           */
    strcpy(file, textpath);             /* Verzeichnis der Texte        */
    if(clicnt > 0) {                    /* Parameter folgen             */
      skipsp(&clicnt, &clipoi);         /* Nachfolgende Leerzeichen     */
      if(strncmp(strlwr(clipoi), "/w", 2) == 0) {       /* Einfache Ausgabe     */
      nextspace(&clicnt, &clipoi);
      skipsp(&clicnt, &clipoi);         /* Nachfolgende Leerzeichen     */
      if(clicnt > 0)                    /* vorhandene Dateimaske        */
        strcat(file, clipoi);           /* an Pfad dranhngen           */
      else                              /* sonst:                       */
        strcat(file, "*.*");            /* alles auswhlen              */
      einfach = TRUE;
      }
      else {
        strcat(file, clipoi);
      }
    }
    else {
      strcat(file,"*.*");
    }
    mbp = getmbp();
    cnt = 0;
    lastentry = findfirst(file, &fblock, 0);
    while (!lastentry) {
      if(einfach) {
        putprintf(mbp,"%15s", fblock.ff_name);
        if(++cnt == 5) {
          putchr('\r', mbp);
          cnt = 0;
        }
      } else {
        ftime = localtime(&fblock.ff_ftime);
        putprintf(mbp,"%12s %8ld Bytes  %2.2d.%02d.%02d %2.2d:%02d:%02d\r",
            fblock.ff_name, fblock.ff_fsize,
            ftime->tm_mday, (ftime->tm_mon)+1, ftime->tm_year%100,
            ftime->tm_hour, ftime->tm_min, ftime->tm_sec);
      }
      lastentry = findnext(&fblock);
    }
    if(einfach) putstr("\r", mbp);
    compact();
    putprintf(mbp,"%lu Bytes free\r", coreleft());
    prompt(mbp);
    seteom(mbp);
  }
  else
    invmsg();
}
#endif

#ifndef MC68302
/************************************************************************/
/* SHELL/DOS/TOS                                                        */
/*----------------------------------------------------------------------*/
void ccpshell()
{
  char sysline[MAXPATH+1];

  if (issyso())                         /* darf nur ein Sysop           */
  {
    strncpy(sysline, (char *)clipoi, MAXPATH);
    sysline[MAXPATH] = 0;
    if (tnnshell(sysline) == TRUE) return;      /* und ausfuehren       */
    /* tnnshell() liefert in sysline den Namen der temporaeren Datei,   */
    /* die die Ausgabe der Shell enthaelt.                              */
    if (*sysline) {
      userpo->fdefblk = (MB *) allocb();
      strcpy(userpo->fdefblk->data, sysline);
      relink((LEHEAD *)userpo->fdefblk,(LEHEAD *)fdfl.tail);
      ccpread(sysline);                 /* Ergebniss dem User sagen     */
    }
    else
      invmsg();
  }
  else
    invmsg();
}
#endif

/* Commandotabelle fuer die Porteinstellung, alles was hier nicht erscheint,
   wird als Gertename interpretiert und an l1attach() bergegen. */
#define PO_DETACH 1
#define PO_NAME   2
#define PO_TXD    3
#define PO_MODE   4
#define PO_MAXF   5
#define PO_CTEXT  6
#define PO_SYSOP  7
#define PO_MH     8
#define PO_DAMA   9
PORTCMD portcmd[] = {
  {"OFF",             PO_DETACH },
  {"NAME",            PO_NAME   },
  {"TXDELAY",         PO_TXD    },
  {"MODE",            PO_MODE   },
  {"MAXFRAME",        PO_MAXF   },
  {"CTEXT",           PO_CTEXT  },
  {"SYSOP",           PO_SYSOP  },
  {"MH",              PO_MH     },
  {"DAMA",            PO_DAMA   },
  {NULL,              0         }
};

/************************************************************************/
/*                                                                      */
/*----------------------------------------------------------------------*/
#ifdef MC68302
void hsbus_stat(MBHEAD *);
#endif

void ccpport()
{
  MBHEAD *mbp;                          /* message-buffer-pointer       */
  WORD       port;                      /* Port-Nummer (0..L2PNUM)      */
  char       buf[80];
  void       put_pcnf(WORD, MBHEAD *);
  PORTCMD   *pc;
  char      *bps;
  WORD       bcs, found;
  UWORD      baud;
  ULONG      lbaud;
  char       mode[16];
  L1MODETAB *mtp;
  PORTINFO  *p;
  WORD       begport = 0;
  WORD       endport = L2PNUM-1;

  skipsp(&clicnt, &clipoi);

  if (*clipoi == '*') { /* Ausgabe der Autoparameter */
    mbp = putals("Port Parameters:"
           "\r-#-Port-------TXDelay-Pers--Slot-IRTT-MaxFrame-L2Retry-Timer2\r");
    for (port = 0, p = portpar; port < L2PNUM; p++, port++) {
      if (!portenabled(port))
	    continue;
	  putprintf(mbp, "%2u:%-10s  %3u     %3u  %3u  %4u     %1u       %2u     %4u\r",
	  		    port,
                p->name,
	  		    p->txdelay,
			    p->persistance,
		  	    p->slottime,
			    p->IRTT,
			    p->maxframe,
			    p->retry,
			    p->T2);
    }
    prompt(mbp);
    seteom(mbp);
    return;
  }
#ifdef MC68302
  if (*clipoi == '?') { /* Ausgabe der Inquiry (vorerst nur hskiss) */
    mbp = putals("Port-Inquiry:\r"
                 "Po. Software-Version                 TxD Per Slt  Tail Dup DAMA    Baud Duo\r");
    hsbus_stat(mbp);
    prompt(mbp);
    seteom(mbp);
    return;
  }
#endif

  if (issyso() && clicnt) {
    port = nxtnum(&clicnt, &clipoi);
    if (port >= 0 && port < L2PNUM && skipsp(&clicnt, &clipoi)) {
      p = &portpar[port];
      l1ctl(L1CCMD, port);                   /* HB9PAE/DB7KG         */
      do {
        *buf = '\0';
        bps = buf;
        if (skipsp(&clicnt, &clipoi)) {
          while(*clipoi && isalnum(*clipoi)) {
            *bps++ = toupper(*clipoi++);
            --clicnt;
          }
          *bps = '\0';
        }
        if (!*buf) {
          clicnt = 0;
          break;
        }
        bcs = (WORD)strlen(buf);

        for (pc = portcmd, found = 0;
             !found && pc->cmdstr != NULL;
             ++pc) {
          if (!strncmp(pc->cmdstr, buf, (size_t)bcs))
            found = pc->cmdpar;
        }

        if (found) {
          switch (found) {
            case PO_DETACH:
              l1detach(port);
              break;

            case PO_NAME:
              if (clicnt > 1) {
                clipoi++;
                clicnt--;
                if (sscanf((char *) clipoi,"%10s", buf) == 1) {
                  strcpy(p->name, buf);
                  bcs = (WORD)strlen(buf);
                  clipoi += bcs;
                  clicnt -= bcs;
                }
              }
              break;

            case PO_TXD:
              p->txdelay = getparam(&clicnt, &clipoi, 0, 255, 25);
              l1ctl(L1CCMD, port);
              autopar(port);
              break;

            case PO_MODE:
              if (clicnt > 1) {
                clipoi++;
                clicnt--;
                *buf = 0;
                lbaud = -1L;
                sscanf((char *) clipoi,"%lu", &lbaud);
                if (lbaud != -1L) {
                  while (isdigit(*clipoi)) {
                    clipoi++;
                    clicnt--;
                  }
                  if (*clipoi != ' ') {
                    sscanf((char *) clipoi,"%8s", buf);
                    strcpy(mode, buf);
                    strlwr(mode);
                  } else
                    *mode = '\0';
                  CLR_L1MODE(port);
                  for (mtp = l1modetab; mtp->ch; mtp++)
                    if (strchr(mode, mtp->ch)) SET_L1MODE(port, mtp->mode);
                  if (lbaud > 4915200L)
                    baud = 49152U;
                  if (lbaud < 300L)
                    baud = 3;
                  else
                    baud = (UWORD) (lbaud/100L);
                  p->speed = baud;
                  nextspace(&clicnt, &clipoi);
                  l1ctl(L1CCMD, port);
                }
              }
              break;

            case PO_MAXF:
              p->maxframe = getparam(&clicnt, &clipoi, 1, 7, 2);
              break;

            case PO_CTEXT:
              if (getparam(&clicnt, &clipoi, 0, 1, 0))
                p->l2mode |= MODE_x;
              else
                p->l2mode &= ~MODE_x;
              break;

            case PO_SYSOP:
              if (getparam(&clicnt, &clipoi, 0, 1, 0))
                p->l2mode |= MODE_s;
              else
                p->l2mode &= ~MODE_s;
              break;

            case PO_MH:
              if (getparam(&clicnt, &clipoi, 0, 1, 0))
                p->l2mode |= MODE_h;
              else
                p->l2mode &= ~MODE_h;
              break;

            case PO_DAMA:
              if (getparam(&clicnt, &clipoi, 0, 1, 0))
                p->l2mode |= MODE_a;
              else
                p->l2mode &= ~MODE_a;
              break;

          } /* switch */
        }   /* if     */
        else
          l1attach(port, buf);
      } while(clicnt > 0);
      autopar(begport = endport = port); /* Auto-Parameter setzen */
    }
  }

  mbp = putals("Link-Interface Ports:\r");            /* Konfiguration zeigen */
  putstr(
    "-#-Name-----------Speed/Mode-Max-TXD---------------------Hardware--\r", mbp);
  for (port = begport; port <= endport; port++)
    put_pcnf(port, mbp);
  prompt(mbp);
  seteom(mbp);
}

/*----------------------------------------------------------------------*/
void put_pcnf(WORD port, MBHEAD *mbp)
{
  char  mode[16], *cp;
  ULONG baud;
  L1MODETAB *mtp;
  PORTINFO *p = &portpar[port];

  if (!portenabled(port))
    return;

  putprintf(mbp, "%2d %-10s ",
            port, p->name);

  cp = mode;
  for (mtp = l1modetab; mtp->ch; mtp++)
    if (p->l1mode & mtp->mode) *cp++ = mtp->ch;
  *cp = 0;

  baud = ((ULONG)p->speed) * 100L;
  putprintf(mbp," %8lu%-5s  %1u  %3u ", baud, mode, p->maxframe, p->txdelay);

  putstr(p->l2mode & MODE_a ? "DAMA "  : "     " , mbp);
  putstr(p->l2mode & MODE_x ? "CTEXT " : "      ", mbp);
  putstr(p->l2mode & MODE_s ? "SYSOP " : "      ", mbp);
  putstr(p->l2mode & MODE_h ? "MH "    : "   "   , mbp);

  l1hwstr(port, mbp);
  putchr('\r', mbp);
}

/************************************************************************/
/* HELP                                                                 */
/*----------------------------------------------------------------------*/
void ccphelp()                                  /* HELP - Befehl        */
{
  struct ffblk fb;
  char tmp[9];
  MBHEAD *mbp;
  char file[80];
  char *cp;
  WORD i,j;
  WORD next = 0;
  WORD       cnt;
  char      *poi;
#ifndef MC68K
  BOOLEAN found = FALSE;
#endif

  poi = clipoi;
  cnt = clicnt;

  clipoi = clilin;
  clicnt = strlen(clilin);

#ifndef MC68K
  if (issyso())                /* HELP.EXE fuer Sysops (OHS) suchen        */
    found = !do_file(sysopexepath);
  if (!found)                  /* HELP.EXE fuer User (OHU) suchen          */
    found = !do_file(userexepath);

  if (found)                   /* wenn es HELP.EXE gibt, sind wir fertig   */
    return;
#endif

  clipoi = poi;                /* die alte Hilfe                           */
  clicnt = cnt;

  if (clicnt == 0)             /* Kein Argument angegegen, kurzer HELP.TXT */
  {
    strcpy(file,textpath);
    strcat(file,"HELP.TXT");
    ccpread(file);
  }
  else
  {
    if (strnicmp((char *)clipoi, "INDEX", 5) == 0) /* Hilfe-Index ausgeben */
    {
      mbp = putals("HELP - Index:\r");
      strcpy (file,textpath);
      strcat (file,"*.HLP");
      if (xfindfirst(file, &fb, 0) == 0)
      {
        while (next == 0)
        {
          for (i = 0; i < 7; i++)
          {
            for (cp = fb.ff_name, j = 0; j < 8 && *cp != '.'; cp++, j++)
            {
              tmp[j] = *cp;
            }
            tmp[j] = '\0';
            putstr(tmp, mbp);
            for (; j<10; j++)
              putchr(' ', mbp);
            if ((next = xfindnext(&fb)) != 0)
              break;
          }
          putchr('\r', mbp);
        }
      }

      prompt(mbp);
      seteom(mbp);
    }
    else
    { /* HILFE-Info fuer angegebenen Befehl suchen und ausgeben */

      for (cp = tmp, i=0; clicnt-- && i<8 && isalnum(*clipoi); ++i)
        *cp++ = (char) toupper(*clipoi++);
      if (i < 8)
        *cp++ = '*';
      *cp = '\0';

      if (userpo->sysflg != 0)
      {
        sprintf(file, "%s%s.SLP", textpath, tmp);
        if (i && !xfindfirst(file, &fb, 0)) {
           strcpy(file, textpath);
           strcat(file, fb.ff_name);
           ccpread(file);
           return;
         }
      }

      sprintf(file, "%s%s.HLP", textpath, tmp);
      if (i && !xfindfirst(file, &fb, 0)) {
        strcpy(file, textpath);
        strcat(file, fb.ff_name);
        ccpread(file);
        return;
      }

      mbp = putals("No HELP available for \'");
      putstr(strtok(file,"*."), mbp);
      putstr("\'.\r",mbp);
      prompt(mbp);
      seteom(mbp);
    }
  }
}

/************************************************************************/
/* SUSPEND - Befehl                                                     */
/*----------------------------------------------------------------------*/
void ccpsusp()
 {
  SUSPEND *suspoi;
  MBHEAD  *mbp;
  char     call[L2IDLEN];
  WORD     i;
  WORD     port;
  int      mode;

  if (!issyso()) {                  /* nur der Sysop darf SUSPEND       */
    invmsg();
    return;
  }

  if (skipsp(&clicnt, &clipoi)) {
    mode = *clipoi++;
    clicnt--;
    port = nxtnum(&clicnt, &clipoi);
    if (getcal(&clicnt, &clipoi, FALSE, call) == TRUE)
      for (suspoi = sustab, i = 0; i < MAXSUSPEND; suspoi++, i++) {
        if (   suspoi->port == port
            && cmpcal(suspoi->call, call)
           ) /* erstmal austragen */
          suspoi->call[0] = '\0';
        if (   mode == '+'
            && suspoi->call[0] == '\0'
           ) {
          memcpy(suspoi->call, call, L2CALEN);
          suspoi->port = port;
          suspoi->okcount = nxtnum(&clicnt,&clipoi);
          break;
        }
      }
  }

  mbp = putals("Suspended are\r");
  for (suspoi = sustab, i = 0; i < MAXSUSPEND; suspoi++, i++)
  {
    if (*suspoi->call != '\0') {
      putcal(suspoi->call, mbp);
      putstr(" is restricted ", mbp);
      switch (suspoi->port) {
        case 254: putstr("to level-2 access\r", mbp);
                  break;
        case 255: putstr("to max ", mbp);
                  putnum(suspoi->okcount,mbp);
                  putstr(" simultanous connections\r", mbp);
                  break;
        default:  putstr("from using Port ", mbp);
                  putnum(suspoi->port, mbp);
                  putchr('\r', mbp);
      }
    }
  }
  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/* READB - Datei lesen (binaer)                                  DL1XAO   */
/*------------------------------------------------------------------------*/
#ifdef MC68K
LONG swaplong(LONG)0x4840;     /* SWAP.L D0    */
#endif

void ccpreadb(void)
{
  char   buf[1024];
  char   fn[14];
  char   *cp;
  WORD   c;
  WORD   i;
  UWORD  crc;
  LONG   pos;
  LONG   len;
  MBHEAD *mbp;

  if (issyso() && userpo->convers == NULLCONNECTION) { /* darf er ? */
    i = 0;
    for (cp = buf; clicnt-- && i < 128; i++)
      *cp++ = (char) toupper(*clipoi++);
    *cp = '\0';
    userpo->fp = (i == 0) ? NULL : xfopen(buf, "rb");

    if (userpo->fp != NULL) {
#ifndef MC68302
      getftime(fileno(userpo->fp), (struct ftime *)&pos);
#else
      getftime(buf, (struct ftime *)&pos);
#endif
#ifdef MC68K
      pos = swaplong(pos);
#endif
      if ((cp = strrchr(buf, '\\')) != NULL)/* Dateinamen isolieren */
        cp++;
       else
        cp = buf;
      strncpy(fn, cp, 12);
      fn[12] ='\0';
      len = 0L;
      crc = 0;                 /* CRC errechnen und Laenge bestimmen */
      while ((i = (WORD)fread(buf, 1, 1024, userpo->fp)) > 0) {
        len += i;
        for (cp = buf; i--; cp++)
          crc = crctab[crc >> 8] ^ ((crc << 8) | (UWORD)*cp);
      }
      mbp = getmbp();

      putprintf(mbp, "\r#BIN#%ld#|%u#$%08lX#%s\r", len, crc, pos, fn);
      send_msg(TRUE, mbp);
      fseek(userpo->fp, 0L, SEEK_SET);
      pos = 0L;
      LOOP {                                        /* und ausgeben */
        mbp = getmbp();
        for (i = 0; i < paclen; ++i) {
          if ((c = fgetc(userpo->fp)) == EOF) {
            putchr('\r', mbp);
            prompt(mbp);
            send_msg(TRUE, mbp);
            fclose(userpo->fp);
            userpo->fp = NULL;
            userpo->status = US_CCP;
            return;
          }
          putchr(c, mbp);
        }
        if (send_msg(FALSE, mbp)) {
          pos = ftell(userpo->fp);
        }
        else {
          dealmb((MBHEAD *)ulink((LEHEAD *) mbp));
          fseek(userpo->fp, pos, SEEK_SET);
          userpo->status = US_SBIN;
          return;
        }
      }
    }
    else {
      mbp = getmbp();
      putstr("File not found!\r", mbp);
      prompt(mbp);
      seteom(mbp);
    }
  }
  else
    invmsg();
}

/**************************************************************************/
/*                                                                      */
/* ESC Befehl  (nach einer Idee von DL9HCJ)                             */
/*             (Implementation: DL2LAY)                                 */
/*                                                                      */
/* Funktion : Ermoeglicht den Sysops den Remote-Zugriff auf Konsolen-   */
/*            ESC-Befehle                                               */
/* Syntax   : ESC <esc-befehl>                                          */
/*----------------------------------------------------------------------*/
void ccpesc(void)
{
  MBHEAD *mbp;
  char    esctab[] = "@ITVY";

  if (issyso())
   {
    if (clicnt != 0)
     {
      if (strchr(esctab, toupper(*clipoi)))
       {
        blipoi = (char *)clipoi;
        blicnt = clicnt;
        hstcmd(mbp = (MBHEAD *) allocb());
        mbp->l2link = g_ulink(userpo->uid);
        mbp->type   = g_utyp(userpo->uid);
        prompt(mbp);
        seteom(mbp);
       }
      else
        putmsg("Invalid Hostcommand\r");
     }
   }
  else
    invmsg();
}

/************************************************/
/* L2-QSO killen                                */
/************************************************/
void ccpkill(void) {
  #define ALLPORTS 255

  MBHEAD  *mbp, *msg;
  WORD    what = 0, i;
  char    call[L2IDLEN];
  char    syscall[L2IDLEN];
  UBYTE   mask[MAXMASK], port = 128;
  LNKBLK  *savlp = lnkpoi;
  BOOLEAN kill = 0;
  UWORD   kill_zaehler = 0;

  if (issyso())
  {
    mbp = getmbp();
    cpyid (syscall,calofs(UPLINK, userpo->uid));

    /* schaun ob ein Port angegeben wurde, wenn ja, dann diesen merken */

    if ((*clipoi >= '0') && (*clipoi <= '9' ))
    {
      if ((port = nxtnum(&clicnt, &clipoi)) <= L2PNUM) what = 3; /* Port angegeben ? */
      else port = 128;
    }

    if (*clipoi == '*')
    {
      if (*clipoi != 0) clipoi++;
      if (*clipoi != 0) clipoi++;
      port = ALLPORTS;         /* alle Ports killen ? */
      what = 3;
    }

    if ((port == 128) && (strlen ((char *)clipoi) > 3)) /* Call killen ? */
    {
      getcal(&clicnt, &clipoi, FALSE, call);
      what = 1;
      port = ALLPORTS;        /* Call auf allen Ports abwerfen */
    }

    if (what)
    {
        skipsp(&clicnt, &clipoi);

        /* nun die L2-Liste durchsehen und User ggfs abwerfen */

        for (lnkpoi = lnktbl, i = 0;i < LINKNMBR;++lnkpoi, ++i)
        {
          if  (lnkpoi->state  &&
              ((lnkpoi->liport == port) || (port == ALLPORTS)))
          {
              switch (what)
              {
                  case 1 : kill = (!strncmp (call, lnkpoi->srcid,7) ||
                                   !strncmp (call, lnkpoi->dstid,7));
                           break;
                  case 2 : kill = (c6mtch(lnkpoi->srcid, mask) ||
                                   c6mtch(lnkpoi->dstid, mask) );
                           break;
                  case 3 : if (!cmpid (lnkpoi->dstid,syscall))
                                               /* nicht den Sysop killen !  */
                                  kill = TRUE; /* jeden auf dem Port */
                              else
                                  kill = FALSE;
              }
              if (kill)
              {
                /*dealml((LEHEAD *)&lnkpoi->sendil);*/ /* clear send liste */
                /*lnkpoi->tosend = 0;               */ /* alles weg        */
                /*siehe Hinweis in L2DAMA           */
                if (   *clipoi
                    && lnkpoi->state >= L2SIXFER)   /* Msg ?            */
                {
                  msg = (MBHEAD *) allocb();    /* Buffer besorgen  */
                  msg->l2link = lnkpoi;
                  msg->type = 2;
                  putprintf(msg, "\r*** Msg from Sysop: %s ***\r", clipoi);
                  seteom(msg);
                }
                kill_zaehler++;    /* zaehlen      */
/*#define DEBUG*/
#ifdef DEBUG
                newlnk();
#else
                dsclnk();          /* und DISC     */
#endif
              }
           }
         }
         if (!kill_zaehler)
           putstr("No L2-link found.\r", mbp);
         else
          putprintf(mbp, "%3u link(s) disconnected.\r",kill_zaehler);
    }
    else
    {
      putstr("Syntax: KILL [Port] [Msg]\r", mbp);
      putstr("        KILL [Call] [Msg]\r", mbp);
      putstr("        KILL *      [Msg]\r", mbp);
    }

    lnkpoi = savlp;  /* Pointer restaurieren */
    prompt(mbp);     /* Prompt */
    seteom(mbp);     /* senden.... */
  }
  else invmsg();
}

/*----------------------------------------------------------------------*/
/* Save Befehl                                                          */
/*                                                                      */
/* Funktion : speichert die Parameter-Datei, generiert eine Text-Datei, */
/*            die als AUTOEXEC.TNB benutzt werden kann (PARMS.TNB)      */
/* Syntax   : SAVE                                                      */
/*----------------------------------------------------------------------*/
void ccpsave(void)
{
  MBHEAD    *mbp;

  if (!issyso())
  {
     invmsg();
     return;
  }

  save_stat();   /* Stat speichern */
  save_parms();  /* Parameter      */
  save_mh();     /* und MH-Liste   */

  mbp = getmbp();
  putstr("PARMS.TNB saved...\r", mbp);
  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/*                                                                        */
/* TRACE-Befehl                                                           */
/*                                                                        */
/* Funktion : Einloggen zur Systemueberwachung.                           */
/*                                                                        */
/*------------------------------------------------------------------------*/
void ccptrace(void)
{
  MBHEAD  *mbp;

  /* Bestehendes Monitoring wird ausgeschaltet */
  if (monitor) {
    if (userpo->monitor) {
      moncmd(NULL, userpo->monitor, "N", 1); /* Monitor abschalten */
      dealoc((MBHEAD *)userpo->monitor);
      userpo->monitor = NULL;
    }
  }
  userpo->auditlevel = 0;

  if (issyso()) {

    /* Audit-Level und Monitor setzen */
    userpo->auditlevel = nxtnum(&clicnt, &clipoi);
    if (skipsp(&clicnt, &clipoi)) {
      userpo->monitor = (MONBUF *)allocb();
      moncmd(NULL, userpo->monitor, clipoi, clicnt);
      if (!userpo->monitor->Mpar) { /* er ist nicht angegangen */
        dealoc((MBHEAD *)userpo->monitor);
        userpo->monitor = NULL;
      }
    }

    /* ... zur Kontrolle anzeigen */
    mbp = putals("Trace");
    if (userpo->auditlevel)
      putlong(userpo->auditlevel, FALSE, mbp);
    else
      putstr(" is off", mbp);
    if (userpo->monitor) /* Monitor-Status zeigen */
      moncmd(mbp, userpo->monitor, "", 0);
    else
      putchr('\r', mbp);
    prompt(mbp);
    seteom(mbp);     /* senden.... */
  } else
    invmsg();
}

/************************************************************************/
/*                                                                      */
/* RUNBATCH                                                             */
/*                                                                      */
/* Funktion : Batch ausfuehren (nur als Sysop)                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void ccprun(void)
{
  if (issyso()) {                   /* nur der Sysop darf               */
    if (skipsp(&clicnt, &clipoi))
      putmsg(runbatch((char*)clipoi) ? "OK\r" : "File not found\r");
    else
      putmsg("Syntax: RUNBATCH FILENAME.TNB\r");
  } else
    invmsg();
}

/**************************************************************************/
/*                                                                      */
/* DCD                                                                  */
/*                                                                      */
/* Funktion : Status der DCD pro Port anzeigen (fuer alle)              */
/*                                                                      */
/*----------------------------------------------------------------------*/
void ccpdcd(void)
{
  MBHEAD  *mbp;
  int      port;
  PORTINFO *p;
  int      dcd;

  mbp = putals("Data carrier detect:\r");
  for (port = 0; port < L2PNUM; port++) {
    putprintf(mbp, "P%02u", port);
    if (port <= 15) putchr(' ', mbp);
  }
  putchr('\r', mbp);
  for (port = 0, p = portpar; port < L2PNUM; p++, port++) {
    mbp->l4time = mbp->mbpc;
    if (portenabled(port)) {
      if ((dcd = iscd(port)) & DCDFLAG)
            putstr(dcd & RXBFLAG ? "R" : "r", mbp);
      if (dcd & PTTFLAG)
            putstr(dcd & TXBFLAG ? "T" : "t", mbp);
    } else
      putstr("OFF", mbp);
    if (port <= 15) putspa(4, mbp);
  }
  putchr('\r', mbp);
  prompt(mbp);
  seteom(mbp);
}

#ifdef GRAPH
/*---------------------------------------------------------------------------*/
/* GRAPH                                                                     */
/*                                                                           */
/* Funktion: zeigt einen Textgrahpen an und speichert ihn in ueberlieferten  */
/*           mbp. Zur Graphengestaltung werden nur niederwertige Asciis ver- */
/*           wendet.                                                         */
/*---------------------------------------------------------------------------*/
ULONG graph_values[GRAPH_MAXSELECT][GRAPH_ELEMENTS];
ULONG graph_day[GRAPH_MAXSELECT][48];
WORD  graph_day_aktpos=50;                      /* 50 ist kein Schreibfehler */
/*---------------------------------------------------------------------------*/
void ccpgraph(void)
{ void      showgraph(int,int,int,MBHEAD *mbp);
  MBHEAD   *mbp;
  int      timeart,select,expand;
  char      timemode,selectmode;

  mbp = getmbp();
  putchr('\r',mbp);

  timemode= toupper(*clipoi);

  switch (timemode) {
    case 'D': timeart=1;break;
    default : timeart=0;
  }
  if (timeart) {
    clipoi++;
    clicnt--;
    skipsp(&clicnt, &clipoi);
    selectmode=toupper(*clipoi);
  }
  else selectmode=timemode; /* da ja schon ausgelesen */
  switch (selectmode){
    case 'B':select=GRAPH_THROUGHPUT;break;
    case 'C':select=GRAPH_CIRCUITS;break;
    case 'F':select=GRAPH_FREEBUFFER;break;
    case 'L':select=GRAPH_L2LINKS;break;
    case 'N':select=GRAPH_NODES;break;
    case 'R':select=GRAPH_ROUNDSPSEC;break;
    case '*':select=GRAPH_MAXSELECT;break;
    default :select=-1;break;
  }

  /* expandet Mode feststellen */
  clipoi++;
  clicnt--;
  skipsp(&clicnt, &clipoi);
  if (*clipoi=='+') expand=1; else expand=0;

  /* Bei fehlerhafte Eingabe Hinweis und Zurueckkehren */
  if (select==-1) {
    putstr("(G)raph (D)ay (B)aud\r"
	   "              (C)ircuits\r"
           "              (F)ree buffers\r"
	   "              (L)2-Links\r"
	   "              (N)odes\r"
	   "              (R)ounds\r",mbp);
   prompt(mbp);
   seteom(mbp);
   return;
  }
  if (select==GRAPH_MAXSELECT) {
    showgraph(timeart,GRAPH_THROUGHPUT,expand,mbp);
    showgraph(timeart,GRAPH_CIRCUITS,expand,mbp);
    showgraph(timeart,GRAPH_FREEBUFFER,expand,mbp);
    showgraph(timeart,GRAPH_L2LINKS,expand,mbp);
    showgraph(timeart,GRAPH_NODES,expand,mbp);
    showgraph(timeart,GRAPH_ROUNDSPSEC,expand,mbp);
  }
  else showgraph(timeart,select,expand,mbp);
  prompt(mbp);
  seteom(mbp);
}
/*---------------------------------------------------------------------------*/
/* Funktion showgraph()                                                      */
/*                                                                           */
/* int timeart: 0: Ueberblick 3600 Sekunden (Input)                          */
/*              1: Ueberblick 24 Stunden (Input)                             */
/* int select:  Welche Werte ausgeben (Input)                                */
/* int expand:  0: Diagramm nicht dehnen (Input)                             */
/*              1: Diagramm zwischen Max und Min strecken                    */
/* MBHEAD *mhp: Stringuebergabe (Output)                                     */
/*---------------------------------------------------------------------------*/
void showgraph(int timeart,int select,int expand,MBHEAD *mbp)
{ LONG  i=0;
  ULONG raster=0L;                       /* noetig fuer Y-Achse (Werteachse) */
  ULONG wert;                  /* beinhaltet Wert aus graph_values oder _day */
  ULONG maximum,minimum,average;
  ULONG expandwert;                               /* enthaelt minimum oder 0 */
  WORD  letztezeile=1;            /* bei expand=1 , die 0. Zeile mitausgaben */
  WORD  elements;               /* entweder GRAPH_ELEMENTS oder 48 halbe Std */
  WORD  averagenum;
  int   lines=GRAPH_LINES;
  char zeile[128];   /* noetig um Zeilen von Leerzeichenballast zu entfernen */

  switch (select) {
    case GRAPH_FREEBUFFER:  putstr("Free buffers:",mbp);break;
    case GRAPH_CIRCUITS:    putstr("Circuits:",mbp);break;
    case GRAPH_L2LINKS:	    putstr("L2-Links:",mbp);break;
    case GRAPH_NODES:	    putstr("Nodes:",mbp);break;
    case GRAPH_ROUNDSPSEC:  putstr("Rounds per seconds:",mbp);break;
    case GRAPH_THROUGHPUT:  putstr("Throughput (Baud):",mbp);break;
    default: 		    select=GRAPH_FREEBUFFER;
			    putstr("Free buffers:",mbp);
  }

  /* Anzahl der Elemente festlegen */
  switch (timeart) {
    case  1: elements=48;break;
    default: elements=GRAPH_ELEMENTS;
  }

  /* Minima und Maxima Werte bestimmen */
  minimum=0xffffffffL;
  maximum=average=0L;
  averagenum=0;

  for(i=0;i<elements;i++) {
    switch (timeart) {
                 /* nichtgesetzte Werte und akt. Tagesposition nicht ausgeben*/
      case 1: if (graph_day[select][i]!=0xffffffffL && i!=graph_day_aktpos)
                  wert=graph_day[select][i]/180;
              else wert=0xffffffffL;break;
     default: wert=graph_values[select][i];
    }
    if (maximum<wert && wert!=0xffffffffL) maximum=wert;
    if (minimum>wert) minimum=wert;
    if (wert!=0xffffffffL) {
       average += wert;
       averagenum++;   /* gibt die wirkliche Anzahl der gesetzen Elemente an */
    }
  }                                             /* jedes Element durchlaufen */

  /* Fuer Ausgabe umsetzen */
  if (minimum==0xffffffffL) minimum=0;
  if (maximum==0xffffffffL) maximum=0;

  if (maximum>0)           putprintf(mbp,"  Maximum: %ld",maximum);
  if (averagenum>0 && average>0) 
    putprintf(mbp,"  Average: %ld",average/averagenum);
  putprintf(mbp,"  Minimum: %ld\r\r",minimum);


  /* im Expandmode: Alle Zeilen unter Minimum gelassen, so stehen */
  /* 5-15 Zeilen fuer Werte zwischen Min und Max zu Verfuegung    */
  if (expand==1) maximum -=minimum;

  /* Zeilenraster ermitteln */
  raster=maximum/GRAPH_LINES;
  if (maximum%GRAPH_LINES>0) raster++;               /* like function ceil() */
  if (raster==0) raster=1;                      /* Divison by zero vorbeugen */

  /* genaue Zeilenanzahl ermitteln */
  lines=maximum/raster;                /*schwankt zwischen 5 und GRAPH_LINES */
  if (maximum%raster>0) lines++;                     /* like function ceil() */
  if (lines<5) lines=5;                      /* min. sollen es 5 Zeilen sein */

  
  /* Damit Minimalzeile im Expandmode mitangezeigt wird */
  if (expand==1 && minimum>0) letztezeile=0; else letztezeile=1;

  /* so, die einzelnen Zeilen generieren */
  lines++;                           
  if (expand==1) expandwert=minimum; else expandwert=0;
  do
  { lines--;
    sprintf(zeile,"%6lu|",(ULONG)raster*lines+expandwert);
    for (i=0;i<elements;i++)
    {  switch (timeart){
         case 1: if (graph_day[select][i]!=0xffffffffL && i!=graph_day_aktpos)
                       wert=graph_day[select][i]/180;
                 else wert=0xffffffffL;break;
        default: wert=graph_values[select][i];
       }

       if (wert>=raster*lines+expandwert && wert!=0xffffffffL)
         strcat(zeile,"#");
       else strcat(zeile," ");
    }
    /* unnoetige Zeichen loeschen, um Datenausgabe zu reduzieren */
    for(i=strlen(zeile);i>0;i--)
      if (zeile[i]=='#' || zeile[i]=='|')
      {	zeile[i+1]='\0';
	break;
      }
    putstr(zeile,mbp);
    putchr('\r',mbp);

  } while(lines!=letztezeile);  /* naechste Zeile */

  /* untere Zeile generieren */
  putstr("      +",mbp);
  for (i=0;i<elements;i++) putchr('-',mbp);

  if (timeart==1) {
  putstr("\r       00  02  04  06  08  10  12  14  16  18  20  22\r"
	  "         01  03  05  07  09  11  13  15  17  19  21  23 Hour\r\r",mbp);
  } else
  {
    putstr(" Elap. time\r      ",mbp);
    for (i=elements;i>0;i--)
    if (i % 6 == 0) putprintf(mbp,"-%-5lu",i*GRAPH_INTERVAL);
    putstr("0 Seconds\r\r",mbp);
  }
}
#endif

/* End of L7CMDS.C */
