/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/*----------------------------------------------------------------------*/
/* Meldetext und Version, Datum und Zeit automatisch eingebunden        */
/*----------------------------------------------------------------------*/

/* Die naechsten beiden Zeilen werden bei einem Hauptrelease geaendert  */
#define __NAME__     "TheNetNode"
#define __VER__      "1.76"

/* #define DEBUG */

#define __AUTHOR__   ""         /* Monogramm des Autors/Programmierers  */
#define __PATCH__    ""         /* Patch-Level des Autors               */

/* Zuerst legen wir die variierenden Texte mal fest                     */
#ifdef __LINUX__
#  define __SYSTEM__                   " (Linux)"
#else
#  ifdef __GNU32__
#    define __SYSTEM__                 " (GNU32)"
#  else
#    ifdef ST
#      define __SYSTEM__               " (ST)"
#    else
#      ifdef __FALCON__
#        define __SYSTEM__             " (FALCON)"
#      else
#        ifdef __DOS16__
#          define __SYSTEM__           " (DOS16)"
#        else
#          ifdef MC68302
#            define __SYSTEM__         " (TNC3)"
#          else
#            ifdef __WIN32__
#              define __SYSTEM__       " (WIN32)"
#            else
#              define __SYSTEM__       " (unknown)"
#            endif
#          endif
#        endif
#      endif
#    endif
#  endif
#endif

/* Aufbau der Versionskennung, diesmal was uebersichtlicher **************/

char signon[]  = __NAME__ __SYSTEM__
                      ", " __VER__ __AUTHOR__ __PATCH__ " (";

char version[] = __NAME__ __SYSTEM__
                      ", " "Version " __VER__ __AUTHOR__ __PATCH__
#ifdef DEBUG
                      " ("__DATE__")\r"
                      "        ALPHA-TEST SOFTWARE, USE ONLY FOR DEBUG PURPOSES.\r";
#else
                      " ("__DATE__")\r";
#endif

char cfgfile[] = "TNN176";

char loginstr[] = "TNN V" __VER__ __SYSTEM__ "\r";

char infostr[] = "TNN176";

/* End of VERSION.C */
