/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/l3c.c (maintained by: ???)                                  */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998, 1999 NORD><LINK e.V. Braunschweig                */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/* definitionen */
/* FlexNet 0er Frames */

/* BYTE 0              */
#define SOFTKENNUNG  0x23
/* Bit 0..2  Software  */
/* 000 Flex Net        */
/* 001 BayCom Node     */
/* 010 Digi Ware       */
/* 011 TheNetNode      */
/* 100 SNet            */
/* 101 .. 111  reserve */
#define S_FLEXNET  0
#define S_BAYCOM   1
#define S_DIGIWARE 2
#define S_THENET   3
#define S_SNET     4
/* Bit 3  Virtuelle Adressierung, 0 = disable, 1 = enable  */
#define S_VFLAG    8
/* Bit 4  frei , 0     */
/* Bit 5  frei , 1     */
/* Bit 6  frei , 1     */
/* Bit 7  frei , 0     */

/* BYTE 1 Version      */
#define SOFTVERSION  0x11

#define TOKEN_ER        0
#define TOKEN_ER_REQ    1
#define TOKEN_ICH       2
#define TOKEN_ICH_REQ   3

#define LOWER   -1
#define HIGHER   1
#define SAME     0

/* Messzeit in Sekunden, hat beim FlexNet nur einen Sinn,
 * wenn noch kein Connect steht, ansonsten gibt diese
 * Zeit nur die Pausen zwischen zwei Local-Tests an
 */

int     callcompare(char *, char *);
void    flex_tx_rtt_query(PEER *pp);
void    flex_tx_init(PEER *pp);
void    flex_tx_routes(PEER *pp);
void    discnbp(PEER *pp);
static void flex_route_reply(char *);
static MBHEAD *getfbp(UBYTE, LNKBLK *, const char *format, ...);
static void sendfbp(MBHEAD *);
static void flex_tx_rtt_reply(PEER *);

extern UWORD flexmode;

#define FLEX_MASK VC|VC_FAR

void localsrv(void)
{
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used) {
      if (pp->typ == LOCAL_M) {
        if (pp->rttstart) continue; /* Messung unterwegs?               */
        if (pp->nbrl2l) discnbp(pp);/* ... Leichen abwerfen             */
        else
          if (pp->rtt_time == 0) {  /* Messzeit abgelaufen?             */
            if (connbr(pp))
              pp->rttstart = tic10; /* Start Zeitmessung                */
          } else pp->rtt_time--;
      }
    }
}

void flexsrv(void)
{
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used) {
      if (pp->typ == FLEXNET) {
        if (pp->nbrl2l == NULL) {        /* gibt es einen Link?       */
          connbr(pp);                    /* sonst neu connecten       */
          continue;
        }
        if (pp->nbrl2l->state < L2SIXFER)
          continue;                      /* und ist er aktiv?         */
        if (pp->rttstart) {              /* Laufzeitmessung unterwegs?*/
          if (tic10-pp->rttstart >= 6000L) /* maximal 60 Sekunden     */
            discnbp(pp);                 /* sonst abwerfen            */
          continue;
        }

        if (pp->rtt_time == 0)           /* Zeit fuer neue Messung    */
          flex_tx_rtt_query(pp);
        else pp->rtt_time--;             /* sonst weiterwarten        */

        if (pp->quality)
         {
          if (pp->brotim == 0)           /* Zeit fuer neue Meldung?   */
            flex_tx_routes(pp);          /* Meldungen uebertragen     */
          else pp->brotim--;
         }
      }
    }
}

/*----------------------------------------------------------------------*/
/* eine Status-Aenderung fuer die LOCALS (gemessene) behandeln          */
/*----------------------------------------------------------------------*/
void local_status(PEER *pp, WORD status)
{
  unsigned long rtt;
  int index;

  if (pp->typ == LOCAL_M) {
    switch (status) {
      case L2MCONNT :
      case L2MLRESF :
      case L2MLREST :
        discnbp(pp);
      case L2MBUSYF :
        if (pp->rttstart) {
          rtt = (tic10 - pp->rttstart) + 1;
          update_peer_quality(pp, rtt, DONT_CHANGE_QUAL);
          if ((index = add_route(pp, pp->l2link->call, (unsigned)pp->quality)) != -1) {
            update_lt(pp, index, 1);
            update_alias(index, pp->l2link->alias);
          }
          rtt_metric(pp, rtt);
        }
        pp->rttstart = 0;
        pp->rtt_time = MESSTIME;
        break;
      case L2MFAILW :
        if (pp->rttstart) {
          update_peer_quality(pp, 0L, DONT_CHANGE_QUAL);
          add_route(pp, pp->l2link->call, 0);
        }
      case L2MDISCF :
        pp->rttstart = 0;
        pp->rtt_time = MESSTIME;
        break;
    }
  }
}

/*----------------------------------------------------------------------*/
/* eine Status-Aenderung fuer die FLEXNET behandeln                     */
/*----------------------------------------------------------------------*/
void flex_status(PEER *pp, WORD status)
{
  if (pp->typ == FLEXNET) {
    switch (status)
    {
      case L2MCONNT :
      case L2MLRESF :
      case L2MLREST :
        pp->token = (callcompare(pp->l2link->call, myid) == LOWER)?
                    TOKEN_ER:TOKEN_ICH;
        connect_peer(pp);
        flex_tx_init(pp);           /* Init-Frame schicken              */
        flex_tx_rtt_query(pp);      /* und Laufzeitmessung              */
        break;

      default :
        update_peer_quality(pp, 0, DONT_CHANGE_QUAL);
        disconnect_peer(pp);
        break;
    }
    pp->brotim =                    /* mit Broadcast beginnen           */
    pp->rttstart =                  /* Messung zuruecksetzen            */
    pp->rtt_time = 0;
  }
}

/*
 * Ein Frame mit einer bestimmten PID anlegen und Verweis auf den
 * zugehoerigen Link speichern.
 */
static MBHEAD *getfbp(UBYTE pid, LNKBLK *lnkpoi, const char *format, ...) {
  va_list  arg_ptr;
  char     str[256];
  MBHEAD  *fbp;

  va_start(arg_ptr, format);        /* String formatieren               */
  vsprintf(str, format, arg_ptr);
  va_end(arg_ptr);

  (fbp = (MBHEAD *) allocb())->l2fflg = pid;
  fbp->l2link = lnkpoi;             /* zugehoerigen Link speichern      */
  putstr(str, fbp);                 /* Text in das Frame speichern      */
  return(fbp);
}

/*
 * Ein Frame an den Level 2 senden (muss mit getfbp erzeugt worden sein)
 */
static void sendfbp(MBHEAD *fbp) {
  rwndmb(fbp);                      /* Frame zurueckspulen              */
  i3tolnk(fbp->l2fflg, fbp->l2link, fbp);
}

#define FLEXSSID(id) (((id[L2IDLEN-1]&0x1e)>>1)+'0')

/*
 * Flexnet Initialisierungs-Frame senden, dort sind die maximale SSID und
 * diverse Kennungen enthalten
 */
void flex_tx_init(PEER *pp) {
  sendfbp(getfbp(L2CFLEXNET, pp->nbrl2l,
          "0"                       /* Frame-Kennung                    */
          "%c"                      /* maximale SSID                    */
          "%c%c"                    /* Software-Name und Version        */
          "%s",                     /* TheNetNode-Version               */
          FLEXSSID(myid),
          SOFTKENNUNG,
          SOFTVERSION,
          version));
}

/*
 * Flexnet Laufzeitmessungs-Antwort senden, es enthaelt unsere eigene
 * Laufzeit*2 (Flexnet uebertraegt Hin-und-Rueck-Laufzeiten).
 */
static void flex_tx_rtt_reply(PEER *pp) {
  sendfbp(getfbp(L2CFLEXNET, pp->nbrl2l,
          "1"                       /* Frame-Kennung                    */
          "%lu",                    /* unsere Laufzeit                  */
          pp->my_quality ? pp->my_quality/10L : pp->nbrl2l->SRTT/10L));
}

/*
 * Flexnet Laufzeitmessungs-Frame senden
 */
void flex_tx_rtt_query(PEER *pp) {
  MBHEAD *fbp;

  fbp = getfbp(L2CFLEXNET, pp->nbrl2l,
               "2");                /* Frame-Kennung                    */
  while (fbp->mbpc < 256)           /* auf 256 Bytes auffuellen         */
    putchr(' ', fbp);
  sendfbp(fbp);
  pp->rttstart = tic10;             /* Startzeit der Messung merken     */
}

/*
 * Flexnet Routing-Inforamtions-Frame senden, hier wird die
 * Tokenuebergabe (was fuer ein Loetzinn...) und die Sendung
 * von Routing-Informationen durchgefuehrt.
 */
void flex_tx_routes(PEER *pp) {
  MBHEAD   *fbp = NULL;
  int       index;
  int       max_nodes = netp->max_nodes;
  NODE     *np = netp->nodetab;
  ROUTE    *rp = pp->routes;
  PEER     *bestpp;
  unsigned  quality;
  unsigned  reported_quality;
  unsigned  diff;

  switch (pp->token) {              /* je nach Token-Status             */
    case TOKEN_ICH_REQ:             /* ich warte auf Token und es kommt */
      discnbp(pp);                  /* nicht                            */
      notify(1, "token lost %6.6s", pp->l2link->call);
      return;

    case TOKEN_ER:
    case TOKEN_ER_REQ:
    case TOKEN_ICH:
      /*
       * Wir koennen mit der Sendung der Informationen beginnen, da wir
       * das Token haben.
       */
      for (index = 0; index < max_nodes; index++, np++, rp++) {
        if (!np->id[0]) continue;   /* leere Eintraege uebergehen       */
                                    /* ebenso den Nachbar selber        */
        if (cmpid(np->id, pp->l2link->call)) continue;
        quality = (find_best_qual(index, &bestpp, FLEX_MASK) + 9) / 10;
        reported_quality = rp->reported_quality/10; /* die gemeldete Qualitaet */

        if (bestpp == pp) {         /* Partner ist der beste Weg        */
          if (!reported_quality)    /* war er schon der Downstream?     */
            continue;               /* dann keine Aenderung             */
          /* Den Partner informieren, das er jetzt unser Upstream wird, */
          /* indem wir 0 melden.                                        */
          quality = 0;
        } else {                    /* bester Weg geht wo anders        */
                                    /* zu meldenede Qualitaet berechnen */
          if (quality) quality += (unsigned)(pp->quality/10L);
          if (quality == reported_quality) continue; /* keine Aenderung */

          diff = (reported_quality/8);/* 12.5% Schwelle                 */
          diff = max(diff, 2);        /* minimum 200ms                  */
          if (quality && reported_quality)      /* beide gut            */
            if (   (quality < reported_quality) /* nicht schlechter     */
                && (reported_quality-quality <= diff))
              continue;                      /* und unwesentlich besser */
        }

        if (pp->token == TOKEN_ER) {          /* erst nach Token fragen */
          sendfbp(getfbp(L2CFLEXNET, pp->nbrl2l, "3+"));
          pp->token = TOKEN_ICH_REQ;
          pp->brotim = 120;         /* falls er nicht in 120s antwortet */
          return;                   /* ohne Token nichts senden         */
        }

        if (fbp == NULL)            /* eventuell neuen Buffer anlegen   */
          fbp = getfbp(L2CFLEXNET, pp->nbrl2l, "3");

        if (quality > 6000) quality = 6000;         /* obere Grenze     */

        /* wenn ich dem Nachbar etwas melde, ist er automatisch mein    */
        /* Upstream, seine Qualitaet verwerfe ich also. Dem Downstream  */
        /* melde ich nie etwas (quality = 0), deshalb werfe ich seine   */
        /* Qualitaet nicht weg.                                         */

        if (quality)
          update_route(pp, index, 0);

        putprintf(fbp, "%6.6s%c%c%u ",
                  np->id,           /* Rufzeichen des Ziels             */
                  FLEXSSID(np->id), /* untere SSID                      */
                  np->ssid_high+'0',/* obere SSID                       */
                  quality);         /* Quality (in 100ms, siehe oben)   */
        rp->reported_quality = quality*10; /* merken, gemeldet wurde    */

        if (fbp->mbpc >= 256 - (6 /*id*/
                                + 2 /*2 ssids*/
                                + 5 /*4 quality+space*/)) {
          sendfbp(fbp);
          fbp = NULL;               /* Frame senden wenn Buffer voll    */
        }
      }
      if (pp->token == TOKEN_ER_REQ) { /* er will das Token             */
        if (!fbp)
          fbp = getfbp(L2CFLEXNET, pp->nbrl2l, "3");
        putchr('-', fbp);           /* ihm das Token geben              */
        pp->token = TOKEN_ER;       /* nun hat er das Token             */
      }
      if (fbp) sendfbp(fbp);        /* eventuell Reste senden           */
      break;
  }
  pp->brotim = 10;                  /* in 10s wieder melden             */
}

/* Einen Buffer in einen String umkopieren. CR wird entfernt.           */
static void mbp2str(MBHEAD *mbp, char *str) {
  int ch;

  while (mbp->mbgc < mbp->mbpc)
    if ((ch = getchr(mbp)) != '\r') *str++ = ch;
  *str = 0;
}

/* Ein Routentest-Frame empfangen und weiterleiten / oder beantworten
 * Routentest weiterleiten Format: 6HQQQQQSSSSSS XXXXXX DDDDDD
 *   H TTL-Zaehler. Beginnt bei ! (ASCII $21) und zaehlt hinauf !"#$%&/()
 *   Q QSO-Nummer
 *   S Source-Digi
 *   X Digipeater ....
 *   D Ziel-Digi
 */
void
flex_route_query(char *buf)
{
  char    *bp, *p;                  /* Buffer fuer die Bearbeitung      */
  char    dstid[L2IDLEN];           /* Zielrufzeichen                   */
  char    dstcal[15];               /* ASCII: Rufzeichen des Zielnode   */
  char    nbrcal[15];               /* ASCII: Rufzeichen des Nachbarn   */
  char   *insert;                   /* Das soll eingefuegt werden.      */
  PEER   *pp;
  MBHEAD *fbp;
  int     len;
  BOOLEAN test = FALSE; /* Wird TRUE wenn der Routentest von uns ist    */

  if (buf[0] == '*')                            /* wurde hier erzeugt   */
    test = TRUE;

  buf[0] = '7';                     /* Default: Frame geht zurueck      */
  bp = buf + 7;

  while ((p = strchr(bp, ' ')) != NULL)
    bp = p + 1;                     /* zum letzten Call gehen           */

  if (strlen(bp) > 9) return;       /* XXXXXX-99 darf noch drinstehen   */
  strcpy(dstcal, bp);               /* auch als ASCII merken            */
  if (test)
/* wenn von hier, dann SSId weg - damit tun wir so als suchen wir einen */
/* -0 Digi                                                              */
  {
    if (strchr(bp, '-') > 0)
//      *(char *) (strchr(bp, '-')) = NUL;
      *(strchr(bp, '-')) = NUL;
  }
  str2call(dstid, bp);              /* Zielrufzeichen lesen             */

  insert = "";                      /* Default: nichts einfuegen        */

  if (++buf[1] < '!' + 20)          /* noch Hops uebrig?                */
  {
    if (iscall(dstid, NULL, &pp, FLEX_MASK) > 0)
    {
/* Wenn es der Linkpartner selber ist, dann schicken wir das einfach    */
/* zurueck, sonst basteln wir sein Call da rein und schicken ihm das    */
/* Frame.                                                               */
/* (durch iscall(..,VC|VC_FAR) ist sichergestellt, das wir hier nur     */
/* Flexnets haben, die ferne Ziele anbieten)                            */
      if(test)
      {
/* und nun schieben wir ihm das eigenliche Call unter. Das erkennt er   */
/* dann nicht als seinen Nachbarn und stoesst einen Routentest an.      */
        strcpy(bp, dstcal);
        str2call(dstid, bp);
      }
      if (!cmpid(dstid, pp->l2link->call))              /* WEITERLEITEN */
      {
        call2str(insert = nbrcal, pp->l2link->call);
        strcat(nbrcal, " ");        /* Leerzeichen als Trennung         */
        buf[0] = '6';               /* doch weiterleiten                */
      }                             /* nichts einfuegen, nur zuerueck   */
    } else insert = "??? ";         /* kein Weg dorthin bekannt         */
  } else insert = "... ";           /* Hops abgelaufen                  */

  len = (int)(strlen(buf) + strlen(insert)) + 1/*CR*/;
  if (len >= 230)                   /* Frame wird zulang, kuerzen       */
  {
    insert = len < 250 ? ">>> " : "";
    buf[0] = '7';                   /* zulange an den Absender zurueck  */
  }
/* hier angekommen haben wir genuegend Platz, um insert einzufuegen,    */
/* oder insert ist leer.                                                */
  strcpy(bp, insert);
  strcat(bp, dstcal);

  if (buf[0] == '6')                /* 6er leiten wir selber weiter     */
  {
    fbp = getfbp(L2CFLEXNET, pp->nbrl2l, "");
    putstr(buf, fbp);               /* String ins Frame                 */
    putchr('\r', fbp);              /* CR hinterher                     */
    sendfbp(fbp);                   /* und senden...                    */
  } else
    flex_route_reply(buf);          /* 7er erledigt flex_route_reply    */
  return;
}

/* Eine Routentest-Antwort auswerten oder weiterleiten.
 * Routentest-Antwort Format: 7HQQQQQSSSSSS XXXXXX DDDDDD
 *                            01234567890123
 *   H TTL-Zaehler. Beginnt bei ! (ASCII $21) und zaehlt hinauf !"#$%&/()
 *   Q QSO-Nummer
 *   S Source-Digi
 *   X Digipeater ....
 *   D Ziel-Digi
 *
 * Wir waehlen einen beliebigen Rueckweg, nicht unbedingt den in der
 * Anfrage festgestellten (eventuell gehts zurueck anders).
 */
static void flex_route_reply(char *buf) {
  char    *p;                       /* Buffer fuer die Bearbeitung      */
  char    srcid[L2IDLEN];           /* Zielrufzeichen                   */
  char    srccal[15];               /* ASCII: Rufzeichen des Zielnode   */
  PEER   *pp;
  MBHEAD *fbp;
  USRBLK *up;
  int     uid;

  if ((p = strchr(buf+7, ' ')) == NULL) return;
  *p = 0;                           /* Rufzeichen isolieren             */
  if (strlen(buf+7) > 9) return;    /* Absender-Rufzeichen zu lang      */
  strcpy(srccal, buf+7);            /* und kopieren                     */
  str2call(srcid, srccal);          /* in internes Format wandeln       */
  *p = ' ';                         /* ... wieder Space daraus machen   */

  if (cmpid(srcid, myid)) {         /* etwa fuer mich?                  */
      sscanf(buf+2, "%5u", &uid);   /* User-ID lesen                    */
      if (uid > 0 && uid < NUMPAT)  /* nur wenn die ID gueltig ist      */
        if ((up = ptctab[uid].ublk) != NULL) {
          send_async_response(up, "Route (VC): ", buf+7);
          return;
        }
  } else                            /* WEITERLEITEN                     */
  if (++buf[1] < '!'+40)            /* noch Hops uebrig?                */
    if (iscall(srcid, NULL, &pp, FLEX_MASK) > 0) {
      if (pp->nbrl2l) {
        fbp = getfbp(L2CFLEXNET, pp->nbrl2l, "");
        putstr(buf, fbp);           /* String ins Frame                 */
        putchr('\r', fbp);          /* CR hinterher                     */
        sendfbp(fbp);               /* und senden...                    */
      }
    }
}

/*
 * Auswertung eines empfangenen Flexnet-Frames
 */
void flex_rx(PEER *pp, MBHEAD * mbp)
{
  char       call[L2IDLEN];
  int        ssidoben;
  long       myrtt;
  long       hisrtt;
  unsigned   quality;
  UBYTE      data;
  char       buf[280];
  int        index;

dbg("flex_rx:1");
  if (pp->nbrl2l == NULL) return;

  if (mbp->l2link) {                /* Info Frame ?                      */
    switch ((buf[0] = getchr(mbp))) {
      case '0':
dbg("flex_rx:2");
        if (mbp->mbpc - mbp->mbgc < 3)
          return;                   /* Minimum 3 Bytes im Frame          */
dbg("flex_rx:3");
        pp->l2link->ssid_high =
          getchr(mbp)-'0';          /* Get max SSID                      */
dbg("flex_rx:4");
        data = getchr(mbp);         /* Version lesen                     */
dbg("flex_rx:5");
        pp->version = data +        /* Versionskennung zusammenbauen     */
          (getchr(mbp)<<8);         /* Softwareversion dazuaddieren      */
        break;

      /* Beantwortung unseres 2er Frames */
      case '1':
dbg("flex_rx:6");
        myrtt  = (tic10 - pp->rttstart);
        myrtt += (myrtt/8 + 1);     /* 15% Aufschlag (empirisch gemessen)*/
        myrtt  = max(myrtt, 10);
        mbp2str(mbp, buf);               /* Frame in ein String kopieren */
dbg("flex_rx:7");
        hisrtt = atoi((char *) buf) * 10;   /* Flex gibt in 100ms an     */
        hisrtt = max(hisrtt, 10);   /* er sendetet RTT, wir wollen Delay */
        update_peer_quality(pp, myrtt, hisrtt);
dbg("flex_rx:8");
        if ((index = add_route(pp, pp->l2link->call,
                               (unsigned)pp->quality)) != -1) {
dbg("flex_rx:9");
          update_lt(pp, index, 1);
dbg("flex_rx:10");
          update_alias(index, pp->l2link->alias);
dbg("flex_rx:11");
          update_ssid(index, pp->l2link->ssid_high);
        }
dbg("flex_rx:12");
        rtt_metric(pp, myrtt);
dbg("flex_rx:13");
        pp->rttstart = 0;

        /* festes Messinterval */
        pp->rtt_time = MESSTIME;
        break;

      /* Partner schickt Testframe, Antwort mit unserer Laufzeit */
      case '2':
dbg("flex_rx:14");
        flex_tx_rtt_reply(pp);      /* Antwort schicken                 */
        break;

      /* Routinginfo / Tokenuebergabe */
      case '3':
        while (mbp->mbgc < mbp->mbpc) {
          if (ge6chr(call, mbp)) {  /* Rufzeichen komplett?             */
            if (mbp->mbpc-mbp->mbgc < 2/*ssid*/+1/*Zeit*/)
              return;               /* wenn zu kurz, Frame nicht aus-   */
dbg("flex_rx:15");
            call[L2IDLEN-1] = ((getchr(mbp)-'0') << 1) | 0x60;
            ssidoben = getchr(mbp)-'0';
            quality = 0;
            while (isdigit(data = getchr(mbp)) && mbp->mbgc < mbp->mbpc)
              quality = 10 * quality + (data -'0');
            if (quality >= 6000) quality = 0;
            if (quality)
              quality += quality/5; /* 20% Aufschlag als Hop-Horizont */
            if ((index = add_route(pp, call, quality * 10)) != -1) {
dbg("flex_rx:16");
              update_lt(pp, index, DEFAULT_LT);
dbg("flex_rx:17");
              update_ssid(index, ssidoben);
            }
          } else {
            switch (call[0]) {
              case '+' :            /* er will das Token haben          */
                pp->token = TOKEN_ER_REQ;
dbg("flex_rx:18");
                flex_tx_routes(pp); /* Routen uebertragen, Token halten */
                break;
              case '-' :            /* er gibt uns das Token            */
                pp->token = TOKEN_ICH;
dbg("flex_rx:19");
                flex_tx_routes(pp); /* Routen uebertragen, Token halten */
                break;
            }
            return;
          }
        }
        break;

      case '4':
dbg("flex_rx:20");
        break;

      case '5':
dbg("flex_rx:21");
        break;

      /* Routentest hin, weiterleiten */
      case '6':
dbg("flex_rx:22");
        mbp2str(mbp, buf+1);        /* Frame in ein String kopieren */
        flex_route_query(buf);
        break;

      /* Routentest zurueck, weiterleiten */
      case '7':
dbg("flex_rx:23");
        mbp2str(mbp, buf+1);        /* Frame in ein String kopieren */
        flex_route_reply(buf);
        break;

      default:
dbg("flex_rx:24");
        break;
    } /* switch       */
  }     /* if infoframe */
}

int callcompare(char * call1, char * call2)
{
  int i;

  for (i = 0; i < L2IDLEN - 1; i++) {
    if (call1[i] != call2[i]) {
      if (call1[i] < call2[i])
        return(LOWER);
      if (call1[i] > call2[i])
        return(HIGHER);
    }
  }
  if ((call1[L2IDLEN-1]&0x1e) > (call2[L2IDLEN-1]&0x1e))
    return(HIGHER);
  else
    return(LOWER);
}

/* find_route() wird vom L7 benutzt, um einen Connect zu einem Node
 * aufzubauen. Dies kann ein dummer L2 sein (Local), ein noch duemmerer
 * L2 (Flexnet) oder ein L4 QSO (NetRom).
 * Wegen Flexnet sieht das Addressfeld bei einem Connect recht witzig
 * aus:
 * fm DB0SRC to DB0DST via DB0MY DB0DUM DB0NBR
 * DB0MY ist das eigene Rufzeichen (myid), DB0DUM ein schlichter L2-
 * Wassertraeger (XNET ist dazu prima) und DB0NBR der Nachbar.
 * DB0DUM entfaellt in der Regel, und da Links keine Regel haben eigentlich
 * fast immer.
 * Besondere Vorkehrung wird fuer die ausgefallenen Nachbarn getroffen,
 * sie stehen eventuell nicht in der Nodes-Liste, aber wir kennen sie
 * ja noch als Nachbarn.
 * In dest.call steht das Ziel-Call, call ist eventuell nur ein Nachbar
 * auf dem Weg dorthin.
 */
int l3_find_route(char *call, DEST *dest)
{
  int          max_peers = netp->max_peers;
  int          index;
  PEER        *bestpp;
  PEER        *pp;
  int          i;
  int          ssid;
  char        *id;

  /* die NODES-Tabelle */
  if ((index = find_node_this_ssid(call)) == -1)
    index = find_node_ssid_range(call);
  if (index != -1) {
    if (find_best_qual(index, &bestpp, DG|VC|VC_FAR) > 0) {
      dest->via[0] = '\0';
      cpyid(dest->nbrcal, bestpp->l2link->call);
      cpyidl(dest->via, bestpp->l2link->digil);
      /*
       * Wenn des Ziel nicht in den SSID-Bereich des Nachbarn passt,
       * muessen wir das Nachbarrufzeichen in des via-Feld aufnehmen.
       */
      id = netp->nodetab[index].id;
      ssid = SSID(id);
      if (   (!cmpcal(id, bestpp->l2link->call))
          || (ssid < SSID(bestpp->l2link->call))
          || (ssid > bestpp->l2link->ssid_high))
        addid(dest->via, bestpp->l2link->call);
      dest->port = bestpp->l2link->port;
      dest->typ  = bestpp->typ;
      dest->np   = netp->nodetab+index;
      return(NODE_AVAILABLE); /* Ziel ist erreichbar */
    }
    return(NODE_DOWN);
  }

  /* wenn direkter Nachbar nicht erreichbar, dies mitteilen */
  for (pp = netp->peertab, i = 0; i < max_peers; pp++, i++)
    if (pp->used)
      if (cmpid(pp->l2link->call, call))
        if (!pp->quality) {
          dest->typ  = pp->typ;
          cpyid(dest->nbrcal, myid);
          return(NODE_DOWN);                 /* Nachbar unerreichbar */
        }

  return(NODE_UNKNOWN); /* Ziel nicht gefunden */
}

/************************************************************************/
/*                                                                      */
/* UI-Frames von einem Port auf einen anderen Port durchreichen. Diese  */
/* Funktion ist vorgesehen, um z.B. Mail-Beacons von Mailboxes zu       */
/* ermoeglichen. Als Digipeater-Call ist der TNN-Alias zu verwenden mit */
/* der Nummer des gewuenschten Sende-Ports als SSID. Fuer die Ueber-    */
/* tragung muessen folgende Voraussetzungen erfuellt sein:              */
/*                                                                      */
/*   - nur PID 0xF0 wird akzeptiert                                     */
/*   - der Sende-Port darf nicht der Empfangsport sein                  */
/*                                                                      */
/* Um fuer F6FBB-Mailboxes eine Antwort-Funktion zu ermoeglichen, wird  */
/* der SSID des Digipeater-Calls bei der Aussendung auf den Empfangs-   */
/* port gesetzt.                                                        */
/*                                                                      */
/************************************************************************/

void gateway_ui(char *fmid, char *toid, char *rxvia, MBHEAD *info)
{
  int     port;
  char   *vp;

  if (info->l2fflg == L2CPID)
   {
    for (vp = rxvia; *vp != '\0'; vp += L2IDLEN)
     {
      if (vp[L2IDLEN-1] & L2CH)
        continue;
      if (cmpcal(vp, l2als))
       {
        port = SSID(vp);
        if ((port < L2PNUM) && portenabled(port) && (port != rxfprt))
         {
          vp[L2IDLEN-1] = (vp[L2IDLEN-1] & ~0x1e) | (rxfprt << 1) | L2CH;
          sdui(rxvia, toid, fmid, port, info);
         }
       }
      break;
     }
   }
  dealmb(info);
  return;
}

/* End of src/l3c.c */
