/*	 +++++++++++++++++
         +               +
	 +   S W I S S   +
	 +               +                ++++++   S E P R A N    ++++++
++++++++++               ++++++++++     Swiss Experimental Packet Radio Net
+                                 +
+                                 +
+ AMATEUR RADIO TELEPRINTER GROUP +
+                                 +
+                                 +
++++++++++               ++++++++++
         +     	         +
	 +    A R T G    +
         +               +
         +++++++++++++++++
*/

/* program Vanutil */
/* testutility for VANESSA */
/* HB9PAE 920207,920512,920820 921012, 930128 */
/* (c) SWISS ARTG */
/* DG1KWA portierung nach Linux 25.12.98      */
/* DL2OAM Bugfixing             17.04.99      */

#define WAIT       250
#define SWAIT      100
#define TXBUFFSIZE 1000
#define RXBUFFSIZE 1000
#define ECHO_ON    0xd
#define ECHO_OFF   0x0
#define MAGIC      0x3412

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include <asm/io.h>
#include <curses.h>
#include "vanlinux.h"

void config (void);
void init (void);
void menu (void);
void led (void);
void dpram (void);
void finito (void);
void reset (void);
void dyram (void);
int  sendframe (void);
int  readframe (void);
int  cmpframe (void);
void cpytxfrm (void);
void sendbea (void);
void assyframe (int);
void frameecho (char);
void inittxbuffer (void);

/* LINUX */
void clears (void);
void kbhit_init (void);
void kbhit_de (void);
#include <termios.h>
#undef getch

char     beacontxt[50] ={" VANESSA BEACON, Frame No: "};
char     adress[70] = {0xa6,0x8a,0xa0,0xa4,0x82,0x9c,0xe0,0xa6,0x82,0xa4,0xa8,0x8e,0x40,0x61,0x03,0xf0};
char     txframe[TXBUFFSIZE];
int      txfrmsize;
char     rxframe[RXBUFFSIZE];
int      rxfrmsize;
long int loops;
int      port,rxport,txport;
char     cmdcode;
static char    *base;

/* Macros aus /usr/include/asm/io.h - da die bei einigen Linux-Distri-  */
/* butionen fehlen ..                                                   */

/*
 * readX/writeX() are used to access memory mapped devices. On some
 * architectures the memory mapped IO stuff needs to be accessed
 * differently. On the x86 architecture, we just read/write the
 * memory location directly.
 */

#ifndef readb
#define readb(addr) (*(volatile unsigned char *) (addr))
#endif
#ifndef readw
#define readw(addr) (*(volatile unsigned short *) (addr))
#endif
#ifndef readl
#define readl(addr) (*(volatile unsigned int *) (addr))
#endif

#ifndef writeb
#define writeb(b,addr) ((*(volatile unsigned char *) (addr)) = (b))
#endif
#ifndef writew
#define writew(b,addr) ((*(volatile unsigned short *) (addr)) = (b))
#endif
#ifndef writel
#define writel(b,addr) ((*(volatile unsigned int *) (addr)) = (b))
#endif

#ifndef memset_io
#define memset_io(a,b,c)	memset((void *)(a),(b),(c))
#endif
#ifndef memcpy_fromio
#define memcpy_fromio(a,b,c)	memcpy((a),(void *)(b),(c))
#endif
#ifndef memcpy_toio
#define memcpy_toio(a,b,c)	memcpy((void *)(a),(b),(c))
#endif

#define ReadVanW(port,what) readw(base + (port<<12) + what)
#define WriteVanW(port,what,data) writew(data , base + (port<<12) + what)
#define ReadVanB(port,what) readb(base+(port<<12)+what)
#define WriteVanB(port,what,data) writeb(data , base + (port<<12) + what)
#define outportb(adr,data) outb(data,adr)
#define delay(data) usleep(100000)


/* das Hauptprogramm */
int main()
{
  char input[10];
  init();
  do
  {
    menu();
    scanf("%s",&input);
    switch (input[0])
    {
      case '1': config();
	        break;
      case '2': led();
	        break;
      case '3': dpram(); 
   	        break;
      case '4': reset();
	        break;
      case '5': dyram();
	        break;
      case '6': sendbea();
	        break;

      case 'q':
      case 'Q': finito();
		break;
    }
  }
  while (1);
 }

/* DUAL-PORT-RAM Test */
void dpram()
{
  int error;
  unsigned char ch;
  int i;
  int loop = 0;
  int pattern1   = 0x5a;
  int pattern2   = 0xa5;

  clears();
  printf ("\n Vanessa Dual Port Memory Test\n\n\n");
  printf ("\n Select Port (0..15) : ");
  scanf  ("%u",&port);
  printf ("\n\n Exit hit any Key\n");
  printf ("\n Test on Port %d running",port);
  error=0;
  getchar ();
  kbhit_init ();
  do
  {
    outportb(ledio_adr[port],LED_ON);
    for(i=0; i<1000; i++)
     WriteVanB (port , dp_oBuffer+i , pattern1); /* write pattern     */

    for (i=0; i<1000; i++)
      {
	ch = ReadVanB (port , dp_oBuffer+i);
	if (kbhit()) goto end2;

	if ((ch & 0xff) != pattern1)
	{
	  error++;
	  printf("Error at Mem ADR 0x%x   Value: %2x\n",i,ch);
	 }
	 else
	 {
	   loop++;
	   gotoxy(23,2);
	   printf("Run No: %d",loop);
           gotoxy(24,10);
	 }
      }
    outportb(ledio_adr[port],LED_OFF);

     for(i=0; i<1000; i++)
       WriteVanB (port , dp_oBuffer+i , pattern2); /* write pattern     */
     
     printf(".");
     for (i=0; i<1000; i++)
       {
	 ch = ReadVanB (port , dp_oBuffer+i);
	 if ((ch & 0xff)!= pattern2)
	 {
	    error++;
	    printf("Error at Mem ADR 0x%3x   Value: %2x\n",i,ch);
	    if (kbhit()) break;
	 }
      }
   }
   while (!kbhit());

 end2:
   getchar();
   outportb (ledio_adr[port],LED_OFF);   
   clears();
   printf ("\n Vanessa Dual Port Memory Test\n\n\n");
   printf ("\n End of Test\n");
   printf (" No of Runs = %d\n", loop);
   printf (" Failures = %d\n",error);
   printf ("\n hit any Key....");
   while (!kbhit());
   getchar();
   kbhit_de ();
}

void finito()
{
   clears();
   printf ("\n VANESSA-Testutility fuer Linux by DG1KWA / Andreas NORD><LINK e.V.");
   printf ("\n DG1KWA@DB0KOE.#NRW.DEU.EU oder http://www.nordlink.org");
   printf ("\n Bugfixing by DL2OAM / Peter NORD><LINK");
   printf ("\n Urversion by Peter / HB9PAE (SWISS ARTG)\n");
   printf ("\n\n ");
   exit(0);
}

/* I/O-Port Test */
void led()
{
   int value,port;
   clears();
   printf("Vanessa LED Test\n\n");
   printf(" Test running!");
   printf("\n\n pse wait .... end hit any Key\n");
   getchar();
   kbhit_init ();
   value = 0;
   do
   {
     for (port =0; port<16 ;port++)
     {
       outportb(ledio_adr[port],value);
       delay(SWAIT);
     }
     value = ~value;
     delay(WAIT);
   }
   while (!kbhit());
   getchar();
// value = 1;

   for (port =0; port<16 ;port++)
     outportb(ledio_adr[port],LED_OFF);

   kbhit_de ();
}

/* VANESSA Reset */
void reset()
{
//  int port;
  clears();
  printf ("\n Vanessa CPU RESET Test\n");
  printf ("\n Select Port (0..15) : ");
  scanf  ("%u",&port);
  printf ("\n\n Vanessa Z280 CPU AT Port %d will be HALTED !",port);
  printf ("\n\n Observe LED on backside !");
  printf ("\n\n Press any key for RESTART");
  outportb(reset_adr[port>>1],0xff);
  outportb(ledio_adr[port],LED_ON);
  printf ("\r\n\007");
  getchar ();
  kbhit_init ();
  while (!kbhit());
  getchar();
  kbhit_de ();
  outportb (reset_adr[port>>1],0);
  outportb (ledio_adr[port],LED_OFF);
}

void menu()
{
   clears();
   printf ("  V A N E S S A   Linux-Testutility       V 0.2\n");
   printf ("  =============================================\n\n\n");
   printf ("  1   Show Concfiguration\n\n");
   printf ("  2   PC I/O Port test  (LED)\n\n");
   printf ("  3   Dual Port RAM test\n\n");
   printf ("  4   Vanessa RESET\n\n");
   printf ("  5   Dynamic RAM Test (noch im Test) \n\n");
//   printf ("  6   Send Beacon and Receive (not aktiv)\n\n\n");
   printf ("  Q   Quit\n");
   printf ("\n\n\n\n");
   printf ("  Select Test: ");
}

/* Device MEM oeffnen und Speicherbereich fuer VAN abilden */
void init()
{
//  int port;

  int fd;

  if ((fd = open("/dev/mem", O_RDWR)) < 0) { /* Device Memory oeffnen */ 
     printf ("Fehler.....");                 /* sollte nie passieren */
     exit(1);	
  }

  /* Device als Speicherabbild bereitstellen ; Offset bei D0000
     Groesse 64 kB                                               */
  base = mmap(0, 0x10000 , PROT_READ|PROT_WRITE , MAP_SHARED , fd , 0xD0000);

  close (fd); /* Device wieder schliessen */

  /* nun noch die IO-Ports freigeben */
  for (port=0; port < 16; port++) {
      ioperm (ledio_adr[port],3,1);
      ioperm (reset_adr[port/2],3,1);
  }

  for (port=0; port < 16;port++)
  {
      outportb(ledio_adr[port],LED_OFF);
  }
}

/* VANESSAs suchen und ausgeben */
void config()
{

  char van_version;       /* Versions-Kennung              */
  char van_revision;      /* der VANESSA                   */
  char van_patch;

//  int port;

  int test;

  clears();

  printf("\n Actual Configuration\n\n");

  for(port=0; port < 16 ; port +=2)
  {
    
    van_version  = 4;            /* aktuelle Version steht nicht im DP */
    van_revision = ReadVanB( (port&0xFE),dp_cData+0x751) / 16;
    van_patch    = ReadVanB( (port&0xFE),dp_cData+0x74E); 

    test = ReadVanW(((port&0xFE)+1),dp_cData+0x750); 

    if (test == MAGIC)
    {
      printf(" Port %d available at  (mem)   Version V4.%2.2x%c\n",port, van_revision,van_patch);
      printf(" Port %d available at  (mem)   Version V4.%2.2x%c\n",port+1,van_revision,van_patch);
    }
    else
    {
      printf(" Port %d not available\n",port);
      printf(" Port %d not available\n",port+1);
    }
  }
  printf("\n\n Press any key ...");
  getchar ();
  kbhit_init ();
  while (!kbhit());
  getchar();
  kbhit_de ();
}

/*  dynanamic dual port ram test */
void dyram()
{
   int result=0;
   long  failure=0;
   int timeout=0;
   inittxbuffer();

   clears();
   printf("\n Vanessa Dynamic Dual Port Memory Test\n");
   printf("\n Select Port (0..15) : ");
   scanf("%u",&port);
   getchar ();
   kbhit_init ();
   rxport = txport = port;
   frameecho(ECHO_ON);				/* CMD Vanessa ECHO ON */

   loops=0;
   clears();
   printf("\n Dynamic Dual Port RAM Memory test running\n\n\n");
   printf("\n Test Port %d running\n",port);
   printf("\n Exit pse wait ....");
   while (!kbhit())
   {
     sendframe();
     result=cmpframe();
     gotoxy(20,3);
     printf("\n Failures: %d",failure);
     gotoxy(21,3);
     printf("\n Run No  : %d",loops);
     gotoxy(23,3);
     switch (result)
     {
	case 0:
//                sendframe();
		timeout=0;
		break;
	case 1: failure++;
		printf("\nFailure run no: %ld",loops);
		failure++;
		timeout=0;
		break;
	default: timeout++;
		if (timeout>10000)
		{
		  printf("\n Vanessa not ready!");
		  timeout=0;
		}
		break;
	}
    }
   frameecho(ECHO_OFF);				/* CMD Vanessa ECHO ON */
   printf("\n Pattern compared = %ld\n Failures = %ld\n",loops,failure);
   printf("\n hit any Key ....");
/*   kbhit_init ();*/
   outportb(ledio_adr[port],LED_OFF);
   while (!kbhit());
   kbhit_de ();
}

void  inittxbuffer()
{
  int i;
  for (i=0; i<TXBUFFSIZE;i++)
    txframe[i]=i%128/*&0xff*/;
    
  txfrmsize=i;
}

void  frameecho(char cmdcode)
{

     WriteVanB (port & 0xfffe, dp_cCMD, CRAM_VALID);
     WriteVanB (port & 0xfffe, dp_cCMD+1, cmdcode);

}


int sendframe()
{
//  int i;
// ptr = &p[txport].dprec.dp_oBuffer[0];
// if (CRAM_VALID != p[txport].dprec.dp_oFProd)       /* CRAM Buffer free*/
//  {
//      for (i=0; i<txfrmsize; i=i+1)
//  	ptr[i]=txframe[i];
//  }
//  else
//    return(0);   				/* cram not free */
//  p[txport].dprec.dp_oLFrm = i;              /* frame size */
//  p[txport].dprec.dp_oFProd = CRAM_VALID;    /* CRAM buffer valid */
 
   int i;
   if (ReadVanW (port, dp_oFProd) != CRAM_VALID) /* CRAM Buffer free */
     {
	for (i=0; i<txfrmsize; i=i+1)
	  WriteVanB (port, dp_oBuffer + i, txframe[i]);
     }
   else
     return (0);                                 /* CRAM not free     */
   WriteVanW (port, dp_oLFrm, i);                /* Frame size        */
   WriteVanW (port, dp_oFProd, CRAM_VALID);      /* CRAM buffer valid */
   return(1);
}

int readframe()
{
//  int i;

//  ptr = &p[rxport].dprec.dp_iBuffer[0];
//  if (CRAM_VALID == p[rxport].dprec.dp_iFProd)       /* CRAM Buffer valid*/
//  {
//    if (0<(rxfrmsize=p[rxport].dprec.dp_iLFrm))        /* frame size */
//    {
//      for (i=0; i<rxfrmsize; i++)
//  	rxframe[i]=ptr[i];
//      rxframe[i]='\0';
//    }
//    else
//      return(0);
//    p[rxport].dprec.dp_iFProd=0xff;       /* CRAM Buffer not valid*/
//    return(1);
//  }
   int i;
   
   if (ReadVanW (port, dp_iFProd) == CRAM_VALID) /* CRAM Buffer valid */
     {
	if (0 < (rxfrmsize = ReadVanW (port, dp_iLFrm))) /* frame size */
	  {
	  for (i=0; i<rxfrmsize; i++)
	      rxframe[i] = ReadVanB (port, dp_iBuffer+i);
	  rxframe[i]='\0';
	  }
	else
	  return (0);
	
	WriteVanW (port, dp_iFProd, 0xff); /* CRAM Buffer not valid */
	return (1);
     }
   return(0);
}

/* compare frame
   exit: 0: successfull
	 1: failure
	 2: frame not ready  */

int cmpframe()
{
   int i=0;

   if (CRAM_VALID == ReadVanW (port, dp_iFProd)) /* CRAM Buffer valid */
     {
	while (ReadVanB (port , dp_iBuffer+i) == txframe[i])
	  i++;
	if (i == ReadVanW (port, dp_iLFrm)) /* frame size */
	     {
		WriteVanW (port, dp_iFProd , !CRAM_VALID);
		loops++;
		return (0);
	     }
	   else
	     {
		WriteVanW (port, dp_iFProd, !CRAM_VALID);
		return (1);
	     }
	    
	}
   
   return(2);
}

void cpytxfrm() 		/* copy rx frame to tx buffer */
{
   int i;
   for (i=0; i<rxfrmsize;i++)
     txframe[i]=rxframe[i];
   txfrmsize=rxfrmsize;
}

void sendbea()
{
//   int port;
   int warten;
   int nr;
   int ist;

   printf("\nSend and receive frames from VANESSA\n\n\n");
   printf("\n Input TX Port: ");
   scanf("%d",&txport);
   printf("\n Input RX Port: ");
   scanf("%d",&rxport);
   printf("\n Input Delay [msec]:");
   scanf("%d",&warten);
   printf("\n Input Nr of Frames:");
   scanf("%d",&nr);
   nr++;
   ist = 0;
   assyframe(++ist);

   while (!kbhit() && (ist !=nr))
   {
     readframe();
     if (sendframe())
       assyframe(++ist);
     readframe();
     delay(warten);
   }
}
	
void assyframe(int ist)
{
   char nrstring[10];

   //itoa (ist,nrstring,10);
   sprintf (nrstring, "%d",ist);
   strcpy (txframe,adress);
   strcat (txframe,beacontxt);
   strcat (txframe,nrstring);
   txfrmsize=strlen(txframe);

}

void clears (void)
{
   printf ("\033[2J");
   printf ("\033[0;0H");
}


int gotoxy (int x,int y)
{
   printf ("\033[%d;%dH",x,y);
}


int kbhit (void)
{

   if (EOF == getc (stdin)) 
      return 0;
  
  return 1;  
}

struct termios  oci;
struct termios  nci;

void kbhit_init (void)
{
	
   tcgetattr(fileno(stdin), &oci);
   nci = oci;
   nci.c_cc[VTIME] = 0;
   nci.c_cc[VMIN] = 0;
   nci.c_cc[VSTART] = -1;
   nci.c_cc[VSTOP] = -1;
   nci.c_iflag = IGNBRK;
   nci.c_oflag = OPOST|ONLCR;
   nci.c_lflag = 0;
   nci.c_cflag = (CS8|CREAD|CLOCAL);
   tcsetattr(fileno(stdin), TCSADRAIN, &nci);
}

void kbhit_de (void)
{
   tcsetattr(0, TCSADRAIN, &oci);
}
