/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/l3a.c (maintained by: ???)                                  */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2001 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* In diesem Modul werden die Verwaltungsstrukturen fuer den Level 3    */
/* und die dazugehoerigen Algorithmen implementiert.                    */
/* Alle Routinen in diesem Modul sind nicht abhaengig vom der ver-      */
/* wendeten Netzwerk-Klasse.                                            */
/************************************************************************/

#include "tnn.h"

NETWORK *netp = NULL;

#define RTT_MIN 1                   /* Grenzwerte fuer SRTT 1ms..<60s      */
#define RTT_MAX 59999L

#define RTT_ALPHA1      7
#define RTT_ALPHA2      8
#define RTT_BETA        3

#define IGNORE_RTT  0               /* Messung ignorieren                  */

static int hashid(const char *, int);
static void range(ULONG *, ULONG);
static void clear_peer(PEER *);

/* HASHING */

int get_next_prim(int num)          /* naechste Primzahl berechnen         */
{
  int i, j;

  for (i = num; ; i++) {            /* intuitive Methode ausreichend       */
    for (j = 2; j < i; j++)
      if (i % j == 0) break;
    if (i == j) return(i);          /* eine Primzahl gefunden              */
  }
}

#if 0
static int hashid(                  /* Hash-Funktion fuer ein Rufzeichen   */
                  const char *id,   /* Rufzeichen ohne SSID                */
                  int hashsize)     /* Hash-Array Groesse                  */
{
  int prim[] = {3, 5, 7, 11, 13, 17}; /* tnx Prof. Dassow, UMD             */
  register int r, hashval = 0;
  for (r = 0; r < 6; r++)
    hashval += ((unsigned)(*id++)) * prim[r];
  return((unsigned)(hashval % hashsize));
}
#else                   /* nicht alle compiler koennen unroll-loops     */
/* Hash-Funktion fuer ein Rufzeichen                                    */
static int
hashid(const char *id,                          /* Rufzeichen ohne SSID */
       int hashsize)                            /* Hash-Array Groesse   */
{
  register int hashval;

  hashval = ((unsigned)(*id++)) * 3;
  hashval += ((unsigned)(*id++)) * 5;
  hashval += ((unsigned)(*id++)) * 7;
  hashval += ((unsigned)(*id++)) * 11;
  hashval += ((unsigned)(*id++)) * 13;
  hashval += ((unsigned)(*id)) * 17;
  return((unsigned)(hashval % hashsize));
}
#endif

/* eine neues Segment anlegen */
PEER *register_peer(void)
{
  PEER *peertab = netp->peertab;    /* Segment-Tabelle                     */
  PEER *pp;

  for (pp = peertab; pp < &peertab[netp->max_peers]; pp++)
    if (!pp->used) break;

  if (pp != &peertab[netp->max_peers]) { /* nur wenn Platz                 */
    if ((pp->routes = calloc((size_t)netp->max_nodes, sizeof(ROUTE))) == NULL)
      return(NULL);                 /* kein Speicher                       */
    pp->quality =                   /* Segment nicht erreichbar            */
    pp->my_quality =
    pp->his_quality = 0L;
    pp->locked = FALSE;
    pp->used = TRUE;
    pp->num_routes = 0;
    pp->primary = pp;
    pp->maxtime = 0;
    netp->num_peers++;
    return(pp);
  }
  return(NULL);
}

void unregister_peer(               /* Segment austragen                   */
                     PEER *pp)      /* Zeiger auf das Segment              */
{
  clear_peer(pp);                   /* Routen ueber das Segment verwerfen  */
  free(pp->routes);                 /* Routentabelle freigeben             */
  netp->num_peers--;
  pp->used = FALSE;
}

/* einen Router initialisieren und Tabellen anlegen */
BOOLEAN register_network(int max_peers, int max_nodes)
{
  char    huge *memp;

  memp = (char *)calloc(1, sizeof(NETWORK)+
                           sizeof(NODE)*max_nodes+
                           sizeof(PEER)*max_peers);
  if (memp) {
    netp = (NETWORK *) memp; memp += sizeof(NETWORK);
    netp->max_peers = max_peers;
    netp->max_nodes = max_nodes;
    netp->peertab = (PEER *) memp; memp += sizeof(PEER)*netp->max_peers;
    netp->nodetab = (NODE *) memp /*, memp += sizeof(NODE)*netp->max_nodes */;
    inithd(&netp->nodelis);
    return(TRUE);
  }
  return(FALSE);
}

/* einen Router deinitialisieren */
void unregister_network(void)
{
  free(netp);
}

/************************************************************************/
/*                                                                      */
/* Node id mit SSID-Bereich suchen                                      */
/*                                                                      */
/************************************************************************/
INDEX
find_node_ssid_range(const char *id)
{
  NODE *np;
  NODE *nodetab = netp->nodetab;
  int   max_nodes = netp->max_nodes;
  int   hash_tries;                     /* Anzahl Schritte bis Treffer  */
  int   ssid = SSID(id);
  INDEX index;

  index = hashid(id, max_nodes);
  np = nodetab + index;

  for (hash_tries = 0;                  /* Ab Hash-Position suchen      */
       hash_tries < max_nodes;          /* ueber die ganze Hash-Tabelle */
       hash_tries++)                    /* keine Nodes mehr uebrig?     */
  {
    if (np->id[0])
      if (   (ssid >= SSID(np->id))     /* passt der SSID-Bereich?      */
          && (ssid <= np->ssid_high))
        if (cmpcal(np->id, id))
          return (index);               /* Index liefern                */
    if (++index >= max_nodes)           /* np weiterruecken, Umbruch    */
    {                                   /* beachten                     */
      np = nodetab;
      index = 0;
    }
    else
      np++;
  }
  return (NO_INDEX);
}

/************************************************************************/
/*                                                                      */
/* Node id mit festem SSID suchen                                       */
/*                                                                      */
/************************************************************************/
INDEX
find_node_this_ssid(const char *id)
{
  NODE *np;
  NODE *nodetab = netp->nodetab;
  int   max_nodes = netp->max_nodes;
  int   hash_tries;                     /* Anzahl Schritte bis Treffer  */
  INDEX index;

  index = hashid(id, max_nodes);
  np = nodetab + index;

  for (hash_tries = 0;                  /* Ab Hash-Position suchen      */
       hash_tries < max_nodes;          /* ueber die ganze Hash-Tabelle */
       hash_tries++)                    /* keine Nodes mehr uebrig?     */
  {
    if (np->id[0])
      if (cmpid(np->id, id))            /* gefunden?                    */
        return (index);                 /* Index liefern                */
    if (++index >= max_nodes)           /* np weiterruecken, Umbruch    */
    {                                   /* beachten                     */
      np = nodetab;
      index = 0;
    }
    else
      np++;
  }
  return (NO_INDEX);
}

/************************************************************************/
/*                                                                      */
/* einen Node einsortieren                                              */
/*                                                                      */
/************************************************************************/
static void
sort_node(NODE *new_np)
{
  NODE *np;
  char *id = new_np->id;                /* Rufzeichen des neuen Nodes   */
  int   ssid = SSID(id);                /* SSID des neuen Nodes         */
  int   i;

  for (np  = (NODE *)netp->nodelis.head;
       np != (NODE *)&netp->nodelis;
       np  = np->next)                  /* richtige Stelle finden       */
    if ((i = strncmp(np->id, id, L2CALEN)) >= 0)
      if ((i > 0) || (SSID(np->id) > ssid))
        break;
  relink((LEHEAD *)new_np, (LEHEAD *)np->prev);
}

/************************************************************************/
/*                                                                      */
/* Node id zur Nodestabelle hinzufuegen                                 */
/*                                                                      */
/************************************************************************/
INDEX
add_node(const char *id)
{
  int   i;
  NODE *np;
  NODE *nodetab = netp->nodetab;
  int   max_nodes = netp->max_nodes;
  INDEX index;

  index = hashid(id, max_nodes);        /* Position vorraussagen        */
  np = nodetab + index;

  for (i = 0; i < max_nodes; i++)
  {
    if (!np->id[0])                     /* Platz gefunden               */
    {
      cpyid(np->id, id);                /* Call umkopieren              */
      cpyals(np->alias, nulide);        /* Alias loeschen               */
      np->ipa = 0L;                     /* IP-Adresse loeschen          */
      np->bits = 0;                     /* Subnet-Maskenbits loeschen   */
      np->options = NULL;               /* keine weiteren INP-Options   */
      np->ssid_high = SSID(id);         /* ohne SSID-Bereich            */
      netp->num_nodes++;                /* ein Node mehr                */
      if (netp->num_nodes > num_nodes_max)
        num_nodes_max = netp->num_nodes;
      sort_node(np);                    /* Node einsortieren            */
      return (index);                   /* Index liefern                */
    }
    if (++index >= max_nodes)           /* np weiterruecken, Umbruch    */
    {                                   /* beachten                     */
      np = nodetab;
      index = 0;
    }
    else
      np++;
  }
  return (NO_INDEX);
}

/************************************************************************/
/*                                                                      */
/* einen Node aus der Liste nehmen                                      */
/*                                                                      */
/************************************************************************/
void
del_node(INDEX index)
{
  NODE *np = netp->nodetab + index;

  destot(index);
  np->id[0] = NUL;                      /* Eintrag unbenutzt            */
  if (np->options != NULL)
    dealmb(np->options);
  netp->num_nodes--;
  ulink((LEHEAD*)np);                   /* aussortieren                 */
}

void drop_unreachable_nodes(void)   /* Routes/Nodes loeschen               */
{
  ROUTE *rp;                        /* Zeiger auf eine Route               */
  PEER  *pp;                        /* Zeiger auf ein Segment              */
  NODE  *np;                        /* Zeiger auf einen Node               */
  NODE  *nodetab = netp->nodetab;   /* Zeiger auf die Node-Tabelle         */
  PEER  *peertab = netp->peertab;   /* Zeiger auf die Segment-Tabelle      */
  int    max_nodes = netp->max_nodes; /* Groesse der Nodes-Tabelle         */
  int    max_peers = netp->max_peers; /* Groesse der Segment-Tabelle       */
  INDEX  index;

  for (index = 0, np = nodetab; index < max_nodes; index++, np++) {
    if (!np->id[0]) continue;       /* Eintrag ist frei                    */
    for (pp = peertab; pp < &peertab[max_peers]; pp++) {
      if (!pp->routes) continue;
      rp = &pp->routes[index];
      if (   rp->reported_quality
          || rp->quality)
        break;
    }
    if (pp == &peertab[max_peers])  /* keine aktiven Routen mehr           */
      del_node(index);
  }
}

/************************************************************************/
/*                                                                      */
/* eine Route aktualisieren anhand des Rufzeichens                      */
/*                                                                      */
/************************************************************************/
INDEX
add_route(PEER *pp, const char *id, unsigned quality)
{
  INDEX index = find_node_this_ssid(id);

  if ((index == NO_INDEX) && quality)   /* nur bei guter Qualitaet neu  */
    index = add_node(id);
  if (index != NO_INDEX)                /* nur wenn noch Platz war      */
    update_route(pp, index, quality);
  return (index);
}

/* eine Route aktualisieren                                             */
void
update_route(PEER *pp, INDEX index, unsigned  quality)
{
  ROUTE *rp = pp->routes + index;       /* Zeiger auf die Route         */

/* Empfangene Laufzeit aktualisieren                                    */

  if (quality >= HORIZONT)
    quality = 0;                        /* ausgefallen                  */
  if (rp->quality && !quality)          /* faellt eine Route aus?       */
    pp->num_routes--;
  if (!rp->quality && quality)          /* neue Route?                  */
    pp->num_routes++;
  rp->quality = quality;                /* Qualitaet neu setzen         */
  rp->timeout = (pp->secured)
                ? (0)                   /* ohne Timeout                 */
                : ROUTE_TIMEOUT;
}

/************************************************************************/
/*                                                                      */
/* Eintragen der L3-Lifetime fuer ein Ziel                              */
/*                                                                      */
/************************************************************************/
void
update_lt(PEER *pp, INDEX index, int lt)
{
  (pp->routes + index)->lt = lt;
}

/************************************************************************/
/*                                                                      */
/* Feststellen, ob sich der Alias aendert, und bei neuem Alias diesen   */
/* eintragen.                                                           */
/*                                                                      */
/************************************************************************/
BOOLEAN
update_alias(INDEX index, const char *alias)
{
  NODE *np = netp->nodetab + index;

  if (cmpcal(alias, nulide))            /* kein Alias gemeldet          */
    return (FALSE);
  if (cmpcal(np->alias, alias))         /* keine Aenderung              */
    return (FALSE);
  cpyals(np->alias, alias);             /* neuen Alias setzen           */
  return (TRUE);
}

BOOLEAN
update_ssid(INDEX index, int ssid_high)
{
  NODE *np = netp->nodetab+index;

  if (np->ssid_high == ssid_high)
    return (FALSE);                     /* keine Aenderung              */
  np->ssid_high = ssid_high;            /* obere SSID-Grenze nachtragen */
  return (TRUE);                        /* geaendert                    */
}

/* Grenzen pruefen                                                         */
static void range(ULONG *oldval, ULONG newval)
{
  if (newval < RTT_MIN)
    newval = RTT_MIN;
  if (newval <= RTT_MAX) {          /* noch nicht am Horizont?             */
    *oldval = newval;
  } else
    *oldval = 0;
}

/* Glaettung durchfuehren und Grenzen pruefen                              */
void smooth(ULONG *oldval, ULONG newval)
{
  if (newval < RTT_MIN)
    newval = RTT_MIN;
  if (newval <= RTT_MAX) {          /* noch nicht am Horizont?             */
    if (*oldval)                    /* nicht die erste Messung             */
      *oldval = ((*oldval + 1) * RTT_ALPHA1 - 1 + newval) / RTT_ALPHA2;
    else
      *oldval = (newval * RTT_BETA);
    if (*oldval < 1)
      *oldval = 1;
  } else
    *oldval = 0;                    /* Link ist tot, komplette Neumessung  */
                                    /* ist notwendig                       */
}

/* Die Qualitaet eines Segmentes aktualisieren, wir unterscheiden dabei
   seine und unsere Messung. Unbekannte/unveraenderte Werte werden
   durch IGNORE_RTT (==0) uebergeben.
   pp->his_quality und pp->my_quality koennen folgende Werte annehmen:

   0                     noch keine Messung in diese Richtung erfolgreich
   RTT_MIN...RTT_MAX     gueltiger Messwert
   groesser RTT_MAX      Peer nicht erreichbar

   pp->quality wird auf RTT_MAX+1 gesetzt
    - wenn pp->my_quality nicht gueltig *oder* unbekannt
    - wenn pp->his_quality nicht gueltig ist
*/

void update_peer_quality(
PEER *pp,                           /* fuer welches Segment?               */
ULONG my_quality,                   /* meine Messung                       */
ULONG his_quality)                  /* Nachbarqualitaet                    */
{
  if (his_quality != DONT_CHANGE_QUAL) {
    if (his_quality > 0)            /* hat er eine Messung?                */
      range(&pp->his_quality, his_quality);
    else
      if (his_quality == 0)
        pp->his_quality = 0;
  }

  if (my_quality != DONT_CHANGE_QUAL) {
    if (my_quality > 0)               /* unsere Messung gueltig?             */
      smooth(&pp->my_quality, my_quality);
    else
      if (my_quality == 0)
        pp->my_quality = 0;
  }

  if (pp->my_quality == 0)
    pp->quality = 0;
  else {
    if (pp->typ == FLEXNET)
      range(&pp->quality,
            (pp->my_quality + (pp->his_quality ? pp->his_quality : 6000))/2);
    else
      pp->quality = pp->my_quality;
  }

  update_primary_peer(pp->l2link->call);
}

/************************************************************************/
/*                                                                      */
/* Routen ueber das Segment verwerfen                                   */
/*                                                                      */
/************************************************************************/
static void
clear_peer(PEER *pp)
{
  memset(pp->routes, 0, netp->max_nodes*sizeof(ROUTE));
  pp->num_routes = 0;                   /* Routen loeschen              */
  drop_unreachable_nodes();             /* Routes/Nodes loeschen        */
}

/************************************************************************/
/*                                                                      */
/* Linkreset eines Nachbarn                                             */
/*                                                                      */
/************************************************************************/
void
reset_peer(PEER *pp)
{
  int    i;
  NODE  *np;
  ROUTE *rp;
  int    max_nodes = netp->max_nodes;

  if (pp->typ <= TNN)
    set_peer_typ(pp, NETROM);
  for (i = 0, np = netp->nodetab, rp = pp->routes;
       i < max_nodes;
       i++, np++, rp++)
  {
    if (!np->id[0])                     /* freier Eintrag?              */
      continue;
    rp->reported_quality = 0;           /* Eintrag muss gemeldet werden */
    if (rp->quality != 0)               /* Nachbar hatte gemeldet       */
      if (   rp->timeout == 0           /* bisher sichere Route oder    */
          || rp->timeout > 4)           /* Timeout zu gross?            */
      rp->timeout = 4;                  /* neues Timeout 3-4 Minuten    */
  }
  update_peer_quality(pp, 0, DONT_CHANGE_QUAL);
  drop_unreachable_nodes();
}

/************************************************************************/
/*                                                                      */
/* Verbindung zum Segment hergestellt                                   */
/*                                                                      */
/************************************************************************/
void
connect_peer(PEER *pp)
{
  clear_peer(pp);                   /* Alle Ziele loeschen (erstmal)    */
}

/************************************************************************/
/*                                                                      */
/* Verbindung zum Segment beendet                                       */
/*                                                                      */
/************************************************************************/
void
disconnect_peer(PEER *pp)
{
  clear_peer(pp);                       /* alle Routen loeschen         */
}

void set_peer_typ(PEER *pp, int typ)
{
  pp->typ = typ;
  pp->secured =    (typ == LOCAL_M)
                || (typ == LOCAL)
                || (typ == FLEXNET)
                || (typ == INP);
}

/* End of src/l3a.c */
