/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File os/linux/linux.c (maintained by: DF6LN)                         */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#define _TNN_LINUX_C
#include "tnn.h"

static  struct  hostqueue *hostq_root;
static  struct  hostqueue *hostq_last;
static  struct  termios oconin_termios;
static  struct  termios nconin_termios;
static  struct  termios oconout_termios;
static  struct  termios nconout_termios;
static  struct  timeval tv;
static  struct  timezone tz;
static  struct  timeval tv_old;
static  struct  sockaddr_un serv_addr;
static  int     hostq_len;
static  int     servlen;
static  int     consockfd;
static  int     sockfd;
#ifndef NO_WATCHDOG
static  int     wdpid[2];
static  int     watch_dog[2];
#endif
static  BOOLEAN soc_con;
static  BOOLEAN cons_ini = FALSE;

#ifndef NO_WATCHDOG
static void     watchdog_init(void);
static void     watchdog_exit(void);
#endif
static void     sigterm(int);
static void     host_to_queue(char *, int);
static void     setfiletime(struct ffblk *);

BOOLEAN unlock;
BOOLEAN use_socket;
char    tnn_socket[MAXPATH];
char    start_name[MAXPATH];
char    stop_name[MAXPATH];

/*
   String in Kleinbuchstaben umwandeln - aus DJGPP GNU-Paket fuer MS-DOS
   von D.J. Delorie
*/

char *
strlwr(char *s)
{
  char *p = s;
  while (*s)
  {
    if ((*s >= 'A') && (*s <= 'Z'))
      *s += 'a'-'A';
    s++;
  }
  return(p);
}


/*
   String in Grossbuchstaben umwandeln - aus DJGPP GNU-Paket fuer MS-DOS
   von D.J. Delorie
*/

char *
strupr(char *s)
{
  char *p = s;
  while (*s)
  {
    if ((*s >= 'a') && (*s <= 'z'))
      *s += 'A'-'a';
    s++;
  }
  return(p);
}


/************************************************************************/
/*                                                                      */
/* Als Ersatz fuer die Funktionen "findfirst" und "findnext" (bei DOS)  */
/* werden die Funktionen "xfindfirst" und "xfindnext" verwendet. Hier   */
/* wird nur der fuer TNN benoetigte Teil in die Struktur ffblk einge-   */
/* tragen. Der zuletzt gefundene Filename muss in ffblk->ff_name erhal- */
/* ten bleiben, weil dieser beim Aufruf von "xfindnext" gesucht wird.   */
/*                                                                      */
/************************************************************************/

int
xfindfirst(const char *pathname, struct ffblk *ffblk, int attrib)
{
  char          *fnpoi;
  DIR           *dp;
  struct dirent *dirp;
  int           retval;

  strcpy(ffblk->ff_path, pathname);             /* Filename incl. Pfad  */
  normfname(ffblk->ff_path);                    /* '\\' -> '/'          */
  fnpoi = strrchr(ffblk->ff_path, '/');         /* Pfad angegeben?      */
  if (fnpoi == NULL)                            /* - nein ..            */
   {
    strcpy(ffblk->ff_find, ffblk->ff_path);     /* Filename kopieren    */
    strcpy(ffblk->ff_path, textpath);           /* default: textpath    */
   }
  else                                          /* mit Pfad             */
   {
    if (fnpoi == ffblk->ff_path+strlen(ffblk->ff_path)) /* ohne Name    */
      return(-1);                                       /* Unsinn       */
    strcpy(ffblk->ff_find, ++fnpoi);    /* nur Filename                 */
    *fnpoi = NUL;                       /* Filename im Pfad loeschen    */
   }

  if ((dp = opendir(ffblk->ff_path)) == NULL) /* Directory vorhanden?   */
    return(-1);
  retval = -1;                          /* default: nix gefunden        */
  while ((dirp = readdir(dp)) != NULL)  /* Eintrag vorhanden?           */
   {
    if ((fnmatch(ffblk->ff_find, dirp->d_name,
                 FNM_PATHNAME|FNM_PERIOD) != 0))
      continue;
    strcpy(ffblk->ff_name, dirp->d_name);
    setfiletime(ffblk);
    retval = 0;
    break;
   }
  closedir(dp);
  return(retval);
}

/************************************************************************/
/*                                                                      */
/* Erst den zuletzt gefundenen Eintrag suchen (steht in ffblk->ff_name) */
/* und den darauffolgenden passenden Eintrag zurueckmelden.             */
/*                                                                      */
/************************************************************************/

int
xfindnext(struct ffblk *ffblk)
{
  DIR           *dp;
  struct dirent *dirp;
  int           retval;

  if ((dp = opendir(ffblk->ff_path)) == NULL) return(-1);
  retval = -1;                          /* default: nix gefunden        */
  while ((dirp = readdir(dp)) != NULL)
   {
    if ((fnmatch(ffblk->ff_name, dirp->d_name,
                 FNM_PATHNAME|FNM_PERIOD) != 0))
      continue;
    retval = 1;
    break;
   }
  if (retval == 1)
   {
    retval = -1;                          /* default: nix gefunden      */
    while ((dirp = readdir(dp)) != NULL)
     {
      if ((fnmatch(ffblk->ff_find, dirp->d_name,
                   FNM_PATHNAME|FNM_PERIOD) != 0))
        continue;
      strcpy(ffblk->ff_name, dirp->d_name);
      setfiletime(ffblk);
      retval = 0;
      break;
     }
   }
  closedir(dp);
  return(retval);
}

/************************************************************************/
/*                                                                      */
/* Bei xfindfirst und xfindnext Datum und Uhrzeit im Fileblock setzen   */
/*                                                                      */
/************************************************************************/

static void
setfiletime(struct ffblk *ffblk)
{
  struct stat  filestat;
  struct tm   *filetime;
  char         fn[MAXPATH];

  sprintf(fn, "%s%s", ffblk->ff_path, ffblk->ff_name);
  stat(fn, &filestat);
  filetime = gmtime(&filestat.st_mtime);
  ffblk->ff_ftime =   ((filetime->tm_sec / 2) & 0x1f)
                    + ((filetime->tm_min & 0x3f) << 5)
                    + ((filetime->tm_hour & 0x1f) << 11);
  ffblk->ff_fdate =   (filetime->tm_mday & 0x1f)
                    + ((filetime->tm_mon & 0x0f) << 5)
                    + (((filetime->tm_year - 80) & 0x7f) << 9);
}

/************************************************************************/
/*                                                                      */
/* Temporaeren Filenamen generieren und pruefen auf Verwendbarkeit,     */
/* d.h. Grossbuchstaben sind nicht erlaubt, damit die Datei bei ccpread */
/* gefunden wird.                                                       */
/*                                                                      */
/************************************************************************/

char *
xtempnam(const char *directory, const char *prefix)
{
  char   *fn;
  int     i;

  LOOP
   {
    fn = tempnam(directory, prefix);    /* Filename generieren          */
    if (fn == NULL) return(NULL);       /* wenn nicht moeglich          */
    for (i = 0; i < strlen(fn); i++)    /* Filenamen untersuchen        */
     {
      if (fn[i] != tolower(fn[i]))      /* Grossbuchstabe geht nicht    */
       {
        free(fn);                       /* Filename nicht verwendet     */
        fn = NULL;
        break;
       }
     }
    if (fn != NULL) return(fn);         /* wenn Filename gefunden       */
   }
}


/************************************************************************/
/*                                                                      */
/* Ermitteln des freien Festplattenplatzes in Bytes.                    */
/*                                                                      */
/* Damit es fuer grosse Festplatten keinen Ueberlauf gibt (Rueckgabe    */
/* ist vom Typ LONG), wird ab 1GB freiem Speicher immer 1GB zurueck-    */
/* gemeldet - sieht da jemand Probleme?                                 */
/*                                                                      */
/************************************************************************/

LONG
getdiskfree(char *path)
{
  FILE  *fp;
  char  str[100];
  ULONG frei;

  sprintf(str, "df %s", path);
  fp = popen(str, "r");
  fgets(str, 100, fp);
  fgets(str, 100, fp);
  pclose(fp);
  sscanf(str, "%*s %*s %*s %lu", &frei);
  if (frei >= 1024 * 1024 * 1024)
    return(1024 * 1024 * 1024);
  else
    return(frei * 1024);
}

/************************************************************************/
/*                                                                      */
/* Fuer das erweiterte AUTOBIN-Protokoll wird die File-Zeit in einem    */
/* Bitfeld gespeichert (s. Doku zu DPBOX), wie es BC++ bei dem Befehl   */
/* getftime verwendet. Hier wird die Linux-Zeit der letzten Aenderung   */
/* verwendet.                                                           */
/*                                                                      */
/************************************************************************/

int
getftime(int handle, struct ftime *ftimep)
{
  struct stat filestat;
  struct tm   *filetime;

  if (fstat(handle, &filestat) == -1) return(-1);
  filetime = gmtime(&filestat.st_mtime);
  ftimep->ft_tsec = filetime->tm_sec / 2;
  ftimep->ft_min = filetime->tm_min;
  ftimep->ft_hour = filetime->tm_hour;
  ftimep->ft_day = filetime->tm_mday;
  ftimep->ft_month = filetime->tm_mon;
  ftimep->ft_year = filetime->tm_year - 80;
  return(0);
}

/************************************************************************/
/*                                                                      */
/* Fuer DOS-Kompatibilitaet - Programm starten und Exit-Code des        */
/* Programms zurueckgeben                                               */
/*                                                                      */
/************************************************************************/

int
spawnl(int mode, const char *path, const char *arg0, const char *arg1,
       const char *arg2, const char *arg3, const char *arg4, const char *arg5)
{
  pid_t          pid;
  int            status;

  if (mode != P_WAIT)
   {
    errno = EINVAL;
    return(-1);
   }
  if ((pid = fork()) < 0)
   {
    errno = ENOMEM;
    return(-1);
   }
  else
    if (pid == 0)
      if (execl(path, arg0, arg1, arg2, arg3, arg4, arg5) < 0) exit(-1);
  waitpid(pid, &status, 0);
  return(status);
}

/************************************************************************/
/*                                                                      */
/* Groesse des freien RAM feststellen (wenig aussagekraeftig durch      */
/* SWAP-Partition)                                                      */
/*                                                                      */
/************************************************************************/

ULONG
coreleft(void)
{
  FILE  *fp;
  char  str[100];
  ULONG frei;

  fp = popen("free -b", "r");
  fgets(str, 100, fp);
  fgets(str, 100, fp);
  pclose(fp);
  sscanf(str, "%*s %*s %*s %lu", &frei);
  return(frei);
}

/************************************************************************/
/*                                                                      */
/* Befehlszeile auf Zeichen pruefen, die von der Shell ausgewertet      */
/* werden. Diese werden entwertet durch ein vorangesetztes '\\'.        */
/*                                                                      */
/************************************************************************/

void
security_check(char *cmd)
{
  char *cmdpoi;
  char tmpcmd[MAXPATH];
  int  i;
  char ch;

  cmdpoi = cmd;
  for (i = 0; i < MAXPATH - 2; i++)
   {
    ch = *cmdpoi++;
    if (ch == NUL) break;
    if (strchr("*?\\|&;()<>$'`{}[]^#\"", ch) != NULL)
      tmpcmd[i++] = '\\';
    tmpcmd[i] = ch;
   }
  tmpcmd[i] = NUL;
  strcpy(cmd, tmpcmd);
}

/************************************************************************/
/*                                                                      */
/* 10ms-Ticker updaten                                                  */
/*                                                                      */
/************************************************************************/

char uhrzeit[40];

void
update_timer(void)
{
  fd_set rmask;
  struct timeval timevalue;
  int max_fd;
  int count;
  int i;
  int len;
  char buffer[1024];
  int  clilen;
  struct sockaddr_un cli_addr;

  gettimeofday(&tv, &tz);
  sprintf(uhrzeit, "%s", ctime((time_t *) &tv.tv_sec));
#ifndef NO_WATCHDOG
  write(watch_dog[1], "\0", 1);
#endif
  tic10 = (tv.tv_sec - tv_old.tv_sec) * 100 +
          (tv.tv_usec - tv_old.tv_usec) / 10000;
  max_fd = 0;
  FD_ZERO(&rmask);
  if (!use_socket)
   {
    FD_SET(0, &rmask);                          /* Eingabe Console      */
    max_fd = 1;
   }
  else
   {
    if (!soc_con)
     {
      FD_SET(sockfd, &rmask);
      if (sockfd > max_fd - 1)
       {
        max_fd = sockfd + 1;
       }
     }
    else
     {
      FD_SET(consockfd, &rmask);
      if (consockfd > max_fd - 1)
       {
        max_fd = consockfd + 1;
       }
     }
   }
  if (kiss_active)
   {
    for (i = 0; i < L1PNUM; ++i)
     {
      if (l1port[i].kisslink < 0)
        continue;
      if (l1port[i].port_active)
       {
        FD_SET(l1port[i].kisslink, &rmask);
        if (l1port[i].kisslink > max_fd -1)
          max_fd = l1port[i].kisslink + 1;
       }
     }
   }

  timevalue.tv_usec = 10000;
  timevalue.tv_sec = 0;
  count = select(max_fd, &rmask, NULL, NULL, &timevalue);
  if (count == -1) return;
  if (!use_socket)
   {
    if (FD_ISSET(0, &rmask))
      if ((len = read(0, buffer, 1024)) != 0)
        host_to_queue(buffer, len);
   }
  else
   {
    if (!soc_con)
     {
      if (FD_ISSET(sockfd, &rmask))
       {
        clilen = sizeof(cli_addr);
        consockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
        if (consockfd >= 0)
          soc_con = TRUE;
       }
     }
    else
      if (FD_ISSET(consockfd, &rmask))
       {
        len = read(consockfd, buffer, 1024);
        if ((len == -1) || (len == 0))
         {
          close(consockfd);
          soc_con = FALSE;
         }
        else
          host_to_queue(buffer, len);
       }
   }
  if (kiss_active)
   {
    for (i = 0; i < L1PNUM; ++i)
     {
      if (l1port[i].kisslink == -1)
        continue;
#ifdef VANESSA
      if (l1port[i].kisstype == KISS_VAN)
        continue;
#endif
#ifdef AX_IPX
      if (l1port[i].kisstype == KISS_IPX)
        continue;
#endif
#ifdef AX25IP
      if (l1port[i].kisstype == KISS_AXIP)
        continue;
#endif
      if (l1port[i].port_active)
        if (FD_ISSET(l1port[i].kisslink, &rmask))
         {
          if ((len = read(l1port[i].kisslink, buffer, 1024)) != 0)
            framedata_to_queue(i, buffer, len);
         }
     }
   }
}

/************************************************************************/
/*                                                                      */
/* Rechner neu starten                                                  */
/*                                                                      */
/************************************************************************/

void
reboot_system(void)
{
  exit_all();
  sync();
  CRASH();
  system("/sbin/shutdown -r now");
/* Hierher wird man wohl nur kommen, wenn tnn nicht als root gestartet  */
/* wurde. Nun gibt es 2 Moeglichkeiten: entweder wir starten von vorne, */
/* weil die Resourcen ja breits freigegeben wurden, oder aber wir       */
/* beenden das Programm, weil das ja mehr oder weniger gefordert wurde. */
/* Sinnvoller ist es wohl, wenn wir das Programm verlassen, in der      */
/* Hoffnung, dass es danach regulaer von einem Batch erneut gestartet   */
/* wird. Das ist jedenfalls besser, als nix zu tun.                     */
  exit(1);
}


/************************************************************************/
/*                                                                      */
/* Shell-Befehl - Linux-spezifischer Teil:                              */
/* Das gewuenschte Programm wird als Hintergrundprozess gestartet.      */
/*                                                                      */
/************************************************************************/

BOOLEAN
tnnshell(char *cmdline)
{
  char tempfile[MAXPATH];
  char sysline[MAXPATH+1];
  FILE  *fp;

  strncpy(sysline, cmdline, MAXPATH);
  sysline[MAXPATH] = NUL;
  sprintf(userpo->fnsav, "%08lx", tic10);       /* Startzeit merken     */
  sprintf(tempfile, "%s%08lx.tmp", textpath, tic10);
  strcat(sysline, " &> ");      /* stdout UND stderr ins File schreiben */
  strcat(sysline, tempfile);    /* Befehl fuer Shell komplett           */
  if ((userpo->child_pid = fork()) < 0)
   {
    userpo->child_pid = 0;
    fp = xfopen(tempfile, "wb");
    fprintf(fp, "Fork Error!\n");
    fclose(fp);
    strcpy(cmdline, tempfile);
    return(FALSE);
   }
  else
   {
    if (userpo->child_pid == 0)       /* Kind-Prozess                 */
     {
      setpgrp();
      system(sysline);                /* Befehl ausfuehren            */
      exit(0);                        /* Prozess beenden              */
     }
    else                              /* Hauptprogramm                */
     {
      setpgid(userpo->child_pid,
              userpo->child_pid);
      userpo->child_timeout = 60;     /* max. 1 Min. fuer Programm    */
      userpo->status = US_EXTP;       /* externes Programm laeuft     */
      return(TRUE);
     }
   }
  return(TRUE);
}

/************************************************************************/
/*                                                                      */
/* Pruefen, ob Kind-Prozesse beendet sind (vom Sysop gestartete externe */
/* Programme). Bei Zeitueberschreitung wird das Programm mit einer      */
/* entsprechenden Fehlermeldung abgebrochen. Auf jeden Fall wird das    */
/* Antwort-File ausgegeben.                                             */
/*                                                                      */
/************************************************************************/

void
shellsrv(void)
{
  pid_t          c_pid;
  char           tempfile[MAXPATH+1];

  for (userpo  = (USRBLK *) usccpl.head;
       userpo != (USRBLK *) &usccpl;
       userpo  = (USRBLK *) userpo->unext)
   {
    if (userpo->status != US_EXTP)      /* externer Prozess aktiv?      */
      continue;                         /* nein ..                      */
    c_pid = waitpid(userpo->child_pid,  /* dieser Prozess beendet?      */
                    NULL, WNOHANG);
    if (c_pid <= 0)                     /* noch nicht fertig?           */
     {
      if (--userpo->child_timeout == 0) /* zu lange aktiv?              */
       {
        kill(-(userpo->child_pid), SIGKILL);    /* Abbruch (Watchdog)   */
        waitpid(userpo->child_pid,              /* Prozess-Status holen */
                NULL, 0);                       /* sonst gips 'n Zombie */
        putmsg("ABORTED (TIMEOUT)\r");
       }
      else continue;                            /* hat noch Zeit        */
     }
    userpo->child_pid = 0;                      /* Prozess ist fertig   */
    userpo->child_timeout = 0;
    userpo->status = US_CCP;
    sprintf(tempfile, "%s%s.tmp", textpath, userpo->fnsav);
    userpo->fdefblk = (MB *) allocb(ALLOC_MB);
    tempfile[63] = NUL;
    strcpy(userpo->fdefblk->data, tempfile);
    relink((LEHEAD *)userpo->fdefblk, (LEHEAD *)fdfl.tail);
    ccpread(tempfile);                  /* Ergebnis dem User sagen      */
   }
}

/************************************************************************/
/*                                                                      */
/* User-Eingabe in mhdp verarbeiten                                     */
/*                                                                      */
/************************************************************************/

BOOLEAN
l7tosh(MBHEAD *mhdp)
{
  char  tempfile[MAXPATH];

  if (userpo->status == US_EXTP)            /* externer Prozess aktiv?  */
   {
    dealmb(mhdp);                           /* Abbruchzeile ignorieren  */
    userpo->mbhd = NULL;
    kill(-(userpo->child_pid), SIGKILL);    /* Abbruch (Watchdog)       */
    waitpid(userpo->child_pid,              /* Prozess-Status holen     */
            NULL, 0);                       /* sonst gips 'n Zombie     */
    putmsg("ABORTED by User\r");
    userpo->child_pid = 0;                  /* Prozess ist fertig       */
    userpo->child_timeout = 0;
    userpo->status = US_CCP;
    sprintf(tempfile, "%s%s.tmp", textpath, userpo->fnsav);
    userpo->fdefblk = (MB *) allocb(ALLOC_MB);
    tempfile[63] = NUL;
    strcpy(userpo->fdefblk->data, tempfile);
    relink((LEHEAD *)userpo->fdefblk, (LEHEAD *)fdfl.tail);
    ccpread(tempfile);                      /* Ergebnis dem User sagen  */
    return(TRUE);
   }
  return(FALSE);
}

/************************************************************************/
/*                                                                      */
/* Filenamen pruefen                                                    */
/*                                                                      */
/************************************************************************/

BOOLEAN
good_file_name(const char *file)
{
  if (strncmp("/bin/", file, 5) == 0) return(FALSE);
  if (strncmp("/dev/", file, 5) == 0) return(FALSE);
  if (strncmp("/proc/", file, 6) == 0) return(FALSE);
  if (strncmp("/sbin/", file, 6) == 0) return(FALSE);
  if (strncmp("/usr/bin/", file, 9) == 0) return(FALSE);
  if (strncmp("/usr/sbin/", file, 10) == 0) return(FALSE);
  if (strncmp("/usr/local/bin/", file, 16) == 0) return(FALSE);
  if (strncmp("/usr/local/sbin/", file, 17) == 0) return(FALSE);
  return(TRUE);
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
tnnexec(char *file_name)
{
  if (access(file_name, X_OK) == 0)     /* nur ausfuehrbares Programm   */
   {
    exit_all();                         /* Resourcen freigeben          */
    execl(file_name, NULL, NULL);       /* Programm starten             */
/* Hierher darf man eigentlich nicht kommen! Daher verlassen wir das    */
/* Programm in der Hoffnung, dass es danach regulaer von einem Batch    */
/* erneut gestartet wird.                                               */
    exit(1);
   }
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
init_console(void)
{
  if (cons_ini)
    return;
  if (!use_socket)
   {
    setvbuf(stdout, NULL, _IONBF, 0);           /* Ausgabe ungepuffert  */
    tcgetattr(fileno(stdin), &oconin_termios);
    tcgetattr(fileno(stdout), &oconout_termios);
    nconin_termios = oconin_termios;
    nconin_termios.c_cc[VTIME] = 0;
    nconin_termios.c_cc[VMIN] = 1;
    nconin_termios.c_cc[VSTART] = -1;
    nconin_termios.c_cc[VSTOP] = -1;
    nconin_termios.c_iflag = IGNBRK;
    nconin_termios.c_oflag = OPOST|ONLCR;
    nconin_termios.c_lflag = 0;
    nconin_termios.c_cflag = (CS8|CREAD|CLOCAL);
    tcsetattr(fileno(stdin), TCSADRAIN, &nconin_termios);
    nconout_termios = oconout_termios;
    nconout_termios.c_cc[VTIME] = 0;
    nconout_termios.c_cc[VMIN] = 1;
    nconout_termios.c_cc[VSTART] = -1;
    nconout_termios.c_cc[VSTOP] = -1;
    nconout_termios.c_iflag = IGNBRK|ICRNL;
    nconout_termios.c_oflag = OPOST|ONLCR|ONLRET|OCRNL;
    nconout_termios.c_lflag = 0;
    nconout_termios.c_cflag = (CS8|CREAD|CLOCAL);
    tcsetattr(fileno(stdout), TCSAFLUSH, &nconout_termios);
    consfile = stdout;
   }
  else
    consfile = NULL;
  hostq_root = NULL;
  hostq_last = NULL;
  hostq_len = 0;
  cons_ini = TRUE;
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
exit_console(void)
{
  struct hostqueue *hostq_ptr;

  while (hostq_root != NULL) {
    hostq_ptr = hostq_root;
    hostq_root = hostq_ptr->next;
    free(hostq_ptr);
  }
  hostq_last = NULL;
  hostq_len = 0;
  exit_proc();
  if ((!cons_ini) || (use_socket))
    return;
  tcsetattr(1, TCSADRAIN, &oconout_termios);
  tcsetattr(0, TCSADRAIN, &oconin_termios);
  cons_ini = FALSE;
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

static void
alloc_hostqbuf(void)
{
  struct hostqueue *hostq_ptr;

  hostq_ptr = (struct hostqueue *) malloc(sizeof(struct hostqueue));
  if (hostq_ptr == NULL) {
    exit_all();
    exit(1);
  }
  hostq_ptr->first = 0;
  hostq_ptr->last = 0;
  hostq_ptr->next = NULL;
  if (hostq_root == NULL) {
    hostq_root = hostq_ptr;
  }
  else {
    hostq_last->next = hostq_ptr;
    hostq_last = hostq_ptr;
  }
  hostq_last = hostq_ptr;
}

/* put one character in host-queue */

static void
puthostq(char ch)
{
  struct hostqueue *hostq_ptr;

  if (hostq_root == NULL) {
    alloc_hostqbuf();
  }
  hostq_ptr = hostq_last;
  if (hostq_ptr->last >= HOSTQ_BUFLEN) {
    alloc_hostqbuf();
    hostq_ptr = hostq_last;
  }
  hostq_ptr->buffer[hostq_ptr->last] = ch;
  hostq_ptr->last++;
  hostq_len++;
}

/* get one character out of host-queue */

static char
gethostq(void)
{
  struct hostqueue *hostq_ptr;
  char ch;

  if ((hostq_len == 0) || (hostq_root == NULL)) /* sanity check         */
    return(0);
  hostq_ptr = hostq_root;
  ch = hostq_ptr->buffer[hostq_ptr->first];
  hostq_ptr->first++;
  hostq_len--;
  if ((hostq_ptr->first == hostq_ptr->last) ||
      (hostq_ptr->first == HOSTQ_BUFLEN)) {
    if (hostq_ptr->next == NULL) {
      hostq_root = NULL;
      hostq_last = NULL;
    }
    else {
      hostq_root = hostq_ptr->next;
    }
    free(hostq_ptr);
  }
  return(ch);
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
hputc(char c)
{
  int res;

  if (tnb_ch)
   {
    if (consfile != NULL)
     {
      fputc(c, consfile);
     }
    return;
   }
  if (use_socket)
   {
    if (soc_con)
     {
      res = write(consockfd, &c, 1);
      if (res == -1)
       {
        close(consockfd);
        soc_con = FALSE;
       }
     }
   }
  else
   {
    if ((c == '\n') || (c == '\r'))
     {
      putchar(LF);
     }
    else putchar(c);
   }
}

/* return if character available */

BOOLEAN
ishget(void)
{
  return(hostq_len != 0);
}

/* return if output to console is stopped */

BOOLEAN
ishput(void)
{
  return(FALSE);
}

/* get one character from console */

char
hgetc(void)
{
  char ch;

  ch = gethostq();
  if (!use_socket)
    if (ch == LF) ch = CR;
  return(ch);
}

/* put received characters in hostbuffer */

static void
host_to_queue(char *buffer, int len)
{
  char *bufptr;
  int i;

  bufptr = buffer;
  i = 0;
  while (i < len) {
    puthostq(*bufptr);
    i++;
    bufptr++;
  }
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

BOOLEAN
init_hardware(int argc, char *argv[])
{
  umask(0);
  time(&sys_time);
  if (read_init_file(argc, argv))
    return(TRUE);
  if (!init_proc())
    exit(1);
  if (tnn_errfile[0] != NUL)
  {
  }
  RAMBOT = (char *)malloc(tnn_buffers * sizeof(MAX_BUFFER));
  RAMTOP = RAMBOT + tnn_buffers * sizeof(MAX_BUFFER);
  if (RAMBOT == NULL)
   {
    RAMBOT = (char *)malloc(TNN_BUFFERS * sizeof(MAX_BUFFER));
    RAMTOP = RAMBOT + TNN_BUFFERS * sizeof(MAX_BUFFER);
    if (RAMBOT == NULL)
     {
      fprintf(stderr, "malloc for buffers failed\n");
      exit(1);
     }
    else
      tnn_buffers = TNN_BUFFERS;
   }

  if (kiss_active)
  {
    if (init_kisslink())
    {
      free(RAMBOT);
      exit(1);
    }
  }

  if (use_socket)
  {
    if ((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
    {
      printf("Can't open socket\n");
      free(RAMBOT);
      if (kiss_active)
        exit_kisslink();
      exit(1);
    }
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sun_family = AF_UNIX;
    strcpy(serv_addr.sun_path, tnn_socket);
    servlen = strlen(serv_addr.sun_path) + sizeof(serv_addr.sun_family);
    unlink(serv_addr.sun_path);
    if (bind(sockfd, (struct sockaddr *) &serv_addr, servlen) < 0)
    {
      printf("Can't bind socket\n");
      free(RAMBOT);
      if (kiss_active)
        exit_kisslink();
      exit(1);
    }
    listen(sockfd, 5);
    if (getppid() != 1)
    {
      if (fork() != 0)
        exit(0);
      else
        if (!init_proc())
          exit(1);
    }
  }

#ifndef NO_WATCHDOG
  watchdog_init();
#endif

  signal(SIGHUP, SIG_IGN);
  signal(SIGTSTP, SIG_IGN);
  signal(SIGTTIN, SIG_IGN);
  signal(SIGTTOU, SIG_IGN);
  signal(SIGTERM, sigterm);
  signal(SIGPIPE, sigterm);

  terminated = 0;
  soc_con = FALSE;

  gettimeofday(&tv, &tz);
  tv_old = tv;

  return(FALSE);
}

#ifndef NO_WATCHDOG
/************************************************************************/
/*                                                                      */
/* Watchdog - ein vom TNN-Hauptprogramm unabhaengiger Prozess muss      */
/* regelmaessig vom Hauptprogramm Daten erhalten. Bleiben diese Daten   */
/* laenger als 60s aus, wird TNN beendet.                               */
/*                                                                      */
/************************************************************************/

static void
watchdog_init(void)
{
  pid_t  pid;
  time_t wdzeit;
  time_t zeit;
  int    num;
  char   buf[100];

  if (pipe(watch_dog) < 0)
    exit(1);
  if ((pid = fork()) < 0)
    exit(1);
  else
    if (pid > 0)
     {
      wdpid[0] = pid;
      close(watch_dog[0]);
      return;
     }
    else
     {
      wdpid[1] = getppid();
      close(watch_dog[1]);
      num = fcntl(watch_dog[0], F_GETFL, 0);
      num |= O_NONBLOCK;
      fcntl(watch_dog[0], F_SETFL, num);
      signal(SIGHUP, SIG_IGN);
      signal(SIGTSTP, SIG_IGN);
      signal(SIGTTIN, SIG_IGN);
      signal(SIGTTOU, SIG_IGN);
      signal(SIGSEGV, SIG_IGN);
      sleep(30);
      time(&zeit);
      time(&wdzeit);
      LOOP
       {
        num = read(watch_dog[0], &buf, 100);
        if (num > 0)
         {
          time(&wdzeit);
          continue;
         }
        time(&zeit);
        if ((zeit - wdzeit) > 60)
          break;
        sleep(1);
       }
      time(&wdzeit);
      kill(-wdpid[1], SIGSEGV);
      exit(0);
     }
}

/************************************************************************/
/*                                                                      */
/* Watchdog-Prozess beenden                                             */
/*                                                                      */
/************************************************************************/

void
watchdog_exit(void)
{
  kill(wdpid[0], SIGTERM);
}
#endif

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
exit_hardware(void)
{
  free(RAMBOT);
  if (kiss_active)
    exit_kisslink();
#ifndef NO_WATCHDOG
  watchdog_exit();
#endif
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

static void
sigterm(int signo)
{
  signal(SIGTERM, SIG_IGN);
  quit_program(-1);
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/

int
exit_all(void)
{
  exit_mh();                            /* MH-Liste sichern             */
  save_stat();
  save_configuration();
  personalmanager(SAVE, NULL, NULL);    /* Pers. Daten fuer Convers     */
  free(RAMBOT);
  if (use_socket)
   {
    if (soc_con)
     {
      close(consockfd);
      soc_con = FALSE;
     }
    close(sockfd);
   }
  else
    exit_console();
  if (kiss_active)
    exit_kisslink();
  exit_proc();
  printf("\r\n");
  return(0);
}

static int load[3];
static int tnn_load;
/************************************************************************/
/*                                                                      */
/* Systembelastung durch TNN berechnen                                  */
/* diese Routine muss alle 10 Sekunden aufgerufen werden                */
/*                                                                      */
/************************************************************************/
void
calculate_load(void)
{
  static long clktck = 0;
  static int  oldtime;
  static  pid_t tnnpid;
  FILE   *fp;
  int     utime, stime, gtime, x, z;
  char    proc_name[80], buffer[10], ch;

  if (clktck == 0)
   {
    clktck = sysconf(_SC_CLK_TCK);
    tnnpid = getpid();
    oldtime = 0;
    load[0] = 0;
    load[1] = 0;
    load[2] = 0;
   }

  sprintf(proc_name , "/proc/%d/stat", tnnpid);

/* stat-Datei von TNN oeffnen                                           */

  if ((fp = fopen(proc_name, "r")))
   {
    fscanf(fp, "%*d %*s %*c %*d %*d %*d %*d "
               "%*d %*u %*u %*u %*u %*u %d %d",
                &utime, &stime);

/* User- & System-Time addieren und in Sekunden umrechnen               */

    gtime = (utime + stime) - oldtime;

/* die letzten Zeiten fuer neue Berechnung merken                       */

    oldtime = utime + stime;

/* Prozente ausrechnen                                                  */

    tnn_load = ((gtime * 100) / (10 * clktck));

    fclose(fp);
   }
  else
    tnn_load = FALSE;                           /* Fehler !             */

/*  Systemload aus /proc/loadavg lesen                                  */

  if ((fp = fopen("/proc/loadavg", "r")))
   {
    for (x = 0; x <= 2; x++)
     {
      z = 0;
      ch = fgetc(fp);
      while (ch != ' ')
       {
        if (ch != '.')
         {
          buffer[z] = ch;
          z++;
         }
        ch = fgetc(fp);
       }

/* der Eintrag ist zu Ende, also ausgeben                               */

      if (ch == ' ')
       {
        buffer[z++] = 0;

/* wir wandeln hier schonmal um, vielleicht kann man es spaeter         */
/* brauchen :-)                                                         */

        load[x] = atoi(buffer);
       }
     }

    fclose(fp);
   }
  else
    load[0] = FALSE;
}

/************************************************************************/
/*                                                                      */
/* Load-Werte ausgeben                                                  */
/*                                                                      */
/************************************************************************/
void
print_load(MBHEAD *mbp)
{
  if (tnn_load >= 0)
    putprintf(mbp, "\r          TNN-Load: %i%%", tnn_load);
   else                 /* mhh...Kernel ohne /proc-System compiliert ?  */
     putprintf(mbp, "\r         Sysload : can't read stat from /proc !");

/* Systemlast ausgeben (siehe auch man proc)                            */

   if (load[0] >= 0)
     putprintf(mbp, "\r           Sysload: %i%% %i%% %i%%",
                    load[0], load[1], load[2]);
   else                 /* mhh...Kernel ohne /proc-System compiliert ?  */
     putprintf(mbp, "\r         Sysload : can't read sysload from"
                    " /proc/loadavg !");
}

/*
  Dummy-Funktionen
*/

void
init_timer(void) {}
void
DIinc(void) {}
void
decEI(void) {}
void
exit_timer(void) {}
void
init_rs232(void) {}

/* End of os/linux/linux.c */
