/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File os/dos16/pc.c (maintained by: ???)                              */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998, 1999 NORD><LINK e.V. Braunschweig                */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"
#include "pc.h"

#if defined(__DOS16__)
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/* die Folgende _stklen Definition kann ein Warning erzeugen, das ist   */
/* OK !                                                                 */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
extern unsigned _stklen = 0x8000;
#endif

extern BOOLEAN no_umb;

unsigned int_level = 0;
WORD watchdog;          /* Watchdog, Timer erhoeht                      */

int conscom = -1;       /* Schnittstellen-Handle fuer Console           */

//#define DEBUG
#ifdef DEBUG
  FILE *fp;
#endif

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN ishput(void)
{
  return(conscom == -1 ? FALSE : rs232_out_status(conscom));
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN ishget()
{
  if (kbhit())
    if (ishmod)
      hgetc();       /* im Hostmode Console ignorieren */
    else
      return(TRUE);  /* im Terminalmode melden, dass was da ist */
  if (conscom != -1)
    return(rs232_in_status(conscom));
  return(FALSE);     /* keine Umleitung, also auch nix da */
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
char hgetc(void)
{
  #define Prefix 0
  #define ALT_X '-'
  char retval;

  if (kbhit()) {
    if ((retval = getch()) == Prefix)
      if (getch() == ALT_X)
        quit_program(0);
    return(retval);
  }
  if (conscom != -1)
    if ( rs232_in_status(conscom) )
      return(rs232_in(conscom));
  return(0);
}

/**************************************************************************/
/*                                                                        */
/* Zeichen an die Console ausgeben. Wenn eine Umleitung besteht, das      */
/* Zeichen zusaetzlich noch dort ausgeben. Auf die PC-Console wird im     */
/* Hostmode nichts geschrieben.                                           */
/*                                                                        */
/*------------------------------------------------------------------------*/
void hputc(char c)
{
  if (!ishmod) { /* keine Ausgaben im Hostmode */
    if (c == CR) /* nur fuer PC/Console notwenig! */
      putc(LF, consfile);
    putc(c, consfile);
#ifdef DEBUG
    if (c == CR) /* nur fuer PC/Console notwenig! */
      putc(LF, fp);
    putc(c, fp);
#endif
  }
  if (conscom != -1)
    rs232_out(conscom, c);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void update_timer(void)
{
  watchdog = 0; /* Ruhe, wir leben noch         */
}

int c_break(void)
{
  if (int_level != 0) return(1);
  quit_program(0);
  return(0);
}

#pragma argsused
BOOLEAN init_hardware(int argc, char *argv[])
{
  char s[50];
  char *tz_string;

  randomize();                          /* Zufallsgenerator             */

  if (getenv("TNNBUFFERS") != NULL)
     sscanf(getenv("TNNBUFFERS"), "%lu,%s", &MEMORY_NEEDED, &s);

  MEMORY_NEEDED *= sizeof(MAX_BUFFER);

  if (farcoreleft() <= 32767L) {
    printf("*** ERROR: not enough memory!\n");
    exit(1); /* Das geht nun wirklich nicht */
  }

  if (farcoreleft() < MEMORY_NEEDED + 65535L) {
     MEMORY_NEEDED = farcoreleft()/2;
     printf("*** WARNING: not enough memory, buffer pool shrinked!\n");
  }

  if (MEMORY_NEEDED < 1024) MEMORY_NEEDED = 1024;

  if ((RAMBOT = (char huge *) farmalloc(MEMORY_NEEDED)) == NULL)

  {
     /* in 1K Schritten versuchen Speicher zu belegen ... */

     MEMORY_NEEDED = farcoreleft();
     if (MEMORY_NEEDED > 80000L)
       MEMORY_NEEDED -= 70000L;

     while ( (MEMORY_NEEDED > 1024) &&
                ((RAMBOT = (char huge *) farmalloc(MEMORY_NEEDED)) == NULL) )

                 MEMORY_NEEDED -= 1024;
     printf("*** WARNING: Configured memory size couldn't be allocated!\n");
    }

  RAMTOP = RAMBOT + MEMORY_NEEDED; /* Im Fehlerfalle hoffen, das UMB
                                      vorhanden ist, sonst hat man 0 Buffers
                                      und das is ungesund */
  ctrlbrk(c_break);

  /**********************************************************************/
  /* Komandozeile auswerten                                             */
  /**********************************************************************/
  if (argc > 1) hputs("*** WARNING: Parameters ignored");

  /**********************************************************************/
  /* Systemzeit und Zeitberechung initialisieren                        */
  /**********************************************************************/
  tz_string = getenv("TZ");             /* Feststellen, ob TimeZone     */
  if (tz_string == NULL) {              /* gesetzt ist, sonst           */
     putenv("TZ=UTC0");                  /* mit UTC0 vorbelegen          */
     puts("*** WARNING: Timezone set to UTC");
  }
  tzset();                              /* Teitzone auswerten           */

  return(FALSE);
}

/*------------------------------------------------------------------------*/
/* Ein Programm starten, das TNN ersetzt. Falls etwas schiefgeht, kehrt   */
/* die Routine zurueck und der obere Level entscheidet, was zu tun ist.   */
void tnnexec(char *name)
{
  char  file_name[41];

  strncpy(file_name, name, 40);
  file_name[40] = 0x00;
  if (xaccess(file_name, 0) == 0)
  {
      l1exit();
#ifdef __DOS16__
      done_umb(); /* UMB-Speicherbereiche freigeben */
#endif
      exit_timer();
      exit_hardware();
      printf("%s\n", file_name);
      execl(file_name, file_name, NULL);
      perror("EXEC");
      reboot_system();                /* lieber beenden und resetet    */
  }
}

/*------------------------------------------------------------------------*/
/* Eine Shell aufmachen. Da Parallelshell bei DOS nicht moeglich ist,     */
/* ruht TNN solange.                                                      */
BOOLEAN tnnshell(char *cmdline)
{
  char cmd[MAXPATH+MAXPATH+2], *name;

  strncpy(cmd, cmdline, MAXPATH);
  cmd[MAXPATH] = 0;
  name = tempnam(textpath, "sh");
  if (name) {
    strcat(cmd, " > ");
    strcat(cmd, name);
    system(cmd);
    strcpy(cmdline, normfname(name));
    free(name);
  } else cmdline[0] = 0;

  return(FALSE);
}

/*------------------------------------------------------------------------*/
#pragma argsused
BOOLEAN l7tosh(MBHEAD *mbp)
{
  return(FALSE);
}

void shellsrv(void)
{
}

void init_console(void)
{
  int  dev,adr,irq,bd;

  consfile = stdout;

  read_envcom("CONSOLE", &dev, &adr, &irq);
  if (dev != -1) {
    conscom = open_rs232(dev,adr,irq,512,512);
    bd = setbaud(conscom, 96);
    xprintf(" setting to %u00 8N1.\n", bd);
    xprintf("--- CONSOLE attached to /dev/COM%u\n", dev+1);
  }
#ifdef DEBUG
  fp = fopen("PROTO.TXT", "wt+");
#endif
}

void exit_console(void)
{
  if (conscom != -1)
    close_rs232(conscom);
#ifdef DEBUG
  fclose(fp);
#endif
}

/*------------------------------------------------------------------------*/
void exit_hardware()
{
  farfree((void *) RAMBOT);
}

/*------------------------------------------------------------------------*/
void reboot_system()
{
  void (*reboot)(void);                 /* Ziel im Bios                 */

  l1exit();
  reboot = MK_FP(0xffff, 0x0000);       /* Pointer setzen               */
  reboot();                             /* Rechner neu starten          */
}

/*----------------------------------------------------------------------*/
/* Watchdog - RTS an RS232-Schnittstelle toggeln                        */
/*----------------------------------------------------------------------*/
void toggle_rts()
{
#ifdef TOKENRING
  static BOOLEAN flag = TRUE;

  if (tkcom != -1) {
     if (flag) {
        rts_off(tkcom);                /* RTS und DTR toggeln          */
        flag = FALSE;
     }
     else {
        rts_on(tkcom);                 /* RTS und DTR toggeln          */
        flag = TRUE;
     }
  }
#endif /* TOKENRING */
}

/*----------------------------------------------------------------------*/
/*                                                                      */
void decEI(void) {
/*                                                                      */
/* Wenn moeglich Interrupts wieder freigeben                            */
/*                                                                      */
/*----------------------------------------------------------------------*/
  if (--int_level == 0)
     asm sti
}

/*----------------------------------------------------------------------*/
/*                                                                                                          */
void DIinc(void) {
/*                                                                                                          */
/* Interrupts sperren in kritischen Bereichen.                                  */
/*                                                                                                          */
/*----------------------------------------------------------------------*/
  int_level++;
  asm cli
}

/*----------------------------------------------------------------------*/

/* Disable hardware interrupt */
int
maskoff(unsigned irq)
{
        if(irq < 8){
                setbit(0x21,(char)(1<<irq));
        } else if(irq < 16){
                irq -= 8;
                setbit(0xa1,(char)(1<<irq));
        } else {
                return(-1);
        }
        return(0);
}

/* Enable hardware interrupt */
int maskon(unsigned irq)
{
        if(irq < 8){
                clrbit(0x21,1<<irq);
        } else if(irq < 16){
                irq -= 8;
                clrbit(0xa1,1<<irq);
        } else {
                return(-1);
        }
        return(0);
}

/* Return 1 if specified interrupt is enabled, 0 if not, -1 if invalid */
int getmask(unsigned irq)
{
        if(irq < 8)
                return((inportb(0x21) & (1 << irq)) ? 0 : 1);
        else if(irq < 16){
                irq -= 8;
                return((inportb(0xa1) & (1 << irq)) ? 0 : 1);
        } else
                return(-1);
}

/* Set bit(s) in I/O port */
void
setbit(unsigned port,unsigned char bits)
{
        outportb(port,inportb(port)|bits);
}

/* Clear bit(s) in I/O port */
void
clrbit(unsigned port,unsigned char bits)
{
        outportb(port,inportb(port) & ~bits);
}

/* Set or clear selected bits(s) in I/O port */
void writebit(unsigned port,unsigned char mask,int val)
{
        unsigned char x;

        x = inportb(port);
        if(val)
                x |= mask;
        else
                x &= ~mask;
        outportb(port,x);
}

struct int_tab {
    void interrupt (*old)(void);  /* Previous handler at this vector */
        void (*func)(int);            /* Function to call on interrupt */
        int arg;                        /* Arg to pass to interrupt function */
    int chain;
} Int_tab[16];

/* What a crock. All this inelegance should be replaced with something
 * that figures out what interrupt is being serviced by reading the 8259.
 */
static void interrupt irq0(void)
{
    disable();
        eoi();
        (*Int_tab[0].func)(Int_tab[0].arg);
}
static void interrupt irq1(void)
{
    disable();
        eoi();
        (*Int_tab[1].func)(Int_tab[1].arg);
}
static void interrupt irq2(void)
{
    disable();
        eoi();
        (*Int_tab[2].func)(Int_tab[2].arg);
}
static void interrupt irq3(void)
{
    disable();
        eoi();
        (*Int_tab[3].func)(Int_tab[3].arg);
}
static void interrupt irq4(void)
{
    disable();
        eoi();
        (*Int_tab[4].func)(Int_tab[4].arg);
}
static void interrupt irq5(void)
{
    disable();
        eoi();
        (*Int_tab[5].func)(Int_tab[5].arg);
}
static void interrupt irq6(void)
{
    disable();
        eoi();
        (*Int_tab[6].func)(Int_tab[6].arg);
}
static void interrupt irq7(void)
{
    disable();
        eoi();
        (*Int_tab[7].func)(Int_tab[7].arg);
}
static void interrupt irq8(void)
{
    disable();
        eoi();
        (*Int_tab[8].func)(Int_tab[8].arg);
}
static void interrupt irq9(void)
{
    disable();
        eoi();
        (*Int_tab[9].func)(Int_tab[9].arg);
}
static void interrupt irq10(void)
{
    disable();
        eoi();
        (*Int_tab[10].func)(Int_tab[10].arg);
}
static void interrupt irq11(void)
{
    disable();
        eoi();
        (*Int_tab[11].func)(Int_tab[11].arg);
}
static void interrupt irq12(void)
{
    disable();
        eoi();
        (*Int_tab[12].func)(Int_tab[12].arg);
}
static void interrupt irq13(void)
{
    disable();
        eoi();
        (*Int_tab[13].func)(Int_tab[13].arg);
}
static void interrupt irq14(void)
{
    disable();
        eoi();
        (*Int_tab[14].func)(Int_tab[14].arg);
}
static void interrupt irq15(void)
{
    disable();
        eoi();
        (*Int_tab[15].func)(Int_tab[15].arg);
}

static void interrupt (*Vectab[16])(void) = {
        irq0,irq1,irq2,irq3,irq4,irq5,irq6,irq7,irq8,irq9,irq10,irq11,
        irq12,irq13,irq14,irq15
};

int allocirq(unsigned irq, int chain, void (*func)(int),int arg)
{
        struct int_tab *ip;
        unsigned char intno;

        if(irq > 15)
                return(-1);        /* IRQ out of legal range */

        ip = &Int_tab[irq];
        if(ip->func != NULL)
                return(-1);        /* Already in use */
        /* Convert irq to actual CPU interrupt vector */
        intno = (irq < 8) ? irq + 8 : 0x70 + irq - 8;

    ip->old = getvect(intno);
        ip->func = func;
        ip->arg = arg;
        ip->chain = chain;

    setvect(intno, Vectab[irq]);

    return(0);
}

int freeirq(unsigned irq)
{
        struct int_tab *ip;

        if(irq > 15)
                return(-1);        /* IRQ out of legal range */

        ip = &Int_tab[irq];
        ip->func = NULL;
        /* Convert irq to actual CPU interrupt vector */
        irq = (irq < 8) ? irq + 8 : 0x70 + irq - 8;
    setvect(irq, ip->old);

    return(0);
}

/* Re-arm 8259 interrupt controller(s)
 * Should be called just after taking an interrupt, instead of just
 * before returning. This is because the 8259 inputs are edge triggered, and
 * new interrupts arriving during an interrupt service routine might be missed.
 */
void eoi(void)
{
        /* read in-service register from secondary 8259 */
        outportb(0xa0,0x0b);
        if(inportb(0xa0))
                outportb(0xa0,0x20);        /* Send EOI to secondary 8259 */
        outportb(0x20,0x20);        /* Send EOI to primary 8259 */
}

/* End of os/dos16/pc.c */
