/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File os/linux/init.c (maintained by: DF6LN)                          */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998, 1999 NORD><LINK e.V. Braunschweig                */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

/* tfkiss: TNC-emulation for Linux
   Copyright (C) 1995-96 by Mark Wahl
   Procedures for initialization (init.c)
   created: Mark Wahl DL4YBG 95/09/17
   updated: Mark Wahl DL4YBG 96/03/11
 */

#include "tnn.h"

typedef enum
{
  DIRECTORY, ERRORFILE, PROCFILE, SOCKET, START, STOP,
  BUFFERS, DEV, LOCKFILE, SPEED, KISSTYPE, PORT, NIX
}
INITYP;

typedef struct
{
  const char     *name;
  INITYP          typ;
}
INICMD;

static          INICMD
                inicmdtab[] =
{
  {"tnn_dir",           DIRECTORY},
  {"tnn_errfile",       ERRORFILE},
  {"tnn_procfile",      PROCFILE},
  {"tnn_socket",        SOCKET},
  {"tnn_start",         START},
  {"tnn_stop",          STOP},
  {"buffers",           BUFFERS},
  {"device",            DEV},
  {"tnn_lockfile",      LOCKFILE},
  {"speed",             SPEED},
  {"kisstype",          KISSTYPE},
  {"port",              PORT},
  {"",                  NIX}
};

static BOOLEAN
analyse_value(const char *str1, const char *str2)
{
  INICMD *ip;
  int     tmp;

  for (ip = inicmdtab; ip->typ < NIX; ip++)
  {
    if (stricmp(str1, ip->name) == 0)
      break;
  }
  switch (ip->typ)
  {
    case DIRECTORY:
      strcpy(tnn_dir, str2);
      tmp = strlen(tnn_dir);
      if (tnn_dir[strlen(tnn_dir) - 1] != '/')
        strcat(tnn_dir, "/");
      chdir(tnn_dir);
      return (FALSE);

    case ERRORFILE:
      strcpy(tnn_errfile, str2);
      return (FALSE);

    case PROCFILE:
      strcpy(tnn_procfile, str2);
      return (FALSE);

    case SOCKET:
      if (!use_socket)
      {
        strcpy(tnn_socket, str2);
        use_socket = TRUE;
        return (FALSE);
      }
      return (TRUE);

    case START:
      strcpy(start_name, str2);
      return (FALSE);

    case STOP:
      strcpy(stop_name, str2);
      return (FALSE);

    case BUFFERS:
      if (sscanf(str2, "%lu", &tnn_buffers) != 1)
        return (TRUE);
      return (FALSE);

    case DEV:
      if (max_device >= L1PNUM - 1)
        return (TRUE);
      strcpy(l1port[++max_device].device, str2);
      return (FALSE);

    case LOCKFILE:
      if (   (max_device < 0)                           /* kein Device  */
          || (l1port[max_device].tnn_lockfile[0]))      /* Name doppelt */
        return (TRUE);
      strcpy(l1port[max_device].tnn_lockfile, str2);
      return (FALSE);

    case SPEED:
      if (   (max_device < 0)
          || (sscanf(str2, "%d", &tmp) != 1))
        return (TRUE);
      l1port[max_device].speedflag = 0;
      switch (tmp)
      {
        case 0:
          l1port[max_device].speed = B0;
          return (FALSE);

        case 9600:
          l1port[max_device].speed = B9600;
          return (FALSE);

        case 19200:
          l1port[max_device].speed = B19200;
          return (FALSE);

        case 38400:
          l1port[max_device].speed = B38400;
          return (FALSE);

        case 57600:
          l1port[max_device].speed = B38400;
          l1port[max_device].speedflag = ASYNC_SPD_HI;
          return (FALSE);

        case 115200:
          l1port[max_device].speed = B38400;
          l1port[max_device].speedflag = ASYNC_SPD_VHI;
          return (FALSE);

        default:
          return (TRUE);
      }
      return (FALSE);

    case KISSTYPE:
      if (   (max_device < 0)
          || (sscanf(str2, "%d", &tmp) != 1)
#ifndef AX_IPX
          || (tmp == KISS_IPX)
#endif
#ifndef AX25IP
          || (tmp == KISS_AXIP)
#endif
#ifndef VANESSA
          || (tmp == KISS_VAN)
#endif
          || (tmp < KISS_NORMAL)
          || (tmp > KISS_AXIP)
          || ((tmp == KISS_TOK) && (max_device != 0)))
        return (TRUE);
      l1port[max_device].kisstype = tmp;
      if (tmp == KISS_TOK)
      {
        tkcom = 1;
        switch (l1port[0].speed)
        {
          case B9600:
            tkbaud = 96;
            break;
          case B19200:
            tkbaud = 192;
            break;
          case B38400:
            tkbaud = 384;
            if (l1port[0].speedflag == ASYNC_SPD_HI)
              tkbaud = 576;
            if (l1port[0].speedflag == ASYNC_SPD_VHI)
              tkbaud = 1152;
            break;
        }
      }
      return (FALSE);

    case PORT:
      if (   (max_device < 0)
          || (sscanf(str2, "%d", &tmp) != 1)
          || (tmp < 0)
          || (tmp > L2PNUM)
          || (l1port[max_device].kisstype < 0))
        return (TRUE);
      if (l1port[max_device].kisstype == KISS_TOK)
      {
        if (++tokenring_ports >= L2PNUM)
          return (TRUE);
        l1ptab[tmp] = 0;
        l2ptab[max_device] = -1;
        ++used_l1ports;
      }
      else
      {
        if (++used_l1ports >= L2PNUM)
          return (TRUE);
        if (   l1ptab[tmp] == -1                /* Port noch nicht      */
            && l2ptab[max_device] == -1)        /* verwendet?           */
        {
          l1ptab[tmp] = max_device;
          l2ptab[max_device] = tmp;
        }
      }
/* Evtl. sollte noch geprueft werden, ob die Zuordnung der Vanessa-     */
/* ports konsistent ist.                                                */
      return (FALSE);

    default:
      return (TRUE);
  }
  return (FALSE);
}

void
add_tnndir(char *str)
{
  char            temp[80];

  if (str[0] == NUL)
    return;
  if (str[0] != '/')
  {
    strcpy(temp, tnn_dir);
    strcat(temp, str);
    strcpy(str, temp);
  }
}

BOOLEAN
read_init_file(int argc, char *argv[])
{
  FILE           *init_file_fp;
  BOOLEAN         wrong_usage = FALSE;
  BOOLEAN         file_end = FALSE;
  BOOLEAN         file_corrupt = FALSE;
  BOOLEAN         warning = FALSE;
  char            line[82];
  char            str1[82];
  char            str2[82];
  char            tmp_str[80];
  int             rslt;
  char           *str_ptr;
  int             scanned;
  int             i;
  DEVICE         *l1pp;
#ifdef AX_IPX
  int             axipx_ports = 0;
#endif
#ifdef AX25IP
  int             ax25ip_ports = 0;
#endif

  tnn_buffers = TNN_BUFFERS;
  max_device = -1;
  tokenring_ports = -1;
  used_l1ports = -1;
  kiss_active = FALSE;
  use_socket = FALSE;
  tnn_socket[0] =
    start_name[0] =
    stop_name[0] = NUL;
  for (i = 0; i < L1PNUM; i++)
  {
    l1pp = &l1port[i];
    l1pp->device[0] =
      l1pp->tnn_lockfile[0] = NUL;
    l1pp->speed = 0;
    l1pp->speedflag = 0;
    l1pp->kisstype = KISS_NIX;
    l1pp->kisslink = -1;
    l1pp->port_active = FALSE;
    l2ptab[i] = -1;
  }
  for (i = 0; i < L2PNUM; i++)
  {
    l1ptab[i] = -1;
    CLR_L1MODE(i);
    SET_L1MODE(i, MODE_off);
  }
  strcpy(tnn_initfile, "tnn.ini");
  scanned = 1;
  unlock = 0;
  while ((scanned < argc) && (!wrong_usage))
  {
    if (strcmp(argv[scanned], "-i") == 0)
    {
      scanned++;
      if (scanned < argc)
      {
        strcpy(tnn_initfile, argv[scanned]);
      }
      else
        wrong_usage = TRUE;
    }
    else if (strcmp(argv[scanned], "-s") == 0)
    {
      scanned++;
      if (scanned < argc)
      {
        strcpy(tnn_socket, argv[scanned]);
        use_socket = TRUE;
      }
      else
        wrong_usage = TRUE;
    }
    else if (strcmp(argv[scanned], "-u") == 0)
    {
      unlock = 1;
    }
    else
    {
      wrong_usage = TRUE;
    }
    scanned++;
  }
  if (wrong_usage)
  {
    printf("Usage : tnn [-i <init-file>] [-s <tnn-socket>] [-u]\n");
    return (TRUE);
  }

  if (!(init_file_fp = fopen(tnn_initfile, "r")))
  {
    warning = TRUE;
    str_ptr = getenv("HOME");
    if (str_ptr != NULL)
    {
      sprintf(tmp_str, "%s/%s", str_ptr, tnn_initfile);
      if ((init_file_fp = fopen(tmp_str, "r")) != NULL)
        warning = FALSE;
    }
#ifdef INIPATH
    if (!init_file_fp)
    {
      sprintf(tmp_str, "%s/%s", INIPATH, tnn_initfile);
      if ((init_file_fp = fopen(tmp_str, "r")) != NULL)
        warning = FALSE;
    }
#endif
  }
  if (warning)
  {
    printf("ERROR: %s not found\n\n", tnn_initfile);
    return (TRUE);
  }
  while (!file_end)
  {
    if (fgets(line, 82, init_file_fp) == NULL)
    {
      file_end = TRUE;
    }
    else
    {
      if (strlen(line) == 82)
      {
        file_end = TRUE;
        file_corrupt = TRUE;
      }
      else
      {
        if (line[0] != '#')
        {                       /* ignore comment-lines */
          rslt = sscanf(line, "%s %s", str1, str2);
          switch (rslt)
            {
              case EOF:        /* ignore blank lines */
                break;
              case 2:
                if (analyse_value(str1, str2))
                {
                  file_end = TRUE;
                  file_corrupt = TRUE;
                }
                break;
              default:
                file_end = TRUE;
                file_corrupt = TRUE;
                break;
            }
        }
      }
    }
  }
  fclose(init_file_fp);
  if (file_corrupt)
  {
    printf("ERROR: %s is in wrong format, wrong line:\n%s\n\n",
           tnn_initfile, line);
    return (TRUE);
  }
  else
  {

    for (i = 0; i < L1PNUM; i++)
    {
#ifdef AX_IPX
      if (l1port[i].kisstype == KISS_IPX)
      {
        if (axipx_ports == 0)
        {
          ++axipx_ports;
        }
        else
        {
          l1port[i].kisstype = KISS_NIX;
        }
      }
#endif
#ifdef AX25IP
      if (l1port[i].kisstype == KISS_AXIP)
      {
        if (ax25ip_ports == 0)
        {
          ++ax25ip_ports;
        }
        else
        {
          l1port[i].kisstype = KISS_NIX;
        }
      }
#endif
      if (*(l1port[i].tnn_lockfile) != NUL)
        add_tnndir(l1port[i].tnn_lockfile);
    }
    add_tnndir(tnn_errfile);
    add_tnndir(tnn_procfile);
    add_tnndir(tnn_socket);

    if (used_l1ports >= 0)
      kiss_active = TRUE;
    if (start_name[0])
      system(start_name);
    return (FALSE);
  }
}

BOOLEAN
init_proc(void)
{
  FILE           *fp;
  pid_t           pid;

  fp = fopen(tnn_procfile, "r");
  if (fp != NULL)               /* altes tnn.pid vorhanden?     */
  {
    if (fscanf(fp, "%d", &pid) == 1)  /* alte PID lesen               */
    {
      if (kill(pid, 0) != -1)   /* lebt das alte Programm noch? */
      {
        fclose(fp);
        return (FALSE);         /* lebt noch, also ENDE!        */
      }
    }
    fclose(fp);
  }
  fp = fopen(tnn_procfile, "w+");
  if (fp == NULL)
  {
    printf("ERROR: Can't create process file\n");
    return (FALSE);
  }
  pid = getpid();
  fprintf(fp, "%d", pid);
  fclose(fp);
  return (TRUE);
}

void
exit_proc(void)
{
  unlink(tnn_procfile);
}

/* End of os/linux/init.c */
