
{-----------------------------------------------------------------------------
| Einschalten der hohen Auflsung bei EGA- und VGA-Karten
| EGAMODE +  schaltet die hohe Auflsung ein
| EGAMODE -  schaltet wieder auf normale Auflsung
| EGAMODE    zeigt die momentan gesetzte Auflsung
+----------------------------------------------------------------------------}


USES
       Dos,
       Crt,
       PasLib;

TYPE
       VBufferType       = ARRAY[1..80*2*60] OF Char;

VAR
       MaxX, MaxY        : Byte;
       HiRes             : BOOLEAN;
       VBuffer           : VBufferType;
       VideoPage         : ^VBufferType;
       XX, YY            : Byte;
       YDifferenz        : INTEGER;
       gefunden          : BOOLEAN;
       i                 : INTEGER;


PROCEDURE SetCursorSize(Size:INTEGER);
VAR
  r :REGISTERS;
BEGIN
  r.ah:=$01;
  r.cx:=Size;
  INTR($10,r);
END;


{------------------------------------------------------------------------------
| liefert die Video-Segmantadresse
+-----------------------------------------------------------------------------}

FUNCTION GetVideoSeg : WORD;

 BEGIN
   IF (LO(LASTMODE) = 7) THEN
     GetVideoSeg := $B000
   ELSE
     GetVideoSeg := $B800;
 END;



BEGIN

  IF ParamCount > 0 THEN
   BEGIN
     VideoPage := Ptr(GetVideoSeg,0);
     MaxX := WindMax MOD 256 + 1;
     MaxY := WindMax DIV 256 + 1;
     XX := WhereX;
     YY := WhereY;
     Move(VideoPage^,VBuffer,MaxX*2*MaxY);
     IF ParamStr(1) = '+' THEN
      BEGIN
        { hohe Auflsung einschalten }
        TextMode(LastMode OR $0100);
        SetCursorSize(5*256+7);
        Move(VBuffer,VideoPage^,MaxX*2*MaxY);
        GotoXY(XX,YY);
      END
     ELSE
      BEGIN
        { normale Auflsung einschalten }
        TextMode(LastMode AND $00FF);
        IF (YY > 25) THEN
          YDifferenz := YY - 25
        ELSE
          YDifferenz := 0;
        Move(VBuffer[1+80*2*YDifferenz],VideoPage^,80*2*25);
        GotoXY(XX,YY-YDifferenz);
      END;
   END;

  MaxX := WindMax MOD 256 + 1;
  MaxY := WindMax DIV 256 + 1;

  gefunden := FALSE;
  FOR i := 1 TO ParamCount DO
    IF (UpcaseStr(ParamStr(i)) = '/Q') THEN
      gefunden := TRUE;
  IF NOT gefunden THEN
   BEGIN
     WRITELN;
     WRITELN('EGA/VGA-Mode  ',MaxX,' x ',MaxY);
   END;

END.
