
{-----------------------------------------------------------------------------
|  KISS-Mode beim TNC2 abschalten
+----------------------------------------------------------------------------}

USES
       Crt,
       V24;

CONST
       ComPort      = 3;
       Baudrate     = 19200;
       Port         = 1;

VAR
       chx          : CHAR;
       i            : INTEGER;


BEGIN

  OpenV24(ComPort,10000,Baudrate);
  SwitchV24(Port);

  WRITELN;
  WRITELN('Trying to switch KISS OFF...');
  WRITELN;

  WRITEaux(#$C0#$FF);                    { KISS verlassen }

  i := 60;                { max. 30 Sekunden auf TNC warten }
  REPEAT
    Dec(i);
    Delay(500);
  UNTIL Zeichen OR (i = 0);

  Delay(100);

  IF i > 0 THEN
   BEGIN
     WHILE Zeichen DO
      BEGIN
        Delay(3);
        ReadAux(chx);
        CASE chx OF
         #10 : ;
         #13 : WRITELN;
         ELSE  WRITE(chx);
        END;
      END;
   END;

  CloseV24;                              { RS232 schliessen }

END.
