
PROGRAM PacketRadio_Hostmode_Terminal (Input,Output);

{$UNDEF OS2}

{------------------------------------------------------------------------------
|
|
|    Terminal - Programm fr den HOSTMODE des TNC-1 oder TNC-2
|    in Verbindung mit einem IBM-PC oder kompatiblen Rechner
|
|    Last Edit:  09/1994
|
|    Reiner Schmidt, Hndelstr. 20, 31228 Peine, Tel.: 05171/71055
|
|    Programm und Quelltexte drfen an jeden interessierten Funkamateur
|    zur NICHT-KOMMERZIELLEN NUTZUNG weitergegeben werden.
|
|    Eine Verteilung im PUBLIC-DOMAIN-POOL ist nicht erwnscht !!
|    ============================================================
|
|    Hinweise zum Compilieren von TurboPR:
|    =====================================
|
|    - Zu compilieren ab TURBO-PASCAL Version 6.0, da MEMORY.TPU verwendet wird
|
|    - IMMER PR.PAS als primary file angeben und das bersetzen mit dem
|      Build- oder Make-Kommando von TurboPascal starten.
|
|    - Mit dem bedingten Symbol "OS2" wird TurboPR etwas OS/2-freundlicher,
|      allerdings erfolgt die V24-Behandlung dann nicht mehr Interrupt-
|      gesteuert!
|
|    - Mit dem bedingten Symbol "DEBUG" wird die Debug-Mglichkeit von TurboPR
|      eingebunden, die Freigabe der Funktionen erfolgt ber entsprechende
|      Aufrufparameter. Weitere Infos dazu in der Datei PRDEBUG.DOC.
|
+------------------------------------------------------------------------------
|
|
|    A C H T U N G :
|
|    Dieses Programm ist ein reines Hobby-Produkt!
|
|    Fr Fehler, insbesondere fr eventuelle Datenverluste, kann
|    KEINERLEI HAFTUNG bernommen werden!
|
|
+------------------------------------------------------------------------------
|
|    Mein Dank gilt folgenden OMs, die mageblich an der Verbesserung
|    der Software beteidigt waren/sind:
|
|    Don Moe, DJ0HC
|    Wolfgang Wendefeuer, DC6LK
|    Jan, DL5UE (TCPIP-Monitor)
|
|    Vielen Dank auch den Benutzern, die durch Kritik und Einflle ihren
|    Beitrag zur Programmgestaltung geleistet haben.
|
+-----------------------------------------------------------------------------}

(*
{$IFNDEF OS2}
   Error        Conditional Define "OS2" ist nicht gesetzt !!!
{$ENDIF}
*)

{$M 16384,0,655360}     { 16 KByte Stack scheint z.Z. zu reichen }

{$A+}    { WORD-Ausrichtung zur Geschwindigkeitssteigerung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code generieren, wenn OS/2 gewnscht wird }
{$ENDIF}


USES
      PRDEFS,            { VAR/CONST/TYPE-Vereinbarungen, Initialisierungen }
      Crt,               { TurboPascal-Unit zur Bildschirmbedienung }
      Dos,               { TurboPascal-Unit }
      Printer,           { TurboPascal-Unit zur Druckeruntersttzung }
{      Memory,  }          { TurboVision-Unit, hier nur zur Heap-Begrenzung }
      PRLib,             { Allerlei... }
      PRLib1,            { Help, Log, Catalog, Startmaske }
      PRLib2,            { MH-Liste, Auto-Kommandos, etc. }
      PRLib3,            { Logon, Logoff, etc. }
      PRLib4,            { TNC-Init/DeInit, TNC-Polling, XHost, etc. }
      PRPASS,            { Priv-Routinen fr TheNet und DieBox }
      PRCRC,             { Prfsummenberechnungen }
      PRKBD,             { Dekodierung der Sondertasten }
      PRTast,            { Tastatur-Routinen }
{$IFDEF OS2}
      PRV24OS2,          { V24-Bedienung ohne Interrupts }
{$ELSE}
      PRV24,             { interruptgesteuerte V24-Bedienung }
{$ENDIF}
      PRScreen,          { Zeichenausgabe, Speicherung, Drucken }
      PRScroll,          { Bearbeitung der Rckhol- und des Notizbuffers }
      PRRemote,          { Fernbedienungsfunktionen }
      PRCW,              { Telegrafie-Routinen }
      PRTFPCR,           { TFPCR/TFPCX/TFBOX-Untersttzung }
      PRARPA,            { TCPIP-Routinen von DL5UE }
{$IFDEF DEBUG}
      PRDebug,           { Debug-Funktionen, werden nur bedingt eingebunden }
{$ENDIF}
      PRMouse;           { Routinen zur Maus-Untersttzung }


{ Lokale Vereinbarungen fr PR.PAS }

Label
      PgmEnde;

VAR
      Kanal          : INTEGER;
      i              : INTEGER;
      RPSCount       : INTEGER;

{------------------------------------------------------------------------------
| Hier geht's los
+-----------------------------------------------------------------------------}

BEGIN

{  InitMemory;        }                 { TurboVision }

  ExitSave := ExitProc;
  ExitProc := @NewExit;               { Fehlerprozedur mit Klartext-Fehlerm. }
  CheckBreak := FALSE;                { kein Abbruch durch ctrl-C }
  GetCBreak(BreakStatus);             { Break-Status holen und retten }
  SetCBreak(FALSE);                   { Break off }
  CheckSnow := FALSE;
  CursorMerker := GetCursorSize;
  LastModeMerker := LastMode;         { aktueller Video-Modus }

  VideoPage := Ptr(GetVideoSeg,0);    { Pointer auf das Video-Ram holen }

  Global_VAR_init;

  IF Pos('-V-',CmdLinePar) > 0 THEN
   BEGIN
     i := GetChecksum(upcaseStr(ParamStr(0)),FALSE);
     Goto PgmEnde;   { *************** >>>>>>>>>>>>>>>>> }
   END;

  IF Pos('-?-',CmdLinePar) > 0 THEN
   BEGIN
     ParameterHelp;
     Goto PgmEnde;   { *************** >>>>>>>>>>>>>>>>> }
   END;

  IF VideoRestore THEN
   BEGIN
     WRITELN(CrLf,V1_Str);
     { Bildschirm-Inhalt sichern zum spteren Restaurieren }
     i := MaxX*MaxY*2;
     GetMem(VideoPageSave,i);            { Speicher fr Bildschirm }
     Move(VideoPage^,VideoPageSave^,i);
     VideoPageSaveX := WhereX;
     VideoPageSaveY := WhereY;
     Delay(30*DelayCorr);
   END;

  StartMaske;
  GotoXY(1,MaxY);

  FOR Kanal := 0 TO maxLink DO
    Kanal_VAR_init(Kanal);

  Load_ConfigFile;

  IF (Pos('-LCD-',CmdLinePar) > 0) THEN
    AttrSet := '4'; {LCD-Attribute whlen}

  M_SetRange(0,0,8*MaxX-1,8*MaxY-1);    { Mauscursor-Bereich setzen }

  Load_StatusFile;

  FOR i := 1 TO 4 DO
   IF TNC[i].used THEN
    BEGIN
     { dieser TNC wird gebraucht, also los }
     V24_Init(TNC[i].RS232,FALSE);
     WITH TNC[i] DO
      BEGIN
       XHOSTok := FALSE;
       currentQRG := Space(8-Length(Ident)) + Ident; { rechtsbndig }
       getMem(MH,Sizeof(MH^));
       getMem(MoniStatus,SizeOf(MoniStatus^));
       getMem(UCmdStr,SizeOf(UCmdStr^));
       fillChar(MH^,SizeOf(MH_Liste),#0);
      END;
    END;

  Load_AttributFile;
  Load_MsgFile;
  Load_QRGFile;

  IF (ListPgm = '') THEN
   output_Errortext('List-Pgm nicht gefunden! ''Help'' und ''Log'' werden nicht funktionieren!');
  IF (EditPgm = '') THEN
   output_Errortext('Edit-Pgm nicht gefunden, daher Edit-Funktion nicht mglich!');

  MBX_remote_init;
  RemInit;
  LinkStateAttrInit;
  SetCWSpeed(CWSpeed);

  Gotoxy(1,20);
  Cursor_aus;

  FOR Kanal := 0 TO Kanal_Anzahl DO
    WITH K[Kanal]^ DO BEGIN
      GetMem(TXFileBuffer,SizeOf(TXFileBuffer^));
      GetMem(RXFileBuffer,SizeOf(RXFileBuffer^));
      Assign(RXFile,RX_Name);
      SetTextBuf(RXFile,RXFileBuffer^);
      GetMem(EditLine,maxEditLine*SizeOf(Str80));
      FOR i := 1 TO maxEditLine DO
        EditLine^[i] := '';
      IF connected OR Save THEN
       BEGIN
         Save := TRUE;
         OpenRXFile(Kanal);
         RX_Count := 0;
       END;
    END;           { WITH K[Kanal]^ DO ... }

{  TextAttr := low;   }
  Datum := Date;
  Zeit := Time;
  OldTime := Zeit;
  show := 0;

  Init_BackScrollBuffer;   { Buffer zuletzt anfordern, damit beim DOS-  }
                           { Aufruf eine Freigabe mglich ist!          }

  { ***************************************************************** }
  { Ab hier darf KEIN DYNAMISCHER SPEICHER mehr angefordert werden!!! }
  { ***************************************************************** }

{$IFDEF DEBUG}
  Debug_Init;
{$ENDIF}

  Init_TNCs;      { TNC(s) in den Hostmode schalten und }
                  { Init-Kommandos an die TNCs schicken }

  unproto := 1;
  WHILE (NOT TNC[unproto].used) DO
    Inc(unproto);
  Channel0 := unproto;
  switch_TNC(unproto);

  i := lastChannel;
  IF (i > Kanal_Anzahl) THEN
   i := 0;

  show := i;
  restore_Screen;

  XHost.Status := 0;
  XHost.Counts := 10;

  polling.Status := 0;

  CopyrightWindow;         { ALAS-Hinweis bringen }

  Timer[RPSTmr] := Sec2;
  RPSCount := 0;

  Timer[CursorTmr] := Sec05;


  {----------------------------------------------------------------------------
  |  H A U P T S C H L E I F E
  +---------------------------------------------------------------------------}
  REPEAT

   Dec_Timer;               { 55ms-Timer dekrementieren }

   Inc(RPSCount);
   IF Timer[RPSTmr] = 0 THEN
    BEGIN
      RPS := RPSCount DIV 2;    { RPS auf 1 Sekunde normieren }
      Status1Out(0,40,neg,int_Str(RPS)+'  ');
      RPSCount := 0;
      Timer[RPSTmr] := Sec2;    { Timer wieder neu aufsetzen }
    END;

   poll_Tastatur;           { Tastatur abfragen }

   IF TNC[Channel0].XHostok THEN
     { TNC kann XHost, also los... }
     DO_XHost
   ELSE
     { TNC kann kein XHost, also normale Abfrage abklappern... }
     DO_polling;

   Uhr_aus;                 { bei Bedarf Uhrzeitdarstellung }

   IF Timer[CursorTmr] = 0 THEN
    BEGIN
      IF NOT ScreenStby THEN
        ShowEditCursor;
      Timer[CursorTmr] := Sec05;
    END;

  UNTIL QRT;
  {----------------------------------------------------------------------------
  |  Ende  der  H A U P T S C H L E I F E
  +---------------------------------------------------------------------------}


  DeInit_TNCs;  { De-Init-Kommandos senden, Hostmode beenden }
  V24_Close;    { InterruptVektoren zurckstellen }

  gesMin := gesMin + LaufZeit;

  Save_Statusfile;

  FOR Kanal := 0 TO maxLink DO
   IF K[Kanal]^.Save THEN
     CloseRXFile(Kanal);

  SetBorderColor(0);

  NormVideo;                       { altes VideoAttribut einstellen }
  Cursor_ein;

{$IFDEF DEBUG}
  Debug_Close;
  IF Debug.Status > 0 THEN
    Window(1,1,80,50);
{$ENDIF}

  ClrScr;

  WRITELN;
  WRITE('Ende  ');
  HighVideo;
  WRITE('Turbo-PR');
  NormVideo;
  WRITELN('  ',Date,'  ',Time);
  WRITELN(ConstStr('',75));

  WRITELN;
  WRITELN(V1_str,' in Betrieb fr ',Laufzeit,' Minute(n).');
  WRITELN('Gesamt-Programmlaufzeit:  ',LZStr(gesMin));

  IF VideoRestore THEN
   BEGIN
    { Bildschirm-Inhalt restaurieren }
    Move(VideoPageSave^,VideoPage^,MaxX*MaxY*2);
    GotoXY(VideoPageSaveX,VideoPageSaveY);
   END;

  PgmEnde:

  NormVideo;                        { altes Video-Attribut setzen }

  IF NOT VideoRestore THEN
   WRITELN;

  SetCBreak(BreakStatus);           { alten Break-Status setzen }

END .

{-----------------------------------------------------------------------------
|  Tja, das war's ...
+----------------------------------------------------------------------------}
