
{------------------------------------------------------------------------------
|
|  PRARPA.PAS
|
|  Routinen zum Mitlesen der im Amateurfunk verwendeten ARPA-Protokolle
|  (ARP, IP, ICMP, UDP, TCP)
|
|  DL5UE, im November 1988
|  (Mit Anleihen bei KA9Q (NET.EXE) und DK5SG (WAMPES))
|  Umbau als UNIT DL1BHO im April 1989
|  Begrenzung der Strings in typisierten Konstanten auf die erforderliche
|  Mindestlnge im August 1989
|
+-----------------------------------------------------------------------------}

UNIT    PRARPA;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


Interface


PROCEDURE ipdump(Response : String);
PROCEDURE arpdump(Response : String);


Implementation


Uses
        Crt,
        PRDefs,
        PRLib,
        PRScreen;


function pull8(instr:string; var point:BYTE):BYTE;
begin
  pull8 := ord(instr[point]);
  inc(point);
end;


function pull16(instr:string; var point:BYTE):WORD;
begin
   pull16 := 256 * ord(instr[point]) + ord(instr[point+1]);
   point := point + 2;
end;


function pull32(instr:string; var point:BYTE):LONGINT;
var   i   : INTEGER;
      tmp : LONGINT;
begin
     tmp := 0;
     for i:=0 to 3 do
     tmp := 256 * tmp + ord(instr[point+i]);
     point := point + 4;
     pull32 := tmp;
end;


function ipNtoA(adr:LONGINT; map:BOOLEAN) : string;
var addrstr : string[15];
    tmpstr  : str8;
    hiword  : INTEGER;
    loword  : INTEGER;
    dummy   : INTEGER;
begin;
    case map of
     true,false:               { true: map ip address to hostname }
      begin                    { to be done later... }
         tmpstr := hex(adr,8);
         val('$'+copy(tmpstr,1,4),hiword,dummy);
         val('$'+copy(tmpstr,4,8),loword,dummy);
         addrstr := int_str(hi(hiword)) + '.' + int_str(lo(hiword)) + '.' +
                    int_str(hi(loword)) + '.' + int_str(lo(loword));
       end;
    end;
    ipNtoA := addrstr;
end;


procedure ipdump;  { dump internet protocol }
const
     ICMP =  1;     { internet control message protocol }
     TCP  =  6;     { transmission control protocol }
     UDP  = 17;     { user datagram protocol }
     DF   = $4000;  { don't fragment flag }
     MF   = $2000;  { more fragments flag }

var  i     : INTEGER;
     id    : WORD;    { identification }
     len   : WORD;    { total length }
     ihl   : WORD;    { length of internet header }
     Offs  : WORD;    { fragment offset }
     ttl   : BYTE;    { time to live }
     prot  : BYTE;    { protocol }
     tos   : BYTE;    { type of service }
     sp    : BYTE;    { sort of pointer into string }

   procedure tcpdump;
   const tcpflags : ARRAY [1..6] of STRING[3] =
         ('FIN','SYN','RST','PSH','ACK','URG');
         TCPLEN  =  20;     { length of TCP header }
   var   seq     : LONGINT;
         ack     : LONGINT;
         i       : INTEGER;
         srcport : INTEGER;    { source port }
         dstport : INTEGER;    { destination port }
         window  : INTEGER;    { tcp window size }
         up      : INTEGER;    { urgent pointer }
         hdrlen  : INTEGER;    { length of TCP header }
         optlen  : BYTE;       { length of option field }
         mss     : INTEGER;    { optional message size field }
         flags   : BYTE;
         mask    : BYTE;

       function port(pnr:integer):string;
       begin
          case pnr of
              7 : port := 'ECHO';
              9 : port := 'DISCARD';
             20 : port := 'FTP-DATA';
             21 : port := 'FTP';
             23 : port := 'TELNET';
             25 : port := 'SMTP';
             79 : port := 'FINGER';
           3600 : port := 'CONVERS';
           5800..5999 :
                  port := 'X10';
           6000..6099 :
                  port := 'X11';
          else port := int_str(pnr);
          end;
       end;

   begin
     mask := 1; mss := 0;
     srcport := pull16(Response,sp);
     dstport := pull16(Response,sp);
     seq := pull32(Response,sp);
     ack := pull32(Response,sp);
     hdrlen := (pull8(Response,sp) AND $F0) div 4;
     flags := pull8(Response,sp) AND $3f;
     window  := pull16(Response,sp);
     i := pull16(Response,sp);          { ignore this one }
     up      := pull16(Response,sp);
     M_aus('TCP: '+port(srcport)+'->'+port(dstport)+' Seq:'+HEX(seq,8));
     if (flags AND $10) <> 0 then      { ACK included }
        M_aus(' Ack:'+HEX(ack,8));
     for i:= 1 to 5 do begin
         if (flags and mask) <> 0 then
            M_aus(' '+tcpflags[i]);
         mask := 2 * mask;
     end;
     M_aus(' Wnd:'+int_str(window));
     if (flags AND $20) <> 0 then      { URGENT flag set }
        M_aus(' UP:'+int_str(up));
     while sp <= (ihl + hdrlen) do begin    { now process options }
        case pull8(Response,sp) of
          1 : ;                               { NOOP type }
          2 : begin
                 optlen := pull8(Response,sp);
                 if optlen = 4 then              { MSS type }
                    mss := pull16(Response,sp);
              end;
          else sp := ihl + hdrlen - 1;         { flush rest of options }
        end;
     end;
     if mss <> 0 then
        M_aus(' MSS:'+int_str(mss));
     M_aus(^M);
   end;

   procedure udpdump;
   begin
      M_aus('UDP: ' + int_str(pull16(Response,sp)) + '->' +
            int_str(pull16(Response,sp)) + ' len:' +
            int_str(pull16(Response,sp)) + ^M);
      sp := sp + 2;       { ignore checksum }
   end;

   procedure icmpdump;
   const icmptypes: array[0..16] of String[20] =
                    ('Echo Reply','','','Unreachable','Source Quench',
                    'Redirect','','','Echo Request','','','Time Exceeded',
                    'Parameter Problem','Timestamp','Timestamp Reply',
                    'Information Request','Information Reply');
         unreach  : array[0..5] of String[14] =
                    ('Network','Host','Protocol','Port','Fragmentation',
                    'Source Route');
         redirect : array[0..3] of String[14] =
                    ('Network','Host','TOS & Network','TOS & Host');
         exceeded : array[0..1] of String[20] =
                    ('Time-to-live','Fragment reassembly');

         ECHO_REP        = 0;       { Echo Reply }
         DEST_UNREACH    = 3;       { Destination Unreachable }
         QUENCH          = 4;       { Source Quench }
         REDIR           = 5;       { Redirect }
         ECHO_REQ        = 8;       { Echo Request }
         TIME_EXCEED     = 11;      { Time-to-live Exceeded }
         PARAM_PROB      = 12;      { Parameter Problem }
         TIMESTAMP       = 13;      { Timestamp }
         TIMESTAMP_REP   = 14;      { Timestamp Reply }
         INFO_REQ        = 15;      { Information Request }
         INFO_REP        = 16;      { Information Reply }

   var   itype  : INTEGER;
         code   : INTEGER;
         codemsg: STRING;
         pointer: BYTE;
         id     : WORD;
         seq    : WORD;

   begin
      itype := pull8(Response,sp);
      code := pull8(Response,sp);
      codemsg := '';
      sp := sp + 2;                { ignore checksum }
      if (itype <= 16) AND (icmptypes[itype] <> '') then
         M_aus('ICMP: ' + icmptypes[itype]+' ')
      else M_aus('ICMP: type:' + int_str(itype));
      case itype of
        DEST_UNREACH:  if code <= 6 then codemsg := unreach[code];
        REDIR:         if code <= 4 then codemsg := redirect[code];
        TIME_EXCEED:   if code <= 2 then codemsg := exceeded[code];
      end;
      if codemsg='' then M_aus(' Code:' + int_str(code))
      else M_aus(' ' + codemsg);
      case itype of
      PARAM_PROB:   begin
                      pointer := pull8(Response,sp);
                      M_aus(' Pointer:0x' + HEX(pointer,2));
                      sp := sp + 3;
                    end;
      DEST_UNREACH, TIME_EXCEED, QUENCH:
                     sp := sp + 4;
      REDIR:         M_aus(' Gate:'+ipNtoA(pull32(Response,sp),TRUE));
      ECHO_REP, ECHO_REQ, TIMESTAMP, TIMESTAMP_REP, INFO_REQ, INFO_REP:
                     begin
                       id := pull16(Response,sp);
                       seq := pull16(Response,sp);
                       M_aus(' ID:'+int_str(id));
                       M_aus(' Seq:'+int_str(seq));
                     end;
      end;
      M_aus(^M);
      case itype of
      DEST_UNREACH, REDIR, TIME_EXCEED, PARAM_PROB, QUENCH :
          begin                        { dump offending IP header }
            TextAttr := MoniInfoAttr;
            M_aus('      ');
            TextAttr := NetzHeaderAttrib;
            M_aus('Returned ');
            ipdump(copy(Response,sp,length(Response)-sp));
          end;
      TIMESTAMP, TIMESTAMP_REP :
          begin
            TextAttr := MoniInfoAttr;
            M_aus('      ');
            TextAttr := NetzHeaderAttrib;
            M_aus(' Orig:'+HEX(pull32(Response,sp),8));
            M_aus(' Rx:'+HEX(pull32(Response,sp),8));
            M_aus(' Tx:'+HEX(pull32(Response,sp),8));
          end;
      end;
   end;


begin
    TextAttr := NetzHeaderAttrib;
    sp := 1;
    ihl := 4 * (pull8(Response,sp) AND 15);
    tos := pull8(Response,sp);
    len := pull16(Response,sp);
    id := pull16(Response,sp);
    offs := pull16(Response,sp);
    ttl := pull8(Response,sp);
    prot := pull8(Response,sp);
    i := pull16(Response,sp);             { ignore this one }

    M_aus('IP: ' + ipNtoA(pull32(Response,sp),TRUE));
    M_aus('->' + ipNtoA(pull32(Response,sp),TRUE));
    M_aus(' len:'+int_str(len)+' ihl:'+int_str(ihl)+' ttl:');
    M_aus(int_str(ord(ttl))+' prot:'+int_str(prot));
    if tos <> 0 then
       M_aus(' tos:'+int_str(tos));
    if offs <> 0 then
      M_aus(' id:'+int_str(id)+' offs:'+int_str(offs AND $1FF));
    if (offs AND DF) <> 0 then
      M_aus(' DF');
    if (offs AND MF) <> 0 then
      M_aus(' MF');
    M_aus(^M);
    case prot of       { now up to the next protocol ! }
    TCP  : tcpdump;
    UDP  : udpdump;
    ICMP : icmpdump;
    end;
    TextAttr := MoniInfoAttr;      { dump the data field }
    M_aus(copy(Response,sp,length(Response)-sp) + ^M);
end;



procedure arpdump;    { dump adress resolution protocol }
const hwtypes : ARRAY [1..8] of String[15] = ('10 MB Ethernet','3 MB Ethernet',
                                'AX.25','Pronet','Chaos','','Arcnet','Appletalk');
VAR   sp      : BYTE;
      hwalen  : BYTE;
      pralen  : BYTE;
      opcode  : WORD;
      hwtype  : WORD;
      sprotadr: LONGINT;
      tprotadr: LONGINT;
      tmpstr  : string;


    procedure hw_shift(var hwstring:string); { Shift hwadress 1 Bit right }
    var count: INTEGER;
        sl,tmp:BYTE;

    begin
      sl := length(hwstring);
      for count := 1 to sl do
         hwstring[count] := chr(ord(hwstring[count]) shr 1);
      hwstring[sl] := hwstring[sl-1];
      hwstring[sl-1] := '-';
      tmp := pos(' ',hwstring);
      if tmp <> 0 then
      begin
         for count := tmp+1 to sl do
           hwstring[count-1] := hwstring[count];
         hwstring := copy(hwstring,1,sl-1);
      end;
    end;


begin
   sp := 1;
   if length(Response) = 0 then exit;
   TextAttr := NetzHeaderAttrib;
   M_aus('ARP: len:'+int_str(length(Response))+' hwtype:');
   hwtype := pull16(Response,sp);
   case hwtype of
      1..8:  M_aus(hwtypes[hwtype]);
      else   M_aus(int_str(hwtype));
   end;
   M_aus(' prot:' + hex(pull16(Response,sp),2) + ' hwalen:');
   hwalen := pull8(Response,sp);
   pralen := pull8(Response,sp);
   M_aus(int_str(hwalen) + ' pralen:'+int_str(pralen)+' op ');
   opcode := pull16(Response,sp);
   case opcode of
      1    : begin
               M_aus('REQUEST'+^M);
               tmpstr:=copy(Response,sp,hwalen+1);
               hw_shift(tmpstr);
               sp := sp + hwalen;
               TextAttr := MoniInfoAttr;
               M_aus(ipNtoA(pull32(Response,sp),FALSE)+' ('+
                     tmpstr+'): Who is ');
               sp := sp + hwalen;
               M_aus(ipNtoA(pull32(Response,sp),FALSE)+' ?'^M);
             end;
      2    : begin
               M_aus('REPLY'+^M);
               tmpstr := copy(Response,sp,hwalen+1);
               hw_shift(tmpstr);
               sp := sp + hwalen;
               sprotadr := pull32(Response,sp);
               sp := sp + hwalen;
               tprotadr := pull32(Response,sp);
               TextAttr := MoniInfoAttr;
               M_aus(ipNtoA(sprotadr,TRUE)+'->'+ipNtoA(tprotadr,TRUE)+
                    ': '+ipNtoA(sprotadr,FALSE)+' is '+tmpstr+^M);
             end;
      else   begin
               M_aus(int_str(opcode)+^M);
               sp := sp + 2 * hwalen + pralen;
               TextAttr := MoniInfoAttr;
               M_aus('Target ' + ipNtoA(pull32(Response,sp),FALSE)+^M);
             end;
   end;
   TextAttr := MoniInfoAttr;
   M_aus(^M);
end;


BEGIN


END.
