
{-----------------------------------------------------------------------------
|  CRC-Check nach CCITT
|  Autor nicht bekannt...
+----------------------------------------------------------------------------}


UNIT PRCRC;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


  INTERFACE

    FUNCTION CRC(Data : Byte; OldCRC : Word) : WORD;

  IMPLEMENTATION

    CONST Poly = $1021; (* Nach CCITT V.41 *)
    (* Das Teilerpolynom ist: X^16+X^12+X^5+1 *)

    VAR LookUp : ARRAY [0..255] OF WORD;

  FUNCTION CRC(Data : Byte; OldCRC : WORD) : WORD;
    BEGIN
      CRC := LookUp[OldCRC SHR 8] XOR ((OldCRC SHL 8) OR Data);
    END;

  PROCEDURE InitLookUp;
    VAR I : 0..7;
        J, K : BYTE;
        R : INTEGER;

    BEGIN
      LookUp[0]:=0; R:=-$8000;
      FOR I:=0 TO 7 DO
        BEGIN
          K:=1 SHL I;
          IF R<0
            THEN R:=(R SHL 1) XOR Poly
            ELSE R:=R SHL 1;
          FOR J:=0 TO pred(K) DO
            LookUp[K+J] := Word(R XOR LookUp[J]);
        END;
    END;

BEGIN
  InitLookUp
END.
