{-----------------------------------------------------------------------------
|
|  P R C W . P A S
|
|  Unit zur Ausgabe von Morsetelegrafie
|
|  Reiner Schmidt (DL1BHO), schon lange her....
|
+----------------------------------------------------------------------------}

UNIT PRCW;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


Interface


PROCEDURE Telegrafie (Zeile : String);
PROCEDURE SetCWSpeed (Speed : INTEGER);


Implementation


Uses
       Crt,
       PRDefs,
       PRLib;


CONST
       TonHoehe    = 800;

       SpeedTab : ARRAY[1..17] OF INTEGER =
                    (190,152,128,109,95,85,77,70,65,59,56,53,50,46,44,42,41);

       Morse  : ARRAY[42..90,1..10] OF CHAR =

                  ('...-.-    ',     {  * = sk  }
                   '.-.-.     ',     {  +  }
                   '--..--    ',     {  ,  }
                   '-....-    ',     {  -  }
                   '.-.-.-    ',     {  .  }
                   '-..-.     ',     {  /  }
                   '-----     ',     {  0  }
                   '.----     ',     {  1  }
                   '..---     ',     {  2  }
                   '...--     ',     {  3  }
                   '....-     ',     {  4  }
                   '.....     ',     {  5  }
                   '-....     ',     {  6  }
                   '--...     ',     {  7  }
                   '---..     ',     {  8  }
                   '----.     ',     {  9  }
                   '---...    ',     {  :  }
                   '          ',     {  ;  }
                   '          ',     {  <  }
                   '-...-     ',     {  =  }
                   '          ',     {  >  }
                   '..--..    ',     {  ?  }
                   '          ',     {  @  }
                   '.-        ',     {  A  }
                   '-...      ',     {  B  }
                   '-.-.      ',     {  C  }
                   '-..       ',     {  D  }
                   '.         ',     {  E  }
                   '..-.      ',     {  F  }
                   '--.       ',     {  G  }
                   '....      ',     {  H  }
                   '..        ',     {  I  }
                   '.---      ',     {  J  }
                   '-.-       ',     {  K  }
                   '.-..      ',     {  L  }
                   '--        ',     {  M  }
                   '-.        ',     {  N  }
                   '---       ',     {  O  }
                   '.--.      ',     {  P  }
                   '--.-      ',     {  Q  }
                   '.-.       ',     {  R  }
                   '...       ',     {  S  }
                   '-         ',     {  T  }
                   '..-       ',     {  U  }
                   '...-      ',     {  V  }
                   '.--       ',     {  W  }
                   '-..-      ',     {  X  }
                   '-.--      ',     {  Y  }
                   '--..      ');    {  Z  }

VAR
       CWSpeed     : INTEGER;

       PTime       : Word;     { Dauer eines Punktes }
       STime       : Word;     { Dauer eines Striches }
       DTime       : Word;     { Dauer einer Pause }


PROCEDURE Telegrafie (Zeile : String);

VAR  i,k   : INTEGER;
     ch    : CHAR;

 PROCEDURE Punkt;
 BEGIN
   Sound(TonHoehe);
   Delay(PTime);
   NoSound;
   Delay(PTime);
 END;

 PROCEDURE Strich;
 BEGIN
   Sound(TonHoehe);
   Delay(STime);
   NoSound;
   Delay(PTime);
 END;

BEGIN   { Telegrafie }

  Zeile := upcaseStr(Zeile);
  FOR i := 1 TO Length(Zeile) DO
  BEGIN
    ch := Zeile[i];
    IF ((ch >= #42) AND (ch <= #90)) OR (ch = ' ') THEN
    BEGIN
      IF (ch = ' ') THEN
        Delay(PTime)
      ELSE
        BEGIN
          k := 1;
          WHILE Morse[ORD(ch),k] <> ' ' DO
          BEGIN
            IF (Morse[ORD(ch),k] = '.')
              THEN Punkt
              ELSE Strich;
            k := k + 1;
          END;
        END;
      Delay(DTime);
    END;
  END;
END;


{-----------------------------------------------------------------------------
|  CW-Geschwindigkeit einstellen
+----------------------------------------------------------------------------}

PROCEDURE SetCWSpeed (Speed : INTEGER);
BEGIN
  IF (Speed < 40) THEN Speed := 40;
  IF (Speed > 200) THEN Speed := 200;
  Speed := ((Speed+5) DIV 10) * 10;     { runden }
  CWSpeed := Speed;

  PTime := (SpeedTab[(CWSpeed DIV 10)-3]*DelayCorr) DIV 10;
  STime := 3 * PTime;
  DTime := (7*PTime) DIV 4;
  IF (PTime < 60) THEN          { Pausen-Korrektur, mu mal gendert werden }
    DTime := (3*PTime) DIV 2;
  IF (PTime < 50) THEN
    DTime := (3*PTime) DIV 2;
  IF (PTime < 44) THEN
    DTime := (5*PTime) DIV 4;
END;



BEGIN
  CWSpeed := 100;
  SetCWSpeed(CWSpeed);
END.
