{-----------------------------------------------------------------------------
|
|  P R D e b u g . P A S
|
|  DL1BHO, 04/1994
|
|  Unit wird nur dann verwendet, wenn der Source mit der Option "DEBUG"
|  bersetzt wird.
|
+----------------------------------------------------------------------------}

UNIT    PRDebug;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE

  PROCEDURE Debug_Init;
  PROCEDURE Debug_Close;
  PROCEDURE Debug_Put (NewX, NewY, Attr : Byte; Zeile : String);


IMPLEMENTATION


USES
       Dos,
       Crt,
       PRDefs,
{$IFDEF OS2}
       PRV24OS2,
{$ELSE}
       PRV24,
{$ENDIF}
       PRLib,
       PRScreen;



PROCEDURE Debug_Init;

 VAR   x0, y0, a0     : Byte;
       Zeile          : String;

 BEGIN
   IF Debug.Status > 0 THEN
    BEGIN
      Zeile := SysPfad + 'PRDEBUG.DAT';
      x0 := WhereX;
      y0 := WhereY;
      a0 := TextAttr;
      Window(1,26,80,50);
      TextAttr := 7;
      ClrScr;
      WRITE('v  PRDebug-Ausgaben  ScanPort=',Debug.ScanPort,'  ');
      IF Debug.Save THEN
       BEGIN
         WRITE('Save=',Zeile);
         Assign(Debug.SaveFile,Zeile);
         Rewrite(Debug.SaveFile);
       END;
      WRITELN;
      Debug.XPos := 1;
      Debug.YPos := 1;

      maxWindow;
      TextAttr := a0;
      GotoXY(x0,y0);
    END;
 END;


PROCEDURE Debug_Close;

 BEGIN
   IF Debug.Status > 0 THEN
    BEGIN
      IF Debug.Save THEN
        Close(Debug.SaveFile);
    END;
 END;


{------------------------------------------------------------------------------
| Debug_Put
| Zu Service-Zwecken bestimmte Debug-Informationen anzeigen.
| (fr den normalen Benutzer vollkommen uninteressant)
| Es wird ein 50-Zeilen-Schirm vorausgesetzt! Die Debug-Informationen werden
| in den unteren 24 Zeilen dargestellt!
+-----------------------------------------------------------------------------}

PROCEDURE Debug_Put (NewX, NewY, Attr : Byte; Zeile : String);

 VAR   ch            : CHAR;
       x0, y0, a0    : Byte;        { Cursor-Position und TextAttribut }
       i,f           : INTEGER;
       x1, y1        : Byte;

 BEGIN

   IF Debug.Status > 0 THEN
    BEGIN
      a0 := TextAttr;
      x0 := WhereX;
      y0 := whereY;

      Window(1,27,80,50);
      TextAttr := Attr;

      IF NewX = 0 THEN
        x1 := Debug.XPos
      ELSE
        x1 := NewX;
      IF NewY = 0 THEN
        y1 := Debug.YPos
      ELSE
        y1 := NewY;
      GotoXY(x1,y1);

      FOR i := 1 TO Length(Zeile) DO
       BEGIN
         ch := Zeile[i];
         CASE ch OF
          #0,#7,#8,#10,#13,#127 : ;
          ELSE
            WRITE(ch);
         END;
       END;

      IF Debug.Save THEN                 { Fileformat nach PMLM-Standard }
        FOR i := 1 TO Length(Zeile) DO
          WRITE(Debug.SaveFile,Zeile[i],Chr(Attr));

      Debug.XPos := WhereX;
      Debug.YPos := WhereY;
      maxWindow;
      TextAttr := a0;
      GotoXY(x0,y0);
    END;
 END;


BEGIN

END.
