
{------------------------------------------------------------------------------
|
|   P R D E F S . P A S
|
|   Variablen-, Typ- und Konstantendeklarationen +
|   Initialisierungsroutine fuer alle Variablen
|
|   Wird als UNIT compiliert und ist in allen anderen Units Voraussetzung.
|
|   ACHTUNG: Diese Unit mu die erste Unit in PR.PAS sein, damit ein Check
|            auf 80286-Fhigkeit stattfinden kann !!!
|
|   DL1BHO  im Januar 1993
|
+-----------------------------------------------------------------------------}


UNIT PRDefs;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


Interface


USES
      Dos;


CONST
      Version         = '3.25-1-au';
      Update          = '28.03.98';
      StatusZusatz    = '32';            { zur Vermeidung von Problemen mit }
                                         { falsch aufgebauten Status-Dateien }

      V_Nummer        = 'V' + Version + '  ' + Update;
      V1_Str          = 'Turbo-PR ' + V_Nummer;

      S1Pos           = 5;      { Y-Position der ersten Statuszeile }
      maxEditLine     = 20;     { max. 20 Zeilen Vorschreibspeicher pro Kanal }

      minBCount       = 220;    { min. BufferCount fr FileSend }

      maxMsgLaenge    = 2048;   { maximale Lnge eines Festspeichertextes }

      maxQRG          = 20;     { max Anzahl QRGs in der QRG-Datei }

      maxX            = 80;     { 80 Zeichen pro Zeile (fest) }

      maxLink         = 10;     { Kanle 1-10 + Monitor, NICHT VERNDERN!! }

      cmd_CHAR        = #27;    { Esc-Zeichen im TNC-Eprom }

      BSave           = TRUE;   { Buffer-Save beim DOS-Call }
      noBSave         = FALSE;

      Esc             = #27;
      Bell            = #7;
      CrLf            = #13#10;

      DelayCorr       = 10;     { Korrekturwert bei Delay-Aufrufen, da Delay() }
                                { bei Cache-Prozessoren zu schnell abluft }
                                { Die meisten Delays arbeiten mit Timern. }
      CWSpeedInit     = 110;    { CW-Speed 110 bpm }

      VGA             = TRUE;   { erstmal als CONST, spter Auto-Detect,    }
                                { ich wei allerdings noch nicht wie...     }
                                { Bei VGA=TRUE wird BorderColor verndert!  }

      maxTimer        = 6;      { Anzahl benutzter 55ms-Timer }

      SysDelayTmr     = 1;      { Timer fr SysDelay }
      ResyncTmr       = 2;      { Timer fr Hostmode-Resync }
      RPSTmr          = 3;      { Timer zur Ermittlung "Rounds per Second" }
      ms55_4          = 4;      { lokaler Timer }
      ms55_5          = 5;      { lokaler Timer }
      CursorTmr       = 6;      { Timer fr das Cursor-Blinken }

                                { Timer-Constanten fr 18.2 Hz Timer }
      Sec05           = 9;      { 0.5 Sekunden }
      Sec1            = 18;     { 1 Sekunde }
      Sec2            = 36;     { 2 Sekunden }
      Sec3            = 55;     { 3 Sekunden }

TYPE
      Str2       = String [2];
      Str3       = String [3];
      Str4       = String [4];
      Str5       = String [5];
      Str6       = String [6];
      Str7       = String [7];
      Str8       = String [8];
      Str9       = String [9];
      Str10      = String [10];
      Str11      = String [11];
      Str12      = String [12];
      Str13      = String [13];
      Str20      = String [20];
      Str25      = String [25];
      Str32      = String [32];
      Str40      = String [40];
      Str60      = String [60];
      Str80      = String [80];
      Str128     = String [128];

      VideoType  = ARRAY [1..80*60*2] OF CHAR;          { max 80x60 Zeichen  }
                                                        { plus Videoattribute }
      EditLineType = ARRAY [1..100] OF Str80;
      RXTXBuffer = ARRAY [1..1024] OF CHAR;
      MsgType    = ARRAY [1..maxMsgLaenge] OF CHAR;      { 1 Festspeichertext }

      AttrChxBType = ARRAY [1..800,1..80] OF CHAR;  { Speicher-Typ fr Attr-, }
                                                    { Chx- und Notiz-Buffer }

      MH_QRG_Type = RECORD
                      QRG            : Str8;
                      expectedIdent  : Str8;
                      Calls          : Str80;
                    END;

      FuenfString = ARRAY [1..5] OF String [5];

      MH_Typ     = RECORD
                     Call    : Str9;         { Rufzeichen }
                     Zeit    : Str5;         { zuletzt gehrt um ... }
                     Info    : WORD;         { Anzahl Info-Frames }
                   END;

      MH_Liste   = ARRAY [1..60] OF MH_Typ;

      LinkStateType = RECORD
                        Zeile   : Str13;
                        Attr    : Byte;
                      END;

      TNC_Record
                 = RECORD
                     used         : BOOLEAN;   { In Gebrauch? }
                     Channels     : Byte;      { Anzahl der Kanle }
                     RS232        : Byte;      { Com-Nummer }
                     RS232_Switch : Byte;      { Port-Nummer bei V24-Switch }
                     Ident        : Str8;      { Identifier }
                     HeaderAttr   : BYTE;
                     currentQRG   : Str8;
                     MoniStatus   : ^Str80;    { Speicher fr den Moni-Status }
                     MH           : ^MH_Liste; { Speicher fr MH-Liste }
                     UCmdStr      : ^String;   { Speicher fr U-String }
                     XHOSTok      : BOOLEAN;   { Kann TNC XHOST-Protokoll? }
                     ChannelOffset: BYTE;      { PRKanal1-TNCKanal1 }
                   END;

      AutoCmdTyp = RECORD
                     Handle    : Str10;
                     Anzahl    : BYTE;
                     cmd_Line  : String;
                   END;

      ScanType   = RECORD
                     Call1, Call2  : String [9];
                     SuchString    : String [22];
                     INr           : Byte;
                   END;

      XHost_Rec  = RECORD
                     Status        : INTEGER;
                     Channel       : INTEGER;
                     Counts        : INTEGER;
                     ChannelInfo   : ARRAY [0..10] OF BOOLEAN;
                   END;

      polling_Rec= RECORD
                     Status        : INTEGER;
                     Channel       : INTEGER;
                     ChannelInfo   : ARRAY [0..10] OF BOOLEAN;
                   END;

      Debug_Rec  = RECORD
                     Status        : INTEGER;
                     XPos          : Byte;
                     YPos          : Byte;
                     Save          : BOOLEAN;
                     SaveFile      : Text;
                     ScanPort      : Byte;
                   END;


{------------------------------------------------------------------------------
| Variablenstruktur fr jeden Kanal (0 bis 10)
+-----------------------------------------------------------------------------}

      Kanal_Record

         = RECORD
             poll         : BOOLEAN;       { soll der Kanal gepollt werden?   }
             Call         : Str9;          { Call bei connect                 }
             TNCCall      : Str9;          { eigenes Call pro Kanal           }
             connected    : BOOLEAN;       { TRUE wenn connected              }
             qsoDatum     : String[11];    { Datum QSO-Beginn                 }
             qsoBeginn    : String[5];     { Zeit QSO-Beginn                  }
             ConText      : String;        { Text fuers Log                   }
             EditLine     : ^EditLineType; { Vorschreib-Buffer                }
             actEditLine  : INTEGER;       { aktuelle Vorschreib-Zeile        }
             TopEditLine  : Byte;
             FrameCount   : Word;          { FrameZhler                      }
             X1,Y1,X2     : BYTE;          { Cursor-Positionen                }
             AttrBuffer   : ^AttrChxBType; { Attribut-Buffer }
             ChxBuffer    : ^AttrChxBType; { Backscroll-Buffer }
             AttrBufferP  : Word;          { Zeiger auf AttrBuffer }
             ChxBufferP   : Word;          { Zeiger auf ChxBuffer }
             ChxBufferPmax : Word;         { max Zeilen Backscroll }
             Trenn        : BYTE;          { Y_Pos der Trennzeile             }

             L_mess       : INTEGER;       { LinkStatusMessages               }
             R_Frames     : INTEGER;       { Received Frames                  }
             S_Frames     : INTEGER;       { Sent Frames                      }
             T_Frames     : INTEGER;       { Transmitted Frames               }
             Tries        : INTEGER;       { Try-Counter                      }
             LinkState    : INTEGER;       { Link-Status                      }

             TXFile       : FILE;          { Sende-File                       }
             FileSend     : BOOLEAN;       { Merker fuer FileSend             }
             TX_Name      : PathStr;       { TXFile-Name mit Pfad             }
             TX_Laenge    : LongInt;       { Laenge von Binaerfiles           }
             TX_Count     : LongInt;       { Zaehler f. Bin-Uebertr.          }
             TXFileBuffer : ^RXTXBuffer;
             TX_Buffer_Count : INTEGER;
             TX_Mode      : BYTE;          { Merker fuer Filesendeart         }
             TX_CRC       : WORD;          { CRC-Check bei Bin-Transfer       }
             TX_Sum       : WORD;          { Sum-Check (TNN)                  }

             RXFile       : Text;          { Save-File mit 1K Buffer          }
             RXFileBuffer : ^RXTXBuffer;
             save         : BOOLEAN;       { Merker fuer Save                 }
             RX_Name      : PathStr;       { Savefile-Name und Pfad           }
             RX_Laenge    : LongInt;       { nur fr Auto-Binfiles            }
             RX_Count     : LongInt;
             RX_Mode      : BYTE;          { Merker fr Fileempfangsart       }
             RX_XBin      : BOOLEAN;       { Extended Bin-RX                  }
             RX_Checksum  : WORD;          { CRC-Check bei Bin-Transfer       }
             RX_expectCheck : WORD;        { erwartete CRC-Summe              }
             DTInt        : LongInt;       { Date/Time-Longint                }
             FiFoStr      : Str80;         { FiFo-Speicher                    }

             Umlaut       : Byte;          { 0 : keine Umlaute                }
                                           { 1 : 7-Bit-Umlaute                }
                                           { 2 : 8-Bit-Umlaute                }
             Pause        : INTEGER;
             notice       : BOOLEAN;       { Notiz-Buffer ein/aus             }
             Paclen       : BYTE;          { Paclen fr diesen Kanal          }
             MaxFrame     : BYTE;          { Maxframe fr diesen Kanal        }
             TNCNummer    : BYTE;          { 1 bis 4 }
             TNCKanal     : CHAR;          { physikalischer Kanal des TNC     }
             Auto_cmd     : BOOLEAN;
             cmd_Stufe    : INTEGER;
             cmd_Nummer   : INTEGER;
             NCheck       : BOOLEAN;
             newText      : BOOLEAN;
             fremdConnect : BOOLEAN;       { nicht selbst ausgelster Connect }
                                           { Erkennung noch etwas Murks... }
             PassWort     : String[4];     { PW fr DieBox ab V1.4            }
             LocalEcho    : BOOLEAN;
             CW           : BOOLEAN;
             Remote       : Byte;          { 0 = kein Remote                 }
                                           { 1 = Anti-Remote                 }
                                           { 2 = Remote                      }
             RemStatus    : INTEGER;
             RemPriv      : Byte;          { privilegiert? }
             RemPrivAnswer : Str5;         { erwartetes Pawort }

             simplex      : BOOLEAN;       { Simplex-Kanal? Test fr PTC-Treiber }

             Ansi         : BOOLEAN;       { ANSII Emulation                 }
           END;

CONST
      LinkStateStr      : ARRAY [-1..16] OF LinkStateType =
                           ((Zeile:'             ';Attr:0),
                            (Zeile:'Disconnected ';Attr:0),
                            (Zeile:' Link Setup  ';Attr:0),
                            (Zeile:'Frame Reject ';Attr:0),
                            (Zeile:'Disc Request ';Attr:0),
                            (Zeile:'Info Transfer';Attr:0),
                            (Zeile:' Reject sent ';Attr:0),
                            (Zeile:' Waiting Ack ';Attr:0),
                            (Zeile:' Device Busy ';Attr:0),
                            (Zeile:'RemDevice Bsy';Attr:0),
                            (Zeile:'Both Dev Bsy ';Attr:0),
                            (Zeile:'noAck+Dev Bsy';Attr:0),
                            (Zeile:'noAck+Rem Bsy';Attr:0),
                            (Zeile:'noAck+2DevBsy';Attr:0),
                            (Zeile:'RejSnt+DevBsy';Attr:0),
                            (Zeile:'RejSnt+RemBsy';Attr:0),
                            (Zeile:'RejSent+2Bsy ';Attr:0),
                            (Zeile:' ########### ';Attr:0));

{------------------------------------------------------------------------------
| globale Variablen
+-----------------------------------------------------------------------------}

VAR
      VideoPage         : ^VideoType;    { Pointer auf Video-Ram }
      VideoPageSave     : ^VideoType;
      VideoPageSaveX,
      VideoPageSaveY    : Byte;
      VideoRestore      : BOOLEAN;
      K                 : ARRAY [0..maxLink] OF ^Kanal_Record;
      show              : BYTE;        { zur Zeit angezeigter Kanal }
      QRT               : BOOLEAN;     { Ende-Merker }

      Response          : ARRAY [0..256] OF CHAR;    { Antwort des TNC }
      ResponseStr       : String Absolute Response;  { zur einf. Verarbeitung }
                                                     { mit String-Funktionen  }
      { leider geht dabei das letzte (256.) Zeichen flten (Sonderbehandlung) }

      Sek15             : BOOLEAN;     { Programmlaufzeit ueber 15 Sekunden? }
      Sek15Counter      : INTEGER;
      Datum             : Str11;
      Zeit              : Str8;
      OldTime           : Str8;
      PID               : BYTE;

      gesMin            : LongInt;   { Gesamt-Programmlaufzeit (Minuten) }
      Laufzeit          : WORD;      { Programmlaufzeit seit Pogrammstart (Minuten) }

      Drucker           : INTEGER;
      D_Spalte          : BYTE;
      AttrSet           : Char;
      VideoSeg          : WORD;
      Time_stamp        : BOOLEAN; { Merker, Software soll Zeit anfuegen (Moni) }
      CR                : BOOLEAN;
      TNC               : ARRAY[1..4] OF TNC_Record;
      SendKanal         : BYTE;
      Channel0          : Byte;     { TNC, der auf Kanal 0 gepollt wird }
      myText            : BOOLEAN;
      TextPfad          : PathStr;
      SysPfad           : PathStr;   { Pfad fr die Packet-Systemfiles }
      TempPfad          : PathStr;   { Pfad fr temporre Daten }
      ScrollBufferSavePfad : PathStr;
      Printer1          : ARRAY[1..10] OF Str10;   { Drucker-Steuerzeichen }
      Resync_Z          : INTEGER;         { Zaehler fuer Resync's }
      AutoCMD           : ARRAY[1..10] OF ^AutoCmdTyp;
      active_TNC        : BYTE;
      Klingel           : BOOLEAN;
      Neu_Bild_if_keypressed : BOOLEAN;
      unproto           : BYTE;
      multiTNC          : BOOLEAN;
      msg               : ARRAY [1..11] OF ^MsgType;  { Festspeichertexte }
      Kanal_Anzahl      : BYTE;
      ScreenSTBY        : BOOLEAN;
      ScreenInit        : INTEGER;
      ScreenTimer       : INTEGER;
      NetPWFileOK       : BOOLEAN;
      Ausgabe           : BOOLEAN;
      AlarmCalls        : String;
      LPT1_Base         : WORD ABSOLUTE 0:$0408;  { Basisadresse fr LPT1: }
      LPT1_vorhanden    : BOOLEAN;   { Druckerschnittstelle vorhanden? }
      lastChannel       : BYTE;    { zuletzt benutzter Kanal }
      CursorMerker      : INTEGER;
      BreakStatus       : BOOLEAN;
      LastModeMerker    : Word;
      ExitSave          : Pointer;
      StatusFileOK      : BOOLEAN;
      NotizBuffer       : ^AttrChxBType;
      NotizX            : Byte;
      NotizBufferP      : Word;    { vorher INTEGER }
      NotizBufferPmax   : Word;    { " }
      AttrBufferPmax    : Word;    { " }
      handleKbdIrq      : BOOLEAN;
      Stby_X,Stby_Y     : INTEGER;
      MaxY              : Byte;       { maximale Y-Position }
      QRGCheck          : ARRAY [1..maxQRG] OF ^MH_QRG_Type;
      lastQRG           : BYTE;
      ScreenSize        : Word;
      _B                : Byte;
      ListPgm           : Str40;
      EditPgm           : Str40;
      CmdLinePar        : String;    { alle Kommandozeilen-Parameter }
      Scan              : ARRAY [1..2] OF ScanType;
      ScanChannel       : INTEGER;
      ScanMatch         : Byte;
      CWSpeed           : INTEGER;

      oldTimer          : LongInt;
      Timer             : ARRAY [1..maxTimer] OF Word;

      XHost             : XHost_Rec;
      polling           : polling_Rec;
{$IFDEF DEBUG}
      Debug             : Debug_Rec;
{$ENDIF}
      Code5             : BOOLEAN;    { Merker fr Monitor-Info-followes }

      RPS               : INTEGER;    { Rounds per Second }
      EditCursorToggle  : BOOLEAN;

      norm,
      low,
      blinkAttr,
      neg,
      neg_high,
      neg_blink,
      ctrlAttrib,
      conRXAttrib,
      conTXAttrib,
      MoniInfoAttr,
      NetzHeaderAttrib,
      FRahmenAttr,
      FTitelAttr,
      FNormAttr,
      FHighAttr,
      FBlinkAttr        : BYTE;    { Bildschirm-Attribute }



  PROCEDURE Global_VAR_Init;
  PROCEDURE Kanal_VAR_init (Kanal : BYTE);
  PROCEDURE LinkStateAttrInit;


IMPLEMENTATION


USES

       Crt,
       PRLib;


{------------------------------------------------------------------------------
| Initialisierung der globalen Variablen
+-----------------------------------------------------------------------------}

PROCEDURE Global_VAR_INIT;

 VAR i, xxx     : INTEGER;
     act_maxX   : Byte;
     subStr     : String;

 BEGIN

   QRT := FALSE;
   LaufZeit := 0;
   active_TNC := 0;
   Channel0 := 0;
   Sek15 := FALSE;
   Sek15Counter := 10;       { eigentlich 15 Sekunden... hi }
   PID := 0;
   Drucker := -1;            { Drucker aus }
   D_Spalte := 1;
   Time_stamp := TRUE;
   CR := FALSE;
   myText := FALSE;
   Klingel := TRUE;
   Neu_Bild_if_keypressed := FALSE;
   Kanal_Anzahl := 0;
   ScreenSTBY := FALSE;
   NetPWFileOK := FALSE;
   Ausgabe := TRUE;
   SysPfad := '';
   ScrollBufferSavePfad := '';
   lastChannel := 0;
   Resync_Z := 0;
   gesMin := 0;
   StatusFileOK := FALSE;
   VideoRestore := FALSE;
   LPT1_vorhanden := (LPT1_Base <> 0);

   SysPfad := onlyDName(ParamStr(0));    { Pfad von PR.EXE }
   TempPfad := SysPfad + 'TEMP\';

   NotizBufferP := 1;
   NotizX := 1;

   handleKbdIrq := FALSE;

   _B := 0;

   { Kommandozeilenparameter aufsammeln. Ein Aufruf wie "PR -v /cxx" ergibt }
   { in CmdLinePar die Form "-V-CXX-" }
   CmdLinePar := '';
   FOR i := 1 TO ParamCount DO
    BEGIN
      subStr := upcaseStr(ParamStr(i));
      IF subStr[1] = '/' THEN
        subStr[1] := '-';
      IF subStr[1] <> '-' THEN
        subStr := '-' + subStr;
      CmdLinePar := CmdLinePar + subStr;
    END;
   CmdLinePar := CmdLinePar + '-';

   IF (Pos('-R-',CmdLinePar) > 0) THEN
     VideoRestore := TRUE;

   act_MaxX := WindMax MOD 256 + 1;
   MaxY := WindMax DIV 256 + 1;
   IF (act_MaxX <> 80) OR (MaxY < 25) OR (MaxY > 60) THEN
    BEGIN
      WRITELN;
      WRITELN('TurboPR: Falsches Bildschirm-Format (',
                act_MaxX,'x',MaxY,') !',Bell);
      WRITELN;
      WRITELN('         TurboPR arbeitet nur mit 25 bis 60 Zeilen und ',
                '80 Zeichen/Zeile !');
      WRITELN;
      Halt;
    END;

{$IFDEF DEBUG}
   Debug.Status := 0;
   Debug.Save := FALSE;
   Debug.ScanPort := 0;
   IF Pos('-DEBUG-',CmdLinePar) > 0 THEN
     IF MaxY >= 50 THEN
      BEGIN
        { Debug-Modus nur in der hohen Auflsung zulassen! }
        Debug.Status := 1;
        MaxY := 25;         { Bildschirm begrenzen }
      END;
   IF Pos('-DSAVE-',CmdLinePar) > 0 THEN
     IF Debug.Status = 1 THEN
       Debug.Save := TRUE;
   i := Pos('-DPORT=',CmdLinePar);
   IF i > 0 THEN
    BEGIN
      Val(Copy(CmdLinePar,i+7,1),Debug.ScanPort,xxx);
      IF (xxx > 0) OR (Debug.ScanPort > 5) THEN
        Debug.ScanPort := 0;
    END;
{$ENDIF}

   ScreenSize := 2*MaxX*MaxY;
   AttrBufferPmax := MaxY - 3;

   NotizBufferPmax := MaxY - 3;

   FOR i := 1 TO 2 DO
    BEGIN
      Scan[i].Call1 := '';
      Scan[i].Call2 := '';
      Scan[i].SuchString := '';
      Scan[i].INr := 0;
    END;
   ScanChannel := -1;
   ScanMatch := 0;

   CWSpeed := CWSpeedInit;

   oldTimer := getTimer;
   FOR i := 1 TO maxTimer DO     { 55ms-Timer initialisieren }
     Timer[i] := 0;

   Code5 := FALSE;

   RPS := 0;
   EditCursorToggle := FALSE;
 END;


{------------------------------------------------------------------------------
| Speicher fr einen Kanal anfordern + Initialisierung der Kanalvariablen.
| Initialisierungswerte knnen spter vom Config-File teilweise berschrieben
| werden!
+-----------------------------------------------------------------------------}

PROCEDURE Kanal_VAR_INIT(Kanal : BYTE);

 BEGIN

   GetMem(K[Kanal],Sizeof(Kanal_Record));        { Speicher auf Heap belegen }

   WITH K[Kanal]^ DO BEGIN
     Call := '         ';
     TNCCall := '';
     connected := FALSE;
     qsoDatum := '';
     qsoBeginn := '';
     ConText := '';
     IF (Kanal = 0) THEN
       Trenn := 26
     ELSE
       Trenn := 19;
     x1 := 1;
     y1 := 1;
     x2 := 1;
     AttrBufferP := 1;
     ChxBufferP := 1;
     ChxBufferPmax := MaxY - 3;
     L_mess := 0;
     R_Frames := 0;
     S_Frames := -1;
     T_Frames := -1;
     Tries := -1;
     IF (Kanal = 0) THEN
       LinkState := 0
     ELSE
       LinkState := -1;
     FrameCount := 0;
     RX_Mode := 0;
     RX_XBin := FALSE;
     FiFoStr := ConstStr(#13,80);
     save := FALSE;
     RX_Name := '';
     TX_Name := '';
     FileSend := FALSE;
     notice := FALSE;
     Umlaut := 2;
     Pause := 1;
     Paclen := 128;
     MaxFrame := 1;
     IF (Kanal = 0) THEN
       poll := TRUE
     ELSE
       poll := FALSE;
     TNCNummer := 0;
     TNCKanal := #0;
     Auto_cmd := FALSE;
     cmd_Stufe := 0;
     cmd_Nummer := 1;
     NCheck := TRUE;             { Prfen auf Nodes-Meldungen eingeschaltet }
     newText := FALSE;
     actEditLine := 1;
     TopEditLine := 1;           { Zeile, die i.d. ersten Videozeile steht }
     fremdConnect := FALSE;
     PassWort := '';
     LocalEcho := TRUE;
     CW := FALSE;
     Remote := 1;                { Anti-Remote-Automatik eingeschaltet }
     RemStatus := 0;
     RemPriv := 0;
     RemPrivAnswer := '';
     simplex := FALSE;
     Ansi := FALSE;
   END;

 END;


{-----------------------------------------------------------------------------
| Initialisierung der Attribute fr die Darstellung der Linkstates in der
| Statuszeile
+----------------------------------------------------------------------------}

 PROCEDURE LinkStateAttrInit;
  VAR  i     : INTEGER;
  BEGIN
    FOR i := -1 TO 16 DO
      LinkStateStr[i].Attr := neg_blink;
    LinkStateStr[0].Attr := neg;
    LinkStateStr[2].Attr := neg_high;
    LinkStateStr[3].Attr := neg_high;
    LinkStateStr[4].Attr := neg_high;
    LinkStateStr[5].Attr := neg_high;
    LinkStateStr[6].Attr := neg_high;
  END;


{-----------------------------------------------------------------------------
| Funktion zur berprfung auf Prozessor >= 80286
| Ursprnglich von Borland...
+----------------------------------------------------------------------------}

function Is286Able: Boolean; assembler;
asm
        PUSHF
        POP     BX
        AND     BX,0FFFH
        PUSH    BX
        POPF
        PUSHF
        POP     BX
        AND     BX,0F000H
        CMP     BX,0F000H
        MOV     AX,0
        JZ      @@1
        MOV     AX,1
@@1:
end;



BEGIN

{$IFOPT G+}
  if not Is286Able then
   begin
     WRITELN;
     Writeln('Need an 80286-compatible system to run this program');
     Halt(1);
   end;
{$ENDIF}

END.
