
{------------------------------------------------------------------------------
|
|  P R L I B . P A S
|
|  Packet-Radio Pascal Library
|
|  DL1BHO  03/1994
|
|  03/1994:   Dec_Timer zugefgt
|
+-----------------------------------------------------------------------------}


UNIT PRLib;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


USES
      Dos,
      PRDefs;


  PROCEDURE Fenster (X_Pos, Y_Pos, Breite, Hoehe : BYTE ; Kopf : Str80);
  PROCEDURE restore_Screen;
  PROCEDURE Alarm_Bell;
  PROCEDURE C_Bell;
  PROCEDURE D_Bell;
  PROCEDURE REC_Bell;
  FUNCTION  str_int (Zeile : Str8) : LongInt;
  PROCEDURE OpenRXFile(Kanal : BYTE);
  PROCEDURE CloseRXFile (Kanal : BYTE);
  FUNCTION  GetCursorSize : INTEGER;
  PROCEDURE SetCursorSize (Size:INTEGER);
  PROCEDURE Cursor_aus;
  PROCEDURE EditStr (VAR Zeile : Str80; maxL,x0,y0 : Byte; VAR chx : Char);
  PROCEDURE Cursor_ein;
  FUNCTION  GetVideoSeg : WORD;
  FUNCTION  int_str (i : LongInt) : Str8;
  PROCEDURE beep (Ton,Laenge : INTEGER);
  FUNCTION  Date : Str11;
  FUNCTION  Time : Str8;
  FUNCTION  HEX (Dezimal : longInt ; Stellenzahl : BYTE) : Str8;
  FUNCTION  BIN (Dezimal : LONGINT ; Stellenzahl : BYTE) : Str32;
  PROCEDURE File_not_found;
  FUNCTION  WochenTag (Datum : Str8) : Str2;
  FUNCTION  Channel_ID (Kanal : BYTE) : Str8;
  FUNCTION  GetTimer : LONGINT;
  PROCEDURE SysDelay (CountDown : INTEGER);
  PROCEDURE SysKeyDelay (CountDown : INTEGER);
  PROCEDURE Dec_Timer;
  FUNCTION  ConstStr (ch : CHAR ; L : INTEGER) : String;
  FUNCTION  CutStr (Zeile : String) : String;
  FUNCTION  UpcaseStr (Zeile : String) : String;
  FUNCTION  CutLeftStr (Zeile : String) : String;
  FUNCTION  CutRightStr (Zeile : String) : String;
  FUNCTION  Space(L : INTEGER) : String;
  FUNCTION  LPT1_Error : BOOLEAN;
  FUNCTION  FehlerText (FehlerCode : BYTE) : Str80;
  PROCEDURE NewExit;
  FUNCTION  Pointer_Str (Zeiger : Pointer) : Str9;
  PROCEDURE WaitKey (Art : BYTE);
  FUNCTION  Kbd_Status : BYTE;
  FUNCTION  onlyFName (Pfad : PathStr) : Str12;
  FUNCTION  onlyDName (Pfad : PathStr) : DirStr;
  FUNCTION  packedFTime (VAR Datei) : LongInt;
  PROCEDURE KBDlock;
  PROCEDURE KBDfree;
  FUNCTION  IO_ok : BOOLEAN;
  FUNCTION  RxTxStr (Kanal : Byte) : Str25;
  FUNCTION  LZStr(Zeit : LongInt) : Str10;
  FUNCTION  GetChecksum (DatName : String; silent : BOOLEAN) : Word;
  PROCEDURE ParameterHelp;
  FUNCTION  onlyCall(Call : Str20) : Str9;
  FUNCTION  onlyIdent(Call : Str20) : Str9;
  FUNCTION  File_exists (DatName : Str80) : BOOLEAN;
  FUNCTION  Path_exists (Suchbegriff : PathStr) : BOOLEAN;
  FUNCTION  StdFilename(Kanal : Byte) : Str80;
{$IFDEF OS2}
  PROCEDURE OS2_Idle(CountDown : INTEGER);
{$ENDIF}


IMPLEMENTATION


USES
       Crt,
       PRKbd,
       PRScreen,
       PRMouse,
       PRCRC;


CONST  HexChars  : ARRAY[0..15] OF CHAR = ('0','1','2','3','4','5','6','7',
                           '8','9','A','B','C','D','E','F');



{-----------------------------------------------------------------------------}
{ Channel_ID  liefert den Ident des Kanals zurck                             }
{-----------------------------------------------------------------------------}

FUNCTION Channel_ID (Kanal : BYTE) : Str8;
VAR B_str   : str8;
BEGIN
  IF (Kanal = 0)
    THEN B_str := TNC[active_TNC].Ident
    ELSE B_str := TNC[K[Kanal]^.TNCNummer].Ident;
  IF length(B_str) > 0 THEN B_str := B_str + ' ';
  Channel_ID := B_str;
END;


{------------------------------------------------------------------------------
| GetTimer  liefert den Systemtimer zurck
| ACHTUNG !!!  Neue Version von DL5UE zur Beseitigung des Datum-Problems.
+-----------------------------------------------------------------------------}

FUNCTION GetTimer : LONGINT;

 BEGIN
   Inline ($FA);
   GetTimer := MemL [$0040:$006C];
   Inline ($FB);
 END;


{-----------------------------------------------------------------------------
|  Bei Bedarf die 55ms-Timer dekrementieren
+----------------------------------------------------------------------------}

PROCEDURE Dec_Timer;

 VAR    i           : INTEGER;
        TimerDiff   : LongInt;

 BEGIN
   TimerDiff := getTimer - oldTimer;
   IF TimerDiff < 0 THEN
     TimerDiff := 1;              { vermutlich Overflow/Geisterstunde... }
   IF TimerDiff > 8 THEN
     TimerDiff := 8;              { vermutlich zu seltener Aufruf... }
   IF TimerDiff > 0 THEN
    BEGIN
      oldTimer := getTimer;
      FOR i := 1 TO maxTimer DO
        IF Timer[i] > TimerDiff THEN
          Dec(Timer[i],TimerDiff)       { max. TimeDiff-mal dekrementieren }
        ELSE
          Timer[i] := 0;
    END;
 END;


{------------------------------------------------------------------------------
| SysDelay  macht eine Pause. Ein Wert von 18 entspricht etwa 1 Sekunde
+-----------------------------------------------------------------------------}

PROCEDURE SysDelay (CountDown : INTEGER);

 BEGIN
   REPEAT
   UNTIL getTimer <> oldTimer;       { Timer-Umsprung abwarten }
   oldTimer := getTimer;
   Timer[SysDelayTmr] := CountDown;
   REPEAT
     Dec_Timer;
   UNTIL Timer[SysDelayTmr] = 0;
 END;


{------------------------------------------------------------------------------
| SysKeyDelay  macht eine Pause. Ein Wert von 18 entspricht etwa 1 Sekunde
| Vorzeitiger Abbruch durch Tastatureingabe mglich.
+-----------------------------------------------------------------------------}

PROCEDURE SysKeyDelay (CountDown : INTEGER);

 BEGIN
   REPEAT
   UNTIL getTimer <> oldTimer;
   oldTimer := getTimer;
   Timer[SysDelayTmr] := CountDown;
   REPEAT
     Dec_Timer;
   UNTIL KeyPressed OR (Timer[SysDelayTmr] = 0);
 END;


{-----------------------------------------------------------------------------}
{ CutStr  liefert den bergebenen String bis zum ersten Leerzeichen zurck.   }
{-----------------------------------------------------------------------------}

FUNCTION CutStr (Zeile : String) : String;

 VAR  i  : INTEGER;

 BEGIN
   i := Pos(' ',Zeile);
   IF (i = 0)
     THEN i := Length(Zeile)
     ELSE Dec(i);
   CutStr := Copy(Zeile,1,i);
 END;


{-----------------------------------------------------------------------------}
{ UpcaseStr  liefert den bergebenen String in Grobuchstaben zurck.         }
{-----------------------------------------------------------------------------}

FUNCTION UpcaseStr (Zeile : String) : String;

 VAR  i   : INTEGER;

 BEGIN
   FOR i := 1 TO Length(Zeile) DO
     Zeile[i] := Upcase(Zeile[i]);
   UpcaseStr := Zeile;
 END;


{-----------------------------------------------------------------------------
| CutLeftStr  liefert den bergebenen String ohne fhrende Leerzeichen zurck
+----------------------------------------------------------------------------}

FUNCTION  CutLeftStr (Zeile : String) : String;

 VAR  i    : INTEGER;
      L    : INTEGER;

 BEGIN
   i := 0;
   L := Length(Zeile);
   REPEAT
     Inc(i);
   UNTIL (i >= L) OR (Zeile[i] <> ' ');
   IF (Zeile[i] = ' ')
     THEN CutLeftStr := ''
     ELSE CutLeftStr := Copy(Zeile,i,L-i+1);
 END;


{-----------------------------------------------------------------------------
| Einen String AB dem ersten Space OHNE fhrende Spaces zurckliefern
+----------------------------------------------------------------------------}

FUNCTION CutRightStr (Zeile : String) : String;

 VAR   i      : INTEGER;

 BEGIN
   i := Pos(' ',Zeile);
   IF (i = 0) THEN
     CutRightStr := ''
   ELSE
     BEGIN
       Delete(Zeile,1,i);
       WHILE (Zeile[1] = ' ') AND (Length(Zeile) > 0) DO
         Delete(Zeile,1,1);
       CutRightStr := Zeile;
     END;
 END;


FUNCTION LPT1_Error;        { changes by DJ0HC }
 VAR le  : BOOLEAN;
     b   : BYTE;
 BEGIN
   b := 5;
   REPEAT
      Delay(1*DelayCorr);
      Dec(b);
{    le := ((Port[LPT1_Base + 1] AND $B8) <> $98);     }
      le := ((Port[LPT1_Base + 1] AND $A8) <> $88);
   UNTIL (NOT le) OR (b = 0);
   LPT1_Error := le;
 END;


{-----------------------------------------------------------------------------}
{ ConstStr  liefert einen String der Lnge L gefllt mit Zeichen ch zurck.   }
{-----------------------------------------------------------------------------}

FUNCTION ConstStr (ch : CHAR ; L : INTEGER) : String;

 VAR B_Str : String;

 BEGIN
   IF (L < 0)
     THEN L := 0
     ELSE L := L AND 255;
   Fillchar(B_str,L+1,ch);
   B_Str[0] := Chr(L);
   ConstStr := B_Str;
 END;


FUNCTION  Space(L : INTEGER) : String;
 BEGIN
   Space := ConstStr(' ',L);
 END;


{-----------------------------------------------------------------------------
|  Editieren eines Strings
|  maximale Stringlnge = 80 Zeichen !
+----------------------------------------------------------------------------}

PROCEDURE EditStr (VAR Zeile : Str80; maxL,x0,y0 : Byte; VAR chx : Char);

 VAR   kc         : KeyCodes;
       Ende       : BOOLEAN;
       SPos       : Byte;     { Position im String }
       L          : Byte;
       firstKey   : BOOLEAN;

 BEGIN

   Ende := FALSE;
   L := Length(Zeile);
   SPos := SUCC(L);
   GotoXY(x0,y0);
   WRITE(Zeile);
   Cursor_ein;
   FirstKey := TRUE;

   REPEAT

     GotoXY(x0+PRED(SPos),y0);
     L := Length(Zeile);

     REPEAT UNTIL Keypressed;
     GetKey(chx,kc);

     IF FirstKey AND (kc = _Sonstige) THEN
      BEGIN
        { erste Nicht-Sondertaste lscht die Eingabe }
        GotoXY(x0,y0);
        Write(ConstStr(' ',L));
        Zeile := '';
        L := Length(Zeile);
        SPos := SUCC(L);
        GotoXY(x0,y0);
      END;
     FirstKey := FALSE;

     CASE kc OF

      CLeft
        : BEGIN
            IF (SPos > 1) THEN Dec(SPos);
          END;
      CRight
        : BEGIN
            IF (SPos < SUCC(L)) THEN Inc(SPos);
          END;
      CHome
        : BEGIN
            SPos := 1;
          END;
      CEnd
        : BEGIN
            SPos := SUCC(L);
          END;
      _Backstep
        : BEGIN
            IF (SPos >= 2) THEN
             BEGIN
               Dec(SPos);
               Delete(Zeile,SPos,1);
               WRITE(^H,Copy(Zeile,SPos,80),' ');
             END;
          END;
      Del
        : BEGIN
            IF (SPos < SUCC(L)) THEN
             BEGIN
               Delete(Zeile,SPos,1);
               WRITE(Copy(Zeile,SPos,80),' ');
             END;
          END;
      _Return,
      _Escape
        : BEGIN
            Ende := TRUE;
          END;
      _Sonstige
        : BEGIN
            chx := upcase(chx);
            IF (L < maxL) THEN
             BEGIN
               Insert(chx,Zeile,SPos);
               WRITE(Copy(Zeile,SPos,80));
               Inc(SPos);
             END;
          END;
      ELSE
          BEGIN

          END;

     END;   { CASE }

   UNTIL Ende;

   Cursor_aus;

 END;


{------------------------------------------------------------------------------
| WochenTag  liefert zu einem bergebenen Datum den Wochentag als 2-Byte-
| String zurck.
+-----------------------------------------------------------------------------}

FUNCTION  WochenTag (Datum : Str8) : Str2;

 CONST WoTagStr = 'SoMoDiMiDoFrSa';

 VAR  Tag, Monat, Jahr, i : INTEGER;
      x, y, z, Fehler     : INTEGER;

 BEGIN
   val(copy(Datum,1,2),Tag,Fehler);
   IF Fehler = 0 THEN val(copy(Datum,4,2),Monat,Fehler);
   IF Fehler = 0 THEN val(copy(Datum,7,2),Jahr,Fehler);
   IF Fehler = 0 THEN
   BEGIN
     Jahr := Jahr + 1900;
     IF Monat > 2 THEN Monat := Monat -2
       ELSE
       BEGIN
         Monat := Monat + 10;
         Jahr := Jahr - 1;
       END;
     x := Jahr MOD 100;
     z := Jahr DIV 100;
     y := (13 * Monat - 1) DIV 5 + x DIV 4 + z DIV 4;
     i := (x + y + Tag - 2 * z) MOD 7;
     IF (i < 0) THEN i := i + 7;
     IF (i >= 0) AND (i <= 6)
       THEN Wochentag := Copy(WoTagStr,1+2*i,2)
       ELSE Wochentag := 'xx';
   END
   ELSE WochenTag := 'xx';
 END;


{------------------------------------------------------------------------------
| Fehlermeldung ausgeben und Programm beenden
+-----------------------------------------------------------------------------}

PROCEDURE File_not_found;

 BEGIN
   WRITELN; writeln;
   WRITELN(^G'File nicht gefunden! Programm abgebrochen!');
   halt(0);
 END;


{------------------------------------------------------------------------------
| Hex  liefert den Hexadezimalwert eines LongInts mit vorgebbarer
| Stellenzahl (maximal 8) zurck.
+-----------------------------------------------------------------------------}

FUNCTION  Hex (Dezimal : LONGINT ; Stellenzahl : BYTE) : Str8;

 VAR    Stelle : BYTE;

 BEGIN
   IF (Stellenzahl > 8) THEN Stellenzahl := 8;
   Hex := '        ';
   Hex[0] := Chr(Stellenzahl);
   FOR Stelle := Stellenzahl DOWNTO 1 DO
    BEGIN
      Hex[Stelle] := HexChars[Dezimal AND $0F];
      Dezimal := Dezimal shr 4;
    END;
 END;


{------------------------------------------------------------------------------
| Bin  liefert den Wert eines Longints binr mit vorgebbarer
| Stellenzahl (max. 32) zurck
+-----------------------------------------------------------------------------}

FUNCTION  Bin (Dezimal : LongInt ; Stellenzahl : BYTE) : Str32;

 VAR  Stelle     : BYTE;

 BEGIN
   IF Stellenzahl > 32 THEN Stellenzahl := 32;
   Bin[0] := Chr(Stellenzahl);
   FOR Stelle := Stellenzahl DOWNTO 1 DO
    BEGIN
      IF (Dezimal AND $01) > 0
        THEN Bin[Stelle] := '1'
        ELSE Bin[Stelle] := '0';
      Dezimal := Dezimal shr 1;
    END;
 END;


{------------------------------------------------------------------------------
| Krach machen ...
+-----------------------------------------------------------------------------}

PROCEDURE Alarm_Bell;
VAR   i     : INTEGER;
BEGIN
{
  FOR i := 1 TO 6 DO BEGIN
    Beep(880,60);
    Beep(1200,60);
  END;
  Delay(30*DelayCorr);
}
  Beep(1200,400);
  Delay(30*DelayCorr);
END;


{------------------------------------------------------------------------------
| Klingel beim Connect
+-----------------------------------------------------------------------------}

PROCEDURE C_Bell;
BEGIN
  Beep(880,80);
  Beep(1200,80);
END;


{------------------------------------------------------------------------------
| Klingel beim Disconnect
+-----------------------------------------------------------------------------}

PROCEDURE D_Bell;
BEGIN
  Beep(1200,80);
  Beep(880,80);
END;


{------------------------------------------------------------------------------
| Klingel beim REConnect
+-----------------------------------------------------------------------------}

PROCEDURE REC_Bell;
BEGIN
  Beep(1200,80);
  Beep(880,80);
  Beep(1200,80);
END;


{------------------------------------------------------------------------------
| Umformung eines Strings in einen LongInt
+-----------------------------------------------------------------------------}

FUNCTION  str_int (Zeile : Str8) : LongInt;
VAR i    : INTEGER;
    Zahl : INTEGER;
BEGIN
  Val(Zeile,Zahl,i);
  IF (i <> 0) THEN Zahl := 0;
  Str_Int := Zahl;
END;


{------------------------------------------------------------------------------
|   Das SaveFile oeffnen. Wenn es nicht existiert, dann wird es neu
|   angelegt, andernfalls wird es zum APPENDen vorbereitet.
+-----------------------------------------------------------------------------}

PROCEDURE OpenRXFile;

CONST  FileNotFound    = 2;
       PathNotFound    = 3;
       InvalidDrive    = 15;

VAR    Error           : INTEGER;

BEGIN
  WITH K[Kanal]^ DO
  BEGIN
    {$I-}
    Reset(RXFile);
    {$I+}
    Error := IOResult;
    IF (Error = PathNotFound) THEN
     BEGIN
       { Pfad nicht gefunden, also neuer Versuch }
       RX_Name := SysPfad + onlyFName(RX_Name);
       Assign(RXFile,RX_Name);
       SetTextBuf(RXFile,RXFileBuffer^);
       {$I-}
       Reset(RXFile);   {$I+}
       Error := IOResult;
     END;
    IF Error <> 0 THEN
     BEGIN
       { wahrscheinlich File nicht vorhanden }
       Rewrite(RXFile);
     END
    ELSE
     BEGIN
       { File gefunden }
       IF Eof(RXFile) THEN
        BEGIN
          Close(RXFile);
          Rewrite(RXFile);
        END
      ELSE
       Append(RXFile);
    END;
  END;
END;


{------------------------------------------------------------------------------
| Ein SaveFile schlieen, leeres File lschen
+-----------------------------------------------------------------------------}

PROCEDURE CloseRXFile (Kanal : BYTE);

 VAR Datei    : File;
     Error    : INTEGER;

 BEGIN
   WITH K[Kanal]^ DO BEGIN
     Error := IOResult;
     {$I-}
     Close(RXFile);
     {$I+}
     Error := IOResult;
     Save := FALSE;
     IF (Error = 0) THEN
      BEGIN
        { weiteres Vorgehen nur, wenn kein Disk-Error aufgetreten }
        Assign(Datei,RX_Name);
        {$i-}
        Reset(Datei,1);  {$I+}
        IF (IOResult = 0) THEN
         BEGIN
           { Datei vorhanden }
           IF (FileSize(Datei) = 0) THEN
             BEGIN
               { leere Datei lschen um "Leichen" zu unterdrcken }
               Close(Datei);
               Erase(Datei);
             END
           ELSE
             Close(Datei);
         END;
      END;
   END;
 END;


{------------------------------------------------------------------------------
| liefert einen DatumString in der Form  'Mo 23.01.89'
+-----------------------------------------------------------------------------}

FUNCTION Date : Str11;

CONST Wochentag = 'SoMoDiMiDoFrSa';

VAR
  Tag,
  WoTag,
  Monat,
  Jahr          : WORD;
  TagStr,
  WotagStr,
  MonatStr,
  JahrStr       : String[2];

BEGIN { Date }

  GetDate(Jahr, Monat, Tag, WoTag);  { PROCEDURE im Unit DOS }
  str(Tag:2,TagStr);
  str(Monat:2,MonatStr);
  str(Jahr-1900,JahrStr);
  str(WoTag,WoTagStr);
  WotagStr := copy(Wochentag,Wotag*2+1,2);

  IF Tag < 10 THEN TagStr[1] := '0';
  IF Monat < 10 THEN MonatStr[1] := '0';

  Date := WotagStr + ' ' + TagStr + '.' + MonatStr + '.' + JahrStr;

END;


{------------------------------------------------------------------------------
| liefert einen ZeitString in der Form  '18:35:47'
+-----------------------------------------------------------------------------}

FUNCTION Time : Str8;

VAR
  Stunden,
  Minuten,
  Sekunden,
  Sek100        : Word;
  StundenStr,
  MinutenStr,
  SekundenStr   : String[2];

BEGIN { Time }

  GetTime(Stunden, Minuten, Sekunden, Sek100);   { PROCEDURE im Unit DOS }
  str(Stunden:2,StundenStr);
  str(Minuten:2,MinutenStr);
  str(Sekunden:2,SekundenStr);

  IF Stunden < 10 THEN Stundenstr[1] := '0';
  IF Minuten < 10 THEN MinutenStr[1] := '0';
  IF Sekunden < 10 THEN SekundenStr[1] := '0';

  Time := StundenStr + ':' + MinutenStr + ':' + SekundenStr;

END;


{----------------------------------------------------------------------------+
| Liefert Cursorgroesse      (aus PCT von DD6CV)
+----------------------------------------------------------------------------}

FUNCTION GetCursorSize;
VAR
  r :REGISTERS;
BEGIN
  r.ah:=$03;
  INTR($10,r);
  GetCursorSize:=r.cx;
END;


{----------------------------------------------------------------------------+
| Setzt Cursorgroesse        (aus PCT von DD6CV)
+----------------------------------------------------------------------------}

PROCEDURE SetCursorSize;
VAR
  r :REGISTERS;
BEGIN
  r.ah:=$01;
  r.cx:=Size;
  INTR($10,r);
END;


{----------------------------------------------------------------------------+
| Schaltet Cursor aus.       (aus PCT von DD6CV)
+----------------------------------------------------------------------------}

PROCEDURE Cursor_aus;
CONST
  CursorOffBit=8192;
BEGIN
  SetCursorSize(GetCursorSize OR CursorOffBit);
END;


{----------------------------------------------------------------------------+
| Schaltet Cursor ein.       (aus PCT von DD6CV)
+----------------------------------------------------------------------------}

PROCEDURE Cursor_ein;
CONST
  CursorOnMask=-8193;
BEGIN
  { SetCursorSize(GetCursorSize AND CursorOnMask); }
  SetCursorSize(CursorMerker);
END;


{------------------------------------------------------------------------------
| liefert die Video-Segmantadresse
+-----------------------------------------------------------------------------}

FUNCTION GetVideoSeg : WORD;

 BEGIN
   IF (LO(LASTMODE) = 7) THEN
     GetVideoSeg := $B000
   ELSE
     GetVideoSeg := $B800;
 END;


{------------------------------------------------------------------------------
| Umformung eines LongInts in einen String
+-----------------------------------------------------------------------------}

FUNCTION  int_str (i : LongInt) : Str8;
VAR b_str  : str8;
BEGIN
  str(i,b_str);
  int_str := b_str;
END;


{------------------------------------------------------------------------------
| einen Ton mit bestimmter Lnge und bestimmter Tonhhe erzeugen
+-----------------------------------------------------------------------------}

PROCEDURE beep (Ton,Laenge : INTEGER);
BEGIN
  NoSound;
  Delay(2);
  Sound(20000);        { Sorry ... ich weiss mir nicht anders zu helfen }
  Delay(2);            { manchmal will die Bimmel einfach nicht... }
  NoSound;
  Delay(2);
  Sound(Ton);
  Delay((Laenge*DelayCorr) DIV 10);
  NoSound;
END;


{------------------------------------------------------------------------------
| ein Fenster ffnen
| Neues Format
+-----------------------------------------------------------------------------}

PROCEDURE Fenster (X_Pos, Y_Pos, Breite, Hoehe : BYTE ; Kopf : Str80);

VAR i,k   : INTEGER;
    Leer  : String[80];
    Quer  : String[80];
    AMerk : BYTE;

BEGIN

  AMerk := TextAttr;
  TextAttr := FRahmenAttr;
  Quer := constStr(#205,Breite-2);
  Leer := '' + constStr(' ',Breite-2) + '';

  gotoxy(X_Pos,Y_Pos);
  WRITE(#201,Quer,#187);     { oberer Rahmen }

  FOR k := 1 TO Hoehe-2 DO
  BEGIN
    gotoxy(X_Pos,Y_Pos+k);
    WRITE(Leer);
  END;

  gotoxy(X_Pos,Y_pos+Hoehe-1);        { unterer Rahmen }
  WRITE(#200,Quer,#188);

  Quer := ' ' + Kopf + ' ';
  IF (Length(Quer) > (Breite-4)) THEN
    Quer := Copy(Quer,2,Breite-4);
  i := (Breite - Length(Quer)) DIV 2 - 1;
  GotoXY(X_Pos+i,Y_Pos);
  WRITE('');
  TextAttr := FTitelAttr;
  WRITE(Quer);
  TextAttr := FRahmenAttr;
  WRITE('');

  TextAttr := AMerk;
END;


PROCEDURE DecAttrBufferP (VAR BufferP : INTEGER);
 BEGIN
   Dec(BufferP);
   IF (BufferP < 1) THEN BufferP := AttrBufferPmax;
 END;


PROCEDURE DecChxBufferP (Kanal : Byte; VAR BufferP : INTEGER);
 BEGIN
   Dec(BufferP);
   IF (BufferP < 1) THEN BufferP := K[Kanal]^.ChxBufferPmax;
 END;


{------------------------------------------------------------------------------
| den Bildschirm des angezeigten Kanals komplett neu aufbauen
+-----------------------------------------------------------------------------}

PROCEDURE restore_Screen;

VAR   Zeile,i      : INTEGER;
      BildPos      : INTEGER;
      ABufferP     : INTEGER;
      CBufferP     : INTEGER;
      AMerk        : Word;

BEGIN
  IF (show = 0) THEN
   BEGIN
     { Monitor-Schirm restaurieren }
     WITH K[0]^ DO
      BEGIN
        ABufferP := AttrBufferP;
        CBufferP := ChxBufferP;
        BildPos := ScreenSize;
        FOR Zeile := MaxY DOWNTO (S1Pos+2) DO
         BEGIN
           FOR i := 80 DOWNTO 1 DO
            BEGIN
              VideoPage^[BildPos] := AttrBuffer^[ABufferP,i];
              Dec(BildPos);
              VideoPage^[BildPos] := ChxBuffer^[CBufferP,i];
              Dec(BildPos);
            END;
           DecAttrBufferP(ABufferP);
           DecChxBufferP(0,CBufferP);
         END;
      END;
   END     { show = 0 }

  ELSE

   BEGIN
     { QSO-Schirm restaurieren }
     BildPos := ScreenSize;
     IF (K[show]^.Trenn < MaxY) THEN WITH K[0]^ DO
      BEGIN
        { es mu mindestens eine Monitorzeile ausgegeben werden }
        ABufferP := AttrBufferP;
        CBufferP := ChxBufferP;
        FOR Zeile := MaxY DOWNTO (K[show]^.Trenn+1) DO
         BEGIN
           FOR i := 80 DOWNTO 1 DO
            BEGIN
              VideoPage^[BildPos] := AttrBuffer^[ABufferP,i];
              Dec(BildPos);
              VideoPage^[BildPos] := ChxBuffer^[CBufferP,i];
              Dec(BildPos);
            END;
           DecAttrBufferP(ABufferP);
           DecChxBufferP(0,CBufferP);
         END;
      END;

     WITH K[show]^ DO
      BEGIN
        IF (Trenn <= MaxY) THEN Dec(BildPos,2*MaxX);
        ABufferP := AttrBufferP;
        CBufferP := ChxBufferP;
        FOR Zeile := (Trenn-1) DOWNTO (S1Pos+1) DO
         BEGIN
           FOR i := 80 DOWNTO 1 DO
            BEGIN
              VideoPage^[BildPos] := AttrBuffer^[ABufferP,i];
              Dec(BildPos);
              VideoPage^[BildPos] := ChxBuffer^[CBufferP,i];
              Dec(BildPos);
            END;
           DecAttrBufferP(ABufferP);
           DecChxBufferP(0,CBufferP);
         END;
      END;
   END;
  Status1(show);
  Status2;
  restoreEditLines;
{  SetEditCursor;   }
  EditCursorToggle := FALSE;
  Neu_Bild_if_keypressed := false;

  SetBorderColor(1);

END;


{------------------------------------------------------------------------------
| FehlerText  liefert zu einer Fehlernummer die Fehlerbeschreibung
| Stand ist TurboPascal Version 7.0 !
+-----------------------------------------------------------------------------}

FUNCTION FehlerText (FehlerCode : BYTE) : Str80;

 BEGIN
   CASE FehlerCode OF
      0 : FehlerText := '';
      2 : FehlerText := 'File not found';
      3 : FehlerText := 'Path not found (check CONFIG.PR)';
      4 : FehlerText := 'Too many open files (check CONFIG.SYS)';
      5 : FehlerText := 'File access denied';
      6 : FehlerText := 'Invalid file handle';
     12 : FehlerText := 'Invalid file access mode';
     15 : FehlerText := 'Invalid drive number';
     16 : FehlerText := 'Cannot remove current directory';
     17 : FehlerText := 'Cannot rename across drives';
     18 : FehlerText := 'File not found (sri, nicht eindeutig)';
    100 : FehlerText := 'Disk read error';
    101 : FehlerText := 'Disk write error';
    102 : FehlerText := 'File not assigned';
    103 : FehlerText := 'File not open';
    104 : FehlerText := 'File not open for input';
    105 : FehlerText := 'File not open for output';
    106 : FehlerText := 'Invalid numeric format';
    150 : FehlerText := 'Disk is write protected';
    151 : FehlerText := 'Unknown unit';
    152 : FehlerText := 'Drive not ready';
    153 : FehlerText := 'Unknown command';
    154 : FehlerText := 'CRC error in data';
    155 : FehlerText := 'Bad drive request structure length';
    156 : FehlerText := 'Disk seek error';
    157 : FehlerText := 'Unknown media type';
    158 : FehlerText := 'Sector not found';
    159 : FehlerText := 'Printer out of paper';
    160 : FehlerText := 'Device write fault';
    161 : FehlerText := 'Device read fault';
    162 : FehlerText := 'Hardware failure';
    200 : FehlerText := 'Division by zero';
    201 : FehlerText := 'Range check error';
    202 : FehlerText := 'Stack overflow error';
    203 : FehlerText := 'Heap overflow error';
    204 : FehlerText := 'Invalid pointer operation';
    205 : FehlerText := 'Floating point overflow';
    206 : FehlerText := 'Floating point underflow';
    207 : FehlerText := 'Invalid floating point operation';
    208 : FehlerText := 'Overlay manager not installed';
    209 : FehlerText := 'Overlay file read error';
    210 : FehlerText := 'Object not initialized';
    211 : FehlerText := 'Call to abstract method';
    212 : FehlerText := 'Stream registration error';
    213 : FehlerText := 'Collection index out of range';
    214 : FehlerText := 'Collection overflow error';
    215 : FehlerText := 'Arithmetic overflow error';
    ELSE  FehlerText := '??? (' + Int_Str(FehlerCode) +
                        ') No error discription found';
   END;

 END;


{------------------------------------------------------------------------------
| Programm-Exit-Prozedur
+-----------------------------------------------------------------------------}

{$F+}
PROCEDURE  NewExit;  {$F-}

 VAR   i     : INTEGER;

 BEGIN
   IF (ExitCode <> 0) THEN BEGIN
     NormVideo;
     FOR i := (maxY-4) TO maxY DO BEGIN
       GotoXY(1,i);
       ClrEOL;
     END;
     GotoXY(1,maxY-3);
     TextAttr := neg_high;
     WRITE(' Runtime error ',ExitCode,' at ',Pointer_Str(ErrorAddr),
           '  (',FehlerText(ExitCode),') ');
     NormVideo;
     Cursor_ein;
     WRITELN;
     ErrorAddr := NIL;
     NoSound;
     FOR i := 1 TO 5 DO BEGIN
       Sound(300);
       Delay(7*DelayCorr);
       NoSound;
       Delay(7*DelayCorr);
     END;
   END;
   ExitProc := ExitSave;
 END;


{------------------------------------------------------------------------------
| liefert den Wert eines Pointers in der Form 'Seg:Ofs' als String der Lnge 9
+-----------------------------------------------------------------------------}

FUNCTION Pointer_Str (Zeiger : Pointer) : Str9;

 TYPE DoubleWord   = ARRAY [1..2] OF WORD;

 VAR  Abs_Zeiger   : ^DoubleWord;

 BEGIN
   Abs_Zeiger := @Zeiger;   { Abs_Zeiger enthlt die Adresse von Zeiger }
   IF (Zeiger = NIL)
     THEN
       Pointer_Str := 'NIL      '
     ELSE
       Pointer_Str := Hex(Abs_Zeiger^[2],4) + ':' + Hex(Abs_Zeiger^[1],4);
 END;


{------------------------------------------------------------------------------
| WaitKey wartet auf einen Tastendruck.
| Whrend des Wartens kann (Uhrzeit) oder (Datum + Uhrzeit) oder auch
| garnichts angezeigt werden (Art = 1,2 oder 0).
+-----------------------------------------------------------------------------}

PROCEDURE WaitKey (Art : BYTE);

 VAR X,Y     : BYTE;
     ch      : CHAR;
     AMerk   : BYTE;
     Time1   : String[8];
     Sek1    : CHAR;

 BEGIN

   Cursor_ein;
   AMerk := TextAttr;
   TextAttr := neg;
   X := WhereX;
   Y := WhereY;
   Sek1 := 'X';

   REPEAT
     Time1 := Time;
     Cursor_aus;

     CASE Art OF
       0 : BEGIN
             { garnichts ausgeben }
           END;
       1 : BEGIN
             { Nur die Uhrzeit auf der Statuszeile ausgeben }
             IF (Sek1 <> Time1[8]) THEN
              BEGIN
                GotoXY(MaxX-9,1);
                WRITE(Time1);
              END;
           END;
       2 : BEGIN
             { Datum UND Uhrzeit auf Statuszeile ausgeben }
             IF (Sek1 <> Time1[8]) THEN
              BEGIN
                GotoXY(MaxX-21,1);
                WRITE(Date,'  ',Time);
              END;
           END;
     END;

     IF (Sek1 <> Time1[8]) THEN Sek1 := Time1[8];
     GotoXY(X,Y);
     Cursor_ein;
   UNTIL Keypressed OR M_anyButton;

   REPEAT UNTIL M_NoButton;

   IF Keypressed THEN
     BEGIN
       ch := Readkey;
       IF (ch = #0) THEN
         ch := Readkey;
     END;

   TextAttr := AMerk;
   Cursor_aus;

 END;


{------------------------------------------------------------------------------
| Kbd_Status liefert den Status der Sondertasten
+------------------------------------------------------------------------------
| Bit 0 = 1 : Rechte Shift-Taste gedrckt
| Bit 1 = 1 : Linke Shift-Taste gedrckt
| Bit 2 = 1 : Crtl-Taste gedrckt
| Bit 3 = 1 : Alt-Taste gedrckt
| Bit 4 = 1 : [Scroll Lock] gedrckt
| Bit 5 = 1 : [Num Lock] gedrckt
| Bit 6 = 1 : [Caps Lock] gedrckt
| Bit 7 = 1 : [Ins] gedrckt
+-----------------------------------------------------------------------------}

FUNCTION Kbd_Status : BYTE;

 VAR r  : REGISTERS;

 BEGIN
   r.ah:=$02;
   INTR($16,r);
   Kbd_Status := r.al;
 END;


{------------------------------------------------------------------------------
| onlyFName liefert zu einem kompletten Pfad nur den Dateinamen
+-----------------------------------------------------------------------------}

FUNCTION  onlyFName (Pfad : PathStr) : Str12;

 VAR    DStr   : DirStr;
        NStr   : NameStr;
        EStr   : ExtStr;

 BEGIN
   Pfad := FExpand(Pfad);
   FSplit(Pfad,DStr,NStr,EStr);
   onlyFName := NStr + EStr;
 END;


{------------------------------------------------------------------------------
| onlyDName liefert zu einem kompletten Pfad nur den Directory-Namen
+-----------------------------------------------------------------------------}

FUNCTION  onlyDName (Pfad : PathStr) : DirStr;

 VAR    DStr   : DirStr;
        NStr   : NameStr;
        EStr   : ExtStr;

 BEGIN
   Pfad := FExpand(Pfad);
   FSplit(Pfad,DStr,NStr,EStr);
   onlyDName := DStr;
 END;


FUNCTION  packedFTime (VAR Datei) : LongInt;

 VAR    TimeInt    : LongInt;

 BEGIN
   GetFTime(Datei,TimeInt);
   packedFTime := TimeInt;
 END;


{------------------------------------------------------------------------------
| Tastaturinterrupthandling von DL5FBD
+-----------------------------------------------------------------------------}

PROCEDURE KBDlock;                    { Tastaturinterrupt sperren }
 BEGIN
   IF handleKbdIrq THEN
     Port[$21] := Port[$21] OR 2;     { 8259 IRQ1 sperren }
 END;


PROCEDURE KBDfree;                    { Tastaturinterrupt freigeben }
 BEGIN
   IF handleKbdIrq THEN
     Port[$21] := Port[$21] AND 253;  { 8259 IRQ1 freigeben }
 END;


FUNCTION IO_ok : BOOLEAN;

 BEGIN
   IO_ok := (IOResult = 0);
 END;


{-----------------------------------------------------------------------------
|  Aufbau des kompletten Dateinamens fr File-Senden und File-Empfang
|  Formatierung auf 21 Zeichen
+----------------------------------------------------------------------------}

FUNCTION RxTxStr (Kanal : Byte) : Str25;

 CONST  Meg1      = 1048576;      { 1 Megabyte }

 VAR    subStr    : Str25;
        subStr1   : Str3;
        dummy     : LongInt;      { Zwischenwert }

 BEGIN

   subStr := '';

   WITH K[Kanal]^ DO BEGIN

     IF Save THEN subStr := 'E';
     IF FileSend THEN subStr := 'S';
     IF (Save AND FileSend) THEN subStr := 'ES';

     IF Save AND NOT FileSend THEN
      BEGIN
        { RX-Namen darstellen }
        subStr := subStr + #16 + onlyFName(RX_Name) + ' ';
        CASE RX_Mode OF
         0,1 : BEGIN
                 { Text- oder Binr-Empfang }
                 IF (RX_Count >= 1024000) THEN
                  BEGIN
                    { Megabyte-Angabe in der Form "1M234" }
                    dummy := RX_Count DIV Meg1;
                    subStr := subStr + int_Str(dummy) + 'M';
                    dummy := ((RX_Count MOD Meg1) * 1000) DIV Meg1;
                    subStr1 := int_Str(dummy);
                    IF dummy < 100 THEN
                      subStr1 := '0' + subStr1;
                    IF dummy < 10 THEN
                      subStr1 := '0' + subStr1;
                    subStr := subStr + subStr1;
                  END
                 ELSE
                  IF (RX_Count >= 100000) THEN
                   BEGIN
                     { Kilobyte-Angabe in der Form "123K4" }
                     dummy := RX_Count DIV 1024;
                     subStr := subStr + int_Str(dummy) + 'K';
                     dummy := ((RX_Count MOD 1024) * 10) DIV 1024;
                     subStr := subStr + int_Str(dummy);
                   END
                  ELSE
                   BEGIN
                     { Byte-Angabe in der Form "12345" }
                     subStr := subStr + int_Str(RX_Count);
                   END;
               END;
         2   : ;
         3   : BEGIN
                 { Auto-Binr-Empfang }
                 subStr := subStr +
                           int_Str(Trunc(RX_Count/RX_Laenge*100)) + '%';
               END;
        END;
      END;

     IF FileSend THEN
      BEGIN
        subStr := subStr + #16 + onlyFName(TX_Name) + ' ';
        subStr := subStr + int_Str(Trunc(TX_Count/TX_Laenge*100)) + '%';
      END;

   END;

   RxTxStr := subStr + Space(21-Length(subStr));
 END;


{-----------------------------------------------------------------------------
| Umwandeln einer Zeitangabe (in Minuten) in Tage:Stunden:Minuten
+----------------------------------------------------------------------------}


FUNCTION  LZStr(Zeit : LongInt) : Str10;

 VAR  Tage        : Integer;
      Stunden     : INTEGER;
      Minuten     : INTEGER;
      TageStr     : Str3;
      StundenStr  : Str2;
      MinutenStr  : Str2;
      subStr      : Str10;

 BEGIN
   Tage := Zeit DIV 1440;
   Zeit := Zeit - LongInt(Tage)*1440;
   Stunden := Zeit DIV 60;
   Minuten := Zeit - Stunden*60;
   Str(Tage:3,TageStr);
   Str(Stunden:2,StundenStr);
   Str(Minuten:2,MinutenStr);
   IF TageStr[1] = ' ' THEN TageStr[1] := '0';
   IF TageStr[2] = ' ' THEN TageStr[2] := '0';
   IF StundenStr[1] = ' ' THEN StundenStr[1] := '0';
   IF MinutenStr[1] = ' ' THEN MinutenStr[1] := '0';
   LZStr := TageStr + '/' + StundenStr + ':' + MinutenStr;
 END;


{-----------------------------------------------------------------------------
|  Prfsumme von PR.EXE berechnen und ausgeben
+----------------------------------------------------------------------------}

FUNCTION GetCheckSum (DatName : String; silent : BOOLEAN) : Word;

 VAR  Datei      : FILE;
      Buffer     : ARRAY [1..2048] OF Byte;
      Laenge     : LongInt;
      Counter    : LongInt;
      Checksum   : Word;
      i          : INTEGER;
      Result     : Word;
      xPos       : Byte;

 BEGIN

   Assign(Datei,DatName);
   Reset(Datei,1);
   Laenge := FileSize(Datei);

   IF NOT silent THEN
    BEGIN
      ClrScr;
      WRITELN;
      WRITELN(V1_Str,'   CRC-Prfsummenberechnung');
      WRITELN;
      WRITE('Checking ',DatName,'   ');
      xPos := WhereX;
      WRITE('       von ',Laenge,' Bytes gelesen.');
    END;

   Counter := 0;
   Checksum := 0;
   REPEAT
     Counter := Counter + 2048;
     BlockRead(Datei,Buffer,2048,Result);
     IF NOT silent THEN
      BEGIN
        GotoXY(xPos,WhereY);
        WRITE((Counter-2048+Result):6);
      END;
     FOR i := 1 TO Result DO
       Checksum := CRC(Buffer[i],Checksum);
   UNTIL (Counter >= Laenge);

   Close(Datei);

   IF NOT silent THEN
    BEGIN
      WRITELN;
      WRITELN;
      WRITELN('CRC-Checksum = ',Checksum,' ($',Hex(Checksum,4),')');
    END;

   GetChecksum := Checksum;

 END;


PROCEDURE ParameterHelp;

 BEGIN
   ClrScr;
   WRITELN;
   WRITELN(V1_Str);
   WRITELN;
   WRITELN('Mgliche Parameter beim Programmstart:');
   WRITELN;
   WRITELN(' -?     Ausgabe dieses Textes');
   WRITELN;
   WRITELN(' -LCD   Wahl des Video-Attributsatzes Nr.4 (LCD-Attribute)');
   WRITELN('        aus der Datei ATTRIB.PR');
   WRITELN;
   WRITELN(' -Cxx   Anstatt CONFIG.PR wird die Datei CONFIGxx.PR einge-');
   WRITELN('        lesen, wobei ''xx'' zwei beliebige Zeichen sind');
   WRITELN;
   WRITELN(' -V     CRC-Prfsummenberechnung fr die Datei PR.EXE');
   WRITELN;
   WRITELN(' -R     Wiederherstellen des Bildschirms bei Programmende');
   WRITELN;
 END;


{-----------------------------------------------------------------------------
|  ein Call von SSID und Ident befreien
|
|  Neu: Suche nach ":" und "-" vertauscht, um auch Idents wie "MS70-0" zu
|       verarbeiten.
+----------------------------------------------------------------------------}

FUNCTION onlyCall(Call : Str20) : Str9;

 VAR   i     : INTEGER;

 BEGIN
   i := Pos(':',Call);
   IF (i > 0) THEN Delete(Call,1,i);
   i := Pos('-',Call);
   IF (i > 0) THEN Call := Copy(Call,1,pred(i));
   onlyCall := cutStr(Call);
 END;


{-----------------------------------------------------------------------------
|  nur den Ident eines Calls zurckliefern  (Call = 'IIIIII:CCCCCC-SS')
+----------------------------------------------------------------------------}

FUNCTION onlyIdent(Call : Str20) : Str9;

 VAR   i,m     : INTEGER;

 BEGIN
   i := Pos(':',Call);
   IF (i=0) THEN
    onlyIdent := ''
   ELSE
    BEGIN
      m := i;
      REPEAT
        Dec(m);
      UNTIL (m = 0) OR (Call[m] = ' ') OR (Call[m] = #13);
      Inc(m);
      onlyIdent := Copy(Call,m,i-m);
    END;
 END;


{-----------------------------------------------------------------------------
|  feststellen, ob die Datei DatName vorhanden ist
+----------------------------------------------------------------------------}

FUNCTION File_exists (DatName : Str80) : BOOLEAN;

 VAR   Datei      : File;

 BEGIN
   Assign(Datei,DatName);
   {$I-}
   Reset(Datei,1);   {$I+}
   IF (IOResult = 0) THEN
    BEGIN
      IF Filesize(Datei) > 0 THEN
        File_exists := TRUE
      ELSE
        File_exists := FALSE;
      Close(Datei);
    END
   ELSE
    File_exists := FALSE;
 END;



{-----------------------------------------------------------------------------
|  Standard-Filename
+----------------------------------------------------------------------------}

FUNCTION  StdFilename(Kanal : Byte) : Str80;
 BEGIN
   StdFileName := TextPfad+'C'+Int_Str(Kanal)+'.TXT';
 END;


{------------------------------------------------------------------------------
| Test auf existierenden Pfad
+-----------------------------------------------------------------------------}

FUNCTION Path_Exists (Suchbegriff : PathStr) : BOOLEAN;

VAR
      Pfad        : PathStr;
      SRec        : SearchRec;         { Im Unit DOS definiert }

BEGIN

  Pfad := Suchbegriff + '*.*';
  FindFirst(Pfad,AnyFile,SRec);     { Prozedur im Unit DOS }
  Path_Exists := (DosError = 0);

END;


{-----------------------------------------------------------------------------
|  Test fr OS/2-Idles...
+----------------------------------------------------------------------------}

PROCEDURE OS2_Idle(CountDown : INTEGER);

 VAR    i         : INTEGER;

 BEGIN
   i := CountDown;
   REPEAT
     Dec(i);
     Dec_Timer;                 { manchmal die Timer bearbeiten... }
   UNTIL KeyPressed OR (i <= 0);
 END;


BEGIN

  {----------------------------------------------------------------------------
  |
  +---------------------------------------------------------------------------}

END.
