
{------------------------------------------------------------------------------
|
|   P R L I B 1 . P A S
|
|   Packet-Library-Routinen
|   Hauptschlich Lesen/Schreiben von Systemdateien
|
|   DL1BHO  05/1992
|
+-----------------------------------------------------------------------------}


UNIT PRLIB1;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


PROCEDURE StartMaske;
PROCEDURE Catalog(upcase_Zeile : String);
PROCEDURE do_LOGcommand;
PROCEDURE do_HELPcommand (Zeile : String);
PROCEDURE output_Errortext (Zeile : String);


PROCEDURE Load_ConfigFile;
PROCEDURE Load_Statusfile;
PROCEDURE Load_AttributFile;
PROCEDURE Load_MsgFile;
PROCEDURE Load_QRGFile;

PROCEDURE Save_Statusfile;


IMPLEMENTATION


USES
      Dos,
      Crt,
      PRDEFS,
      PRLIB,
      PRLib2,
      PRLIB4,
      PRScreen,
{$IFDEF OS2}
      PRV24OS2,
{$ELSE}
      PRV24,
{$ENDIF}
      PRMouse;


{------------------------------------------------------------------------------
| Ausgabe der Bildschirmmaske beim Start
+-----------------------------------------------------------------------------}

PROCEDURE StartMaske;

 VAR  Y0    : Byte;

 PROCEDURE Maske_T (x_Pos,y_Pos : INTEGER);
  VAR y  : INTEGER;
  BEGIN
    y := y_Pos;
    GotoXY(x_Pos,y);
    WRITE('Ŀ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('Ŀ  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos+8,y);
    WRITE('');
  END;

 PROCEDURE Maske_P (x_Pos,y_Pos : INTEGER);
  VAR y  : INTEGER;
  BEGIN
    y := y_Pos;
    GotoXY(x_Pos,y);
    WRITE('Ŀ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  Ŀ  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('           ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('    ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('  ');
    Inc(y); GotoXY(x_Pos,y);
    WRITE('');
  END;

BEGIN
  Y0 := (MaxY-17) DIV 2;
  HighVideo;
  ClrScr;
  Maske_T(9,Y0);
  GotoXY(32,Y0);
  WRITE('',ConstStr('',48));
  GotoXY(1,Y0+11);
  WRITE(ConstStr('',16),'');
  Maske_P(49,Y0+2);
  GotoXY(1,Y0+13);
  WRITE(ConstStr('',48),'');
  GotoXY(67,Y0+2);
  WRITE('',ConstStr('',13));
  GotoXY(28,Y0+10);
  WRITE('U R B O');
  GotoXY(60,Y0+12);
  WRITE('A C K E T');
  NormVideo;
  GotoXY(7,Y0+18);
  WRITELN('Version ',Version,'      IBM-PC XT/AT + TNC-1/TNC-2 mit Hostmode-Software');
  GotoXY(1,maxY-1);
  WRITE(ConstStr('',80));
END;


{-----------------------------------------------------------------------------
|  einen Fehlertext fr etwa 3 Sekunden anzeigen
+----------------------------------------------------------------------------}

PROCEDURE output_Errortext (Zeile : String);

 VAR  XPos, YPos    : Byte;
      AStore        : Byte;

 BEGIN
   AStore := TextAttr;
   XPos := WhereX;
   YPos := WhereY;
   GotoXY(1,maxY-2);
   ClrEol;
   NormVideo;
   WRITE(Zeile,Bell);
   SysDelay(Sec3);
   TextAttr := AStore;
   GotoXY(XPos,YPos);
 END;


{------------------------------------------------------------------------------
| Einlesen der Datei CONFIG.PR
| Achtung, neues Format !!       (02/1991)
+-----------------------------------------------------------------------------}

PROCEDURE Load_ConfigFile;

 VAR  ConfigFile    : Text;
      ConfigName    : String;
      Zeile         : String;
      ZeilenCount   : Word;
      i,j,i1,i2     : INTEGER;
      m             : LongInt;
      Error         : INTEGER;
      subStr        : String;
      subStr1       : String;


 {----------------------------------------------------------------------------
 | durch Kommas getrennte Parameter auswerten
 +---------------------------------------------------------------------------}

 FUNCTION KommaParam (Zeile : String; Nummer : Byte) : String;

  VAR   i        : INTEGER;
        KPos     : INTEGER;
        ok       : BOOLEAN;

  BEGIN
    ok := TRUE;
    KPos := 0;
    FOR i := 2 TO Nummer DO
     BEGIN
       KPos := Pos(',',Zeile);
       IF (KPos > 0) THEN
         BEGIN
           Zeile[KPos] := '|';
         END
       ELSE
         ok := FALSE;
     END;
    IF ok THEN
      BEGIN
        Delete(Zeile,1,KPos);
        KPos := Pos(',',Zeile);
        IF (KPos > 0) THEN Zeile := Copy(Zeile,1,KPos-1);
        KommaParam := cutStr(Zeile);
      END
    ELSE
      KommaParam := '';
  END;


 {-----------------------------------------------------------------------------
 | Umformen der Druckerparameter
 +----------------------------------------------------------------------------}

 FUNCTION Printer_Par (Zeile : Str80) : Str10;

 VAR   i         : BYTE;
       subStr    : Str80;
       subStr1   : Str10;
       d, Fehler : INTEGER;

 BEGIN

   subStr := '';
   FOR i := 1 TO 10 DO
    BEGIN
      subStr1 := KommaParam(Zeile,i);
      IF Length(subStr1) > 0 THEN
       BEGIN
         Val(subStr1,d,Fehler);
         IF (Fehler = 0) THEN
           subStr := subStr + Chr(d)
         ELSE
           BEGIN
             output_Errortext('Falscher Aufbau der Druckerparameter in CONFIG.PR !');
             Halt(0);
           END;
       END;
    END;
   Printer_Par := subStr;
 END;


 PROCEDURE Config_Error;
 BEGIN
   output_Errortext('Fehler im File CONFIG.PR (Zeile '+ int_Str(ZeilenCount)
                       + ') !');
   Halt(0);
 END;


BEGIN                         { Load_ConfigFile }

  i := Pos('-C',CmdLinePar);
  IF (i > 0) THEN
   BEGIN
     Zeile := Copy(CmdLinePar,i+2,20);
     i := Pos('-',Zeile);
     IF (i > 0) THEN Zeile := Copy(Zeile,1,i-1);
     ConfigName := SysPfad + 'CONFIG' + Zeile + '.PR';
   END
  ELSE
   ConfigName := SysPfad + 'CONFIG.PR';

  Assign(ConfigFile,ConfigName);

  WRITE(onlyFName(ConfigName),'  ');
  clreol;
  {$I-}
  Reset(ConfigFile);
  {$I+}
  IF IOResult <> 0 THEN File_not_found;
  ZeilenCount := 0;
  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  IF (Zeile[1] <> '<') THEN Config_Error;
  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  AttrSet := Zeile[1];

  {----------------------------------------------------------------------------
  | fr die Einbindung von vom Standard abweichenden V24-Adaptern
  | Angaben im Config-File HABEN IMMER VORRANG !
  | Neu: Auch AT-Interrupts (8 bis 15) werden zugelassen.
  +---------------------------------------------------------------------------}
  FOR i := 1 TO 4 DO
   BEGIN
     READLN(ConfigFile,Zeile);
     Inc(ZeilenCount);
     Zeile := CutStr(Zeile);

     { Basisadresse }
     VAL(KommaParam(Zeile,1),m,Error);
     IF (Error <> 0) THEN m := 0;          { Standard verwenden }
     IF (m <> 0) THEN Com[i].Base := m;

     { Interrupt-Nummer }
     VAL(KommaParam(Zeile,2),m,Error);
     IF ((i <= 2) AND NOT (m IN [0,2..5,7])) OR
        ((i >= 3) AND NOT (m IN [0,2..5,7,8..15])) THEN
      BEGIN
        output_Errortext('Falsche Interrupt-Nummer fr COM' + Int_Str(i) + ': !');
        Halt(0);
      END;
     IF (Error > 0) THEN m := 0;        { Standard verwenden }
{$IFNDEF OS2}
     IF (m > 0) THEN
       IF (m <= 7) THEN
         Com[i].IntNummer := m + 8      { XT-Interrupt }
       ELSE
         Com[i].IntNummer := m + $68;   { AT-Interrupt }
{$ENDIF}
     { Baudrate }
     VAL(KommaParam(Zeile,3),m,Error);
     IF (m < 300) OR (m > 115200) OR (Error > 0) THEN
      BEGIN
        output_Errortext('Falsche Baudrate fr COM' + Int_Str(i) + ': !');
        Halt(0);
      END;
     Com[i].BaudRate := m;
   END;

  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  TextPfad := UpcaseStr(CutStr(Zeile));
  IF (TextPfad = '') THEN TextPfad := SysPfad;
  IF (TextPfad[Length(TextPfad)] <> '\') THEN TextPfad := TextPfad + '\';

  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  Zeile := UpcaseStr(CutStr(Zeile));
  IF (Zeile <> '') THEN
    IF (Zeile[Length(Zeile)] <> '\') THEN Zeile := Zeile + '\';
  ScrollBufferSavePfad := Zeile;

  subStr := SysPfad + ';' + GetEnv('PATH');    { Suchpfade }

  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  ListPgm := UpcaseStr(CutStr(Zeile));
  IF (ListPgm = '') THEN ListPgm := 'LIST.COM';
  ListPgm := FSearch(ListPgm,subStr);

  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  EditPgm := UpcaseStr(CutStr(Zeile));
  IF (EditPgm = '') THEN EditPgm := 'EDITOR.EXE';
  EditPgm := FSearch(EditPgm,subStr);

  { Bildschirm-Schoner-Init }
  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  Zeile := CutStr(Zeile);
  Val(Zeile,ScreenInit,i);
  ScreenTimer := ScreenInit;

  { Tastatur-Sperrung Ja/Nein }
  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  Zeile := UpcaseStr(Zeile);
  handleKbdIrq := (Zeile[1] = 'J') OR (Zeile[1] = 'Y') OR (Zeile[1] = '1');

  { Maus-Untersttzung Ja/Nein }
  READLN(ConfigFile,Zeile);
  Inc(ZeilenCount);
  Zeile := UpcaseStr(Zeile);
  IF M_ok THEN
    M_ok := (Zeile[1] = 'J') OR (Zeile[1] = 'Y') OR (Zeile[1] = '1');
  IF NOT M_ok AND
    ((Zeile[1] = 'J') OR (Zeile[1] = 'Y') OR (Zeile[1] = '1')) THEN
    output_ErrorText('Kein Maustreiber gefunden, aber im CONFIG.PR Maus gefordert!');

  READLN(ConfigFile,Zeile);            { "<<<" berlesen }
  Inc(ZeilenCount);
  IF (Zeile[1] <> '<') THEN Config_Error;


  FOR i := 1 TO 4 DO                   { TNC-Konfiguration auswerten }
   BEGIN
     TNC[i].used := FALSE;
     TNC[i].Channels := 0;
     READLN(ConfigFile,Zeile);
     Inc(ZeilenCount);
     Zeile := cutStr(Zeile);
     Val(KommaParam(Zeile,1),m,Error);
     IF (Error > 0) THEN Config_Error;
     IF (m > 0) AND (Kanal_Anzahl < maxLink) THEN
      BEGIN
        { hier sollen ein paar Kanle spendiert werden }
        Val(KommaParam(Zeile,2),j,Error);
        IF (Error > 0) THEN Config_Error;
        IF (j < 10) THEN j := 10*j + 1;
        i1 := j DIV 10;    { COM-Nummer }
        i2 := j MOD 10;    { Port-Nummer }
        IF (i1 < 1) OR (i1 > 5) OR (i2 < 1) OR (i2 > 4) THEN Config_Error;
        WITH TNC[i] DO BEGIN
          RS232 := i1;
          RS232_Switch := i2;
          Ident := KommaParam(Zeile,3);
          Channels := m;
          ChannelOffset := Kanal_Anzahl;
          used := TRUE;
        END;
        i1 := Kanal_Anzahl + 1;
        Kanal_Anzahl := Kanal_Anzahl + m;
        IF (Kanal_Anzahl > maxLink) THEN Kanal_Anzahl := maxLink;
        FOR j := i1 TO Kanal_Anzahl DO WITH K[j]^ DO BEGIN
          poll := TRUE;
          TNCNummer := i;
          TNCKanal := Chr(j+1-i1);
        END;
      END;
   END;

  READLN(ConfigFile,Zeile);            { "<<<" berlesen }
  Inc(ZeilenCount);
  IF (Zeile[1] <> '<') THEN Config_Error;

  FOR i := 1 TO 10 DO BEGIN            { Druckerparameter einlesen }
    READLN(ConfigFile,Zeile);
    Inc(ZeilenCount);
    Zeile := cutStr(Zeile);
    Printer1[i] := Printer_Par(Zeile);
  END;

  READLN(ConfigFile,Zeile);            { "<<<" berlesen }
  Inc(ZeilenCount);
  IF (Zeile[1] <> '<') THEN Config_Error;
  READLN(ConfigFile,Zeile);            { "<<<" berlesen }
  Inc(ZeilenCount);
  IF (Zeile[1] <> '<') THEN Config_Error;

  FOR i := 1 TO 10 DO
   BEGIN
     j := 0;
     subStr := '';
     subStr1 := '';
     READLN(ConfigFile,Zeile);
     Inc(ZeilenCount);
     IF (Copy(Zeile,1,1) = '#') THEN BEGIN
       { Handle einlesen }
       Delete(Zeile,1,1);
       subStr1 := upcaseStr(Zeile);
       READLN(ConfigFile,Zeile);
       Inc(ZeilenCount);
     END;
     WHILE (Zeile[1] <> '<') DO BEGIN
       Inc(j);
       subStr := subStr + Chr(j) + Zeile;
       READLN(ConfigFile,Zeile);
       Inc(ZeilenCount);
     END;
     subStr := subStr + Chr(j+1);
     GetMem(AutoCMD[i],Word(Length(subStr)) + 13);
     WITH AutoCMD[i]^ DO BEGIN
       Handle := subStr1;
       Anzahl := j;
       CMD_Line := subStr;
     END;
   END;

  READLN(ConfigFile,AlarmCalls);
  Inc(ZeilenCount);
  AlarmCalls := UpcaseStr(AlarmCalls);
  i := pos(';',AlarmCalls);
  IF i <> 0 THEN DELETE(AlarmCalls,i,255);
  AlarmCalls := AlarmCalls + ' ';                                    {26.2.90}
  IF (AlarmCalls[1] <> '+') AND (AlarmCalls[1] <> '-')
    THEN AlarmCalls := '+ ' + AlarmCalls;
  Close(ConfigFile);

END;


{------------------------------------------------------------------------------
| Hilfedatei mit dem List-Programm anzeigen
+-----------------------------------------------------------------------------}

PROCEDURE do_HelpCommand(Zeile : String);

BEGIN
  do_DOScommand('DOS '+ListPgm+' '+SysPfad+'HELP.PR /8',FALSE,TRUE,FALSE,BSave);
END;


{------------------------------------------------------------------------------
| Einlesen der Datei STATUS.PR
+-----------------------------------------------------------------------------}

PROCEDURE Load_Statusfile;

VAR   Statusfile       : Text;
      StatusfileName   : Str80;
      Zeile            : String;
      PacLenStr        : STRING[10];
      i,i1,i2          : INTEGER;
      Kanal            : INTEGER;

BEGIN
  StatusfileName := SysPfad + 'STAT' + StatusZusatz + '.PR';
  Assign(Statusfile,StatusfileName);
  WRITE('STATUS.PR  ');
  {$I-}
  Reset(StatusFile);
  {$I+}
  IF (IOResult = 0) THEN

   BEGIN
     { Statusdatei vorhanden, also lesen und auswerten }

     StatusFileOK := TRUE;
     READLN(StatusFile,Zeile);  { Ueberschrift ueberlesen }
     READLN(StatusFile,Zeile);

     FOR Kanal := 1 TO maxLink DO WITH K[Kanal]^ DO
     BEGIN

       READLN(StatusFile,Zeile);          { 1 }
       IF Pos('dis',Zeile) = 0 THEN
        BEGIN
          { Kanal ist connected }
          Call := Zeile;
          READLN(StatusFile,Zeile);       { 2 }
          qsoDatum := Zeile;
          READLN(StatusFile,Zeile);       { 3 }
          qsoBEGINn := Zeile;
          READLN(StatusFile,Zeile);       { 4 }
          ConText := Zeile;
          connected := TRUE;
        END
       ELSE
        BEGIN
          { Kanal ist disconneced }
          FOR i := 1 TO 3 DO READLN(StatusFile,Zeile); { 2-4 }
        END;
       READLN(StatusFile,K[Kanal]^.TNCCall); { 5 }

       READLN(StatusFile,Zeile);             { 6 }
       PacLenStr := CutStr(Zeile);
       VAL(PacLenStr,PacLen,i);
       IF i <> 0 THEN PacLen := 128;

       READLN(StatusFile,Zeile);             { 7 }
       Umlaut := 0;
       IF (Pos('U7',Zeile) > 0) THEN Umlaut := 1;
       IF (Pos('U8',Zeile) > 0) THEN Umlaut := 2;
       CW := (Pos('C',Zeile) <> 0);
       localEcho := (Pos('E',Zeile) <> 0);
       notice := (pos('N',Zeile) <> 0);
       Save := (pos('S',Zeile) <> 0);
       Remote := 0;
       IF (Pos('R1',Zeile) > 0) THEN Remote := 1;
       IF (Pos('R2',Zeile) > 0) THEN Remote := 2;

       READLN(StatusFile,Zeile);             { 8 }
       READLN(StatusFile);                   { 9 }
       IF Save THEN
        BEGIN
          RX_Name := Zeile;
          IF (RX_Name = '') THEN
            RX_Name := StdFilename(Kanal);
        END
       ELSE
        RX_Name := StdFilename(Kanal);

     END; { WITH K... }

     READLN(StatusFile); { (0) ueberlesen }
     WITH K[0]^ DO
     BEGIN
       READLN(StatusFile,Zeile);
       PacLenStr := CutStr(Zeile);
       VAL(PacLenStr,PacLen,i);
       IF (i <> 0) THEN PacLen := 128;
       READLN(StatusFile,Zeile);
       Umlaut := 0;
       IF (Pos('U7',Zeile) > 0) THEN Umlaut := 1;
       IF (Pos('U8',Zeile) > 0) THEN Umlaut := 2;
       Time_Stamp := (pos('T',Zeile) <> 0);
       Klingel := (pos('K',Zeile) <> 0);
       notice := (pos('N',Zeile) <> 0);
       Save := (pos('S',Zeile) <> 0);
       READLN(StatusFile,Zeile);
       READLN(StatusFile);

       IF Save THEN
        BEGIN
          RX_Name := Zeile;
          IF (RX_Name = '') THEN
            RX_Name := StdFilename(0);
        END
       ELSE
        RX_Name := StdFilename(0);

     END;  { WITH K[0]... }

     FOR i := 1 TO 4 DO
       READLN(Statusfile,Zeile);

     READLN(StatusFile,Zeile);
     VAL(CutStr(Zeile),i1,i2);
     IF (i2 = 0) THEN
      BEGIN
        IF i1 > MaxY THEN i1 := MaxY - 4;
        FOR i2 := 1 TO maxLink DO
          K[i2]^.Trenn := i1;
      END;

     READLN(StatusFile,Zeile);
     VAL(CutStr(Zeile),lastChannel,i);

     READLN(StatusFile,Zeile);
     VAL(CutStr(Zeile),Resync_Z,i);

     READLN(StatusFile,Zeile);
     VAL(CutStr(Zeile),gesMin,i);

     FOR i := 1 TO 2 DO
      WITH Scan[i] DO BEGIN
        READLN(StatusFile,Zeile);
        Call1 := CutStr(Zeile);
        READLN(StatusFile,Zeile);
        Call2 := CutStr(Zeile);
        IF (Call1 <> '') OR (Call2 <> '') THEN
          SuchString := Call1 + ' > ' + Call2 + ' '
        ELSE
          SuchString := '';
      END;
     READLN(StatusFile,Zeile);
     VAL(CutStr(Zeile),ScanChannel,i);
     IF (i <> 0) THEN ScanChannel := -1;

     CLOSE(StatusFile);
   END
  ELSE
   BEGIN
     { Statusdatei nicht vorhanden, also Variablen zu Fu initialisieren }
     output_Errortext('Statusdatei '+StatusfileName+' nicht gefunden, Defaults werden gesetzt.');
     FOR Kanal := 0 TO maxLink DO WITH K[Kanal]^ DO
       RX_Name := StdFilename(Kanal);
     WITH K[0]^ DO BEGIN
       PacLen := 255;
       Klingel := TRUE;
       Time_Stamp := TRUE;
     END;
     { der Rest der Variablen wurde schon in PRDEFS.PAS initialisiert }
   END;

END;


{------------------------------------------------------------------------------
| Einlesen der Datei 'ATTRIB.PR' und Zuweisung der Video-Attribute
+-----------------------------------------------------------------------------}

PROCEDURE Load_AttributFile;

 VAR   AttribFile   : Text;
       Zeile        : String;
       i            : BYTE;
       gefunden     : BOOLEAN;

 BEGIN
   Assign(AttribFile, SysPfad+'ATTRIB.PR');
   WRITE('ATTRIB.PR  ');
   {$I-}
   Reset(AttribFile);
   {$I+}
   IF IOResult <> 0 THEN File_not_found;

   gefunden := FALSE;
   REPEAT                        { passende Attribute suchen }
     READLN(AttribFile,Zeile);
     gefunden := Copy(Zeile,1,3) = ('<<' + AttrSet);
   UNTIL gefunden OR Eof(AttribFile);

   IF NOT gefunden THEN BEGIN
     output_Errortext('Attributsatz ' + AttrSet + ' nicht gefunden!');
     Halt;
   END;

   READLN(AttribFile,Zeile);
   norm := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   low := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   blinkAttr := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   neg := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   neg_high := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   ctrlAttrib := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   neg_blink := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   conRXAttrib := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   conTXAttrib := str_int(CutStr(Zeile));

   FOR i := 1 TO 4 DO BEGIN
     READLN(AttribFile,Zeile);
     TNC[i].HeaderAttr := str_int(CutStr(Zeile));
   END;

   READLN(AttribFile,Zeile);
   MoniInfoAttr := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   NetzHeaderAttrib := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   FRahmenAttr := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   FTitelAttr := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   FNormAttr := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   FHighAttr := str_int(CutStr(Zeile));
   READLN(AttribFile,Zeile);
   FBlinkAttr := str_int(CutStr(Zeile));

   Close(AttribFile);

 END;


{------------------------------------------------------------------------------
| Einlesen der Datei 'MSG.PR'
+-----------------------------------------------------------------------------}

PROCEDURE Load_MsgFile;

VAR MSGFile    : Text;
    NetPWFile  : Text;
    msgNummer  : INTEGER;
    msgZeiger  : INTEGER;
    i          : INTEGER;
    Zeile      : String;
    subStr     : String [20];
    MsgBuffer  : MsgType;

 PROCEDURE msgFileError(i : INTEGER);
  VAR Zeile   : Str80;
  BEGIN
    Zeile := 'Fehler im Aufbau der Datei MSG.PR !!  >>>  ';
    CASE i OF
     1..10 : Zeile := Zeile + '&<' + int_Str(i) + '>';
     11    : Zeile := Zeile + '&<DIGICOM>';
     12    : Zeile := Zeile + '&<ENDE>';
    END;
    Zeile := Zeile + ' erwartet.';
    output_Errortext(Zeile);
    Halt(0);
  END;

BEGIN

  WRITE('MSG.PR  ');
  Assign (MsgFile,SysPfad+'MSG.PR');
  {$I-}
  Reset(msgFile);
  {$I+}
  IF IOResult <> 0 THEN File_not_found;

  READLN(msgFile,Zeile);         { &<1> ueberlesen }
  FOR msgNummer := 1 TO 11 DO
   BEGIN
     FillChar(MsgBuffer,maxMsgLaenge,#0);
     msgZeiger := 1;
     READLN(msgFile,Zeile);
     Zeile := Zeile + #13;
     WHILE (Zeile[1] <> '&') DO
     BEGIN
       FOR i := 1 TO length(Zeile) DO
         IF (msgZeiger < maxMsgLaenge) THEN
          BEGIN
            MsgBuffer[msgZeiger] := Zeile[i];
            Inc(msgZeiger);
          END;
       READLN(msgFile,Zeile);
       IF (Copy(Zeile,1,1) = '&') THEN BEGIN
         CASE msgNummer OF
          1..9 : subStr := '&<'+int_Str(msgNummer+1)+'>';
          10   : subStr := '&<DIGICOM>';
          11   : subStr := '&<ENDE>';
         END;
         IF (Copy(Zeile,1,Length(subStr)) <> subStr)
           THEN msgFileError(msgNummer+1);
       END;
       Zeile := Zeile + #13;
     END;
     GetMem(msg[msgNummer],msgZeiger+1);    { Verwaltung gendert ! }
     msg[msgNummer]^ := MsgBuffer;
   END;

  Close(msgFile);

  { Testen, ob Netzknoten-PasswortFile vorhanden ist }
  Assign (NetPWFile,SysPfad+'NETPW.PR');
  {$I-}
  Reset(NetPWFile);
  {$I+}
  IF IOResult = 0 THEN
  BEGIN
    { Netzknoten-PWFile ist vorhanden }
    Close(NetPWFile);
    NetPWFileOK := TRUE;
  END;

END;


{------------------------------------------------------------------------------
| QRG-File einlesen und entsprechend Platz auf dem Heap schaffen.
+-----------------------------------------------------------------------------}

PROCEDURE Load_QRGFile;

 VAR  QRGFile    : Text;
      Zeile      : String;
      CallStr    : Str80;
      QRGStr     : Str8;
      IDStr      : Str8;
      QRGNummer  : BYTE;
      i          : INTEGER;

 BEGIN
   lastQRG := 0;
   Assign (QRGFile,SysPfad+'QRG.PR');
   {$I-}
   Reset(QRGFile);  {$I+}
   IF (IOResult = 0) THEN
    BEGIN
      QRGNummer := 1;
      WHILE (NOT EOF(QRGFile)) AND (QRGNummer <= maxQRG) DO BEGIN
        READLN(QRGFile,Zeile);
        IF (Length(Zeile) > 0) AND (Zeile[1] <> '#') THEN BEGIN
          IDStr := '';
          QRGStr := cutStr(Zeile);
          IF Length(QRGStr) < 8
            THEN QRGStr := Space(8-Length(QRGStr)) + QRGStr;
          i := Pos('#',Zeile);
          IF (i > 0) THEN
           BEGIN
             IDStr := Copy(Zeile,i+1,8);
             IDStr := cutStr(IDStr);
             Delete(Zeile,i,100);
           END;
          CallStr := cutLeftStr(upcaseStr(Zeile)) + ' ';
          GetMem(QRGCheck[QRGNummer],2*SizeOf(Str8)+Length(CallStr)+1);
          WITH QRGCheck[QRGNummer]^ DO BEGIN
            QRG := QRGStr;
            expectedIdent := IDStr;
            Calls := CallStr;
          END;
          Inc(QRGNummer);
        END;
      END;
      IF QRGNummer > maxQRG THEN
        output_Errortext('Zu viele Frequenzen in der Datei QRG.PR');
      lastQRG := QRGNummer - 1;
      Close(QRGFile);
    END;
 END;


{------------------------------------------------------------------------------
| Logdatei mit dem List-Programm anzeigen
+-----------------------------------------------------------------------------}

PROCEDURE do_LOGcommand;

BEGIN
  do_DOScommand('DOS '+ListPgm+' '+SysPfad+'LOG.PR /8',FALSE,TRUE,FALSE,BSave);
END;


{------------------------------------------------------------------------------
| Speichern der Status-Datei bei Programmende
+-----------------------------------------------------------------------------}

PROCEDURE Save_Statusfile;

 VAR   i            : INTEGER;
       StatusFile   : Text;
       Kanal        : Byte;

 BEGIN

   Assign(StatusFile, SysPfad+'STAT'+StatusZusatz+'.PR');
   {$I-}
   Rewrite(StatusFile); {$I+}
   IF IOResult = 0 THEN BEGIN
     WRITELN(StatusFile,'Turbo-Packet V',Version,
                        ' Statusdatei (STAT',StatusZusatz,'.PR)  ',
              Date,'  ',Time);
     WRITELN(StatusFile,ConstStr('',78));
     FOR Kanal := 1 TO maxLink DO
       WITH K[Kanal]^ DO
         BEGIN
           IF connected THEN
            BEGIN
              WRITELN(StatusFile,Call);
              WRITELN(StatusFile,qsoDatum);
              WRITELN(StatusFile,qsoBeginn);
              WRITELN(StatusFile,ConText);
            END
           ELSE
            BEGIN
              WRITELN(StatusFile,'(',Kanal,') disconnected');
              WRITELN(StatusFile,'.');
              WRITELN(StatusFile,'.');
              WRITELN(StatusFile,'.');
            END;
           WRITELN(StatusFile,TNCCall);
           WRITELN(StatusFile,PacLen);

           IF (Umlaut = 1) THEN WRITE(Statusfile,'U7');
           IF (Umlaut = 2) THEN WRITE(Statusfile,'U8');
           IF localEcho THEN WRITE(StatusFile,'E');
           IF notice THEN WRITE(StatusFile,'N');
           IF CW THEN WRITE(StatusFile,'C');
           IF Save THEN WRITE(StatusFile,'S');
           IF (Remote = 1) THEN WRITE(Statusfile,'R1');
           IF (Remote = 2) THEN WRITE(Statusfile,'R2');
           WRITELN(StatusFile);
           IF Save
             THEN WRITELN(StatusFile,RX_Name)
             ELSE WRITELN(StatusFile);
           WRITELN(StatusFile,ConstStr('',20));
         END; { WITH K... }

     WRITELN(StatusFile,'(0)');
     WITH K[0]^ DO
     BEGIN
       WRITELN(StatusFile,PacLen);
       IF (Umlaut = 1) THEN WRITE(Statusfile,'U7');
       IF (Umlaut = 2) THEN WRITE(Statusfile,'U8');
       IF Time_stamp THEN WRITE(StatusFile,'T');
       IF Klingel THEN WRITE(StatusFile,'K');
       IF notice THEN WRITE(StatusFile,'N');
       IF Save THEN WRITE(StatusFile,'S');
       WRITELN(StatusFile);
       IF Save
         THEN WRITELN(StatusFile,RX_Name)
         ELSE WRITELN(StatusFile);
     END;

     WRITELN(StatusFile,ConstStr('',20));
     FOR i := 1 TO 4 DO
       WRITELN(Statusfile,'.');
     WRITELN(StatusFile,K[1]^.Trenn,' ; Position der Statuszeile');
     WRITELN(StatusFile,show,' ; zuletzt benutzter Kanal');
     WRITELN(StatusFile,Resync_Z,' ; Resyncs');
     WRITELN(StatusFile,gesMin,' ; Laufzeit Minuten');
     WRITELN(StatusFile,Scan[1].Call1,' ; ScanCall 1-1');
     WRITELN(StatusFile,Scan[1].Call2,' ; ScanCall 1-2');
     WRITELN(StatusFile,Scan[2].Call1,' ; ScanCall 2-1');
     WRITELN(StatusFile,Scan[2].Call2,' ; ScanCall 2-2');
     WRITELN(StatusFile,ScanChannel,' ; ScanChannel');
     WRITELN(StatusFile,'----- Ende STAT',StatusZusatz,'.PR -----');
     CLOSE(StatusFile);
   END;

 END;


{------------------------------------------------------------------------------
| Ausgabe eines Catalogs (mehrspaltig)
+-----------------------------------------------------------------------------}

PROCEDURE Catalog (upcase_Zeile : String);

VAR
      i           : INTEGER;
      FileExt     : STRING[3];
      PunktPos    : INTEGER;
      free        : LONGINT;
      Laenge      : STRING[10];
      Eintrag     : INTEGER;
      Zaehler     : INTEGER;
      x_pos       : INTEGER;
      Pfad        : PathStr;
      ch          : CHAR;
      AMerk       : BYTE;
      ScreenX,
      ColumnX     : INTEGER;

      SRec        : SearchRec;  { Im Unit DOS definiert }

BEGIN

  Moni_off;

  AMerk := TextAttr;

  WHILE (upcase_Zeile[1] <> ' ') AND (Length(upcase_Zeile) > 0) DO
    Delete(upcase_Zeile,1,1);
  WHILE (upcase_Zeile[1] = ' ') AND (Length(upcase_Zeile) > 0) DO
    Delete(upcase_Zeile,1,1);
  Pfad := upcase_Zeile;

  IF (Pos(':',Pfad) = 0) THEN Pfad := TextPfad + Pfad;
  Pfad := FExpand(Pfad);
  IF (Pfad[Length(Pfad)] = '\') THEN Pfad := Pfad + '*.*';

  FindFirst(Pfad,Archive + Directory,SRec);     { Prozedur im Unit DOS }

  ColumnX := MaxY - 4;
  ScreenX := (MaxX DIV 26) * ColumnX;
  ClrScr;
  TextAttr := neg_high;
  WRITE(Space(MaxX));
  GotoXY(3,1);
  WRITE('D I R E C T O R Y  ');
  TextAttr := neg;
  WRITE('von  ',Pfad);
  TextAttr := low;
  GotoXY(1,MaxY-1);
  WRITE(CONSTStr('',MaxX));

  Eintrag := 0;
  Zaehler := 0;
  x_Pos := 4;
  GotoXY(x_Pos,3);

  IF (DosError <> 0) THEN

   BEGIN
     { irgendetwas ist schief gelaufen ... }
     TextAttr := norm;
     GotoXY(3,5);
     WRITE('Fehler: ');
     TextAttr := blinkAttr;
     WRITE(FehlerText(DosError),Bell);
     GotoXY(1,MaxY);
     TextAttr := norm;
     WRITE('>>>  Weiter mit beliebigem Tastendruck.');
     GotoXY(4,MaxY);
   END

  ELSE

   BEGIN

     WHILE (DosError = 0) DO WITH SRec DO BEGIN

       Inc(Eintrag);
       Inc(Zaehler);
       PunktPos := Pos('.',Name);

       IF (Attr <> Directory) THEN BEGIN
         { kein Dir-Eintrag }
         IF (PunktPos <> 0) THEN BEGIN
           FileExt := copy(Name,PunktPos+1,length(Name)-PunktPos);
           delete(Name,PunktPos,1+length(Name)-PunktPos);
         END
         ELSE FileExt := '';

         FileExt := FileExt + Space(3-Length(FileExt));
         Name := Name + Space(8-length(Name));

         Str(Size,Laenge);
         Laenge := Space(7-Length(Laenge)) + Laenge;
         GotoXY(X_Pos,whereY);
         TextAttr := norm;
         WRITE(Name,' ',FileExt);
         TextAttr := low;
         WRITELN(Laenge);
       END
       ELSE BEGIN
         { Dir-Eintrag }
         GotoXY(X_Pos,whereY);
         TextAttr := low;
         WRITELN(Name,Space(12-Length(Name)),'<dir>');
       END;

       IF (Zaehler MOD ColumnX) = 0 THEN
       BEGIN
         x_Pos := x_Pos + 26;
         GotoXY(X_Pos,3);
       END;

       FindNext(SRec);

       IF (Zaehler = ScreenX) AND (DosError = 0) THEN
         BEGIN
           {Seite voll UND weitere Eintrge vorhanden}
           GotoXY(1,MaxY);
           TextAttr := norm;
           WRITE('>>>  Weiter mit beliebigem Tastendruck.');
           GotoXY(4,MaxY);
           WaitKey (1);
           WINDOW(1,2,MaxX,MaxY-2);
           ClrScr;
           maxWindow;
           Zaehler := 0;
           x_Pos := 1;
           GotoXY(x_Pos,3);
         END;

     END; { WHILE DosError ... }

     free := DiskFree(ord(Pfad[1]) - 64) DIV 1024;

     GotoXY(1,MaxY);
     TextAttr := norm;
     WRITE('>>>  ',Eintrag,' Dateien, ',free,
           ' KBytes frei.  Weiter mit bel. Taste.');
     GotoXY(4,MaxY);

   END;

  WaitKey (1);
  restore_Screen;
  TextAttr := AMerk;

  restore_MoniStatus;

END;


BEGIN

  {----------------------------------------------------------------------------
  | Keine Initialisierung erforderlich
  +---------------------------------------------------------------------------}

END.
