
{------------------------------------------------------------------------------
|
|   P R L I B 2 . P A S
|
|   DL1BHO  11/1992
|
+-----------------------------------------------------------------------------}

{$V-}           { keine strikte VAR-String-Prfung }


UNIT PRLIB2;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


USES
       PRDEFS;


PROCEDURE MH_darstellen(SuchCall : Str9);
PROCEDURE MH_Update;
PROCEDURE adjust_Header (VAR Response : String);
FUNCTION  end_cmd(cmd_Nummer : BYTE) : BYTE;
FUNCTION  Auto_Command(Kanal, cmd_Nummer, Nummer : BYTE) : Str80;
PROCEDURE Auto_cmd_darstellen;
PROCEDURE check_Scroll_Lock;
PROCEDURE Stby_Logo;
PROCEDURE do_PACcommand(Kanal : BYTE ; upcase_Zeile : String);
PROCEDURE do_DOScommand(Zeile : String;
                        WaitForKey,Clr,RestoreTextmode,BufferSave : BOOLEAN);
PROCEDURE do_ScanCommand(Zeile : String);
PROCEDURE do_CLScommand;

{------------------------------------------------------------------------------
| Ende INTERFACE
+-----------------------------------------------------------------------------}


IMPLEMENTATION


USES
       Dos,
       Crt,
       Memory,
       PRLIB,
       PRLIB4,
{$IFDEF OS2}
       PRV24OS2,
{$ELSE}
       PRV24,
{$ENDIF}
       PRKBD,
       PRScreen,
       PRScroll,
       PRMouse;


VAR
       Dateiname      : Str60;


{------------------------------------------------------------------------------
| Darstellen der MHeard-Liste
+-----------------------------------------------------------------------------}

PROCEDURE MH_darstellen (SuchCall : Str9);
VAR   i, i1, X_Pos   : INTEGER;
      gehoert        : INTEGER;
      AMerk          : BYTE;
BEGIN
  AMerk := TextAttr;
  IF (show = 0)
    THEN i1 := unproto
    ELSE i1 := K[show]^.TNCNummer;
  ClrScr;
  TextAttr := neg_high;
  WRITE(Space(MaxX));
  GotoXY(3,1);
  WRITE('M H E A R D - Liste  ');
  TextAttr := neg;
  WRITE('(',cutLeftStr(TNC[i1].currentQRG),')  seit  ',Datum,'  ',Zeit);

  gehoert := 1;
  (* feststellen, wieviele Calls gehoert wurden *)
  WHILE (TNC[i1].MH^[gehoert+1].Call <> '') AND (gehoert < 60) DO
    Inc(gehoert);

  TextAttr := low;
  WRITELN;
  WRITELN;
  WRITE(' Call       Zeit   Info');
  IF (gehoert > 19) THEN
    WRITE('      Call       Zeit   Info');
  IF (gehoert > 38) THEN
    WRITE('      Call       Zeit   Info');
  WRITELN;
  WRITELN(CONSTStr('',MaxX));
  X_Pos := 2;                   { X-Position der Spaltenausgabe }
  Gotoxy(X_Pos,5);
  FOR i := 1 TO 57 DO BEGIN
    WITH TNC[i1].MH^[i] DO BEGIN
      IF (Call <> '') THEN BEGIN
        IF (SuchCall <> '') AND (SuchCall = Copy(Call,1,Length(SuchCall)))
          THEN TextAttr := norm;
        Gotoxy(X_Pos,WhereY);
        WRITELN(Call,Zeit:7,Info:6);
        TextAttr := low;
      END;
    END;
    IF (i = 19) THEN BEGIN
      X_Pos := 30;
      GotoXY(X_Pos,5);
    END;
    IF (i = 38) THEN BEGIN
      X_Pos := 58;
      GotoXY(X_Pos,5);
    END;
  END;

  GotoXY(1,MaxY-1);
  WRITE(CONSTStr('',MaxX));
  GotoXY(1,MaxY);
  TextAttr := norm;
  WRITE('>>>  Weiter mit beliebigem Tastendruck.');
  WRITE('    (Monitor wird NICHT abgeschaltet!)');
  GotoXY(4,MaxY);
  WaitKey (1);

  restore_Screen;
  TextAttr := AMerk;
END;


{------------------------------------------------------------------------------
| Bearbeitung der Heard-Liste
| + Frequenzfindung
+-----------------------------------------------------------------------------}

PROCEDURE MH_Update;

VAR Stelle     : INTEGER;
    i          : INTEGER;
    gefunden   : BOOLEAN;
    RufZ       : String[10];
    InfoMerk   : WORD;       (* Merker fr Anzahl Info-Frames *)

BEGIN

  RufZ := CutStr(ResponseStr);
  RufZ := RufZ + Space(9-Length(RufZ));   {RufZ ist 9 Zeichen lang}
  Stelle := 0;
  gefunden := FALSE;
  WITH TNC[active_TNC] DO BEGIN
    REPEAT
      Inc(Stelle);
      IF (RufZ = MH^[Stelle].Call) THEN gefunden := TRUE;
    UNTIL gefunden OR (Stelle = 60);
    IF gefunden
      THEN InfoMerk := MH^[Stelle].Info
      ELSE InfoMerk := 0;
    FOR i := (Stelle - 1) DOWNTO 1 DO
      MH^[i+1] := MH^[i];
    MH^[1].Call := RufZ;
    MH^[1].Zeit := Copy(Time,1,5);
    MH^[1].Info := InfoMerk;
    IF (Pos(' ctl I',ResponseStr) > 0) THEN Inc(MH^[1].Info);

    {--------------------------------------------------------------------------
    | aktuelle Frequenz aus den Monitorframes finden
    +-------------------------------------------------------------------------}
    RufZ := CutStr(RufZ) + ' ';
    i := 1;
    gefunden := FALSE;
    WHILE (i <= lastQRG) AND NOT gefunden DO
     BEGIN
       gefunden := (Pos(RufZ,QRGCheck[i]^.Calls) <> 0);
       IF gefunden THEN
        BEGIN
          { expectedIdent mit dem TNC-Ident vergleichen }
          IF Length(QRGCheck[i]^.expectedIdent) > 0 THEN
            IF QRGCheck[i]^.expectedIdent <> TNC[active_TNC].Ident THEN
              gefunden := FALSE;
        END;
       Inc(i);
     END;
    IF gefunden THEN currentQRG := QRGCheck[i-1]^.QRG;
    IF (active_TNC = unproto) AND Sek15 THEN Status1Out(0,53,neg,currentQRG);

  END;   { WITH TNC... }

END;


{-----------------------------------------------------------------------------
| Monitor-Header-Format anpassen
+----------------------------------------------------------------------------}

PROCEDURE adjust_Header (VAR Response : String);

 VAR    i      : INTEGER;

 BEGIN
   Delete(Response,1,3);
   i := Pos(' to ',Response);
   IF (i > 0) THEN
    BEGIN
      Delete(Response,i+1,1);
      Response[i+1] := '>';
    END;
 END;


FUNCTION end_cmd (cmd_Nummer : BYTE) : BYTE;
BEGIN
  end_cmd := AutoCMD[cmd_Nummer]^.Anzahl;
END;


FUNCTION Auto_Command (Kanal, cmd_Nummer, Nummer : BYTE) : Str80;
VAR b_str   : Str80;
    i,j     : INTEGER;
BEGIN
  WITH AutoCMD[cmd_Nummer]^ DO BEGIN
    i := Pos(Chr(Nummer),cmd_Line) + 1;
    j := Pos(Chr(Nummer+1),cmd_Line);
    b_Str := Copy(cmd_Line,i,j-i);
    i := Pos('*',b_str);
    IF (i <> 0) THEN
     BEGIN
       Delete(b_str,i,1);
       Insert(int_Str(Kanal),b_Str,i);
     END;
    Auto_Command := b_str;
  END;
END;


PROCEDURE Auto_cmd_darstellen;
LABEL Nochmal;
VAR   i          : INTEGER;
      MaxLaenge  : INTEGER;
      Zeile      : Str80;
      FXPos,
      FYPos      : INTEGER;
      AMerk      : BYTE;
      ch         : CHAR;
      KC         : KeyCodes;
BEGIN
  WITH K[show]^ DO BEGIN

    AMerk := TextAttr;
    Nochmal:

    WITH AutoCMD[cmd_Nummer]^ DO BEGIN
      MaxLaenge := 1;
      FOR i := 1 TO Anzahl DO BEGIN
        (* lngstes Kommando suchen *)
        Zeile := Auto_Command(show,cmd_Nummer,i);
        IF (Length(Zeile) > MaxLaenge) THEN MaxLaenge := Length(Zeile);
      END;
      Zeile := 'Auto-Cmd Alt-F' + int_Str(Cmd_Nummer);
      IF (Handle <> '') THEN Zeile := Zeile + ' (' + Handle + ')';
      IF (MaxLaenge < Length(Zeile)) THEN MaxLaenge := Length(Zeile);
      IF (maxLaenge < 18) THEN maxLaenge := 18;
      FXPos := (80-MaxLaenge-6) DIV 2;
      FYPos := (MaxY-Anzahl-5) DIV 2;
      Fenster(FXPos,FYPos,MaxLaenge+6,Anzahl+5,Zeile);
      Gotoxy(FXPos+2,FYPos+2);
      TextAttr := FNormAttr;
      FOR i := 1 TO Anzahl DO BEGIN
        WRITELN(Auto_Command(show,cmd_Nummer,i));
        Gotoxy(FXPos+2,WhereY);
      END;
      WRITELN;
      GotoXY(FXPos+2,WhereY);
      TextAttr := FHighAttr;
      WRITE('<ESC> oder <ENTER>');
      REPEAT UNTIL Keypressed;
      GetKey (ch,KC);
      IF KC IN [F1..F10,Alt_F1..Alt_F10] THEN BEGIN
        IF (KC < Alt_F1)
          THEN cmd_Nummer := ORD(KC) - ORD(Alt_M)
          ELSE cmd_Nummer := ORD(KC) - ORD(Ctrl_F10);
        restore_Screen;
        Goto Nochmal;
      END;
    END;
    IF (ch = #13) THEN Auto_cmd := TRUE;
  END;
  TextAttr := AMerk;
  restore_Screen;
END;


{------------------------------------------------------------------------------
| check_Scroll_Lock prft, ob Scroll-Lock gedrckt wurde.
| Bei gedrcktem Scroll-Lock wird die Programmausfhrung angehalten.
+-----------------------------------------------------------------------------}

PROCEDURE check_Scroll_Lock;

 VAR  AMerk    : BYTE;

 BEGIN
   IF (Kbd_Status AND $10) = $10 THEN
     BEGIN
       { Scroll-Lock gedrckt }
       AMerk := TextAttr;
       Fenster(62,1,19,5,'Scroll-Lock');
       TextAttr := FBlinkAttr;
       GotoXY(69,3);
       WRITE('Pause');

       REPEAT
         { warten, bis Scroll-Lock ausgeschaltet wird ... }
       UNTIL (Kbd_Status AND $10) = $00;

       restore_Screen;
       TextAttr := AMerk;
     END;
 END;


{-----------------------------------------------------------------------------
| Stby_Logo  stellt eine zufllige Laufschrift dar, whrend der Bildschirm-
| schoner in Betrieb ist.
| Diese Routine wird alle 10 Sekunden von der Uhr_aus-Routine aufgerufen.
+----------------------------------------------------------------------------}

PROCEDURE Stby_Logo;

 LABEL  Abbruch;

 VAR    AStore      : Byte;
        oldX,oldY   : Byte;
        Logo_Str    : Str20;
        Out_Str     : Str20;
        Laenge      : INTEGER;
        Laenge2     : INTEGER;
        i           : INTEGER;

 BEGIN

   Logo_Str := ' TurboPR  ' + Copy(Time,1,5) + ' ';
   AStore := TextAttr;
   oldX := stby_X;
   oldY := stby_Y;
   stby_X := 1 + Random(maxX-Length(Logo_Str));
   stby_Y := 1 + Random(maxY);

   Laenge := Length(Logo_Str);
   Laenge2 := Laenge DIV 2;

   (* Logo lschen *)
   FOR i := (Laenge2-1) DOWNTO 0 DO BEGIN
     Out_Str := Copy(Logo_Str,1,i) + Copy(Logo_Str,Laenge+1-i,i);
     GotoXY(oldX,oldY);
     Delay(5*DelayCorr);
     NormVideo;
     WRITE(Space(Laenge2-i));
     TextAttr := neg;
     WRITE(Out_Str);
     NormVideo;
     WRITE(Space(Laenge2-i));
     IF Keypressed THEN Goto Abbruch;
   END;

   (* neues Logo aufbauen *)
   TextAttr := neg;
   FOR i := 1 TO Laenge2 DO BEGIN
     Out_Str := Copy(Logo_Str,1,i) + Copy(Logo_Str,Laenge+1-i,i);
     GotoXY(stby_X+Laenge2-i,stby_Y);
     Delay(5*DelayCorr);
     WRITE(Out_Str);
     IF Keypressed THEN Goto Abbruch;
   END;

   Abbruch:

   TextAttr := AStore;

 END;


{------------------------------------------------------------------------------
| das PAClen-Kommando auswerten
+-----------------------------------------------------------------------------}

PROCEDURE do_PACcommand(Kanal : BYTE ; upcase_Zeile : String);

 VAR   i,i1,Fehler      : INTEGER;

 BEGIN
   WITH K[Kanal]^ DO BEGIN
     i := Pos(' ',upcase_Zeile);
     IF i = 0 THEN
       BEGIN
         (* Kein neuer Wert angegeben *)
         timedWindow(0,5,FHighAttr,
                           Channel_ID(show)+'('+int_str(show)+') PACLEN ' +
                           int_str(PacLen))
       END
     ELSE
       BEGIN
         (* neuer Wert *)
         val(copy(upcase_Zeile,i+1,length(upcase_Zeile)-i),i1,Fehler);
         IF (Fehler = 0) AND (i1 >= 10) and (i1 <= 255) THEN
           BEGIN
             PacLen := i1;
           END
         ELSE
           BEGIN
             IF Klingel THEN beep(220,20);
             timedWindow(0,5,FBlinkAttr,
                              Channel_ID(show) + '('+int_str(show) +
                              ') PACLEN-Error!');
           END;
       END;
   END;
 END;


PROCEDURE ExecDos(Pfad : Str80; CmdLine : Str80);
 VAR   chx   : Char;
 BEGIN
{
   GotoXY(1,1);
   WRITELN('>>>',Pfad,'<<<');
   WRITELN('>>>',CmdLine,'<<<');
   ReadLn;
}
   IF (Pfad = '') THEN
     Exit;                { sonst knallt's mchtig... }
   SetMemTop(HeapPtr);
   Delay(1*DelayCorr);
   SwapVectors;
   Exec(Pfad,CmdLine);
   SwapVectors;
   SetMemTop(HeapEnd);
 END;


{------------------------------------------------------------------------------
| Das DOS-Kommando des Kommandointerpreters ausfhren
+-----------------------------------------------------------------------------}

PROCEDURE do_DOScommand (Zeile : String; WaitForKey,
                                         Clr,
                                         RestoreTextmode,
                                         BufferSave        : BOOLEAN);

 VAR  oldTextMode   : Word;
      i             : INTEGER;
      Kanal         : INTEGER;
      act_MaxY      : INTEGER;

 BEGIN

   Moni_off;

   { alle Textfiles schlieen, um eine Bearbeitung zu ermglichen }
   FOR Kanal := 0 TO Kanal_Anzahl DO WITH K[Kanal]^ DO
    BEGIN
      IF save AND (RX_Mode = 0) THEN
       BEGIN
         CloseRXFile(Kanal);
         save := TRUE;         { CloseRXFile lscht das Save-Flag... }
       END;
    END;

   IF BufferSave THEN
     Save_ScrollBuffer;

   i := Pos(' ',Zeile);
   IF i > 0
     THEN Delete(Zeile,1,i)
     ELSE Zeile := '';
   Zeile := cutLeftStr(Zeile);

   SetBorderColor(0);

   NormVideo;
   Cursor_ein;

   IF Clr THEN
    BEGIN
      ClrScr;
{$IFDEF OS2}
      WRITELN;     { naja... OS/2's Statuszeile... }
{$ENDIF}
    END;

   oldTextMode := LastMode;
   SetCBreak(Breakstatus);       { restore BREAK setting }

   IF (Length(Zeile) > 0) THEN
    BEGIN
      ExecDos(GetEnv('COMSPEC'),'/C '+Zeile);

      IF WaitForKey THEN
       BEGIN
         act_MaxY := WindMax DIV 256 + 1;
         NormVideo;
         GotoXY(39,act_MaxY-1);
         WRITE(' ',constStr('',39));
         gotoXY(39,act_MaxY);
         write('  [TurboPR] Bitte eine Taste drcken...');
         WaitKey(0);
       END;
    END
   ELSE
    BEGIN
      WRITELN('Mit EXIT geht''s zurck zu TurboPR');
      ExecDos(GetEnv('COMSPEC'),'');
    END;

   IF BufferSave THEN
     Restore_ScrollBuffer;

   SetCBreak(false);             { disable Ctrl-C/Break }

   IF RestoreTextmode THEN
     TextMode(oldTextMode);

{$IFDEF OS2}
   SysDelay(Sec05);
{$ENDIF}

   Cursor_aus;
   restore_screen;

   { alle erforderlichen Textfiles wieder ffnen }
   FOR Kanal := 0 TO Kanal_Anzahl DO WITH K[Kanal]^ DO
    BEGIN
      IF save AND (RX_Mode = 0) THEN OpenRXFile(Kanal);
    END;

   restore_MoniStatus;

   M_SetRange(0,0,8*MaxX-1,8*MaxY-1);    { Mauscursor-Bereich wieder setzen }

   IF (DosError > 0) THEN
    BEGIN
      WRITE(Bell);
      M_aus(#13+'Dos-Error '+Int_Str(DosError)+' '+FehlerText(DosError)+#13#13);
    END;

 END;


{-----------------------------------------------------------------------------
| Scan-Kommando
+----------------------------------------------------------------------------}

PROCEDURE do_ScanCommand (Zeile : String);

 VAR   i,i1,i2      : INTEGER;
       error        : INTEGER;
       OldAttr      : Byte;
       chx          : Char;
       FXPos,
       FYPos        : INTEGER;

 BEGIN
   OldAttr := TextAttr;
   IF (Zeile <> '') THEN
    BEGIN
      { Parameter wurde bergeben, also auswerten }
      Val(Zeile,i1,error);
      IF (error = 0) AND (i1 >= 0) AND (i1 <= Kanal_Anzahl) THEN
       BEGIN
         IF (i1 = 0) THEN
           ScanChannel := 0
         ELSE
           IF NOT K[i1]^.connected THEN
             ScanChannel := i1;
         restore_Screen;
       END;
    END
   ELSE
    BEGIN
      { kein Parameter, also Men aufbauen }
      FXPos := (80-28) DIV 2;
      FYPos := (MaxY-9) DIV 2;
      Fenster(FXPos,FYPos,27,13,'Scan-Rufzeichen');
      TextAttr := FNormAttr;
      GotoXY(FXPos+2,FYPos+2);
      WRITELN('Eingeben/Verndern der');
      GotoXY(FXPos+2,WhereY);
      WRITELN('zu scannenden Call-');
      GotoXY(FXPos+2,WhereY);
      WRITELN('Kombinationen (max. 2');
      GotoXY(FXPos+2,WhereY);
      WRITELN('Call-Kombinationen).');

      TextAttr := FHighAttr;
      GotoXY(FXPos+2,FYPos+11);
      WRITE('<Enter>=next <ESC>=Ende');
      GotoXY(FXPos+2,FYPos+7);
      TextAttr := ConRXAttrib;
      WRITE(Space(11),'>',Space(11));
      GotoXY(FXPos+3,FYPos+7); WRITE(Scan[1].Call1);
      GotoXY(FXPos+15,FYPos+7); WRITE(Scan[1].Call2);
      GotoXY(FXPos+2,FYPos+9);
      TextAttr := ConTXAttrib;
      WRITE(Space(11),'>',Space(11));
      GotoXY(FXPos+3,FYPos+9); WRITE(Scan[2].Call1);
      GotoXY(FXPos+15,FYPos+9); WRITE(Scan[2].Call2);
      i1 := 1;
      chx := #0;

      WHILE (chx <> Esc) DO
       BEGIN
         CASE i1 OF
          1 : BEGIN
                TextAttr := ConRXAttrib;
                EditStr(Scan[1].Call1,9,FXPos+3,FYPos+7,chx);
              END;
          2 : BEGIN
                TextAttr := ConRXAttrib;
                EditStr(Scan[1].Call2,9,FXPos+15,FYPos+7,chx);
              END;
          3 : BEGIN
                TextAttr := ConTXAttrib;
                EditStr(Scan[2].Call1,9,FXPos+3,FYPos+9,chx);
              END;
          4 : BEGIN
                TextAttr := ConTXAttrib;
                EditStr(Scan[2].Call2,9,FXPos+15,FYPos+9,chx);
              END;
         END;
         Inc(i1);
         IF (i1 = 5) THEN i1 := 1;
       END;

       FOR i := 1 TO 2 DO WITH Scan[i] DO
        BEGIN
          IF (Call1 <> '') OR (Call2 <> '') THEN
            SuchString := Call1 + ' > ' + Call2 + ' '
          ELSE
            SuchString := '';
        END;

      maxWindow;
      restore_Screen;
    END;

   TextAttr := OldAttr;
 END;


{-----------------------------------------------------------------------------
|  CLS  Clear Screen Command (11/1992, auf Wunsch von DL6OBN)
+----------------------------------------------------------------------------}

PROCEDURE do_CLScommand;

 VAR   i,Lines   : INTEGER;

 BEGIN
   IF (show <> 0) AND (K[show]^.connected = FALSE) AND (show <> scanChannel) THEN
    BEGIN
      Lines := checkEmptyLines(show);
      FOR i := 1 TO maxY-Lines-3 DO
       BEGIN
         myText := TRUE;
         _aus(show,CrLf);
       END;
    END;
 END;


BEGIN

  {----------------------------------------------------------------------------
  |
  +---------------------------------------------------------------------------}

END.
