
{------------------------------------------------------------------------------
|
|   In  P R L I B 3 . P A S  sind die Routinen zur Netzverwaltung zusammen-
|   gefat. Auerdem enthalten sind die LogOn- und LogOff-Prozeduren.
|
|   DL1BHO  04/1992
|
|   nderungen
|   ==========
|
|   06/94: Fehler "File not open" beim Login beseitigt (Remote)
|
|   05/94: Behandlung des Kommandos "U 2" fr TF2.6 eingebaut
|
|
+-----------------------------------------------------------------------------}


UNIT  PRLib3;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


USES
       PRDefs;


PROCEDURE SENDTNC (Kanal , Art : BYTE ; Zeile : STRING);
PROCEDURE S_XGCmd (TncNr : Byte; check : BOOLEAN);
PROCEDURE L_Off (Kanal : BYTE);
PROCEDURE L_ON (Kanal, ConType : BYTE);
FUNCTION  RufZeichen (Zeiger : INTEGER ; CONST_Laenge : integer) : Str9;
FUNCTION  Flags : str8;
FUNCTION  Broadcast (Stelle : INTEGER) : str40;
PROCEDURE Net_aus;
FUNCTION  NetPw (Kanal : BYTE ; Parms1 : FuenfString) : Str8;
PROCEDURE PARMS_Auswert (Kanal : BYTE ; Zeile : STRING);
PROCEDURE check_for_connect(Kanal : INTEGER);


IMPLEMENTATION


USES
       Crt,
       PRLib,
       PRLib2,
       PRLib4,
       PRScreen,
{$IFDEF OS2}
       PRV24OS2,
{$ELSE}
       PRV24,
{$ENDIF}
       PRRemote,
       PRCW;


{------------------------------------------------------------------------------
| Eine HOSTMODE-Zeile an den TNC senden, vorher passenden TNC einschalten
| Format:   SENDTNC(KanalNummer,Art(0=Text,1=Kommando),String)
+-----------------------------------------------------------------------------}

PROCEDURE SendTNC (Kanal,Art : BYTE ; Zeile : String);

VAR   Laenge  : char;
      Channel : char;

BEGIN
  IF (Kanal > 0) THEN
    switch_TNC(K[Kanal]^.TNCNummer);
  Laenge := Chr(Length(Zeile)-1);
  Channel := K[Kanal]^.TNCKanal;
  SendKanal := Kanal;
  WRITEaux(Channel + Chr(Art) + Laenge);
  WRITEaux(Zeile);
END;


{------------------------------------------------------------------------------
| Das XHOST-G-Kommando an einen TNC auf Kanal 255 senden, vorher passenden
| TNC einschalten
| Format:   S_XGCmd(TNC-Nummer,check)
+-----------------------------------------------------------------------------}

PROCEDURE S_XGCmd (TncNr : Byte; check : BOOLEAN);

 LABEL  EndeProc;

 VAR    ch           : CHAR;
        i            : INTEGER;
        k            : INTEGER;
        offset       : INTEGER;
        XGCmd_Str    : Str11;      { max. 10 Kanle + Monitor }
        Sync         : BOOLEAN;

BEGIN
  switch_TNC(TncNr);
  WRITEaux(#255#1#0'G');       { G-Kommando auf Kanal 255 }

  KBDLock;

  READaux(ch,Sync);
  IF (ch <> #255) OR NOT Sync THEN
   BEGIN
     IF Klingel THEN
       Beep(800,40);
     KbdFree;
     TextAttr := blinkAttr;
     M_aus('*** (TNC '+int_Str(TncNr)+') wrong channel number '+
           '(S:255 R:'+int_Str(Ord(ch)) + ')!'#13);
     SysDelay(5);
     WHILE Zeichen DO
       READAux(ch,Sync);
     FOR i := 0 TO Kanal_Anzahl DO
       XHost.ChannelInfo[i] := FALSE;
     XHost.Status := -1;
     Goto EndeProc;        { Abbruch... }
   END;

   READaux(ch,Sync);            { Frame-Code, hier uninteressant }
   IF NOT Sync THEN
     Goto EndeProc;
   i := 0;
   REPEAT
     READaux(ch,Sync);
     IF NOT Sync THEN
      BEGIN
        FOR i := 0 TO Kanal_Anzahl DO
          XHost.ChannelInfo[i] := FALSE;
        Goto EndeProc;
      END;
     IF i < 11 THEN
      BEGIN
        Inc(i);
        XGCmd_Str[i] := ch;
      END;
   UNTIL ch = #0;
   XGCmd_Str[0] := CHR(i-1);       { Stringlnge eintragen }
   KBDfree;

   FOR i := 0 TO Kanal_Anzahl DO
     XHost.ChannelInfo[i] := FALSE;

   IF check THEN
    BEGIN
      IF Pos('INVALID',XGCmd_Str) > 0 THEN
        XHost.Status := -1       { invalid channel number, kein XHost }
      ELSE
        XHost.Status := 0;
    END
   ELSE
    BEGIN
      offset := TNC[TncNr].ChannelOffset;
      FOR i := 1 TO Length(XGCmd_Str) DO
       BEGIN
         k := Ord(XGCmd_Str[i]) - 1;
         IF k > 0 THEN
           k := k + offset;        { TurboPR-Kanal treffen }
         IF (k >= 0) AND (k <= Kanal_Anzahl) THEN
           XHost.ChannelInfo[k] := TRUE;
       END;
    END;

EndeProc:

  KbdFree;

END;


{------------------------------------------------------------------------------
| Disconnect-Prozedur
+-----------------------------------------------------------------------------}

PROCEDURE L_Off (Kanal : BYTE);

VAR AMerk      : BYTE;
    i          : INTEGER;
    chx        : CHAR;
    LogFile    : Text;
    TNC_K      : BOOLEAN;      { im TNC ist K1 eingestellt }
    TNC_Date   : Str11;
    TNC_Time   : Str8;
    Zeile      : String;
    subStr     : Str80;
    IOError    : INTEGER;
    qsoEnde    : Str5;

BEGIN
  AMerk := TextAttr;
  WITH K[Kanal]^ DO
  BEGIN
    ResponseStr := cutRightStr(ResponseStr);     { '(x) ' lschen }
    TNC_K := FALSE;
    i := Pos(' - ',ResponseStr);
    IF i <> 0 THEN
    BEGIN
      { TNC-Firmware hat Uhrzeit gesendet }
      TNC_K := TRUE;
      TNC_Date := Copy(ResponseStr,i+3,8);
      IF TNC_Date[3] = '/' THEN         { amerikanisches Format -> DL-Format }
        TNC_Date := Copy(TNC_Date,4,2) + '.' + Copy(TNC_Date,1,2) +
                    '.' + Copy(TNC_Date,7,2);
      TNC_Date := WochenTag(TNC_Date) + ' ' + TNC_Date;
      TNC_Time := Copy(ResponseStr,i+12,8);
      Delete(ResponseStr,i,20);
    END;
    qsoEnde := Copy(Time,1,5);
    IF (NOT Sek15) AND TNC_K THEN qsoEnde := Copy(TNC_Time,1,5);
    TextAttr := low;
    IF (X2 > 1) THEN _aus(Kanal,^M);
    _aus(Kanal,'*** ' + Copy(ResponseStr,1,Length(ResponseStr)-1));
    IF (Sek15 OR TNC_K) AND connected
      THEN _aus(Kanal,' (' + qsoDatum + ' ' + qsoEnde + ')');
    _aus(Kanal,^M^M);

    NCheck := TRUE;
    RemPriv := 0;

    IF FileSend THEN
     BEGIN
       Close(TXFile);
       FileSend := FALSE;
       Status1(Kanal);
     END;

    IF connected THEN
    BEGIN
      connected := FALSE;
      Status2;
      IF Sek15 OR TNC_K THEN
      BEGIN
        IF Klingel AND Sek15 THEN
          IF CW THEN
             Telegrafie('*')   { ...-.- }
           ELSE
             D_Bell;
        Assign(LogFile,SysPfad+'LOG.PR');
        {$I-}
        Reset(LogFile); {$I+}
        IOError := IOResult;
        IF (IOError <> 0) THEN                            {26.11.90}
         BEGIN
           { Logfile nicht vorhanden, also Anlegen versuchen... }
           {$I-}
           Rewrite(LogFile);
           WRITELN(LogFile);
           WRITELN(LogFile,'TurboPR Log:');
           WRITELN(LogFile);
           Close(LogFile);
           Reset(LogFile);  {$I+}
           IOError := IOResult;
         END;
        IF (IOError = 0) THEN
         BEGIN
           IF NOT EOF(LogFile)
             THEN Append(LogFile)
             ELSE Rewrite(LogFile);
           i := Pos(';',ConText);
           IF i = 0
             THEN i := Length(ConText)
             ELSE i := i - 1;
           WRITELN(LogFile,qsoDatum,'  ',qsoBeginn,' - ',qsoEnde,
                   ' ',TNC[K[Kanal]^.TNCNummer].currentQRG,'  ',
                   TNCCall,' > ',Copy(conText,1,i));
           Delete(ConText,1,i);
           Zeile := ' ';
           WHILE Copy(ConText,1,1) = ';' DO
            BEGIN
              Delete(ConText,1,1);
              i := Pos(';',ConText);
              IF i = 0
                THEN i := Length(ConText)
                ELSE i := i-1;
              subStr := Copy(ConText,1,i);
              Delete(ConText,1,i);
              IF (Length(Zeile) + Length(subStr)) < 79 THEN
                Zeile := Zeile + ' ' + subStr
              ELSE
                BEGIN
                  { Zeile wird zu lang }
                  WRITELN(Logfile,Zeile);
                  Zeile := '  ' + subStr;
                END;
            END;
           IF Length(Zeile) > 1 THEN WRITELN(Logfile,Zeile);
           Close(LogFile);
         END;
      END;
      IF Save THEN
       BEGIN
         { Datei nach Disconnect schlieen und u.U. Textdatei wieder ffnen }
         Close(RXFile);
         IF (RX_Mode = 0) THEN
           BEGIN
             IF Remote <> 2 THEN
               OpenRXFile(Kanal)    (* hier knnte 'was schiefgehen... *)
             ELSE
               Save := FALSE;       { Versuch 2.6.94 }
           END
         ELSE
           BEGIN
             Save := FALSE;
             { unfertige Bin-Files wieder lschen }
             {$I-}
             IF (RX_Mode = 2) OR (RX_Mode = 3) THEN
               Erase(RXFile);   {$I+}
             i := IOResult;
           END;
       END;
    END; { IF connected ... }
    TextAttr := AMerk;              { Versuch 22.8.91 }
    Ausgabe := FALSE;
    S_Com(Kanal,'I '+TNCCall);      { Call wieder einstellen }
    Status1(Kanal);
  END; { WITH K[Kanal] ... }
  ScreenTimer := ScreenInit;
END;


{------------------------------------------------------------------------------
|
| Connect-Prozedur
|
| Neu: ConType=0 -> Connect, ConType=1 -> REConnect
|
+-----------------------------------------------------------------------------}

PROCEDURE L_ON (Kanal, ConType : BYTE);

VAR i          : INTEGER;
    Zeile      : String;       { HilfsString }
    TNC_K      : BOOLEAN;      { im TNC ist K1 eingestellt }
    TNC_Date   : Str11;
    TNC_Time   : Str8;

BEGIN
  WITH K[Kanal]^ DO
  BEGIN
    ScreenTimer := ScreenInit;
    IF ScreenSTBY THEN
    BEGIN
      ScreenSTBY := FALSE;
      restore_Screen;
    END;

    TNC_K := FALSE;
    i := Pos(' - ',ResponseStr);
    IF (i <> 0) THEN
    BEGIN
      { TNC V2.1c hat Uhrzeit gesendet }
      TNC_K := TRUE;
      TNC_Date := Copy(ResponseStr,i+3,8);
      IF TNC_Date[3] = '/' THEN     { amerikanisches Format }
        TNC_Date := Copy(TNC_Date,4,2) + '.' + Copy(TNC_Date,1,2) +
                    '.' + Copy(TNC_Date,7,2);
      TNC_Date := WochenTag(TNC_Date) + ' ' + TNC_Date;
      TNC_Time := Copy(ResponseStr,i+12,8);
      Delete(ResponseStr,i,20); { Datum/Uhrzeit abschneiden }
    END;

    newText := FALSE;

    ResponseStr := cutRightStr(ResponseStr);   { '(x) ' abschneiden }
    Call := CutStr(Copy(ResponseStr,14,Length(ResponseStr)-14));
    i := Pos(#13,Call);
    IF (i > 0) THEN Call := Copy(Call,1,i-1);

    IF (Klingel AND Sek15) THEN
     BEGIN
       { Der ganze Klingelkram funktioniert erst
         nach 15 Sek. Programmlaufzeit !           }
       IF connected THEN
        BEGIN
          IF (ConType = 1)
            THEN REC_Bell
            ELSE C_Bell;
        END
       ELSE
        BEGIN
          IF (CW AND fremdConnect) THEN
           BEGIN
             i := Pos('-',Call);
             IF i = 0
               THEN i := Length(Call)
               ELSE Dec(i);
             Telegrafie(Copy(Call,1,i));
           END
          ELSE
           C_Bell;
        END;
     END;

    IF NOT connected THEN
     BEGIN
       { es besteht noch kein Connect }
       qsoDatum := Date;
       qsoBeginn := Copy(Time,1,5);
       IF (NOT Sek15) AND TNC_K THEN
        BEGIN
          qsoDatum := TNC_Date;
          qsoBeginn := TNC_Time;
        END;
       ConText := Copy(ResponseStr,14,length(ResponseStr)-14);
       { Text nur bis zum CR gltig. Vorsicht, Framesammler !?! }
       i := Pos(#13,ConText);
       IF (i > 0) THEN ConText := Copy(ConText,1,i-1);
     END
    ELSE
     BEGIN
       { es besteht schon ein Connect }
       ConText := ConText + ';';
       IF ConType = 0
         THEN ConText := ConText + '>'           { connect }
         ELSE ConText := ConText + 'R>';         { REconnect }
       ConText := ConText + ' ' + Copy(ResponseStr,14,Length(ResponseStr)-14);
       { Text nur bis zum CR gltig. Vorsicht, Framesammler !?! }
       i := Pos(#13,ConText);
       IF (i > 0) THEN ConText := Copy(ConText,1,i-1);
       ConText := ConText + ' (' + Copy(Time,1,5) + ')';
     END;

    IF NOT connected THEN
     BEGIN
       connected := TRUE;
       TextAttr := low;
       _aus(Kanal,'*** ' + Copy(ResponseStr,1,Length(ResponseStr)-1));
       IF Sek15 OR TNC_K THEN _aus(Kanal,' (' + qsoDatum + ' ' + qsoBeginn + ')');
       _aus(Kanal,^M);
       IF (Remote <> 2) AND fremdConnect AND Sek15 THEN
        BEGIN
          WITH TNC[TNCNummer] DO BEGIN
            IF (UCmdStr^[1] = '1') OR (UCmdStr^[1] = '2') THEN
             BEGIN
               Zeile := Copy(UCmdStr^,3,Length(UCmdStr^)-2);
               Zeile := Zeile + #13;
               TX_Out(Kanal,Zeile);
             END;
          END;
        END;
     END;

    Status2;

    FrameCount := 0;
    RemStatus := -1;
    RemPriv := 0;
    PassWort := '';

{    IF (Remote = 2) AND fremdConnect AND Sek15 THEN   }
    IF (Remote = 2) AND Sek15 THEN
     BEGIN
       { Remote-Login bearbeiten }
       IF RemCallOK(Call) THEN RemStatus := 0;
       IF (RemStatus = 0) THEN
        BEGIN
          { Call ist remote-berechtigt }
          IF RemPrivOK(Call) THEN RemPriv := 1;  { Priv-Call }
          RemClearBuffer;
          IF fremdConnect THEN
           BEGIN
             { beim FremdConnect Remote-Login bearbeiten }
             Zeile := RemLoginStr;
             RemConvert(Zeile,Kanal);
             RemPutBuffer(Zeile);
             Zeile := onlyCall(Call);
             IF RemSearchFirst(Zeile+'.*') THEN
              BEGIN
                RemPutBuffer(#13'Achtung, Nachricht(en) fuer Dich!'#13);
                RemCatalog(Kanal,Zeile+'.*');
              END;
             RemPutBuffer(RemPrompt(Kanal));
             IF simplex THEN
               BEGIN
                 S_Com(Kanal,'@X0');
                 S_Com(Kanal,'@M1');
               END;
             RemSendBuffer(Kanal);
           END;
        END
       ELSE
        BEGIN
          { Call nicht remote-berechtigt }
          IF fremdConnect THEN
           BEGIN
             { U.U. U-Text senden, da Call nicht remote-berechtigt }
             WITH TNC[TNCNummer] DO BEGIN
               IF (UCmdStr^[1] = '1') OR (UCmdStr^[1] = '2') THEN
                BEGIN
                  Zeile := Copy(UCmdStr^,3,Length(UCmdStr^)-2);
                  Zeile := Zeile + #13;
                  TX_Out(Kanal,Zeile);
                END;
             END;
           END;   { fremdConnect }
        END;
     END;

    fremdConnect := FALSE;

    IF Auto_cmd THEN
    BEGIN
      IF (cmd_Stufe > end_cmd(cmd_Nummer)) THEN Auto_cmd := FALSE;
      IF Auto_cmd THEN
       BEGIN
         Zeile := Auto_Command(Kanal,cmd_Nummer,cmd_Stufe) + ^M;
         TX_Out(Kanal,Zeile);
         Inc(cmd_Stufe);
       END;
    END;    { Auto_cmd }

    Status1(Kanal);

  END;  { WITH K[Kanal] DO... }

END;  { L_on }


FUNCTION RufZeichen (Zeiger : INTEGER ; CONST_Laenge : INTEGER) : Str9;

VAR  i     : INTEGER;
     b_str : str9;

BEGIN
  b_str := '';
  FOR i := Zeiger TO (Zeiger+5) DO
    IF Response[i] <> #64 THEN
      b_str := b_str + chr(ord(Response[i]) div 2);
  i := (Ord(Response[Zeiger+6]) DIV 2) AND $0F;
  IF (i <> 0) THEN
    b_str := b_str + '-' + int_str(i);
  IF (CONST_Laenge = 1) THEN
    b_str := b_str + Space(9-Length(b_str));
  RufZeichen := b_str;
END;


{------------------------------------------------------------------------------
| Die 4 Flags von TheNet dekodieren
+-----------------------------------------------------------------------------}

FUNCTION Flags;

CONST Flag_str = 'CNMR';  { Choke,NAK,More-follows,Reserved }

VAR   b_str    : str8;
      flgs,i   : INTEGER;

BEGIN
  b_str := '';
  flgs := Ord(Response[20]) shr 4;
  FOR i := 1 TO 4 DO
  BEGIN
    IF flgs mod 2 <> 0
      THEN b_str := Copy(Flag_str,i,1) + b_str
      ELSE b_str := '.' + b_str;
    flgs := flgs shr 1;
  END;
  Flags := ' '+ b_str + ' ';
END;


{------------------------------------------------------------------------------
| Den Broadcast von TheNet auswerten
+-----------------------------------------------------------------------------}

FUNCTION Broadcast (Stelle : INTEGER) : Str40;

 VAR subStr    : Str40;
     subStr1   : Str10;
     i         : INTEGER;

BEGIN
  subStr := '';
  FOR i := (Stelle+7) TO (Stelle+12) DO
    IF Response[i] <> ' ' THEN subStr := subStr + Response[i];
  IF Response[Stelle+7] <> ' ' THEN subStr := subStr + ':';
  subStr := subStr + RufZeichen(Stelle,1);
  subStr := subStr + Space(17-Length(subStr)) + 'via ';
  subStr := subStr + RufZeichen(Stelle+13,1) + ' ';
  str(ord(Response[Stelle+20]),subStr1);
  subStr := subStr + subStr1 + ^M;
  Broadcast := subStr;
END;


PROCEDURE Net_aus;

BEGIN
  M_aus('('+Rufzeichen(1,0)+' > '+RufZeichen(8,0));
  M_aus(' LT:'+int_str(ord(Response[15]))+ ' ');
END;


{------------------------------------------------------------------------------
|
|  Nach einem Sysop-Kommando das Passwort suchen
|
+-----------------------------------------------------------------------------}

FUNCTION NetPw (Kanal : BYTE ; Parms1 : FuenfString) : Str8;

VAR NetPWFile      : Text;
    Zeile          : Str128;
    Call_gefunden  : BOOLEAN;
    SuchCall1      : Str10;
    SuchCall2      : Str10;
    i,i1,r         : INTEGER;
    subStr         : Str8;

BEGIN
  subStr := '';
  IF NetPWFileOK THEN
  BEGIN
    Assign(NetPWFile,SysPfad+'NETPW.PR');
    {$I-}
    Reset(NetPWFile);  {$I+}
    IF (IOResult <> 0) THEN Exit;
    Call_gefunden := FALSE;
    SuchCall1 := K[Kanal]^.Call + ' ';
    SuchCall2 := K[Kanal]^.Call;
    i := Pos('-',SuchCall2);
    IF (i > 0) THEN SuchCall2 := Copy(SuchCall2,1,i) + '*';
    SuchCall2 := SuchCall2 + ' ';
    REPEAT
      READLN(NetPWFile,Zeile);
      Zeile := Zeile + ' ';
      IF (Pos(SuchCall1,Zeile) > 0) OR (Pos(SuchCall2,Zeile) > 0)
        THEN Call_gefunden := TRUE;
    UNTIL Call_gefunden OR Eof(NetPWFile);
    subStr := '';
    IF Call_gefunden THEN
    BEGIN
      READLN(NetPWFile,Zeile);
      FOR i := 1 TO 5 DO
      BEGIN
        val(Parms1[i],i1,r);
        IF r <> 0 THEN i1 := 1;
        subStr := subStr + Zeile[i1];
      END;
    END;
    Close(NetPWFile);
  END;
  NetPW := subStr;
END;


{------------------------------------------------------------------------------
| Auswerten der Netzknoten-Parameter und des Sysop-Kommandos
|
| nderung fr TheNet 1.16 mit 30 Parametern  (08/1990)
+-----------------------------------------------------------------------------}

PROCEDURE PARMS_Auswert (Kanal : BYTE ; Zeile : String);

VAR  i,y,z         : INTEGER;
     Parms         : ARRAY [1..30] OF String [5];
     Parms1        : FuenfString ABSOLUTE Parms;
     AMerk         : BYTE;
     parms_count   : BYTE;
     Fehler        : BOOLEAN;
     subStr        : Str20;
     subStr80      : Str80;

 FUNCTION Parm_Str(i : BYTE; Name : Str25) : Str25;
 VAR  subStr    : Str20;
      l         : INTEGER;
 BEGIN
   subStr := Int_Str(i);
   IF (i < 10) THEN subStr := '0' + subStr;
   subStr := subStr + ' ' + Name + ' ';
   l := Length(subStr) + Length(Parms[i]);
   Parm_Str := subStr + Space(20-l) + Parms[i] + '     ';
 END;

BEGIN
  AMerk := TextAttr;
  FOR i := 1 TO length(Zeile) DO
  BEGIN
    IF Zeile[i] = #13 THEN Zeile[i] := ' ';
  END;
  Fillchar(Parms,Sizeof(Parms),#0);
  z := 1;
  FOR i := 1 TO 30 DO
  BEGIN
    WHILE (Zeile[Z] <> ' ') and (Z <= Length(Zeile)) DO
    BEGIN
      Parms[i] := Parms[i] + Zeile[Z];
      Inc(z);
    END;
    Inc(z);        { Space ueberspringen }
  END;

  parms_count := 0;
  REPEAT
    Inc(parms_count);
  UNTIL (parms_count = 30) OR (Parms[parms_count] = '');
  IF (Parms[parms_count] = '') THEN Dec(parms_count);

  Fehler := FALSE;
  FOR i := 1 TO parms_count DO
   BEGIN
     { prfen, ob jeder Parameter ein numerischer Wert ist }
     Val(Parms[i],y,z);
     IF (z <> 0) THEN Fehler := TRUE;
   END;

  IF NOT Fehler THEN
   BEGIN
     { alle erkannten Parameter sind numerisch, scheint also ok zu sein ... }

     IF (parms_count >= 24) THEN
      BEGIN
        { mindestens 24 Parameter erkannt }
        TextAttr := norm;
        _aus(Kanal,^M + 'Net-Parameter-Auswertung:' + ^M^M);
        TextAttr := low;

        _aus(Kanal,Parm_str(1,'Max-Nodes') + Parm_str(2,'Min-Quality'));
        _aus(Kanal,Parm_str(3,'HF-Quality') + ^M);
        _aus(Kanal,Parm_str(4,'V24-Quality') + Parm_str(5,'Obs-Init'));
        _aus(Kanal,Parm_str(6,'Min-BCast') + ^M);
        _aus(Kanal,Parm_str(7,'Broadcast') + Parm_str(8,'Lifetime'));
        _aus(Kanal,Parm_str(9,'T-Timeout') + ^M);
        _aus(Kanal,Parm_str(10,'T-Retry') + Parm_str(11,'T-AckDelay'));
        _aus(Kanal,Parm_str(12,'T-BsyDelay') + ^M);
        _aus(Kanal,Parm_str(13,'T-Window') + Parm_str(14,'NoAckBuf'));
        _aus(Kanal,Parm_str(15,'Timeout') + ^M);

        IF (parms_count = 24) THEN
         BEGIN
           { NET/ROM 1.0 bis 1.2 }
           _aus(Kanal,Parm_str(16,'DWait') + Parm_str(17,'FrAck'));
           _aus(Kanal,Parm_str(18,'MaxFame') + ^M);
           _aus(Kanal,Parm_str(19,'L2-Retry') + Parm_str(20,'T2-Timer'));
           _aus(Kanal,Parm_str(21,'T3-Timer') + ^M);
           _aus(Kanal,Parm_str(22,'L2-Digi') + Parm_str(23,'CallCheck'));
           _aus(Kanal,Parm_str(24,'ID-Beacon' + ^M));
         END;

        IF (parms_count >= 26) THEN
         BEGIN
           { NET/ROM 1.3 und TheNet }
           _aus(Kanal,Parm_str(16,'Persistance') + Parm_str(17,'SlotTime'));
           _aus(Kanal,Parm_str(18,'FrAck') + ^M);
           _aus(Kanal,Parm_str(19,'MaxFrame') + Parm_str(20,'L2-Retry'));
           _aus(Kanal,Parm_str(21,'T2-Timer') + ^M);
           _aus(Kanal,Parm_str(22,'T3-Timer') + Parm_str(23,'L2-Digi'));
           _aus(Kanal,Parm_str(24,'CallCheck') + ^M);
           _aus(Kanal,Parm_str(25,'ID-Beacon'));
           IF (parms_count > 25) THEN
             _aus(Kanal,Parm_str(26,'CQ-UI-Frame'));
           IF (parms_count = 30) THEN
            BEGIN
              { TheNet 1.16 }
              _aus(Kanal,Parm_Str(27,'FullDuplex') + #13);
              _aus(Kanal,Parm_Str(28,'PausenFlag'));
              _aus(Kanal,Parm_Str(29,'TXDelay'));
              { Flags in Parameter #30 auswerten }
              Val(Parms[30],y,z);
              subStr := Bin(y,16);
              Delete(subStr,2,4);
              Insert('xxxx',subStr,2);
              Insert('.',subStr,9);
              _aus(Kanal,#13 + '30 Flags:  ' + subStr);
            END;
           _aus(Kanal,#13);
         END;

        _aus(Kanal,^M);
      END;

     IF (parms_count = 5) THEN
      BEGIN
        { 5 Parameter ... wird wohl ein Sysop-Kommando gewesen sein }
        TextAttr := low;
        _aus(Kanal,'Net-SYSOP-Kommando!' + ^M);
        subStr := NetPw(Kanal,Parms1);
        IF subStr <> '' THEN
         BEGIN
           { PW gefunden, also zum Aussenden vorschlagen }
           WITH K[Kanal]^ DO
            BEGIN
              EditLine^[actEditLine] := subStr;
              X1 := Succ(Length(subStr));   { Cursor positionieren }
              IF (Kanal = show) THEN
               BEGIN
                 restoreEditLines;
{                 SetEditCursor;    }
               END;
            END;
         END;
      END;    { parms_count = 5 }

   END;   { IF NOT Fehler ... }

  TextAttr := AMerk;
END;


{-----------------------------------------------------------------------------
|
|  ResponseStr auf 'Connected to' und 'Reconnected to' untersuchen
|
|  Neue Strategie, untersttzt wird erstmal nur TheNet, NetRom und
|  RMNC/FlexNet
|
+----------------------------------------------------------------------------}

PROCEDURE check_for_connect(Kanal : INTEGER);

 VAR   i, i1          : INTEGER;
       C_Type         : INTEGER;
       CPos           : INTEGER;
       FPos           : INTEGER;
       C_ok           : BOOLEAN;
       Call1, Call2   : Str9;
       Call3          : Str9;
       subStr         : String;

 BEGIN
   C_ok := FALSE;
   CPos := Pos('onnected to ',ResponseStr);
   IF (CPos > 0) THEN
    BEGIN
      { Connect-Meldung im empfangenen Text, also genauer forschen... }
      subStr := Copy(ResponseStr,CPos+12,100);   { Rest des Strings }
      Call1 := onlyCall(K[Kanal]^.Call);
      IF (Copy(ResponseStr,CPos-5,5) = '*** c') AND
        ((CPos=6) OR (ResponseStr[CPos-6]=#13)) THEN
       BEGIN
         { '*** connected to ' von RMNC/FlexNet am Frameanfang oder am }
         { Zeilenanfang }
         C_Type := 0;
         C_ok := TRUE;
       END
      ELSE
       BEGIN
         { tja, das war wohl nichts, also weiter versuchen... }
         IF (Copy(ResponseStr,CPos-7,7) = '*** rec') AND
           ((CPos=8) OR (Response[CPos-8]=#13)) THEN
          BEGIN
            { '*** reconnected to ' von RMNC/FlexNet am Frameanfang oder }
            { am Zeilenanfang }
            C_Type := 1;
            C_ok := TRUE;
          END
         ELSE
          BEGIN
            { kein RMNC/FlexNet, also TheNet/NetRom?!?... }
            IF (Copy(ResponseStr,CPos-4,4) = ' Rec') AND
              ((ResponseStr[CPos-5]='>') OR (ResponseStr[CPos-5]='}') OR
               (ResponseStr[CPos-5]='!')) THEN
             BEGIN
               { das mu wohl ein Reconnect von TheNet oder NetRom sein... }
               { Call-Check wird vorsichtshalber nicht durchgefhrt }
               C_Type := 1;
               C_ok := TRUE;
             END
            ELSE
             BEGIN
               { dann bleibt nur noch ein Connect von TheNet/NetRom... }
               C_Type := 0;
               IF (Copy(ResponseStr,CPos-2,2) = ' C') AND
                 ((ResponseStr[CPos-3]='>') OR (ResponseStr[CPos-3]='}')) THEN
                BEGIN
                  { wirklich ein Connect? das wollen wir erstmal sehen... }
                  i := CPos-3;  { i zeigt auf das '>' }
                  REPEAT
                    Dec(i);
                  UNTIL (i=0) OR (ResponseStr[i]=' ') OR (ResponseStr[i]=#13);
                  Inc(i);
                  Call2 := onlyCall(Copy(ResponseStr,i,CPos-i-3));
                  Call3 := onlyIdent(Copy(ResponseStr,i,CPos-i-3));
                  IF (Call1 = Call2) OR (Call1 = Call3) THEN C_ok := TRUE;
                END;
             END;
          END;
       END;

      IF C_ok THEN
       BEGIN
         i := Pos(':',subStr);
         i1 := Pos(#13,subStr);            { CR }
         IF i1 = 0 THEN i1 := Length(subStr);
         IF (i > 0) AND (i < i1) THEN Delete(subStr,1,i);
         { TurboPR einen 'richtigen' Connect vorgaukeln ... }
         ResponseStr := '(x) CONNECTED to ' + subStr;
         L_ON(Kanal,C_Type);
       END;
    END; { Net-Connect }

   IF K[Kanal]^.auto_cmd THEN
    BEGIN
      FPos := Pos('ailure with ',ResponseStr);
      IF (FPos > 0) THEN
       BEGIN
         { Auto_Cmd abbrechen bei Failure }
         K[Kanal]^.auto_Cmd := FALSE;
         Status1(Kanal);
       END;
    END;

 END;



BEGIN

  {---------------------------------------------------------------------------
  |  Unit-Initialisierung (nicht erforderlich)
  +--------------------------------------------------------------------------}

END.
