
{------------------------------------------------------------------------------
|
|  P R L I B 4 . P A S
|
|  DL1BHO  04/1994
|
+-----------------------------------------------------------------------------}


UNIT  PRLib4;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE

USES
      PRDefs;

PROCEDURE Uhr_aus;
PROCEDURE Init_TNCs;
PROCEDURE DeInit_TNCs;
PROCEDURE TX_out(Kanal : BYTE; Zeile : String);
PROCEDURE GetTNC;
PROCEDURE S_Com (Kanal : BYTE ; Zeile : STRING);
PROCEDURE S_Text (Kanal : BYTE ; Zeile : STRING);
PROCEDURE DO_XHost;
PROCEDURE DO_polling;
PROCEDURE Moni_off;
PROCEDURE restore_MoniStatus;
FUNCTION  UnprotoStr : Str20;
PROCEDURE get_UCmdStr (TNCNummer : INTEGER);
PROCEDURE do_Ucommand (Zeile : String; TNCNummer : INTEGER);


IMPLEMENTATION


USES
       Dos,
       Crt,
       PRScreen,
{$IFDEF OS2}
       PRV24OS2,
{$ELSE}
       PRV24,
{$ENDIF}
       PRArpa,
       PRPass,
       PRLib,
       PRLib2,
       PRLib3,
       PRRemote,
       PRTast,
       PRCRC;


CONST
       Init        = 1;
       DeInit      = 2;

{       _BChar      : ARRAY [0..3] OF CHAR = (#30,#16,#31,#17);   }
       _BChar      : ARRAY [0..3] OF CHAR = (#30,#31,#30,#31);


{------------------------------------------------------------------------------
| Uhr_aus gibt jede Sekunde die aktuelle Uhrzeit auf der Statuszeile aus.
+-----------------------------------------------------------------------------}

PROCEDURE Uhr_aus;

VAR   Zeit        : Str8;
      i           : INTEGER;
      any_connect : BOOLEAN;

BEGIN

  Zeit := Time;

{$IFDEF OS2}
  Status1Out(show,MaxX-8,neg,Zeit);    { OS/2 Aktivitt vorgaukeln... }
{$ENDIF}

  IF Zeit[8] = OldTime[8] THEN Exit;   { Sekunden haben sich nicht gendert }

  { Hier ist 1 Sekunde vorbei }
  OldTime[8] := Zeit[8];
  Status1Out(show,MaxX-8,neg,Zeit);

  IF NOT Sek15 THEN
   BEGIN
     Dec(Sek15Counter);
     IF (Sek15Counter = 0) THEN
      BEGIN
        Sek15 := TRUE;                          { 15 sec. Programmlaufzeit }
{       IF (show = 0) THEN Status1(show);    }
      END;
   END;

  IF (Zeit[7] = OldTime[7]) OR (Zeit[7] = '6') THEN Exit;
  { Hier sind volle 10 Sekunden erreicht }
  OldTime[7] := Zeit[7];
  IF ScreenStby THEN Stby_Logo;

  IF Zeit[5] = OldTime[5] THEN Exit;
  { Hier ist eine volle Minute erreicht }
  OldTime[5] := Zeit[5];
  Inc(LaufZeit);
  IF NOT ScreenSTBY AND (ScreenInit <> 0) THEN
   BEGIN
     any_connect := FALSE;
     FOR i := 1 TO Kanal_Anzahl DO
       IF (K[i]^.LinkState > 0) THEN
         any_connect := TRUE;
     IF NOT any_connect and (show <> 0) AND (show <> ScanChannel) THEN
       BEGIN
         Dec(ScreenTimer);
         IF (ScreenTimer = 0) THEN
           BEGIN
             { Bildschirmschoner aktivieren }
             ScreenSTBY := TRUE;
             Stby_X := 1;
             Stby_Y := 1;

             ClearEditCursor;

             SetBorderColor(0);

             NormVideo;
             ClrScr;
             Stby_Logo;
           END;
       END
     ELSE
       ScreenTimer := ScreenInit;
   END;

  IF Zeit[4] = OldTime[4] THEN Exit;
  { Hier sind volle 10 Minuten erreicht }
  OldTime[4] := Zeit[4];

  IF Zeit[2] = OldTime[2] THEN Exit;
  { Hier ist eine volle Stunde erreicht }
  OldTime[2] := Zeit[2];

  IF Zeit[1] = OldTime[1] THEN Exit;
  { Hier sind volle 10 Stunden erreicht }
  OldTime[1] := Zeit[1];

END;


{------------------------------------------------------------------------------
| InputZeile nach einem RETURN bearbeiten
+-----------------------------------------------------------------------------}

PROCEDURE TX_out(Kanal : BYTE; Zeile : String);
 VAR AMerk    : BYTE;
BEGIN
  WITH K[Kanal]^ DO BEGIN
    AMerk := TextAttr;
    TextAttr := conTXAttrib;
    IF (Kanal = 0) THEN switch_TNC(unproto);
{    Auto_cmd := FALSE;  }
    IF (Kanal <> 0) THEN
     BEGIN
       myText := TRUE;
       IF localEcho THEN
        BEGIN
          IF (Drucker = Kanal) THEN WRITElst(Printer1[7]);
          _aus(Kanal,Zeile);
          IF (Drucker = Kanal) THEN WRITElst(Printer1[8]);
        END;
       myText := FALSE;
     END;

    IF (Length(Zeile) > PacLen) THEN
      REPEAT
        S_Text(Kanal,Copy(Zeile,1,PacLen));
        Delete(Zeile,1,PacLen);
      UNTIL Length(Zeile) <= PacLen;
    S_Text(Kanal,Zeile);

    TextAttr := AMerk;
  END;  { WITH K[Kanal]^ }
END;  { TX_out }


{-----------------------------------------------------------------------------
| Entweder die Init- oder die DeInit-Kommandos aus CMD.PR an die TNCs
| schicken.
+----------------------------------------------------------------------------}

PROCEDURE Send_CMDs (what : Byte);

 VAR   CmdFile    : Text;
       Zeile      : String;
       i,p        : INTEGER;
       TNCNr      : INTEGER;
       CmdFound   : BOOLEAN;

 BEGIN
   CmdFound := FALSE;
   Assign(CmdFile,SysPfad+'CMD.PR');
   {$I-}
   Reset(CmdFile);   {$I+}
   IF (IOResult = 0) THEN
    BEGIN
      REPEAT
        Readln(CmdFile,Zeile);
        IF (Length(Zeile) > 0) AND (Zeile[1] <> '#') THEN
         BEGIN
           IF ((what = Init) AND (Copy(upcaseStr(Zeile),1,4) = 'INI=')) OR
              ((what = DeInit) AND (Copy(upcaseStr(Zeile),1,4) = 'DEI=')) THEN
            BEGIN
              CmdFound := TRUE;
              Delete(Zeile,1,4);
              TNCNr := Ord(Zeile[1]) - 48;
              IF (TNCNr < 1) OR (TNCNr > 4) THEN TNCNr := 0;
              IF (TNCNr <> 0) THEN Delete(Zeile,1,1);  { TNC-Nr abtrennen }
              WHILE (Copy(Zeile,1,1) = ' ') DO
                Delete(Zeile,1,1);      { fhrende Spaces kappen }
              p := Pos('\n',Zeile);
              WHILE (p > 0) DO
               BEGIN
                 Delete(Zeile,p,2);
                 Insert(#13,Zeile,p);
                 p := Pos('\n',Zeile);
               END;
              IF (TNCNr = 0) THEN
               BEGIN
                 { Kommando an ALLE TNCs schicken }
                 FOR i := 1 TO 4 DO
                   IF TNC[i].used THEN
                    BEGIN
                      switch_TNC(i);
                      S_Com(0,Zeile);
                    END;
               END
              ELSE
               BEGIN
                 { Kommando nur an EINEN TNC schicken }
                 IF TNC[TNCNr].used THEN
                  BEGIN
                    switch_TNC(TNCNr);
                    S_Com(0,Zeile);
                  END;
               END;
            END;
         END;
      UNTIL Eof(CmdFile);
      Close(CmdFile);
    END;
   IF NOT CmdFound THEN
    BEGIN
      { es wurde in der ganzen CMD-Datei kein Kommando gefunden! }
      WRITE('CMDFile-Error! ',Bell);
      SysDelay(Sec2);
    END;
 END;


{-----------------------------------------------------------------------------
| - alle angeschlossenen TNCs in den Hostmode schalten
| - Speicher fr MH-Liste anfordern
| - wenn mglich, dann bei V2.1c die Software-Uhren stellen
| - Init-Kommandos an die TNCs schicken
| - Test auf Simplex-Kanal (Test!)
| - Rufzeichen auf jedem Kanal stellen
| - XHost-Fhigkeit feststellen
+----------------------------------------------------------------------------}

PROCEDURE Init_TNCs;

 VAR   i           : INTEGER;
       TNC_Count   : INTEGER;
       Dummy       : Char;
       Sync        : BOOLEAN;

 BEGIN

   TNC_Count := 0;

   FOR i := 1 TO 4 DO
   BEGIN
     IF TNC[i].used THEN
     BEGIN
       { dieser TNC ist in Gebrauch, also los... }
       Inc(TNC_Count);
       GotoXY(1,maxY);
       ClrEOL;
       WRITE('TNC ',i,'  ');
       IF (TNC[i].RS232 = 5) THEN
         WRITE('(TFPCR/TFPCX-Treiber)')
       ELSE
         WRITE('(COM',TNC[i].RS232,'/Port',TNC[i].RS232_Switch,')');
       switch_TNC(i);
       WRITEaux(^X^X);
       Delay(2*DelayCorr);
       WRITEaux(cmd_char + 'MN'#13);
       Delay(1*DelayCorr);
       WRITEaux(cmd_char + 'JHOST1'#13);
       SysDelay(18);    { ca. 1 Sekunde warten }
       WHILE Zeichen DO READaux(Dummy,Sync);
       WRITE('  ist im Hostmode');
       unproto := i;
       Channel0 := i;
       { Uhr in jedem TNC stellen, falls mglich }
       Ausgabe := FALSE;                { ev. Fehlerausgabe unterdruecken }
       S_Com(0,'K' + Copy(Datum,4,8));
       IF ResponseStr = 'ok' THEN BEGIN
         { TNC hat V2.1c, also Uhr stellen und ev. einschalten (K1) }
         S_Com(0,'K' + Zeit);
         Ausgabe := FALSE;
         S_Com(0,'K');
         IF Response[1] = '0' THEN S_Com(0,'K1');  { Uhr einschalten }
       END;

       S_XGCmd(i,TRUE);        { prfen, ob TNC XHost-fhig ist }
       IF (XHost.Status = 0) THEN
         TNC[i].XHOSTok := TRUE;

     END;
   END;

   multiTNC := (TNC_Count > 1);
{
   unproto := 1;
   WHILE (NOT TNC[unproto].used) DO Inc(unproto);
   Channel0 := unproto;
   switch_TNC(unproto);
}
   ClrScr;
   restore_Screen;

   Send_CMDs(Init);

   FOR i := 1 TO 4 DO
     IF TNC[i].used THEN get_UCmdStr(i);

   FOR i := 1 TO Kanal_Anzahl DO
    BEGIN
      { Test auf Simplex-Kanal (Test!) }
      Ausgabe := FALSE;
      S_Com(i,'@X');
      IF Pos('INVALID',ResponseStr) = 0 THEN
        K[i]^.simplex := TRUE;
      { Call auf jedem Kanal einstellen }
      Ausgabe := FALSE;
      IF StatusFileOK THEN
        S_Com(i,'I ' + K[i]^.TNCCall)
      ELSE
        BEGIN
          { Call des TNCs erfragen }
          S_Com(i,'I');
          K[i]^.TNCCall := Copy(ResponseStr,1,Length(ResponseStr)-1);
        END;
      M_aus('(' + int_Str(i) + ') ');
      IF (i < 10) THEN
        M_aus(' ');
      Ausgabe := FALSE;
      S_Com(i,'I');
      M_aus(ResponseStr);
    END;
   M_aus(' '+^M);

 END;


{-----------------------------------------------------------------------------
| alle TNCs de-initialisieren
+----------------------------------------------------------------------------}

PROCEDURE DeInit_TNCs;

 VAR  i         : Integer;
      ch_in     : Char;
      Sync      : BOOLEAN;

 BEGIN
   FOR i := 1 TO 4 DO
     IF TNC[i].used THEN
      BEGIN
        switch_TNC(i);
        S_Com(0,'U '+Copy(TNC[i].UCmdStr^,1,1));
      END;
   Send_CMDs(DeInit);
   FOR i := 1 TO 4 DO
   BEGIN
     IF TNC[i].used THEN
     BEGIN
       switch_TNC(i);
       S_Com(0,'MN');                     { Monitor ausschalten }
       S_Com(0,'JHOST0');                 { Hostmode verlassen }
       SysDelay (5);                      { vorsichtshalber warten }
       WHILE Zeichen DO                   { Schnittstelle leeren }
         ReadAux(ch_in,Sync);
     END;
   END;

 END;


{-----------------------------------------------------------------------------
|  einen String (null-terminiert) vom TNC abholen und ein CR anfgen
+----------------------------------------------------------------------------}

PROCEDURE get_null_term;

 VAR   i     : INTEGER;
       ch    : Char;
       Sync  : BOOLEAN;

 BEGIN
   i := 1;
   REPEAT
     READaux(ch,Sync);
     IF (i < 256) THEN
       Response[i] := ch;
     Inc(i);
   UNTIL ch = #0;
   KbdFree;
   Dec(i);
   IF (i > 255) THEN
     i := 255;
   Response[i] := #13;           { Zeile mit <CR> abschliessen }
   Response[0] := chr(i);        { String-Lnge eintragen }
 END;


{-----------------------------------------------------------------------------
|  einen String (Byte-Count) vom TNC abholen
+----------------------------------------------------------------------------}

PROCEDURE get_byte_count (VAR Count : INTEGER);

 VAR   i       : INTEGER;
       ch      : Char;
       Sync    : BOOLEAN;

 BEGIN
   READaux(ch,Sync);
   Count := Ord(ch) + 1;
   FOR i := 1 TO Count DO
    BEGIN
      READaux(Response[i],Sync);
      IF NOT Sync THEN
       BEGIN
         Count := 0;
         ResponseStr := '';
       END;
    END;
   KbdFree;
   IF Count > 255 THEN
     { das Frame hatte 256 Zeichen ! }
     Response[0] := #255
   ELSE
     Response[0] := Chr(Count);
 END;


{------------------------------------------------------------------------------
| GetTNC : TNC-Nachricht abholen und entsprechend auswerten.
| Diese Routine wird hauptschlich nach einem SENDTNC angesprochen.
+-----------------------------------------------------------------------------}

PROCEDURE GetTNC;

VAR   i,i1,i2,i3 : INTEGER;
      Kanal      : INTEGER;
      Code       : INTEGER;
      Count      : INTEGER;
      TNC_K      : BOOLEAN;
      ch         : CHAR;
      AttrStore  : BYTE;
      LSM        : INTEGER;
      NetCtrl    : INTEGER;
      subStr     : String;
      subStr1    : Str10;
      FXPos,
      FYPos      : INTEGER;
      OldResync  : LongInt;
      Sync       : BOOLEAN;

BEGIN { getTNC }
  Code5 := FALSE;
  ResponseStr := '';        { NEU }
{  OldResync := Resync_Z;  }
  AttrStore := TextAttr;
  READaux(ch,Sync);              { Kanalnummer }
  Kanal := SendKanal;
  IF NOT Sync THEN
   BEGIN
     KbdFree;
     Exit;           { Resync bei Kanalnummer }
   END;
  IF (ch <> K[Kanal]^.TNCKanal) THEN
  BEGIN
    IF Klingel THEN
      Beep(800,40);
    KbdFree;
    TextAttr := blinkAttr;
    M_aus('*** (TNC '+int_Str(K[Kanal]^.TNCNummer)+') a wrong channelnumber '+
          '(S:'+Int_Str(ord(K[Kanal]^.TNCKanal)) +
          ' R:'+int_Str(Ord(ch)) + ')!'#13);
    SysDelay(5);
    WHILE Zeichen DO
      READAux(ch,Sync);
    EXIT;               { ************** >>>>>>>>>>>>>>>> }
  END;
  READaux(ch,Sync);
  IF NOT Sync THEN
   BEGIN
     KbdFree;
     Exit;           { Resync bei FrameCode }
   END;
  Code := ord(ch);
  WITH K[Kanal]^ DO
  BEGIN
    case Code of
     0 : BEGIN
           { success, no info }
           { einfach garnichts machen und sich freuen ... hi }
           ResponseStr := 'ok';
           Ausgabe := TRUE;
           KbdFree;
         END;

     1,2
       : BEGIN
           { success or failure with info, null-terminateld }
           { Anzeige in einem Fenster (neu)                 }
           get_null_term;
           IF Ausgabe THEN
            BEGIN
              IF (Copy(ResponseStr,Length(ResponseStr),1) = #13) THEN
                Dec(ResponseStr[0]);

              IF Klingel AND (Code = 2) THEN
               BEGIN
                 beep(220,100);
                 Delay(15*DelayCorr);
                 beep(220,100);
               END;

              IF (Code = 1) THEN
                timedWindow(0,5,FHighAttr,ResponseStr)
              ELSE
                timedWindow(0,5,FBlinkAttr,ResponseStr);

            END;
           Ausgabe := TRUE;
         END;

     3 : BEGIN
           { Link Status (null-terminated) }
           get_null_term;

           IF (Copy(ResponseStr,1,2) = '* ') THEN Delete(ResponseStr,1,2);

           IF Pos('BUSY',ResponseStr) <> 0 THEN LSM := 1 ELSE
           IF Pos('CONNECTED to',ResponseStr) <> 0 THEN LSM := 2 ELSE
           IF Pos('LINK RESET fm',ResponseStr) <> 0 THEN LSM := 3 ELSE
           IF Pos('LINK RESET to',ResponseStr) <> 0 THEN LSM := 4 ELSE
           IF Pos('DISCONNECTED fm',ResponseStr) <> 0 THEN LSM := 5 ELSE
           IF Pos('LINK FAILURE',ResponseStr) <> 0 THEN LSM := 6 ELSE
           IF Pos('CONNECT REQUEST',ResponseStr) <> 0 THEN LSM := 7 ELSE
           IF Pos('REJECT fm',ResponseStr) <> 0 THEN LSM := 8 ELSE
           IF Pos('REJECT to',ResponseStr) <> 0 THEN LSM := 9 ELSE
           LSM := 0;

           TextAttr := low;

           case LSM of
            1 : BEGIN
                  { BUSY fm ... }
                  ResponseStr := cutRightStr(ResponseStr);
                  _aus(Kanal,'*** ' + ResponseStr);
                  IF Auto_cmd THEN
                   BEGIN
                     Auto_cmd := FALSE;
                     Status1(Kanal);
                   END;
                END;
            2 : BEGIN
                  { CONNECTED TO ... }
                  L_ON(Kanal,0);
                END;
            3 : BEGIN
                  { LINK RESET fm ... }
                  ResponseStr := cutRightStr(ResponseStr);
                  _aus(Kanal,'*** ' + ResponseStr);
                END;
            4 : BEGIN
                  { LINK RESET TO ... }
                  ResponseStr := cutRightStr(ResponseStr);
                  _aus(Kanal,'*** ' + ResponseStr);
                END;
            5 : BEGIN
                  { DISCONNECTED }
                  L_Off(Kanal);
                END;
            6 : BEGIN
                  { LINK FAILURE WITH ... }
                  L_Off(Kanal);
                END;
            7 : BEGIN
                  { CONNECT REQUEST fm ... }
                  IF not ScreenSTBY THEN
                  BEGIN
                    IF Klingel THEN beep(600,70);
                    timedWindow(3,10,FBlinkAttr,
                       Channel_ID(Kanal) +
                       Copy(ResponseStr,1,Length(ResponseStr)-1));
                  END;
                END;
            8 : BEGIN
                  { FRAME REJECT fm ... }
                  ResponseStr := cutRightStr(ResponseStr);
                  _aus(Kanal,'*** ' + ResponseStr);
                END;
            9 : BEGIN
                  { FRAME REJECT TO ... }
                  ResponseStr := cutRightStr(ResponseStr);
                  _aus(Kanal,'*** ' + ResponseStr);
                END;
            0 : BEGIN
                  { Unbekannt }
                  IF Klingel THEN WRITE(^G);
                  TextAttr := blinkAttr;
                  _aus(Kanal,'*** unknown LinkStatusMessage: ' + ResponseStr);
                END;
           END;
         END;
     4 : BEGIN
           { Monitor header, no info (null-terminated) }
           get_null_term;
           Response[0] := PRED(Response[0]);           { CR abtrennen }
           adjust_Header(ResponseStr);
           TNC_K := (Pos(' - ',ResponseStr) <> 0);     { K auf 2 gesetzt ? }
           MH_Update;
           IF (Drucker = 0) THEN WRITElst(Printer1[1]);
           TextAttr := TNC[active_TNC].HeaderAttr;
           M_aus(Channel_ID(Kanal));
           M_aus(ResponseStr);
           IF (Time_stamp AND NOT TNC_K) THEN M_aus(' (' + Time + ')');
           M_aus(^M);
           IF (Drucker = 0) THEN WRITElst(Printer1[2]);
         END;
     5 : BEGIN
           { Monitor header WITH info (null-terminated) }
           get_null_term;
           Response[0] := PRED(Response[0]);          { CR abtrennen }
           adjust_Header(ResponseStr);
           TNC_K := (Pos(' - ',ResponseStr) <> 0);    { K auf 2 gesetzt ? }
           MH_Update;
           i := pos('pid',ResponseStr);
           VAL('$'+Copy(ResponseStr,i+4,2),PID,i);      { PID bestimmen }
           IF (Drucker = 0) THEN WRITElst(Printer1[1]);
           TextAttr := TNC[active_TNC].HeaderAttr;
           M_aus(Channel_ID(Kanal));
           M_aus(ResponseStr);
           IF (Time_stamp and not TNC_K) THEN M_aus(' (' + Time + ')');
           M_aus(^M);
           IF (Drucker = 0) THEN WRITElst(Printer1[2]);
           IF (ScanChannel > 0) THEN
            BEGIN
              FOR i := 1 TO 2 DO
                BEGIN
                  { es soll gescannt werden, also los }
                  IF (Length(Scan[i].SuchString) > 0) THEN
                    IF (Copy(ResponseStr,1,Length(Scan[i].SuchString)) =
                      Scan[i].SuchString) THEN
                    ScanMatch := i;
                END;
              IF (ScanMatch > 0) THEN
               BEGIN
                 { Sende-Folgenummer feststellen }
                 i := Pos('ctl I',ResponseStr);
                 IF (i > 0) THEN
                  BEGIN
                    { Info-Frame, also Folgenummer holen }
                    Scan[ScanMatch].INr := ORD(Response[i+6])-48;
                  END;
               END;
            END;
(*
           KBDlock;
           SENDTNC(Kanal,1,'G');
           getTNC;   { Monitor-Info abholen, rekursiver Aufruf... auweia... }
           KBDfree;
*)
           Code5 := TRUE;       { melden, da Monitor-Infos anstehen }

         END;
     6 : BEGIN
           { Monitor info (BYTE count) }
           get_byte_count(Count);

           IF (Drucker = 0) THEN
             WRITElst(Printer1[3]);

           CASE PID OF

            $CF :
              BEGIN
                { TheNet bzw. NET/ROM Frame-Auswertung }
                ScanMatch := 0;
                IF Response[1] = #255 THEN
                 BEGIN
                   { Broadcast auswerten }
                   TextAttr := MoniInfoAttr;
                   M_aus('(Net-Broadcast fm ');
                   IF Response[2] <> ' ' THEN
                    BEGIN
                      FOR i := 2 TO 7 DO
                       BEGIN
                         IF Response[i] <> ' ' THEN M_aus(Response[i]);
                       END;
                      M_aus(':');
                    END;
                   M_aus(CutStr(TNC[active_TNC].MH^[1].Call) + ')' + ^M);
                   i := 8;
                   WHILE (i+1) < length(ResponseStr) DO
                    BEGIN
                      M_aus(Broadcast(i));
                      i := i + 21;
                    END;
                 END
                ELSE
                BEGIN
                  { normales Net-Frame }
                  TextAttr := NetzHeaderAttrib;
                  Net_aus;
                  NetCtrl := ord(Response[20]) AND $0F;
                  CASE NetCtrl OF
                   0 : Begin
                         { Network extension }
                         M_aus('Family-ID:');
                         case ord(Response[16]) of
                          $0c  : M_aus('IP ');
                          else   M_aus('?? ');
                         end;
                         M_aus('Prot-ID:');
                         case ord(Response[17]) of
                          $0c  : begin
                                   M_aus('IP ');
                                   M_aus(Flags+'EXT'+^M);
                                   ipdump(copy(ResponseStr,21,length(ResponseStr)-20));
                                 end;
                          else   begin
                                   M_aus('?? ');
                                   M_aus(Flags+'EXT'+^M);
                                   M_aus(copy(ResponseStr,21,length(ResponseStr)-20)+^M);
                                 end;
                         end;
                       end;
                   1 : BEGIN
                         { Connect-Request }
                         M_aus('my-Idx:'+int_str(ord(Response[16]))+'/');
                         M_aus(int_str(ord(Response[17]))+' ');
                         M_aus(RufZeichen(22,0)+' @ '
                               +Rufzeichen(29,0)+Flags+'CON-RQU)'+^M);
                       END;
                   2 : BEGIN
                         { Connect-Ack }
                         M_aus('ur-Idx:'+int_str(ord(Response[16]))+'/');
                         M_aus(int_str(ord(Response[17]))+' ');
                         M_aus('my-Idx:'+int_str(ord(Response[18]))+'/');
                         M_aus(int_str(ord(Response[19])));
                         M_aus(Flags+'CON-ACK)'+^M);
                       END;
                   3 : BEGIN
                         { Disconnect }
                         M_aus('ur-Idx:'+int_str(ord(Response[16]))+'/');
                         M_aus(int_str(ord(Response[17])));
                         M_aus(Flags+'DISC-RQU)'+^M);
                       END;
                   4 : BEGIN
                         { Disconnect-Ack }
                         M_aus('ur-Idx:'+int_str(ord(Response[16]))+'/');
                         M_aus(int_str(ord(Response[17])));
                         M_aus(Flags+'DISC-ACK)'+^M);
                       END;
                   5 : BEGIN
                         { Info }
                         M_aus('ur-Idx:'+int_str(ord(Response[16]))+'/');
                         M_aus(int_str(ord(Response[17]))+' ');
                         M_aus('TX:'+int_str(ord(Response[18]))+' ');
                         M_aus('RX:'+int_str(ord(Response[19])));
                         M_aus(Flags+'INFO)'+^M);
                         TextAttr := MoniInfoAttr;
                         M_aus(copy(ResponseStr,21,length(ResponseStr)-20));
                         IF Count > 255 THEN
                         BEGIN
                           M_aus(Response[256]);
                           IF Response[256] <> #13 THEN M_aus(^M);
                         END
                         ELSE
                         BEGIN
                           IF ResponseStr[length(ResponseStr)] <> #13
                             THEN M_aus(^M);
                         END;
                       END;
                   6 : BEGIN
                         { Info-Ack }
                         M_aus('ur-Idx:'+int_str(ord(Response[16]))+'/');
                         M_aus(int_str(ord(Response[17]))+' ');
                         M_aus('RX:'+int_str(ord(Response[19])));
                         M_aus(Flags+'INFO-ACK)'+^M);
                       END;
                   ELSE BEGIN
                          { nanu ?? Falscher Opcode ! }
                          M_aus('ctrl-'+int_str(NetCtrl)+' ??)'+^M);
                        END;
                  END;
                END;
              END;

            $CC:                  { IP }
              BEGIN
                ScanMatch := 0;
                ipdump(ResponseStr);
              END;

            $CD:                  { ARP }
              BEGIN
                ScanMatch := 0;
                arpdump(ResponseStr);
              END;

            ELSE
              BEGIN
                { "normales" Monitor-Frame }
                IF (Kanal = 0) THEN
                  BEGIN
                    { Monitorframe auf Kanal 0 empfangen }
                    TextAttr := MoniInfoAttr;
                    M_aus(ResponseStr);
                    IF Count > 255 THEN
                     BEGIN
                       M_aus(Response[256]);
                       IF (Response[256] <> #13) THEN
                         M_aus(^M);
                     END
                    ELSE
                     BEGIN
                       IF (ResponseStr[length(ResponseStr)] <> #13) THEN
                         M_aus(^M);
                     END;
                  END
                ELSE
                  BEGIN
                    { auweia, Monitor-Frame auf Kanal <> 0 ???  }
                    { Fr PTC-Treiber ausnahmsweise zulassen... }
                    TextAttr := ConTXAttrib;
                    _aus(Kanal,ResponseStr);
                    IF (Count > 255) THEN
                      _aus(Kanal,Response[256]);
                  END;

                IF (ScanMatch > 0) THEN
                 BEGIN
                   IF (ScanMatch = 1) THEN
                    BEGIN
                      TextAttr := ConRXAttrib;
                      IF (Drucker = ScanChannel) THEN
                        WRITElst(Printer1[5]);
                    END
                   ELSE
                    BEGIN
                      TextAttr := ConTXAttrib;
                      IF (Drucker = ScanChannel) THEN
                        WRITElst(Printer1[7]);
                    END;
                   _aus(ScanChannel,ResponseStr);
                   IF (Count > 255) THEN
                     _aus(ScanChannel,Response[256]);
                   IF (Drucker = ScanChannel) THEN
                     IF (ScanMatch = 1) THEN
                       WRITElst(Printer1[6])
                     ELSE
                       WRITElst(Printer1[8]);
                   ScanMatch := 0;
                 END;    { IF ScanMatch > 0 }
              END;    { normales Monitor-Frame }
           END;   { CASE PID OF ... }

           IF (Drucker = 0) THEN
             WRITElst(Printer1[4]);
         END;

     7 : BEGIN                      { Connected info (BYTE count) }

           get_byte_count(Count);

           IF (Drucker = Kanal) THEN
             WRITElst(Printer1[5]);

           IF save AND (RX_Mode = 2) THEN
            BEGIN
              { testen, ob die File-Laenge uebermittelt wurde }
              { neues Verfahren mit FiFo-String (11/1991)...  }
              i1 := 0;
              FiFoStr[0] := #80;
              WHILE (i1 < Count) AND (RX_Mode = 2) DO
               BEGIN
                 Inc(i1);
                 IF (Response[i1] <> #10) THEN
                  BEGIN
                    { keine Linefeeds in den FiFo gelangen lassen }
                    FOR i := 1 TO 79 DO
                      FiFoStr[i] := FiFoStr[i+1];
                    FiFoStr[80] := Response[i1];
                  END;
                 IF (Response[i1] = #13) THEN
                  BEGIN
                    { nach jedem CR das #BIN#-Pattern suchen }
                    i2 := Pos(#13'#BIN#',FiFoStr);
                    IF (i2 > 0) THEN
                     BEGIN
                       { #BIN#-Pattern gefunden, Header sizieren... }
                       subStr := Copy(FiFoStr,i2+6,80);  { #13'#BIN#' abtrennen }

                       { CRC-Prfsumme bestimmen }
                       RX_expectCheck := 0;
                       i := Pos('|',subStr);
                       IF (i > 0) THEN
                        BEGIN
                          { CRC-Checksum wurde bertragen, also speichern }
                          subStr1 := Copy(subStr,i+1,10);
                          i := Pos('#',subStr1);
                          IF (i = 0) THEN i := Pos(#13,subStr1);
                          IF (i = 0)
                            THEN i := Length(subStr1)
                            ELSE Dec(i);
                          Val(Copy(subStr1,1,i),RX_expectCheck,i3);
                          IF (i3 <> 0) THEN RX_expectCheck := 0;
                        END;

                       { Date/Time-Angabe bestimmen }
                       DTInt := 0;
                       i := Pos('#$',subStr);
                       IF (i > 0) THEN
                        BEGIN
                          { File-Datum feststellen und setzen }
                          Val(Copy(subStr,i+1,9),DTInt,i3);
                          IF (i3 > 0) THEN DTInt := 0;
                        END;

                       i := Pos('#',subStr);     { kompatibel zu SP6 }
                       IF (i = 0) THEN i := Pos(#13,subStr);
                       IF (i = 0) THEN
                         i := Length(subStr)
                       ELSE
                         Dec(i);
                       Val(Copy(subStr,1,i),RX_Laenge,i3);
                       IF (i3 = 0) THEN
                        BEGIN
                          { File-Lnge richtig erkannt, Frame splitten }
                          TextAttr := conRXAttrib;
                          { #BIN#-Header ausgeben, i1 zeigt auf CR nach Header }
                          _aus(Kanal,Copy(ResponseStr,1,i1));
                          FOR i := 1 TO (Count-i1) DO
                            Response[i] := Response[i+i1];
                          Count := Count-i1;
                          Response[0] := Chr(Count);
                          RX_Mode := 3;
                          RX_Checksum := 0;
                          subStr := ResponseStr;    { Rest retten }
                          TX_Out(Kanal,'#OK#'+^M);
                          ResponseStr := subStr;

                          IF (RX_Count+Count) > RX_Laenge THEN
                           BEGIN
                             { Frame bei AutoBin-RX in zwei Teile splitten }
                             i1 := RX_Laenge-RX_Count;
                             _aus(Kanal,Copy(ResponseStr,1,i1));
                             FOR i := 1 TO (Count-i1) DO
                               Response[i] := Response[i+i1];
                             Count := Count-i1;
                             Response[0] := Chr(Count);
                             _aus(Kanal,ResponseStr);
                           END
                          ELSE
                           BEGIN
                             _aus(Kanal,ResponseStr);
                             IF Count > 255 THEN
                               _aus(Kanal,Response[256]);
                           END;

                        END
                       ELSE
                        BEGIN
                          { Fehler in der Datei-Lnge }
                          FiFoStr := ConstStr(#13,80);    { FiFo lschen }
                          TX_Out(Kanal,'#STOP# Error in File-Length!'+^M);
                        END;
                     END;    { Pattern ok }
                  END;   { CR }
               END;
              IF (RX_Mode = 2) THEN
               BEGIN
                 { kein Pattern, also Frame ausgeben... }
                 TextAttr := conRXAttrib;
                 _aus(Kanal,ResponseStr);
                 IF Count > 255 THEN _aus(Kanal,Response[256]);
               END;
            END        { Save AND (RX_Mode = 2) }
           ELSE
            BEGIN
              TextAttr := conRXAttrib;
              IF Save AND (RX_Mode = 3) AND ((RX_Count+Count)>RX_Laenge) THEN
               BEGIN
                 { U.U. Frame bei AutoBin-RX in zwei Teile splitten }
                 i1 := RX_Laenge-RX_Count;
                 _aus(Kanal,Copy(ResponseStr,1,i1));
                 FOR i := 1 TO (Count-i1) DO
                   Response[i] := Response[i+i1];
                 Count := Count-i1;
                 Response[0] := Chr(Count);
                 _aus(Kanal,ResponseStr);
               END
              ELSE
               BEGIN
                 _aus(Kanal,ResponseStr);
                 IF Count > 255 THEN _aus(Kanal,Response[256]);
               END;
            END;

           IF (Kanal<>show) AND (NOT newText) THEN
            BEGIN
              { Signalisieren, da neuer Text gekommen ist }
              newText := TRUE;
              Status2;
            END;

           IF (Drucker = Kanal) THEN
             WRITElst(Printer1[6]);

           Inc(FrameCount);
           IF (FrameCount <= 3) AND (PassWort = '') THEN
             MBX_remote_scan(Kanal);

           IF NCheck AND NOT (Save AND (RX_Mode >= 2)) THEN
            BEGIN
              check_for_Connect(Kanal);
              { u.U. Parameterauswertung durchfhren }
              i := Pos('}',ResponseStr);
              IF (i = 0) THEN i := Pos('>',ResponseStr);
              IF (i <> 0) THEN
              BEGIN
                Inc(i,2);
                IF (Response[i] = ' ') AND (Response[i-1] = ' ') THEN
                BEGIN
                  Inc(i);
                  IF (Response[i] >= '0') AND (Response[i] <= '9') THEN
                    PARMS_Auswert(Kanal,Copy(ResponseStr,i,length(ResponseStr)-i+1));
                END;
              END;
            END; { IF NCheck }

           IF Sek15 AND (Remote > 0) THEN
            BEGIN
              i := Pos('//',ResponseStr);
              IF (i > 0) THEN
               BEGIN
                 { '//' ist im Frame vorhanden, also testen, ob es am  }
                 { Frameanfang, oder zumindest am Zeilenanfang steht   }
                 IF (i = 1) OR ((i > 1) AND ((Response[i-1] = #13) OR (Response[i-1] = #10))) THEN
                  BEGIN
                    IF (Remote = 1) THEN
                     BEGIN
                       { Digicom ???  Nein danke ... }
                       msg_out(Kanal,11);   { Festspeicher 11 ausgeben }
                     END;
                    IF (Remote = 2) AND RemCfgOK THEN
                     BEGIN
                       RemDecode(Kanal,ResponseStr,i,FALSE);
                     END;
                  END;   { '//' ok }
               END;   { '//' im Frame vorhanden }
            END;   { Sek15 AND (Remote > 0) }

           IF FileSend THEN
           BEGIN
             { testen, ob der Empfnger geantwortet hat }
             IF (TX_Mode = 2) AND (Copy(ResponseStr,1,4) = '#OK#') THEN
             BEGIN
               { Empfnger hat das Auto-Binr-Senden besttigt }
               TX_Mode := 3; { Auto-BinrSenden starten }
             END;

             IF (TX_Mode = 2) AND
                (Copy(ResponseStr,1,6) = '#STOP#') THEN
             BEGIN
               { Empfnger hat die Binr-bertragung abgebrochen }
               FileSend := FALSE;
               Close(TXFile);
               Status1(Kanal);
             END;
           END;

         END; { 7 }

     ELSE

         BEGIN
           KbdFree;
           IF Klingel THEN
             Beep(800,40);
           TextAttr := blinkAttr;
           WRITELN('*** wrong hostmode response (',Code,')!');
         END;
    END; { case }
  END; { WITH K[Kanal]^ DO ... }

  TextAttr := AttrStore;

END;


{-----------------------------------------------------------------------------}
{ S_Com  sendet ein Kommando an einen TNC-Kanal                               }
{-----------------------------------------------------------------------------}

PROCEDURE S_Com(Kanal : BYTE ; Zeile : STRING);
BEGIN
  IF Length(Zeile) > 0 THEN
  BEGIN
    KBDlock;
    SENDTNC(Kanal,1,Zeile);
    getTNC;
  END;
END;


{-----------------------------------------------------------------------------}
{ S_Text  sendet einen Text an einen TNC-Kanal                                }
{-----------------------------------------------------------------------------}

PROCEDURE S_Text(Kanal : BYTE ; Zeile : STRING);
BEGIN
  IF Length(Zeile) > 0 THEN
  BEGIN
    KBDlock;
    SENDTNC(Kanal,0,Zeile);
    getTNC;
  END;
END;


{-----------------------------------------------------------------------------
|  Abfrage-Prozedur
+----------------------------------------------------------------------------}

PROCEDURE PollChannel (Kanal : INTEGER);

label EndeProc;

VAR Zahl          : string[6];
    i             : INTEGER;
    Result        : INTEGER;
    ch            : char;
    new_LinkState : INTEGER;
    S_Fr          : INTEGER;
    T_Fr          : INTEGER;
    Tr            : INTEGER;
    AttrStore     : BYTE;
    Pstr          : string[3];  { PufferString }
    Sync          : BOOLEAN;


 FUNCTION GetBCount(Kanal : Byte) : INTEGER;
 VAR   i, error   : INTEGER;
 BEGIN
   Ausgabe := FALSE;
   S_Com(Kanal,'@B');
   Delete(ResponseStr,Length(ResponseStr),1);    { CR abtrennen }
   Val(ResponseStr,i,error);
   IF (error > 0) OR (i < 0) OR (i > 6000) THEN
     i := 0;
   GetBCount := i;
 END;


 PROCEDURE GetSendFile;

 VAR Zeile      : String;
     i,i1       : INTEGER;
     ch         : char;
     FileEnde   : BOOLEAN;
     AttrStore  : BYTE;

 BEGIN

   IF (GetBCount(Kanal) < minBCount) THEN Exit;

   AttrStore := TextAttr;
   FileEnde := FALSE;
   WITH K[Kanal]^ DO
   BEGIN
     IF TX_Mode <> 2 THEN
     BEGIN
       i := 0;
       REPEAT
         ch := TXFileBuffer^[TX_Buffer_Count];
         IF (TX_Mode = 0) THEN
          BEGIN
            { Textfile senden }
            case ch of
             ^I  : BEGIN
                     { auch Tabulator-Zeichen aussenden ! }
                     Inc(i);
                     Zeile[i] := ^I;
                   END;
             ^M  : BEGIN
                     Inc(i);
                     Zeile[i] := ^M;
                   END;
             ^J  : ;
             ^Z  : ;
             '' : BEGIN
                     Inc(i);
                     IF (Umlaut <> 1)
                       THEN Zeile[i] := ch
                       ELSE Zeile[i] := '[';
                   END;
             '' : BEGIN
                     Inc(i);
                     IF (Umlaut <> 1)
                       THEN Zeile[i] := ch
                       ELSE Zeile[i] := '\';
                   END;
             '' : BEGIN
                     Inc(i);
                     IF (Umlaut <> 1)
                       THEN Zeile[i] := ch
                       ELSE Zeile[i] := ']';
                   END;
             '' : BEGIN
                     Inc(i);
                     IF (Umlaut <> 1)
                       THEN Zeile[i] := ch
                       ELSE Zeile[i] := '{';
                   END;
             '' : BEGIN
                     Inc(i);
                     IF (Umlaut <> 1)
                       THEN Zeile[i] := ch
                       ELSE Zeile[i] := '|';
                   END;
             '' : BEGIN
                     Inc(i);
                     IF (Umlaut <> 1)
                       THEN Zeile[i] := ch
                       ELSE Zeile[i] := '}';
                   END;
             '' : BEGIN
                     Inc(i);
                     IF (Umlaut <> 1)
                       THEN Zeile[i] := ch
                       ELSE Zeile[i] := '~';
                   END;
             ELSE  BEGIN
                     Inc(i);
                     Zeile[i] := ch;
                   END;
            END;  { CASE }

          END
         ELSE
          BEGIN
            { Binaer-Senden, KEINE Zeichenkonvertierung }
            Inc(i);
            Zeile[i] := ch;
            TX_CRC := CRC(Ord(ch),TX_CRC);
            TX_Sum := TX_Sum + Ord(ch);
          END;

         Inc(TX_Count);
         IF (TX_Count >= TX_Laenge) THEN
           FileEnde := TRUE;
         IF NOT FileEnde THEN
         BEGIN
           Inc(TX_Buffer_Count);
           IF (TX_Buffer_Count > 1024) THEN
           BEGIN
             { 1024 BYTEs nachladen }
             TX_Buffer_Count := 1;
             blockREAD(TXFile,TXFileBuffer^,8,i1);
           END;
         END;

       UNTIL (i >= PacLen) OR (i > 254) OR FileEnde;

       Zeile[0] := Chr(i);
       S_Text(Kanal,Zeile);
       IF (TX_Mode = 0) AND LocalEcho THEN BEGIN
         TextAttr := conTXAttrib;
         _aus(Kanal,Zeile);
       END;

       Status1Out(Kanal,16,neg_high,RxTxStr(Kanal));

       IF FileEnde THEN BEGIN
         { Ende der zu sendenden Datei erreicht }
         Close(TXFile);
         FileSend := FALSE;
         Status1(Kanal);

         IF (TX_Mode = 3) THEN BEGIN
           Zeile := 'BIN-TX ok, CRC='+ int_str(TX_CRC) +
                    ' Sum=' + int_Str(TX_Sum) + #13;
           myText := TRUE;
           TextAttr := low;
           _aus(Kanal,Zeile);
         END;

         IF (Remote = 2) AND (RemStatus > 0) THEN
          BEGIN
            IF (TX_Name = RemDosTmpName(Kanal)) THEN
             BEGIN
               Assign(TXFile,TX_Name);
               {$I-}
               Erase(TXFile);   {$I+}
               i1 := IOResult;
             END;
            RemStatus := 0;
            S_Text(Kanal,RemPrompt(Kanal));
            IF LocalEcho THEN
             BEGIN
               TextAttr := conTXAttrib;
               myText := TRUE;
               _aus(Kanal,RemPrompt(Kanal));
             END;
          END;

       END;

     END; { TX_Mode <> 2 }

   END; { WITH ... DO ... }

   TextAttr := AttrStore;

 END; { getSendFile }


 { bei jedem 5. Monitordurchlauf die freien Buffer anzeigen }

 PROCEDURE Check_Buffercount_Output;
  VAR  DummyZ   : Str10;
  BEGIN
    IF (K[0]^.Pause = 5) THEN
     BEGIN
       Str(GetBCount(0),DummyZ);
       DummyZ := ' B:' + DummyZ + ' ';
       Inc(_B);
       IF (_B > 3) THEN            { wandernden Zeiger darstellen }
         _B := 0;
       DummyZ[1] := _BChar[_B];
       Status1Out(0,46,neg,DummyZ);
     END;
  END;


BEGIN   { PollTNC }

  AttrStore := TextAttr;

  WITH K[Kanal]^ DO
  BEGIN

    KBDlock;

    switch_TNC(Channel0);     { notfalls den richtigen TNC einschalten }

    IF Kanal = 0 THEN
      IF active_TNC = unproto THEN
        IF Pause = 5 THEN
          Check_Buffercount_Output;

    SENDTNC(Kanal,1,'L');
    READaux(ch,Sync);

    IF (ch <> K[Kanal]^.TNCKanal) OR NOT Sync THEN
    BEGIN
      IF Klingel THEN Beep(800,40);
      KbdFree;
      TextAttr := blinkAttr;
      M_aus('*** (TNC '+int_Str(K[Kanal]^.TNCNummer)+') '
              + int_Str(Kanal) + ' wrong channelnumber '+
            '(S:'+Int_Str(ord(K[Kanal]^.TNCKanal)) +
            ' R:'+int_Str(Ord(ch)) + ')!'#13);
      SysDelay(5);
      WHILE Zeichen DO
        READAux(ch,Sync);
      Goto EndeProc;       { **************** >>>>>>>>>>>>>>>>>> }
    END;

    READaux(ch,Sync);       { Code abholen, hier uninteressant... }
    IF NOT Sync THEN
      Goto EndeProc;       { ================ >>>>>>>>>>>>>>>> }
    get_null_term;

    i := 1;
    Zahl := '';
    WHILE (Response[i] >= '0') AND (Response[i] <= '9') DO BEGIN
      Zahl := Zahl + Response[i];
      Inc(i);
    END;
    Val(Zahl,L_mess,Result);

    Inc(i);
    Zahl := '';
    WHILE (Response[i] >= '0') AND (Response[i] <= '9') DO BEGIN
      Zahl := Zahl + Response[i];
      Inc(i);
    END;
    val(Zahl,R_Frames,Result);

    IF (Kanal <> 0) THEN
    BEGIN
      Inc(i);
      Zahl := '';
      WHILE (Response[i] >= '0') AND (Response[i] <= '9') DO BEGIN
        Zahl := Zahl + Response[i];
        Inc(i);
      END;
      val(Zahl,S_Fr,Result);
      IF S_Fr <> S_Frames THEN
      BEGIN
        S_Frames := S_Fr;
        str(S_Frames:3,PStr);
        Status1Out(Kanal,52,neg_high,PStr);
      END;

      Inc(i);
      Zahl := '';
      WHILE (Response[i] >= '0') AND (Response[i] <= '9') DO BEGIN
        Zahl := Zahl + Response[i];
        Inc(i);
      END;
      val(Zahl,T_Fr,Result);
      IF T_Fr <> T_Frames THEN
      BEGIN
        T_Frames := T_Fr;
        str(T_Frames:2,PStr);
        Status1Out(Kanal,55,neg_high,PStr);
      END;

      Inc(i);
      Zahl := '';
      WHILE (Response[i] >= '0') AND (Response[i] <= '9') DO BEGIN
        Zahl := Zahl + Response[i];
        Inc(i);
      END;
      val(Zahl,Tr,Result);
      IF Tr <> Tries THEN
      BEGIN
        Tries := Tr;
        str(Tries:3,PStr);
        Status1Out(Kanal,57,neg_high,PStr);
      END;

      Inc(i);
      Zahl := '';
      WHILE (Response[i] >= '0') AND (Response[i] <= '9') DO BEGIN
        Zahl := Zahl + Response[i];
        Inc(i);
      END;
      val(Zahl,new_LinkState,Result);

      IF new_LinkState <> LinkState THEN
      BEGIN
        IF (new_LinkState >= 0) AND (new_LinkState <= 15) THEN
         BEGIN
           IF (LinkState=0) AND (new_LinkState=4) THEN FremdConnect := TRUE;
           LinkState := new_LinkState;
           Status1Out(Kanal,38,LinkStateStr[LinkState].Attr,
                      LinkStateStr[LinkState].Zeile);
         END;
      END;

    END;  { Kanal <> 0 }

    IF (L_Mess <> 0) or (R_Frames <> 0) THEN
    BEGIN
      i := L_Mess + R_Frames;
      IF multiTNC AND (i > 10) THEN
        i := 10;                              { weitere TNCs nicht zu lange }
      REPEAT                                  { warten lassen...            }
        S_Com(Kanal,'G');
        poll_Tastatur;
        IF NOT Code5 THEN
          Dec(i);
      UNTIL (i <= 0);
    END;

    IF FileSend THEN
     BEGIN
       Ausgabe := FALSE;
       S_Com(Kanal,'O');
       Val(Copy(ResponseStr,1,1),MaxFrame,i);
       IF i <> 0 THEN
         MaxFrame := 1;
       FOR i := 1 TO (MaxFrame - S_Frames) DO
        BEGIN
          poll_Tastatur;
          IF FileSend THEN
            GetSendFile;
        END;
     END;

    EndeProc:

  END; { WITH ... }

  TextAttr := AttrStore;

END;


{-----------------------------------------------------------------------------
| einen TNC im Polling abfragen...
+----------------------------------------------------------------------------}

PROCEDURE DO_polling;

 VAR   i        : INTEGER;

 BEGIN
   IF polling.Status = 0 THEN
    BEGIN
      { feststellen, welche Kanle abfragewrdig sind }
      FOR i := 0 TO Kanal_Anzahl DO
        polling.ChannelInfo[i] := FALSE;
      FOR i := 0 TO Kanal_Anzahl DO WITH K[i]^ DO
       BEGIN
         IF (i = 0) OR (TNCNummer = Channel0) THEN
          BEGIN
            Dec(Pause);
            IF Pause <= 0 THEN
              Pause := 5;
            IF (Pause = 5) OR (LinkState > 0) OR (i = 0) THEN
              polling.ChannelInfo[i] := TRUE;
          END;
       END;
      polling.Status := 1;     { Abarbeitung freigeben }
      polling.Channel := 0;    { erster Kanal ist der Monitor-Kanal }
    END
   ELSE
    WITH polling DO BEGIN
      { EINEN abfragewrdigen Kanal abfragen }
      PollChannel(Channel);
      REPEAT
        Inc(Channel);        { Kanal weiterschalten }
      UNTIL ChannelInfo[Channel] OR (Channel > Kanal_Anzahl);
      IF Channel > Kanal_Anzahl THEN
       BEGIN
         { kein abfragewrdiger Kanal mehr in diesem TNC, also weiter }
         Status := 0;
         REPEAT
           Inc(Channel0);
           IF Channel0 > 4 THEN
             Channel0 := 1;
         UNTIL TNC[Channel0].used;
       END;
    END;
 END;


{-----------------------------------------------------------------------------
| einen TNC im XHost-Modus abfragen, dabei alle relevanten Kanle erfassen
|
| Strategie:
|         Zustzlich zu den im XGCmd-Kommando angegebenen Kanlen werden
|         folgende Kanle abgefragt:
|         - Monitorkanal bei jedem 5. Durchlauf (um die Buffer anzuzeigen)
|         - angezeigter Kanal bei jedem 5. Durchlauf
|         - nicht-disconnected-Kanal bei jedem 5. Durchlauf
+----------------------------------------------------------------------------}

PROCEDURE DO_XHost;

 VAR   i        : INTEGER;

 BEGIN
   IF XHost.Status = 0 THEN
    BEGIN
      { feststellen, welche Kanle abfragewrdig sind }
      S_XGCmd(Channel0,FALSE);
      WITH K[0]^ DO
       BEGIN
         Dec(Pause);
         IF Pause = 0 THEN
          BEGIN
            Pause := 5;
            XHost.ChannelInfo[0] := TRUE;
          END;
       END;
      FOR i := 1 TO Kanal_Anzahl DO WITH K[i]^ DO
       BEGIN
         IF TNCNummer = Channel0 THEN
          BEGIN
            IF (LinkState > 0) OR (i = show) THEN WITH K[i]^ DO
             BEGIN
               Dec(Pause);
               IF Pause = 0 THEN
                BEGIN
                  { Kanal mind. nach 5 Runden abfragen }
                  Pause := 5;
                  XHost.ChannelInfo[i] := TRUE;
                END;
             END;
            IF XHost.Counts > 5 THEN
              XHost.ChannelInfo[i] := TRUE;  { zu Anfang ALLE Kanle abfragen }
          END;
       END;
      WITH XHost DO
       BEGIN
         Channel := -1;
         REPEAT
           Inc(Channel);
         UNTIL ChannelInfo[Channel] OR (Channel > Kanal_Anzahl);
         IF Channel > Kanal_Anzahl THEN
          BEGIN
            Status := 0;     { kein Kanal zum Abfragen }
            REPEAT
              Inc(Channel0);
              IF Channel0 > 4 THEN
                Channel0 := 1;
            UNTIL TNC[Channel0].used;
          END
         ELSE
           Status := 1;    { Abarbeitung freigeben }
         IF Counts > 0 THEN
           Dec(Counts);
       END;
    END
   ELSE
    WITH XHost DO BEGIN
      { EINEN abfragewrdigen Kanal abfragen }
      PollChannel(Channel);
      REPEAT
        Inc(Channel);        { Kanal weiterschalten }
      UNTIL ChannelInfo[Channel] OR (Channel > Kanal_Anzahl);
      IF Channel > Kanal_Anzahl THEN
       BEGIN
         { kein abfragewrdiger Kanal mehr in diesem TNC, also weiter }
         Status := 0;
         REPEAT
           Inc(Channel0);
           IF Channel0 > 4 THEN
             Channel0 := 1;
         UNTIL TNC[Channel0].used;
       END;
    END;

 END;


{------------------------------------------------------------------------------
| Monitor-Status aller angeschlossenen TNCs feststellen und speichern,
| danach alle Monitore abschalten.
+-----------------------------------------------------------------------------}

PROCEDURE Moni_off;

 VAR  i         : BYTE;
      storeTNC  : Byte;

 BEGIN
   storeTNC := active_TNC;
   FOR i := 1 TO 4 DO
     IF TNC[i].used THEN WITH TNC[i] DO BEGIN
       switch_TNC(i);
       Ausgabe := FALSE;
       S_Com(0,'M');
       MoniStatus^ := ResponseStr;
       Delete(MoniStatus^,Length(MoniStatus^),1);   { CR abtrennen }
       S_Com(0,'MN');                               { Monitor ausschalten }
     END;
   switch_TNC(storeTNC);
 END;


{------------------------------------------------------------------------------
| Monitor-Status bei allen TNCs wieder herstellen
+-----------------------------------------------------------------------------}

PROCEDURE restore_MoniStatus;

 VAR  i          : BYTE;
      storeTNC   : Byte;

 BEGIN
   storeTNC := active_TNC;
   FOR i := 1 TO 4 DO
     IF TNC[i].used THEN WITH TNC[i] DO BEGIN
       switch_TNC(i);
       S_Com(0,'M' + MoniStatus^);
     END;
   switch_TNC(storeTNC);
 END;


{------------------------------------------------------------------------------
| Unproto-String genau auf 14 Zeichen formatiern (z.B. '>M:1 HALLO!-15')
+-----------------------------------------------------------------------------}

FUNCTION UnprotoStr : Str20;

 VAR subStr    : Str20;

 BEGIN
   switch_TNC(unproto);
   Ausgabe := FALSE;
   S_Com(0,'C');
   subStr := ResponseStr;
   Dec(subStr[0]);                 { CR abtrennen }
   subStr := cutStr(subStr);
   IF multiTNC THEN
     subStr := #16'M:' + int_Str(unproto) + ' ' + subStr
   ELSE
     subStr := #16' ' + subStr;
   UnprotoStr := subStr;
 END;


{-----------------------------------------------------------------------------
|  An jeden TNC das U-Kommando senden und die Antwort speichern
|  anschlieend U0 einstellen
+----------------------------------------------------------------------------}

PROCEDURE get_UCmdStr (TNCNummer : INTEGER);

 VAR   i    : INTEGER;

 BEGIN
   IF TNC[TNCNummer].used THEN WITH TNC[TNCNummer] DO BEGIN
     switch_TNC(TNCNummer);
     Ausgabe := FALSE;
     S_Com(0,'U');
     UCmdStr^ := ResponseStr;
     Delete(UCmdStr^,Length(UCmdStr^),1);    { CR am Ende abtrennen }
     i := Pos('^M',UCmdStr^);
     WHILE (i > 0) DO
      BEGIN
        Delete(UCmdStr^,i,2);
        Insert(#13,UCmdStr^,i);
        i := Pos('^M',UCmdStr^);
      END;
     S_Com(0,'U 0');
   END;
 END;


{-----------------------------------------------------------------------------
|  Abarbeitung des TNC-U-Kommandos
+----------------------------------------------------------------------------}

PROCEDURE do_Ucommand (Zeile : String; TNCNummer : INTEGER);

 BEGIN
   IF TNC[TNCNummer].used THEN WITH TNC[TNCNummer] DO BEGIN
     switch_TNC(TNCNummer);
     S_Com(0,'U'+Copy(UCmdStr^,1,1));     { alten U-Status einstellen }
     S_Com(0,Zeile);
     get_UCmdStr(TNCNummer);
   END;
 END;



BEGIN

  { Unit-Initialisierung (nicht erforderlich) }

END.
