
{-----------------------------------------------------------------------------
|
|  P R M O U S E . P A S
|
|  Untersttzung eines bereits installierten Standard-Maustreibers
|
|  Alle hier gemachten Vereinbarungen beginnen mit 'M_'
|
|  ReSch, im September 1989
|
+----------------------------------------------------------------------------}


UNIT   PRMouse;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


VAR
       M_ok             : BOOLEAN;
       M_Buttons        : Byte;


PROCEDURE M_Cursor_on;
PROCEDURE M_Cursor_off;
PROCEDURE M_getCursorPos (VAR XPos,YPos : Byte);
FUNCTION  M_Button (Button : Byte) : BOOLEAN;
FUNCTION  M_noButton : BOOLEAN;
FUNCTION  M_anyButton : BOOLEAN;
PROCEDURE M_setCursorPos (XPos,YPos : INTEGER);
PROCEDURE M_SetRange (X1,Y1,X2,Y2 : INTEGER);


IMPLEMENTATION


USES
       Dos;

VAR
       R                : Registers;


PROCEDURE M_Cursor_on;

 BEGIN
   IF M_ok THEN
    BEGIN
      R.AX := $01;
      Intr($33,R);
    END;
 END;


PROCEDURE M_Cursor_off;

 BEGIN
   IF M_ok THEN
    BEGIN
      R.AX := $02;
      Intr($33,R);
    END;
 END;


PROCEDURE M_getCursorPos (VAR XPos,YPos : Byte);

 BEGIN
   IF M_ok THEN
    BEGIN
      R.AX := $03;
      Intr($33,R);
      XPos := R.CX DIV 8 + 1;
      YPos := R.DX DIV 8 + 1;
    END;
 END;


FUNCTION  M_Button (Button : Byte) : BOOLEAN;

 BEGIN
   IF M_ok THEN
    BEGIN
      R.AX := $03;
      Intr($33,R);
      M_Button := (R.BX AND Button) = Button;
    END
   ELSE
    BEGIN
      M_Button := FALSE;
    END;
 END;


FUNCTION  M_noButton : BOOLEAN;

 BEGIN
   M_noButton := NOT M_anyButton;
 END;


FUNCTION  M_anyButton : BOOLEAN;

 BEGIN
   IF M_ok THEN
    BEGIN
      R.AX := $03;
      Intr($33,R);
      M_anyButton := (R.BX AND 3) <> 0;
    END
   ELSE
    BEGIN
      M_anyButton := FALSE;
    END;
 END;


PROCEDURE M_setCursorPos (XPos,YPos : INTEGER);

 BEGIN
   IF M_ok THEN
    BEGIN
      R.AX := $04;
      R.CX := (XPos SHL 3) - 1;
      R.DX := (YPos SHL 3) - 1;
      Intr($33,R);
    END;
 END;


PROCEDURE M_SetRange (X1,Y1,X2,Y2 : INTEGER);

 BEGIN
   IF M_ok THEN
    BEGIN
      R.AX := 7;
      R.CX := X1;
      R.DX := X2;
      Intr($33,R);
      R.AX := 8;
      R.CX := Y1;
      R.DX := Y2;
      Intr($33,R);
    END;
 END;


BEGIN

  {---------------------------------------------------------------------------
  |  Unit-Initialisierung
  +--------------------------------------------------------------------------}

  M_Buttons := 0;
  R.AX := 0;
  Intr($33,R);
  M_ok := (R.AX = $FFFF);
  IF M_ok
    THEN M_Buttons := R.BX
    ELSE M_Buttons := 0;

END.
