
{-----------------------------------------------------------------------------
|
|  P R R E M O T E . P A S
|
|  Implementation einiger Remote-Kommandos
|
|  R. Schmidt (DL1BHO)  04/1994
|
|  nderungen
|  ==========
|
|  05/94:  Punkt im Filenamen beim Einschreiben von Nachrichten gesperrt
|
|  04/94:  Simplexkanal-Mode testweise eingefhrt (fr PTC-Treiber), hat
|          keine Auswirkungen auf den TNC- oder TFPCX-Betrieb (hoffentlich)
|
+----------------------------------------------------------------------------}

Unit  PRRemote;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


Interface


USES
       PRDefs;

CONST
       RemVersion      = 'V1.20';

VAR
       RemCfgOK        : BOOLEAN;
       RemPfad         : Str80;
       RemRunPfad      : Str80;
       RemPromptStr    : Str80;
       RemLoginStr     : String;     { String aus REMCFG.PR }
       RemLogoutStr    : String;     { " }
       RemCallStr      : String;     { " }
       RemPrivStr      : Str80;
       RemPWStr        : Str80;


PROCEDURE RemInit;
FUNCTION  RemCallOK (Call : Str9) : BOOLEAN;
FUNCTION  RemPrivOK (Call : Str9) : BOOLEAN;
PROCEDURE RemDecode(Kanal : Byte; Response : String; Position : Byte; RemTerm : BOOLEAN);
PROCEDURE RemConvert (VAR Zeile : String; Kanal : Byte);
FUNCTION  RemDosTmpName (Kanal : Byte) : String;
FUNCTION  RemPrompt (Kanal : Byte) : String;
FUNCTION  RemTxRxStr (Kanal : Byte) : Str2;
PROCEDURE RemClearBuffer;
PROCEDURE RemPutBuffer (Zeile : String);
PROCEDURE RemSendBuffered (Kanal : Byte; Zeile : String);
PROCEDURE RemSendBuffer (Kanal : Byte);
FUNCTION  RemSearchFirst (Suchbegriff : Str12) : BOOLEAN;
PROCEDURE RemCatalog (Kanal : Byte; Suchbegriff : String);


Implementation


Uses
       Dos,
       Crt,
       PRLib,
       PRLib2,
       PRLib4,
       PRScreen;


CONST
       RemMaxBuffer       = 4096;     { Gre des Remote-Buffers }
       FInfo              = TRUE;     { File-Info }
       NoFInfo            = FALSE;

TYPE
       RemBufferType      = ARRAY [1..RemMaxBuffer] OF Char;

VAR
       RemBuffer          : ^RemBufferType;
       RemBufferPointer   : INTEGER;
       RemoteTerm         : BOOLEAN;

{-----------------------------------------------------------------------------
|  Initialisierung der Remote-Variablen
+----------------------------------------------------------------------------}

PROCEDURE RemInit;

 VAR   InitFile      : Text;
       Zeile         : String;
       Kanal         : INTEGER;

 BEGIN
   RemPfad := SysPfad;   { vorlufig }
   Assign(InitFile,SysPfad+'REMCFG.PR');
   {$I-}
   Reset(InitFile);  {$I+}
   IF IO_ok THEN
    BEGIN
      { Remote-Configfile gefunden }
      Readln(InitFile,Zeile);
      Zeile := upcaseStr(cutStr(Zeile));
      IF (Zeile = '') THEN Zeile := FExpand('');
      IF (Zeile[Length(Zeile)] <> '\') THEN
        Zeile := Zeile + '\';
      RemPfad := Zeile;
      Readln(InitFile,RemPromptStr);
      Readln(InitFile,RemLoginStr);
      Readln(Initfile,RemLogoutStr);
      Readln(Initfile,RemCallStr);  RemCallStr := upcaseStr(RemCallStr) + ' ';
      Readln(Initfile,RemPrivStr);  RemPrivStr := upcaseStr(RemPrivStr) + ' ';
      Readln(Initfile,RemPWStr);
      ReadLn(InitFile,Zeile);
      Zeile := upcaseStr(cutStr(Zeile));
      IF (Zeile[Length(Zeile)] <> '\') THEN
        Zeile := Zeile + '\';
      RemRunPfad := Zeile;
      Close(InitFile);
      RemCfgOK := TRUE;
      GetMem(RemBuffer,RemMaxBuffer);    { Speicher fr den Buffer belegen }
    END
   ELSE
    BEGIN
      { kein Remote-Config gefunden }
      FOR Kanal := 1 TO Kanal_Anzahl DO
        IF (K[Kanal]^.Remote = 2) THEN K[Kanal]^.Remote := 1;
    END;
 END;


{-----------------------------------------------------------------------------
|  Feststellen, ob Call Remote-berechtigt
+----------------------------------------------------------------------------}

FUNCTION  RemCallOK (Call : Str9) : BOOLEAN;

 VAR   result   : BOOLEAN;

 BEGIN
   Call := onlyCall(Call) + ' ';
   result := FALSE;
   IF RemCallStr[1] = '-' THEN
    BEGIN
      { Negativ-Liste }
      IF Pos(Call,RemCallStr) = 0 THEN
        result := TRUE;                   { Call ist nicht in der Negativliste }
    END
   ELSE
    BEGIN
      { Positiv-Liste }
      IF Pos(Call,RemCallStr) > 0 THEN
        result := TRUE;                   { Call ist in der Positivliste }
    END;
   RemCallOK := result;
 END;


{-----------------------------------------------------------------------------
|  Feststellen, ob Call PRIV-berechtigt
+----------------------------------------------------------------------------}

FUNCTION  RemPrivOK (Call : Str9) : BOOLEAN;

 BEGIN
   Call := onlyCall(Call) + ' ';
   IF Pos(Call,RemPrivStr) > 0 THEN
     RemPrivOK := TRUE
   ELSE
     RemPrivOK := FALSE;
 END;


{-----------------------------------------------------------------------------
|  Senden einer Textdatei starten
+----------------------------------------------------------------------------}

PROCEDURE RemSendText(Kanal : Byte; DatName : Str80; FileInfo : BOOLEAN);

 VAR  Zeile      : String;
      i          : INTEGER;

 BEGIN

   WITH K[Kanal]^ DO BEGIN
     TX_Mode := 0;
     TX_Name := FExpand(DatName);
     Assign(TXFile,TX_Name);
     {$I-}
     Reset(TXFile,1);   { Datei mit Blocklnge 1 ffnen }
     {$I+}
     IF IO_ok THEN
      BEGIN
        { File vorhanden }
        TX_Laenge := FileSize(TXFile);

        IF FileInfo THEN
         BEGIN
           RemClearBuffer;
           RemPutBuffer(#13'*** File:  ');
           IF (RemPriv = 2) THEN
             RemPutBuffer(TX_Name)
           ELSE
             RemPutBuffer(onlyFName(TX_Name));
           RemPutBuffer('  '+int_Str(TX_Laenge)+' Bytes'+#13);
           RemPutBuffer(ConstStr('-',RemBufferPointer)+ #13#13);
           RemSendBuffer(Kanal);
         END;

        Close(TXFile);
        Reset(TXFile);
        blockREAD(TXFile,TXFileBuffer^,8,i);
        TX_Count := 0;
        TX_Buffer_Count := 1;
        TX_CRC := 0;
        TX_Sum := 0;
        FileSend := TRUE;
        Status1(Kanal);
        RemStatus := 10;
      END
     ELSE
      BEGIN
        IF (K[Kanal]^.RemPriv = 2) THEN
          RemSendBuffered(Kanal,#13'Datei '+TX_Name
                  +' nicht gefunden !'#13 + RemPrompt(Kanal))
        ELSE
          RemSendBuffered(Kanal,#13'Datei '+onlyFName(TX_Name)
                  +' nicht gefunden !'#13 + RemPrompt(Kanal));
      END;
   END;
 END;


{-----------------------------------------------------------------------------
|  $-Kommandos extrahieren
+----------------------------------------------------------------------------}

PROCEDURE RemConvert (VAR Zeile : String; Kanal : Byte);

 VAR  subStr    : String;
      chx       : Char;
      i,i1      : INTEGER;

 BEGIN
   i := 1;

   WITH K[Kanal]^ DO
   REPEAT
     chx := Zeile[i];
     IF (chx = '$') THEN
      BEGIN
        subStr := '';
        chx := Zeile[i+1];
        CASE chx OF
         'T','Z' : subStr := Time;
         't','z' : subStr := Copy(Time,1,5);
         'D'     : subStr := Date;
         'd'     : subStr := Copy(Date,4,8);
         'C','c' : BEGIN
                     IF connected THEN
                       subStr := Call
                     ELSE
                       subStr := 'SYSOP-' + Int_Str(Kanal);
                     IF (chx = 'c') THEN subStr := onlyCall(subStr);
                   END;
         'M','m' : BEGIN
                     {Call des TNC erfragen}
                     IF (Kanal = 0) THEN
                       active_TNC := unproto;
                     Ausgabe := FALSE;
                     S_Com(Kanal,'I');
                     subStr := Copy(ResponseStr,1,Length(ResponseStr)-1);
                     IF (chx = 'm') THEN
                       subStr := onlyCall(subStr);
                   END;
         'N','n' : subStr := #13;
         'V','v' : subStr := 'V' + Version;
         'U','u' : subStr := Update;
         'P','p' : subStr := int_Str(Kanal);
         '_'     : subStr := ' ';
         '$'     : subStr := '$';
        END;

        Delete(Zeile,i,2);
        Insert(subStr,Zeile,i);

      END;   { IF chx = '$' }

     Inc(i);
   UNTIL i > Length(Zeile);

 END;


{-----------------------------------------------------------------------------
|  Temp-Name der Pufferdatei beim DOS-Aufruf
|  Neu: Unterschiedliche Namen fr die verschiedenen Kanle
+----------------------------------------------------------------------------}

FUNCTION  RemDosTmpName (Kanal : Byte) : String;

 BEGIN
   RemDosTmpName := SysPfad + 'PRDOS_' + Int_Str(Kanal) + '.$$$';
 END;


{-----------------------------------------------------------------------------
|  Remote-Prompt bilden und zurckliefern
+----------------------------------------------------------------------------}

FUNCTION  RemPrompt (Kanal : Byte) : String;

 VAR   Zeile     : String;

 BEGIN
   Zeile := RemPromptStr;
   RemConvert(Zeile,Kanal);
   Zeile := Zeile + RemTxRxStr(Kanal);     { ChangeOver fr Simplex-Mode }
   RemPrompt := Zeile;
 END;


{-----------------------------------------------------------------------------
|  Fr Simplexkanle das ChangeOver-Zeichen generieren
+----------------------------------------------------------------------------}

FUNCTION  RemTxRxStr (Kanal : Byte) : Str2;

 BEGIN
   IF K[Kanal]^.simplex THEN
     RemTxRxStr := #9
   ELSE
     RemTxRxStr := '';
 END;


{-----------------------------------------------------------------------------
|
+----------------------------------------------------------------------------}

PROCEDURE RemClearBuffer;

 BEGIN
   RemBufferPointer := 1;
 END;


{-----------------------------------------------------------------------------
|  eine Zeichenkette in den Remote-Buffer schreiben, dabei Buffer-Ende
|  beachten!
+----------------------------------------------------------------------------}

PROCEDURE RemPutBuffer (Zeile : String);

 VAR    i          : INTEGER;

 BEGIN
   FOR i := 1 TO Length(Zeile) DO
    BEGIN
      IF (RemBufferPointer <= RemMaxBuffer) THEN
       BEGIN
         RemBuffer^[RemBufferPointer] := Zeile[i];
         Inc(RemBufferPointer);
       END;
    END;
   IF (RemBufferPointer >= RemMaxBuffer) THEN
    BEGIN
      { nun isser aber voll... }
      Zeile := #13'*** REMOTE-BUFFER-OVERFLOW!! ***'#7#13;
      RemBufferPointer := RemMaxBuffer - Length(Zeile);
      FOR i := 1 TO Length(Zeile) DO
       BEGIN
         RemBuffer^[RemBufferPointer] := Zeile[i];
         Inc(RemBufferPointer);
       END;
    END;
 END;


{-----------------------------------------------------------------------------
|  Aussenden des Remote-Buffers, dabei Beachtung von PacLen.
+----------------------------------------------------------------------------}

PROCEDURE RemSendBuffer (Kanal : Byte);

 VAR   i       : INTEGER;
       Zeile   : String;

 BEGIN
   WITH K[Kanal]^ DO
    BEGIN
      Zeile := '';
      FOR i := 1 TO (RemBufferPointer - 1) DO
       BEGIN
         Zeile := Zeile + RemBuffer^[i];
         IF (Length(Zeile) >= PacLen) OR (i = (RemBufferPointer-1)) THEN
          BEGIN
            myText := TRUE;
{            S_Text(PollChannel,Zeile);       }
            S_Text(Kanal,Zeile);
            IF LocalEcho THEN
             BEGIN
               TextAttr := conTXAttrib;
               _aus(Kanal,Zeile);
             END;
            Zeile := '';
          END;
       END;
    END;
 END;


{-----------------------------------------------------------------------------
|  eine Zeichenkette ber den Remote-Buffer aussenden
+----------------------------------------------------------------------------}

PROCEDURE RemSendBuffered (Kanal : Byte; Zeile : String);

 BEGIN
   RemClearBuffer;
   RemPutBuffer(Zeile);
   RemSendBuffer(Kanal);
 END;



FUNCTION RemArg (Zeile : String) : String;

 VAR   i    : INTEGER;

 BEGIN
   i := Pos(' ',Zeile);
   IF (i = 0) THEN
     i := Length(Zeile);
   Delete(Zeile,1,i);
   Zeile := CutLeftStr(Zeile);
   i := Pos(' ',Zeile);
   IF (i = 0) THEN
     i := Pos(#13,Zeile);
   IF (i > 0) THEN
     Delete(Zeile,i,Length(Zeile)-i+1);
   RemArg := Zeile;
 END;


{------------------------------------------------------------------------------
| Test auf existierendes File, Wildcards erlaubt
+-----------------------------------------------------------------------------}

FUNCTION RemSearchFirst (Suchbegriff : Str12) : BOOLEAN;

VAR
      Pfad        : PathStr;
      SRec        : SearchRec;         { Im Unit DOS definiert }

BEGIN

  Pfad := RemPfad + Suchbegriff;
  FindFirst(Pfad,Archive,SRec);     { Prozedur im Unit DOS }
  RemSearchFirst := (DosError = 0);

END;


{-----------------------------------------------------------------------------
| Hilfsfunktion zur Ausgabe von Int-Werten mit fhrenden Nullen
+----------------------------------------------------------------------------}

FUNCTION Int0 (Zahl : INTEGER; Stellen : Byte) : Str5;
 VAR  subStr    : Str5;
      b         : Byte;
 BEGIN
   Str(Zahl:Stellen,subStr);
   FOR b := 1 TO Stellen DO
     IF subStr[b] = ' ' THEN
       subStr[b] := '0';
   Int0 := subStr;
 END;


{------------------------------------------------------------------------------
| Ausgabe des Inhaltsverzeichnisses
+-----------------------------------------------------------------------------}

PROCEDURE RemCatalog (Kanal : Byte; Suchbegriff : String);

VAR
      FileExt     : STRING[3];
      PunktPos    : INTEGER;
      Laenge      : STRING[10];
      Pfad        : PathStr;
      SRec        : SearchRec;         { Im Unit DOS definiert }
      DT          : DateTime;
      free        : LongInt;
      FCount      : INTEGER;

BEGIN

  IF (K[Kanal]^.RemPriv < 2) THEN Suchbegriff := onlyFName(Suchbegriff);
  RemPutBuffer(#13);
  RemPutBuffer('Directory of <'+upcaseStr(Suchbegriff)+ '>'#13#13);

  IF (K[Kanal]^.RemPriv = 2) AND
      ((Pos(':',Suchbegriff) > 0) OR (Pos('\',Suchbegriff) > 0)) THEN
    Pfad := Suchbegriff
  ELSE
    Pfad := RemPfad + Suchbegriff;

  FCount := 0;

  FindFirst(Pfad,Archive OR ReadOnly,SRec);

  IF (DosError = 0) THEN

   BEGIN

     WHILE (DosError = 0) DO WITH SRec DO BEGIN

       UnpackTime(Time,DT);
       PunktPos := Pos('.',Name);

       IF (PunktPos <> 0) THEN
        BEGIN
          FileExt := Copy(Name,PunktPos+1,Length(Name)-PunktPos);
          Delete(Name,PunktPos,1+Length(Name)-PunktPos);
        END
       ELSE
        FileExt := '';

       FileExt := FileExt + Space(3-Length(FileExt));
       Name := Name + Space(8-length(Name));

       Str(Size,Laenge);
       Laenge := Space(7-Length(Laenge)) + Laenge;
       RemPutBuffer(Name + ' ' + FileExt);
       RemPutBuffer(Laenge + '  ');
       WITH DT DO BEGIN
         RemPutBuffer(Int0(Day,2)+'.'+Int0(Month,2)+'.');
         RemPutBuffer(Int0(Year MOD 100,2)+'  '+Int0(Hour,2)+':'+Int0(Min,2)+ #13);
       END;

       Inc(FCount);
       FindNext(SRec);

     END; { WHILE DosError ... }

   END;

   free := DiskFree(Ord(Pfad[1]) - 64) DIV 1024;
   RemPutBuffer(#13+int_Str(FCount)+' File(s), '+int_Str(free)
                     +' KByte frei'+#13);

END;


{------------------------------------------------------------------------------
| Ausgabe eines vereinfachten Catalogs
+-----------------------------------------------------------------------------}

PROCEDURE RemCat (Suchbegriff : String);

VAR
      FileExt     : STRING[3];
      PunktPos    : INTEGER;
      Laenge      : STRING[10];
      Pfad        : PathStr;
      SRec        : SearchRec;         { Im Unit DOS definiert }
      DT          : DateTime;
      FCount      : INTEGER;

BEGIN

  Pfad := Suchbegriff;

  FCount := 0;

  FindFirst(Pfad,Archive OR ReadOnly,SRec);

  IF (DosError = 0) THEN

   BEGIN

     WHILE (DosError = 0) DO WITH SRec DO BEGIN

       UnpackTime(Time,DT);
       PunktPos := Pos('.',Name);

       IF (PunktPos <> 0) THEN
        BEGIN
          FileExt := Copy(Name,PunktPos+1,Length(Name)-PunktPos);
          Delete(Name,PunktPos,1+Length(Name)-PunktPos);
        END
       ELSE
        FileExt := '';

       FileExt := FileExt + Space(3-Length(FileExt));
       Name := Name + Space(8-length(Name));

       Str(Size,Laenge);
       Laenge := Space(7-Length(Laenge)) + Laenge;
       RemPutBuffer(Name + ' ' + FileExt);
       RemPutBuffer(Laenge + '  ');
       WITH DT DO BEGIN
         RemPutBuffer(Int0(Day,2)+'.'+Int0(Month,2)+'.');
         RemPutBuffer(Int0(Year MOD 100,2)+'  '+Int0(Hour,2)+':'+Int0(Min,2)+ #13);
       END;

       Inc(FCount);
       FindNext(SRec);

     END; { WHILE DosError ... }
   END;
END;


{-----------------------------------------------------------------------------
| Remote-Filesenden abbrechen
+----------------------------------------------------------------------------}

PROCEDURE RemStopFilesend (Kanal : INTEGER);

 VAR   i1     : INTEGER;

 BEGIN
   RemClearBuffer;
   IF K[Kanal]^.FileSend THEN WITH K[Kanal]^ DO
    BEGIN
      Close(TXFile);
      FileSend := FALSE;
      Status1(Kanal);
      TextAttr := low;
      RemPutBuffer(#13#13#13+'*** Read abgebrochen!'+#13);
      IF (TX_Name = RemDosTmpName(Kanal)) THEN
       BEGIN
         { temporre Dos-Datei lschen }
         Assign(TXFile,TX_Name);
         {$I-}
         Erase(TXFile);   {$I+}
         i1 := IOResult;
       END;
    END;
 END;


{-----------------------------------------------------------------------------
| Suche nach dem ersten freien Filenamem
| Filename-Aufbau:   Drive:Path\NAME.NUMMER  mit NUMMER = 000..999
+----------------------------------------------------------------------------}

PROCEDURE RemSearchFree (VAR FileName : String);

 VAR   i         : INTEGER;
       L         : INTEGER;
       free      : BOOLEAN;

 BEGIN
   FileName := FileName + '.000';
   L := Length(FileName) - 2;          { Zeiger auf erste Stelle nach dem Punkt }
   i := 0;
   free := FALSE;
   REPEAT
     Delete(FileName,L,3);                 { FileNummer abschneiden }
     FileName := FileName + Int0(i,3);
     IF NOT RemSearchFirst(FileName) THEN    { File vorhanden? }
       free := TRUE
     ELSE
       Inc(i);
   UNTIL free OR (i >= 1000);    { 1000 Files wird's wohl nicht geben... }
 END;



{-----------------------------------------------------------------------------
|  Kommando-Dekoder der Remote-Funktion
+----------------------------------------------------------------------------}

PROCEDURE RemDecode(Kanal : Byte; Response : String; Position : Byte;
                    RemTerm : BOOLEAN);

 VAR   Command     : INTEGER;
       CmdStr      : String[10];
       CmdStr1     : String[1];
       CmdStr2     : String[2];
       CmdStr3     : String[3];
       Zeile       : String;
       subStr      : String;
       a,b,c,i,i1  : INTEGER;
       Error       : INTEGER;
       gefunden    : BOOLEAN;
       Datei       : File;


 PROCEDURE not_available(Kanal : Byte; CmdZeile : String);

  BEGIN
    RemSendBuffered(Kanal,#13+CmdZeile+' noch nicht implementiert.'#13+RemPrompt(Kanal));
  END;


 PROCEDURE invalid_Command(Kanal : Byte);

  BEGIN
    IF (K[Kanal]^.RemStatus = 0) THEN
     BEGIN
       RemSendBuffered(Kanal,#13'What ?'#13 + RemPrompt(Kanal));
     END;
  END;


 BEGIN

   IF (K[Kanal]^.RemStatus < 0) AND NOT RemTerm THEN Exit; { kein Remote freigegeben }

   RemoteTerm := RemTerm;

   Delete(Response,Position,Position+1);   { // abschneiden }
   Response := CutLeftStr(Response);       { fhrende Spaces trennen }
   Response := upcaseStr(Response);        { Groschrift }
   CmdStr := CutStr(Response);
   CmdStr1 := Copy(CmdStr,1,1);
   CmdStr2 := Copy(CmdStr,1,2);
   CmdStr3 := Copy(CmdStr,1,3);

   IF CmdStr1 = 'Q'   THEN Command := 1  ELSE   { Quit }
   IF CmdStr1 = 'T'   THEN Command := 2  ELSE   { Time }
   IF CmdStr2 = 'WP'  THEN Command := 10 ELSE   { WPrg }
   IF CmdStr1 = 'W'   THEN Command := 3  ELSE   { Write }
   IF CmdStr1 = 'S'   THEN Command := 3  ELSE   { Send }
   IF CmdStr2 = 'RI'  THEN Command := 14 ELSE   { RIng }
   IF CmdStr2 = 'RP'  THEN Command := 11 ELSE   { RPrg }
   IF CmdStr2 = 'RU'  THEN Command := 16 ELSE   { RUn }
   IF CmdStr1 = 'R'   THEN Command := 4  ELSE   { Read }
   IF CmdStr2 = 'DO'  THEN Command := 13 ELSE   { DOs }
   IF CmdStr1 = 'D'   THEN Command := 5  ELSE   { Dir }
   IF CmdStr1 = 'C'   THEN Command := 5  ELSE   { Cat }
   IF CmdStr2 = 'MH'  THEN Command := 6  ELSE   { MHeard }
   IF CmdStr1 = 'I'   THEN Command := 7  ELSE   { Info }
   IF CmdStr1 = 'H'   THEN Command := 8  ELSE   { Help }
   IF CmdStr1 = 'K'   THEN Command := 9  ELSE   { Kill }
   IF CmdStr3 = 'PRI' THEN Command := 12 ELSE   { PRIv }
   IF CmdStr1 = 'B'   THEN Command := 14 ELSE   { Bell }
   IF CmdStr1 = 'E'   THEN Command := 15 ELSE   { Echo }
     Command := 0;

   WITH K[Kanal]^ DO BEGIN

   CASE Command OF

     0 : BEGIN
           { Kommando nicht erkannt }
           IF (RemStatus = 0) THEN
             invalid_Command(Kanal);
         END;

     1 : BEGIN
           { Quit-Kommando }
           RemStopFilesend(Kanal);
           RemClearBuffer;
           Zeile := RemLogoutStr;
           RemConvert(Zeile,Kanal);
           RemPutBuffer(Zeile);
           RemSendBuffer(Kanal);
           S_Com(Kanal,'D');           { disc. bei TNC1 nicht einwandfrei! }
         END;

     2 : BEGIN
           { Time-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              subStr := 'TurboPR $V vom $U   ';
              RemConvert(subStr,Kanal);
              RemSendBuffered(Kanal,#13 + subStr + Date + '  ' + Time + #13
                                    + RemPrompt(Kanal));
            END;
         END;

     3 : BEGIN
           { Write- oder Send-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              IF Save THEN
               BEGIN
                 RemSendBuffered(Kanal,#13'Nachrichtenspeicher ist permanent eingeschaltet,' +
                          #13'daher ist kein Write moeglich.'#13 +
                          RemPrompt(Kanal));
               END
              ELSE
               BEGIN
                 Zeile := RemArg(Response);
                 IF (Zeile = '') THEN
                   RemSendBuffered(Kanal,#13'WRITE erfordert die Angabe des Dateinamens!'#13
                                  + RemPrompt(Kanal))
                 ELSE
                   BEGIN
                     Zeile := Copy(Zeile,1,8);     { max. 8 Zeichen Filename }
                     Zeile := onlyFName(Zeile);
                     i := Pos('.',Zeile);
                     IF i > 0 THEN                 { Punkt ausschlieen }
                       Zeile := Copy(Zeile,1,i-1);
                     RemSearchFree(Zeile);    { nchsten freien Filenamen suchen }
                     Zeile := RemPfad + Zeile;
                     RemSendBuffered(Kanal,#13'Text eingeben fuer '+
                           onlyFName(Zeile)+', beenden mit Ctrl-Z  >'#13#13+
                           RemTxRxStr(Kanal));
                     IF simplex THEN
                       S_Com(Kanal,'@X1');
                     RX_Name := Zeile;
                     { Filename ist klar, also los...}
                     Save := TRUE;
                     RX_Mode := 0;
                     RX_Count := 0;
                     Assign(RXFile,Zeile);
                     SetTextBuf(RXFile,RXFileBuffer^);
                     OpenRXFile(Kanal);
                     WRITELN(RXFile,'fm '+ onlyCall(Call) + '  ' + Date + '  '
                                + Time + CRLF);
                     RemStatus := 5;
                     restore_Screen;    { fr alle Flle }
                   END;
               END;
            END;
         END;

     4 : BEGIN
           { Read-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              Zeile := RemArg(Response);
              IF (Zeile = '') THEN
                RemSendBuffered(Kanal,#13'READ erfordert die Angabe des Dateinamens!'#13
                               + RemPrompt(Kanal))
              ELSE
                BEGIN
                  IF NOT ((RemPriv = 2) AND
                    ((Pos(':',Zeile) > 0) OR (Pos('\',Zeile) > 0))) THEN
                     BEGIN
                       Val(Zeile,a,Error);
                       IF (Error = 0) AND (a >= 0) AND (a < 1000) THEN
                        BEGIN
                          { Filenummer soll gelesen werden }
                          { als Name wird "<CALL>.Nummer" generiert }
                          Zeile := RemPfad + onlyCall(Call)
                                           + '.' + Int0(a,3);
                        END
                       ELSE
                        Zeile := RemPfad + onlyFName(Zeile);
                     END;
                  RemSendText(Kanal,Zeile,FInfo);
                END;
            END
           ELSE
            BEGIN
              { RemStatus <> 0 }
              IF (FileSend) THEN
               BEGIN
                 { es wird gerade ein File gesendet, also abbrechen }
                 RemStopFileSend(Kanal);
                 RemPutBuffer(#13 + RemPrompt(Kanal));
                 RemSendBuffer(Kanal);
                 RemStatus := 0;
               END;
            END;
         END;

     5 : BEGIN
           { Cat- oder Dir-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              Zeile := upcaseStr(RemArg(Response));
              IF (Zeile = '') THEN Zeile := '*.*';
              RemClearBuffer;
              RemCatalog(Kanal,Zeile);
              RemPutBuffer(RemPrompt(Kanal));
              RemSendBuffer(Kanal);
            END;
         END;

     6 : BEGIN
           { MHeard-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              i := Pos('#',Response);
              IF (i > 0) THEN
                BEGIN
                  Val(Copy(Response,i+1,1),i1,a);
                  IF (a <> 0) OR (i1 > 4) OR (i1 < 1) OR (NOT TNC[i1].used)
                    THEN i1 := TNCNummer;
                  Delete(Response,i,2);
                END
              ELSE
                i1 := TNCNummer;
              Zeile := upcaseStr(RemArg(Response));
              RemPutBuffer(#13);
              RemPutBuffer('TNC '+int_Str(i1));
              IF TNC[i1].currentQRG <> '' THEN
                RemPutBuffer(' ('+CutLeftStr(TNC[i1].currentQRG)+'):'#13#13)
              ELSE
                RemPutBuffer(':'#13#13);
              c := 0;
              a := 10;
              subStr := '';
              FOR i := 1 TO 60 DO
                IF TNC[i1].MH^[i].Call <> '' THEN Inc(c);

              IF Zeile <> '' THEN
               BEGIN
                 { Parameter auswerten }
                 Val(Zeile,a,i);
                 IF (i > 0) THEN
                  BEGIN
                    { Parameter war keine Zahl, also Call vermuten }
                    subStr := Zeile;
                    i := Pos('-',subStr);
                    IF (i > 0) THEN subStr := Copy(subStr,1,i-1);
                    a := c;
                  END;
               END;
              IF (a > c) THEN a := c;

              IF subStr = '' THEN
               BEGIN
                 { einen Teil der Heardliste ausgeben }
                 RemPutBuffer('Die '+int_Str(a)+' zuletzt gehoerten Rufzeichen:'#13#13);
                 FOR i := 1 TO a DO BEGIN
                   WITH TNC[i1].MH^[i] DO BEGIN
                     IF (Call <> '') THEN
                      BEGIN
                        RemPutBuffer(Call + '  ' + Zeit);
                        Str(Info:6,subStr);
                        RemPutBuffer(subStr + #13);
                      END;
                   END;
                 END;
               END
              ELSE
               BEGIN
                 { Heardliste nach Call durchsuchen }
                 gefunden := FALSE;
                 Zeile := subStr;
                 FOR i := 1 TO a DO BEGIN
                   WITH TNC[i1].MH^[i] DO BEGIN
                     subStr := Call;
                     b := Pos(' ',subStr);
                     IF (b > 0) THEN subStr := Copy(subStr,1,b-1);
                     b := Pos('-',subStr);
                     IF (b > 0) THEN subStr := Copy(subStr,1,b-1);
                     IF (subStr = Zeile) THEN
                      BEGIN
                        RemPutBuffer(Call + '  ' + Zeit);
                        Str(Info:6,subStr);
                        RemPutBuffer(subStr + #13);
                        gefunden := TRUE;
                      END;
                   END;
                 END;
                 IF NOT gefunden THEN
                   RemPutBuffer(Zeile+' wurde noch nicht gehoert.'#13);
               END;
              RemPutBuffer(RemPrompt(Kanal));
              RemSendBuffer(Kanal);
            END;
         END;

     7 : BEGIN
           { Info-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              RemSendText(Kanal,SysPfad+'REMINFO.PR',NoFInfo);
            END;
         END;

     8 : BEGIN
           { Help-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              RemSendText(Kanal,SysPfad+'REMHELP.PR',NoFInfo);
            END;
         END;

     9 : BEGIN
           { Kill-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              RemPutBuffer(#13);
              Zeile := upcaseStr(RemArg(Response));
              Val(Zeile,a,Error);
              IF (Error = 0) AND (a >= 0) AND (a < 1000) THEN
               BEGIN
                 Str(a:3,Zeile);
                 IF (a < 100) THEN Zeile[1] := '0';
                 IF (a < 10) THEN Zeile[2] := '0';
                 Zeile := RemPfad + onlyCall(Call) + '.' + Zeile;
                 IF File_exists(Zeile) THEN
                  BEGIN
                    Assign(Datei,Zeile);
                    {$I-}
                    Erase(Datei);   {$I+}
                    IF (IOResult = 0) THEN
                      RemPutBuffer('Datei '+onlyFName(Zeile)+' geloescht.'#13)
                    ELSE
                      RemPutBuffer('Datei '+onlyFName(Zeile)+
                                    ' konnte nicht geloescht werden!'#13);
                  END
                 ELSE
                  BEGIN
                    RemPutBuffer('Datei '+onlyFName(Zeile)+' nicht gefunden!'+#13);
                  END;
               END
              ELSE
               BEGIN
                 RemPutBuffer('Nichts geloescht! Die Nachrichten-Nummer fehlt!'#13);
               END;
              RemPutBuffer(RemPrompt(Kanal));
              RemSendBuffer(Kanal);
            END;
         END;

     10: BEGIN
           { WPrg-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              IF Save THEN
               BEGIN
                 { Speichern schon eingeschaltet ! }
                 RemPutBuffer(#13'Save ist permanent eingeschaltet, ' +
                    'daher kein WPrg moeglich!'#13);
               END
              ELSE
               BEGIN
                 IF (RemPriv = 2) THEN
                   BEGIN
                     IF (Pos(':',Response) > 0) OR (Pos('\',Response) > 0) THEN
                       Zeile := upcaseStr(RemArg(Response))
                     ELSE
                       Zeile := RemPfad + upcaseStr(RemArg(Response));
                   END
                 ELSE
                   Zeile := RemPfad + upcaseStr(RemArg(Response));

                 FiFoStr := ConstStr(#13,80);
                 RX_expectCheck := 0;
                 RX_Name := Zeile;
                 Assign(RXFile,RX_Name);
                 SetTextBuf(RXFile,RXFileBuffer^);
                 RX_Count := 0;
                 RX_Mode := 2;
                 {$I-}
                 Reset(RXFile);  {$I+}
                 Error := IOResult;
                 IF (Error <> 2) THEN
                  BEGIN
                    { File vorhanden oder Fehler ! }
                    {$I-}
                    Close(RXFile);   {$I+}
                    Error := IOResult;
                    RemPutBuffer(#13'Datei kann nicht geschrieben werden!'#13);
                  END
                 ELSE
                  BEGIN
                    { File nicht vorhanden, also los }
                    Save := TRUE;
                    Rewrite(RXFile);
                    Status1(Kanal);
                    RemPutBuffer(#13'Fertig fuer Binaerfile-Empfang.'#13);
                  END;
               END;
              RemPutBuffer(RemPrompt(Kanal));
              RemSendBuffer(Kanal);
            END;
         END;

     11: BEGIN
           { RPrg-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              IF NOT FileSend THEN
               BEGIN
                 IF (RemPriv = 2) THEN
                   BEGIN
                     IF (Pos(':',Response) > 0) OR (Pos('\',Response) > 0) THEN
                       Zeile := upcaseStr(RemArg(Response))
                     ELSE
                       Zeile := RemPfad + upcaseStr(RemArg(Response));
                   END
                 ELSE
                   Zeile := RemPfad + upcaseStr(RemArg(Response));
                 IF (File_exists(Zeile)) THEN
                  BEGIN
                    { Datei gefunden, also AutoBin einleiten }
                    TX_Mode := 2;
                    TX_Name := Zeile;
                    Assign(TXFile,TX_Name);
                    {$I-}
                    Reset(TXFile,1);   {$I+}
                    TX_Laenge := FileSize(TXFile);
                    Close(TXFile);
                    Reset(TXFile);
                    blockREAD(TXFile,TXFileBuffer^,8,i);
                    TX_Count := 0;
                    TX_Buffer_Count := 1;
                    TX_CRC := 0;
                    TX_Sum := 0;
                    RemSendBuffered(Kanal,
                                     '#BIN#'
                                     + int_Str(TX_Laenge) + '#'
                                     + '|'+int_Str(GetChecksum(TX_Name,TRUE))+'#'
                                     + '$'+Hex(packedFTime(TXFile),8)+'#'
                                     + onlyFName(TX_Name)
                                     + #13);
                    FileSend := TRUE;
                    RemStatus := 20;
                    Status1(Kanal);
                  END
                 ELSE
                  BEGIN
                    { Datei nicht gefunden }
                    RemSendBuffered(Kanal,#13'Datei '+onlyFName(Zeile)+
                              ' nicht gefunden!'#13 + RemPrompt(Kanal));
                  END;
               END;
            END;
         END;

     12: BEGIN
           { PRIV-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              IF (RemPriv > 0) THEN
               BEGIN
                 { Priv-Call }
                 Zeile := RemArg(Response);
                 IF Length(Zeile) > 0 THEN
                  BEGIN
                    { PRIV mit Argument }
                    IF (Zeile = RemPrivAnswer) THEN RemPriv := 2;
                    RemSendBuffered(Kanal,RemPrompt(Kanal));
                  END
                 ELSE
                  BEGIN
                    { PRIV ohne Argument, also Pawort generieren }
                    Zeile := '';
                    RemPrivAnswer := '     ';
                    Randomize;
                    FOR i := 1 TO 5 DO
                     BEGIN
                       REPEAT
                         a := 1 + Random(Length(RemPWStr));
                       UNTIL RemPWStr[a] <> ' ';
                       RemPrivAnswer[i] := upcase(RemPWStr[a]);
                       Zeile := Zeile + int_Str(a) + ' ';
                     END;
                    RemSendBuffered(Kanal,#13+'>  '+Zeile+#13+RemPrompt(Kanal));
                  END
               END
              ELSE
               BEGIN
                 { Call ist kein Priv-Call }
                 invalid_Command(Kanal);
               END;
            END;
         END;

     13: BEGIN
           { DOS-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              IF (RemPriv = 2) THEN
                BEGIN                              { Call ist privilegiert }
                  Zeile := Response;
                  Delete(Zeile,Length(Zeile),1);   { CR abtrennen }
                  WHILE (Zeile[0] > #0) AND (Zeile[1] <> ' ') DO
                    Delete(Zeile,1,1);
                  Zeile := cutLeftStr(Zeile);
                  IF (Length(Zeile) > 0) THEN
                   BEGIN
                     Zeile := 'DOS ' + Zeile + ' > ' + RemDosTmpName(Kanal);
                     do_DOSCommand(Zeile,FALSE,FALSE,FALSE,BSave);
                     Zeile := RemDosTmpName(Kanal);
                     IF File_exists(Zeile) THEN
                       RemSendText(Kanal,Zeile,NoFInfo)
                     ELSE
                       RemSendBuffered(Kanal,RemPrompt(Kanal));
                   END
                  ELSE
                   BEGIN
                     { DOS-Kommando ohne Parameter ... }
                     RemSendBuffered(Kanal,RemPrompt(Kanal));
                   END;
                END
              ELSE
                invalid_Command(Kanal);
            END;
         END;

     14: BEGIN
           { RIng oder Bell }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              IF Klingel THEN
                FOR i := 1 TO 5 DO
                 BEGIN
                   Beep(1000,50);
                   Beep(1400,50);
                 END;
              RemSendBuffered(Kanal,#13'Sysop wurde gerufen.'#13
                                    + RemPrompt(Kanal));
            END;
         END;

     15: BEGIN
           { Echo }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              Zeile := ResponseStr;
              i := Pos(' ',Zeile);
              IF (i = 0) THEN
                i := Length(Zeile);
              Zeile := Copy(Zeile,i+1,255);
              Zeile := CutLeftStr(Zeile);
              RemPutBuffer(Zeile);
              RemPutBuffer(RemPrompt(Kanal));
              RemSendBuffer(Kanal);
            END;

         END;

     16: BEGIN
           { RUN-Kommando }
           IF (RemStatus = 0) THEN
            BEGIN
              RemClearBuffer;
              Zeile := Response;
              Delete(Zeile,Length(Zeile),1);   { CR abtrennen }
              WHILE (Zeile[0] > #0) AND (Zeile[1] <> ' ') DO
                Delete(Zeile,1,1);
              Zeile := cutLeftStr(Zeile);
              IF (Length(Zeile) > 0) THEN
               BEGIN
                 Zeile := 'DOS ' + RemRunPfad + Zeile + ' > ' + RemDosTmpName(Kanal);
                 do_DOSCommand(Zeile,FALSE,FALSE,FALSE,BSave);
                 Zeile := RemDosTmpName(Kanal);
                 IF File_exists(Zeile) THEN
                   RemSendText(Kanal,Zeile,NoFInfo)
                 ELSE
                   RemSendBuffered(Kanal,RemPrompt(Kanal));
               END
              ELSE
               BEGIN
                 { RUN-Kommando ohne Parameter, also einfaches Directory }
                 RemPutBuffer(#13+'Ausfuehrbare Files im Run-Verzeichnis:'+#13#13);
                 Zeile := RemRunPfad + '*.BAT';
                 RemCat(Zeile);
                 Zeile := RemRunPfad + '*.COM';
                 RemCat(Zeile);
                 Zeile := RemRunPfad + '*.EXE';
                 RemCat(Zeile);
                 RemPutBuffer(RemPrompt(Kanal));
                 RemSendBuffer(Kanal);
               END;
            END;
         END;

   END;        { CASE }

   END;        { WITH K[Kanal]^ DO }

 END;


BEGIN

  {---------------------------------------------------------------------------
  |  Initialisierung
  +--------------------------------------------------------------------------}

  RemCfgOK := FALSE;

END.
