
{------------------------------------------------------------------------------
|
|    P R S C R E E N . P A S
|
|    Routinen fr direkten Video-RAM-Zugriff und Seitenverwaltung;
|    ebenfalls enthalten: Druckerausgabe, Text-Abspeicherung und Verwaltung
|    der Notizseite.
|
|    DL1BHO  10/1992
|
|    nderungen:
|
|    10/94:  Neue Darstellung des Edit-Cursors ber einen Timer
|
+-----------------------------------------------------------------------------}


UNIT PRSCREEN;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


USES
       PRDefs;


PROCEDURE scroll_up (Y1,Y2 : Byte);
PROCEDURE scroll_down (Y1,Y2 : Byte);
PROCEDURE _aus(Kanal : BYTE ; Zeile : String);
PROCEDURE M_aus(Zeile : String);
PROCEDURE WRITElst(Zeile : String);
PROCEDURE Show_Flags(Kanal : BYTE);
PROCEDURE Status1(Kanal : INTEGER);
PROCEDURE Status1Out(Kanal : INTEGER; XPos : Byte; Attr : Byte; Zeile : Str80);
PROCEDURE Status2;
PROCEDURE WriteEditStr (Zeile : Str80);
PROCEDURE ClearEditCursor;
PROCEDURE ShowEditCursor;
PROCEDURE restoreEditLines;
PROCEDURE maxWindow;
PROCEDURE timedWindow (minTime, maxTime : INTEGER; Farbe : Byte; Zeile : String);
PROCEDURE CopyrightWindow;
PROCEDURE SetBorderColor (Farbe : Byte);


IMPLEMENTATION


USES
       Dos,
       Crt,
       Printer,
       PRLib,
       PRRemote,
       PRLib4,
       PRMouse,
       PRCRC;


{-----------------------------------------------------------------------------
|  den Bildschirm von Zeile Y1 bis Zeile Y2 nach OBEN scrollen
+----------------------------------------------------------------------------}

PROCEDURE scroll_up (Y1,Y2 : Byte);

 VAR   AMerk    : Byte;

 BEGIN
   AMerk := TextAttr;
   TextAttr := low;
   Window(1,Y1,MaxX,Y2);
   GotoXY(1,Y2-Y1+1);
   WRITELN;
   maxWindow;
   TextAttr := AMerk;
 END;


{-----------------------------------------------------------------------------
|  den Bildschirm von Zeile Y1 bis Zeile Y2 nach UNTEN scrollen
+----------------------------------------------------------------------------}

PROCEDURE scroll_down (Y1,Y2 : Byte);

 VAR   AMerk    : Byte;

 BEGIN
   AMerk := TextAttr;
   TextAttr := low;
   Window(1,Y1,MaxX,Y2);
   GotoXY(1,1);
   InsLine;
   maxWindow;
   TextAttr := AMerk;
 END;


{-----------------------------------------------------------------------------
| WRITE_SaveFile  schreibt einen String in die SaveDatei eines Kanals,
| die Unterscheidung Binrfile/Textfile wird ebenfalls hier behandelt.
+----------------------------------------------------------------------------}

PROCEDURE WRITE_SaveFile (Kanal : BYTE ; VAR Zeile : String);

VAR i,y         : INTEGER;
    ch          : char;
    WriteError  : INTEGER;
    AStore      : Byte;
    RemSaveEnde : BOOLEAN;

 PROCEDURE DiskError(Kanal, Error : INTEGER);
  VAR  i           : INTEGER;
       AttrStore   : Byte;
  BEGIN
    AttrStore := TextAttr;
    TextAttr := neg;
    y := MaxY DIV 2 - 4;
    Fenster(20,y,40,8,'Disk');
    TextAttr := FHighAttr;
    GotoXY(23,y+3);
    WRITE('Kanal ',Kanal,' : ');
    TextAttr := FBlinkAttr;
    WRITELN('Disk- oder Plattenfehler !');
    TextAttr := FHighAttr;
    GotoXY(23,y+5);
    WRITELN(FehlerText(Error));
    NoSound;
    FOR i := 1 TO 5 DO
     BEGIN
       Sound(880);
       Delay(10*DelayCorr);
       NoSound;
       Delay(8*DelayCorr);
     END;
    Delay(500*DelayCorr);
    TextAttr := AttrStore;
    Restore_Screen;
  END;

BEGIN                 { Write_SaveFile }
  AStore := TextAttr;
  RemSaveEnde := FALSE;
  WITH K[Kanal]^ DO
  BEGIN
    CASE RX_Mode OF
     0 : BEGIN
           { normale TextDatei, also Zeichen u.U. konvertieren }
           {$I-}
           i := 1;
{           FOR i := 1 TO length(Zeile) DO }
{           BEGIN }
           REPEAT
	     ch := Zeile[i];
             IF (Umlaut = 1) THEN
              BEGIN
                { 7-Bit Umlaute in IBM-Umlaute wandeln }
                CASE ch OF
                 #91 : ch := '';
                 #92 : ch := '';
                 #93 : ch := '';
                 #123: ch := '';
                 #124: ch := '';
                 #125: ch := '';
                 #126: ch := '';
                END;
              END;

             CASE ch OF
              ^I  : WRITE(RXFile,^I);
              ^J  : ;
              ^M  : BEGIN
                      WRITELN(RXFile);
                    END;
              ^Z  : IF (RemStatus = 5) THEN
                      BEGIN
                        RemSaveEnde := TRUE;
                        i := Length(Zeile);      { Speichern abbrechen }
                      END
                    ELSE
                      WRITE(RXFile,^Z);
              ELSE  BEGIN
                      IF (ch < #32)
                        THEN WRITE(RXFile,'^',Chr(Ord(ch)+64))
                        ELSE WRITE(RXFile,ch);
                    END;
             END;
             Inc(i);
           UNTIL (i > Length(Zeile)) OR RemSaveEnde;
{           END;   }
           {$I+}
           WriteError := IOResult;
           RX_Count := RX_Count + Length(Zeile);
           Status1Out(Kanal,16,neg_high,RxTxStr(Kanal));
           IF (WriteError > 0) THEN
            BEGIN
              DiskError(Kanal,WriteError);
              CloseRXFile(Kanal);
              Status1(Kanal);
            END;
           IF RemSaveEnde THEN
            BEGIN
              CloseRXFile(Kanal);
              RemStatus := 0;
              { FileEnde melden }
              RemSendBuffered(Kanal,#13'Text ok fuer '+onlyFName(RX_Name)
                      +#13+RemPrompt(Kanal));
              IF simplex THEN
                S_Com(Kanal,'@X0');
              Status1(Kanal);
            END;
         END;
     1 : BEGIN
           { Normaler BinrDatei-Empfang }
           {$I-}
           WRITE(RXFile,Zeile);
           {$I+}
           WriteError := IOResult;
           RX_Count := RX_Count + Length(Zeile);
           Status1Out(Kanal,16,neg_high,RxTxStr(Kanal));
           IF (WriteError > 0) THEN
            BEGIN
              DiskError(Kanal,WriteError);
              CloseRXFile(Kanal);
              Status1(Kanal);
            END;
         END;
     2 : BEGIN
           { Warten auf die Binrfile-Lnge, also nichts speichern ! }
         END;
     3 : BEGIN
           { Automatischer Binrfile-Empfang }
           {$I-}
           WRITE(RXFile,Zeile);       {I+}
           WriteError := IOResult;
           RX_Count := RX_Count + Length(Zeile);
           FOR i := 1 TO Length(Zeile) DO
             RX_Checksum := CRC(Ord(Zeile[i]),RX_Checksum);
           Status1Out(Kanal,16,neg_high,RxTxStr(Kanal));
           IF (RX_Count >= RX_Laenge) OR (WriteError > 0) THEN
           BEGIN
             { File-Ende ist erreicht, File-Empfang abbrechen ! }
             IF (WriteError > 0) THEN
              BEGIN
                DiskError(Kanal,WriteError);
              END;
             Flush(RXFile);
             IF (DTInt <> 0) THEN SetFTime(RXFile,DTInt);
             CloseRXFile(Kanal);
             Status1(Kanal);
             IF (Remote = 2) THEN
              BEGIN
                RemStatus := 0;
                RemSendBuffered(Kanal,#13'BIN-RX ok #'+Int_Str(RX_Checksum)+
                                 #13+RemPrompt(Kanal));
                IF simplex THEN
                  S_Com(Kanal,'@X0');
              END
             ELSE
              BEGIN
                myText := TRUE;
                TextAttr := low;
                IF (RX_expectCheck <> 0) THEN
                  BEGIN
                    IF (RX_Checksum = RX_expectCheck) THEN
                      _aus(Kanal,'BIN-RX ok #'+Int_Str(RX_Checksum)+
                           '/'+Int_Str(RX_expectCheck)+#13)
                    ELSE
                      BEGIN
                        TextAttr := blinkAttr;
                        _aus(Kanal,'BIN-RX-Error #'+Int_Str(RX_Checksum)+
                             '/'+Int_Str(RX_expectCheck)+#13);
                      END;
                  END
                ELSE
                  _aus(Kanal,'BIN-RX ok #'+Int_Str(RX_Checksum)+#13);
              END;
           END;
         END;
    END; { CASE RX_Mode OF ... }

  END; { WITH ... DO }

  TextAttr := AStore;
END;


{-----------------------------------------------------------------------------
| WRITE_Drucker  schickt einen String zum Drucker.
| Steuerzeichen an den Drucker muessen schon vorher gesendet werden !
| Die Fehlerbehandlung wird durch die Prozedur WRITElst() sichergestellt.
+----------------------------------------------------------------------------}

PROCEDURE WRITE_Drucker (Kanal : BYTE ; VAR Zeile : String);

VAR  i   : INTEGER;
     ch  : char;

BEGIN
  WITH K[Kanal]^ DO
  BEGIN
    FOR i := 1 TO length(Zeile) DO
    BEGIN
      ch := Zeile[i];
      IF (D_Spalte > 80) and (ch <> #13) THEN
      BEGIN
        WRITElst(CrLf);
        D_Spalte := 1;
      END;

      IF (Umlaut = 1) THEN
       BEGIN
         { 7-Bit Umlaute in IBM-Umlaute wandeln }
         CASE ch OF
          #91 : ch := '';
          #92 : ch := '';
          #93 : ch := '';
          #123: ch := '';
          #124: ch := '';
          #125: ch := '';
          #126: ch := '';
         END;
       END;

      CASE ch OF
       ^J  : ;
       ^M  : BEGIN
               IF (Kanal = 0) THEN
               BEGIN
                 IF D_Spalte <> 1 THEN WRITElst(CrLf);
               END
               ELSE WRITElst(CrLf);
               D_Spalte := 1;
             END;
       #127: ;
       ELSE  BEGIN
               IF (ch > #31) THEN BEGIN
                 WRITElst(ch);
                 Inc(D_Spalte);
               END;
             END;
      END;

    END;

  END;    { WITH K[Kanal]^ }

END;


{------------------------------------------------------------------------------
|  Eine Zeile in den Notiz-Buffer schreiben
+-----------------------------------------------------------------------------}

PROCEDURE WRITE_Notiz (Kanal : BYTE ; VAR Zeile : String);

 VAR i         : BYTE;
     ch        : CHAR;

 PROCEDURE Notiz_newLine;
  BEGIN
    NotizX := 1;
    Inc(NotizBufferP);
    IF (NotizBufferP > NotizBufferPmax) THEN NotizBufferP := 1;
    FillChar(NotizBuffer^[NotizBufferP],80,' ');
  END;

 BEGIN

   WITH K[Kanal]^ DO
   BEGIN

     FOR i := 1 TO length(Zeile) DO
     BEGIN

       ch := Zeile[i];

       IF (Umlaut = 1) THEN
        BEGIN
          { 7-Bit Umlaute in IBM-Umlaute wandeln }
          CASE ch OF
           #91 : ch := '';
           #92 : ch := '';
           #93 : ch := '';
           #123: ch := '';
           #124: ch := '';
           #125: ch := '';
           #126: ch := '';
          END;
        END;

       IF (ch >= #32) THEN
        BEGIN
          NotizBuffer^[NotizBufferP,NotizX] := ch;
          Inc(NotizX);
        END
       ELSE
        BEGIN
          IF (ch = #13) THEN Notiz_newLine;
        END;

       IF (NotizX > 80) THEN Notiz_newLine;

     END; { FOR i := ... }

   END; { WITH K[Kanal]^ DO }
 END;


{-----------------------------------------------------------------------------
|  Ein Zeichen in den Kanalbuffer einfgen
+----------------------------------------------------------------------------}

PROCEDURE PutAttrChxBuffer (Kanal : Byte; chx : Char);

 BEGIN
   WITH K[Kanal]^ DO
    BEGIN
      ChxBuffer^[ChxBufferP,X2] := chx;
      AttrBuffer^[AttrBufferP,X2] := chr(TextAttr);
    END;
 END;


PROCEDURE AttrChxNewline (Kanal : Byte);

 VAR   i         : INTEGER;
       StdAttr   : Char;

 BEGIN
   WITH K[Kanal]^ DO
    BEGIN
      Inc(AttrBufferP);
      IF (AttrBufferP > AttrBufferPmax) THEN AttrBufferP := 1;
      Inc(ChxBufferP);
      IF (ChxBufferP > ChxBufferPmax) THEN ChxBufferP := 1;
      IF Kanal = 0 THEN
        StdAttr := Chr(MoniInfoAttr)
      ELSE
        StdAttr := Chr(ConRXAttrib);
      FOR i := 1 TO 80 DO
       BEGIN
         ChxBuffer^[ChxBufferP,i] := ' ';
         AttrBuffer^[AttrBufferP,i] := StdAttr;
       END;
      X2 := 1;     { neue X-Position }
    END;
 END;


{------------------------------------------------------------------------------
| Zeile im Hauptschirm ausgeben
+-----------------------------------------------------------------------------}

PROCEDURE _aus (Kanal : BYTE ; Zeile : String);
VAR i,j       : INTEGER;
    ch        : CHAR;
    BildPos   : INTEGER;  { Position auf dem Schirm }
    aktuell   : BOOLEAN;
    Y_Pos     : INTEGER;
    AMerk     : BYTE;

BEGIN

  IF (Kanal = show) AND NOT ScreenSTBY
    THEN aktuell := TRUE
    ELSE aktuell := FALSE;

  WITH K[Kanal]^ DO IF poll THEN
  BEGIN

    Y_Pos := PRED(Trenn);
    BildPos := PRED(Y_Pos) * 2 * maxX + PRED(X2 shl 1);

    IF (NOT Save) OR (Save AND ((RX_Mode = 0) OR (RX_Mode = 2))) OR myText THEN
    FOR i := 1 TO length(Zeile) DO
    BEGIN
      ch := Zeile[i];

      IF (Umlaut = 1) THEN
       BEGIN
         { 7-Bit Umlaute in IBM-Umlaute wandeln }
         CASE ch OF
          #91 : ch := '';
          #92 : ch := '';
          #93 : ch := '';
          #123: ch := '';
          #124: ch := '';
          #125: ch := '';
          #126: ch := '';
         END;
       END;

      CASE ch OF
       ^G  : BEGIN
               AMerk := TextAttr;
               TextAttr := ctrlAttrib;
               ch := chr(ord(ch)+64);
               IF aktuell THEN
               BEGIN
                 VideoPage^[BildPos] := ch;
                 Inc(BildPos);
                 VideoPage^[BildPos] := chr(TextAttr);
                 Inc(BildPos);
               END;
               PutAttrChxBuffer(Kanal,ch);
               Inc(X2);
               TextAttr := AMerk;

               IF Klingel AND NOT (save AND (RX_Mode <> 0)) THEN
                 IF NOT myText THEN
                 BEGIN
                   j := Pos('-',Call);
                   IF (j = 0)
                     THEN j := Length(Call)
                     ELSE Dec(j);
                   IF (Pos(Copy(Call,1,j)+' ',AlarmCalls) <> 0) THEN
                    BEGIN
                      {Call ist in Liste}
                      IF (Sek15 AND (AlarmCalls[1]<>'-')) THEN Alarm_Bell;
                    END
                   ELSE
                    BEGIN
                      {Call ist nicht in Liste}
                      IF (Sek15 AND (AlarmCalls[1]='-')) THEN Alarm_Bell;
                    END;
                 END;

             END;
       ^J  : ;      { Ausgabe eines LineFeeds wird immer unterdrueckt }
       ^M  : BEGIN
               IF (Kanal <> 0) OR ((Kanal = 0) AND (X2 > 1)) THEN
               BEGIN
                 AttrChxNewline(Kanal);
                 IF aktuell THEN
                 BEGIN
                   IF (Kanal = 0)
                     THEN scroll_up(S1Pos+2,MaxY)
                     ELSE scroll_up(S1Pos+1,Trenn-1);
                 END;
                 BildPos := PRED(Y_Pos) * 2 * maxX + PRED(X2 shl 1);
               END;
             END;
       ^H  : BEGIN
               IF X2 > 1 THEN
               BEGIN
                 Dec(X2);
                 Dec(BildPos,2);
               END;
             END;
       ELSE  BEGIN
               AMerk := TextAttr;
               IF (ch <= #31) THEN
               BEGIN
                 TextAttr := ctrlAttrib;
                 ch := Chr(Ord(ch)+64);
               END;
               IF aktuell THEN
               BEGIN
                 VideoPage^[BildPos] := ch;
                 Inc(BildPos);
                 VideoPage^[BildPos] := chr(TextAttr);
                 Inc(BildPos);
               END;
               PutAttrChxBuffer(Kanal,ch);
               Inc(X2);
               TextAttr := AMerk;
             END;

      END; { case ch of ... }

      IF (X2 > MaxX) THEN
      BEGIN
        AttrChxNewline(Kanal);
        IF aktuell THEN
        BEGIN
          IF (Kanal = 0)
            THEN scroll_up(S1Pos+2,MaxY)
            ELSE scroll_up(S1Pos+1,Trenn-1);
        END;
        BildPos := PRED(Y_Pos) * 2 * maxX + PRED(X2 shl 1);
      END;

    END; { FOR i := ... }

    IF save AND (connected OR (Kanal=0) OR (Kanal=ScanChannel)) THEN
    BEGIN
      IF (RX_Mode = 0) THEN
        WRITE_SaveFile(Kanal,Zeile)
      ELSE
        BEGIN
          IF NOT myText THEN WRITE_SaveFile(Kanal,Zeile);
        END;
    END;

    IF (Drucker=Kanal) AND (connected OR (Kanal=0) OR (Kanal=ScanChannel))
      THEN WRITE_Drucker(Kanal,Zeile);

    IF notice AND (NOT myText) THEN WRITE_Notiz(Kanal,Zeile);

    myText := FALSE;
  END; { WITH K[Kanal]^ DO }
END;


{------------------------------------------------------------------------------
| Zeile im Monitorschirm ausgeben
+-----------------------------------------------------------------------------}

PROCEDURE M_aus (Zeile : String);

VAR i         : INTEGER;
    ch        : CHAR;
    BildPos   : INTEGER;     { Position im Video-Ram }
    aktuell   : BOOLEAN;
    AMerk     : BYTE;
    Output    : BOOLEAN;

BEGIN

  aktuell := (show = 0);
  Output := (K[show]^.Trenn < MaxY) OR aktuell;

  WITH K[0]^ DO
  BEGIN
    BildPos := ScreenSize - 2*maxX + PRED(X2 shl 1);

    FOR i := 1 TO length(Zeile) DO
    BEGIN
      ch := Zeile[i];

      IF (Umlaut = 1) THEN
       BEGIN
         { 7-Bit Umlaute in IBM-Umlaute wandeln }
         CASE ch OF
          #91 : ch := '';
          #92 : ch := '';
          #93 : ch := '';
          #123: ch := '';
          #124: ch := '';
          #125: ch := '';
          #126: ch := '';
         END;
       END;

      IF CR THEN
      BEGIN
        IF NOT ((ch = #10) OR (ch = #13)) THEN
        BEGIN
          CR := false;
          IF X2 > 1 THEN
          BEGIN
            AttrChxNewline(0);
            IF (not ScreenSTBY) and Output THEN
            BEGIN
	      IF aktuell
		THEN scroll_up(S1Pos+2,MaxY)
                ELSE scroll_up(K[show]^.Trenn+1,MaxY);
            END;
            BildPos := ScreenSize - 2*maxX + 1;
          END;
        END;
      END;

      case ch of
       ^J  : ;
       ^M  : CR := TRUE;
       ELSE  BEGIN
               AMerk := TextAttr;
               IF (ch <= #31) THEN
               BEGIN
                 TextAttr := ctrlAttrib;
                 ch := chr(ord(ch)+64);
               END;
               PutAttrChxBuffer(0,ch);
               IF (not ScreenSTBY) and Output
                 THEN VideoPage^[BildPos] := ch;
               Inc(BildPos);
               IF (not ScreenSTBY) and Output
                 THEN VideoPage^[BildPos] := chr(TextAttr);
               Inc(BildPos);
               Inc(X2);
               TextAttr := AMerk;
             END;
      END;

      IF X2 > MaxX THEN
      BEGIN
        AttrChxNewline(0);
        IF (not ScreenSTBY) and Output THEN
         BEGIN
           IF aktuell THEN
             scroll_up(S1Pos+2,MaxY)
           ELSE
             scroll_up(K[show]^.Trenn+1,MaxY);
         END;
        BildPos := ScreenSize - 2*maxX + 1;
      END;

    END; { FOR i := ... }

    IF save THEN
      WRITE_SaveFile(0,Zeile);
    IF (Drucker = 0) THEN
      WRITE_Drucker(0,Zeile);
    IF notice THEN
      WRITE_Notiz(0,Zeile);

  END; { WITH K[0]^ DO ... }
END;


{------------------------------------------------------------------------------
| Eine Zeile an den Drucker schicken, dabei Fehlerbehandlung sicherstellen
| (Teile von DJ0HC)
+-----------------------------------------------------------------------------}

PROCEDURE WRITElst(Zeile : String);

 VAR  f       : INTEGER;
      AMerk   : BYTE;
      ch      : CHAR;
      FXPos   : INTEGER;
      FYPos   : INTEGER;

 BEGIN
   {$I-}
   WRITE(lst,Zeile);  {$I+}
   f := IOResult;
   IF (f <> 0) THEN BEGIN
     { Fehler aufgetreten }
     AMerk:=TextAttr;
     FXPos := 26;
     FYPos := (MaxY-12) DIV 2;
     Fenster(FXPos,FYPos,23,12,'Drucker');
     Gotoxy(FXPos+3,11);
     TextAttr := FBlinkAttr;
     WRITELN('Drucker-Fehler!');
     WRITELN;
     Gotoxy(FXPos+3,WhereY);
     TextAttr := FHighAttr;
     WRITELN('Bitte berprfen');
     WRITELN;
     gotoxy(FXPos+3,WhereY);
     TextAttr := FHighAttr;
     Write('W');
     TextAttr := FNormAttr;
     WriteLN('eiterdrucken');
     gotoxy(FXPos+3,WhereY);
     TextAttr := FHighAttr;
     Write('A');
     TextAttr := FNormAttr;
     WriteLN('bstellen');
     WRITELN;
     gotoxy(FXPos+3,WhereY);
     TextAttr := FHighAttr;
     write('Eingabe >>> ');
     Cursor_ein;
     if Klingel then Beep(1000,500);
     REPEAT
       ch := Upcase(ReadKey);
     UNTIL ch IN ['W','A'];
     TextAttr := Amerk;
     if (ch = 'A') then
       Drucker := -1;
     Cursor_aus;
     Restore_Screen;
   END;
 END;


{------------------------------------------------------------------------------
| Aufbau des Flag-Strings.
| Auch das Drucker-Flag wird jetzt in dieser Routine ausgegeben.
|
| Neu: Die Flags werden jetzt mit Attributen versehen.
|      Die ersten 10 Zeichen sind die Flags, die zweiten 10 Zeichen die
|      zugehrigen Attribute.
+-----------------------------------------------------------------------------}

FUNCTION FlagStr (Kanal : BYTE) : Str20;

VAR  subStr1      : String [15];
     subStr2      : String [15];
     c_neg,
     c_neg_high,
     c_neg_blink  : CHAR;

BEGIN
  subStr1 := '';
  subStr2 := '';
  c_neg := Char(neg);
  c_neg_high := Char(neg_high);
  c_neg_blink := Char(neg_blink);

  With K[Kanal]^ DO BEGIN
    CASE Umlaut OF
     0 : ;
     1 : BEGIN
           subStr1 := subStr1 + 'U7';
           subStr2 := subStr2 + c_neg_high + c_neg_high;
         END;
     2 : BEGIN
           subStr1 := subStr1 + 'U8';
           subStr2 := subStr2 + c_neg_high + c_neg_high;
         END;
    END;
    IF (Kanal = 0) THEN
     BEGIN
       { Klingel und Timestamp auf Kanal 0 }
       IF Time_stamp THEN
        BEGIN
          subStr1 := subStr1 + 'T';
          subStr2 := subStr2 + c_neg_high;
        END;
       IF Klingel THEN
        BEGIN
          subStr1 := subStr1 + 'K';
          subStr2 := subStr2 + c_neg_high;
        END;
     END
    ELSE
     BEGIN
       { LocalEcho und Remote auf allen anderen Kanlen }
       IF LocalEcho THEN
        BEGIN
          subStr1 := subStr1 + 'E';
          subStr2 := subStr2 + c_neg_high;
        END;
       CASE Remote OF
        0 : ;
        1 : BEGIN
              subStr1 := 'R1' + subStr1;
              subStr2 := c_neg + c_neg + subStr2;
            END;
        2 : BEGIN
              subStr1 := 'R2' + subStr1;
              subStr2 := c_neg_high + c_neg_high + subStr2;
            END;
       END;
     END;
    IF CW THEN
     BEGIN
       subStr1 := subStr1 + 'C';
       subStr2 := subStr2 + c_neg_high;
     END;
    IF notice THEN
     BEGIN
       subStr1 := subStr1 + 'N';
       subStr2 := subStr2 + c_neg_high;
     END;
    IF (Drucker = Kanal) THEN
     BEGIN
       subStr1 := subStr1 + '-D';
       subStr2 := subStr2 + c_neg_high + c_neg_high;
     END;
    IF auto_cmd THEN
     BEGIN
       subStr1 := 'A' + subStr1;
       subStr2 := c_neg_blink + subStr2;
     END;
    IF Ansi THEN
     BEGIN
       subStr1 := subStr1 + 'X';
       subStr2 := subStr2 + c_neg_high;
     END;
  END;
  { Flag-String wird auf 10 Zeichen rechtsbndig formatiert }
  subStr1 := Copy(subStr1,1,10);
  subStr1 := Space(10-Length(subStr1)) + subStr1;
  subStr2 := Copy(subStr2,1,10);
  subStr2 := constStr(c_neg,10-Length(subStr2)) + subStr2;
  FlagStr := subStr1 + subStr2;
END;


{------------------------------------------------------------------------------
|  Die Ausgabe der Flags erfolgt rechtsbndig und ist auf genau 10 Zeichen
|  begrenzt.
+-----------------------------------------------------------------------------}

PROCEDURE Show_Flags (Kanal : BYTE);

 VAR  i       : INTEGER;
      subStr  : Str25;

BEGIN
  subStr := FlagStr(Kanal);
  FOR i := 1 TO 10 DO
    Status1Out(Kanal,60+i,Byte(subStr[10+i]),subStr[i]);
END;


PROCEDURE clear (y1,y2 : INTEGER);

 VAR i   : INTEGER;

 BEGIN

   FOR i := y1 TO y2 DO
    BEGIN
      GotoXY(1,i);
      ClrEol;
    END;

 END;


{------------------------------------------------------------------------------
| Ausgabe der (kompletten) ersten Statuszeile
+-----------------------------------------------------------------------------}

PROCEDURE Status1(Kanal : INTEGER);

VAR    i         : INTEGER;
       x_Pos     : INTEGER;
       Position  : INTEGER;
       subStr    : Str80;
       subStr1   : Str25;
       Buffer1   : ARRAY [1..80] OF Char;   { Zeichen-Buffer }
       Buffer2   : ARRAY [1..80] OF Char;   { Attribut-Buffer }

 {-----------------------------------------------------------------------------
 | String in die Buffervariablen schreiben (Text und Attribute)
 +----------------------------------------------------------------------------}
 PROCEDURE putBuffer (X_Pos,Attr:INTEGER ; Zeile:Str80);
  VAR    i          : INTEGER;
         Position   : INTEGER;
  BEGIN
    Position := X_Pos;
    FOR i := 1 TO Length(Zeile) DO IF (Position <= 80) THEN
     BEGIN
       Buffer1[Position] := Zeile[i];      { Text }
       Buffer2[Position] := Chr(Attr);     { zugehriges Attribut }
       Inc(Position);
     END;
  END;

BEGIN   { Status1 }

  IF (Kanal <> show) THEN Exit;   { Statusline nur auf sichtbarem Kanal! }

  Fillchar(Buffer1,80,' ');     { Spaces }
  Fillchar(Buffer2,80,neg);     { Attribut "Invers" }

  subStr1 := FlagStr(show);

  IF (show = 0) THEN
   BEGIN
     { Statuszeile fr Monitor-Kanal }
     WITH K[0]^ DO
      BEGIN
        putBuffer(2,neg_high,UnprotoStr);
        putBuffer(16,neg_high,RxTxStr(0));
{
        IF Sek15 THEN
          putBuffer(53,neg,TNC[unproto].currentQRG)
        ELSE
          putBuffer(37,neg,V1_Str);
}
        putBuffer(53,neg,TNC[unproto].currentQRG);
        FOR i := 1 TO 10 DO
          putBuffer(60+i,Byte(subStr1[10+i]),subStr1[i]);
        putBuffer(72,neg,Time);
      END;
   END
  ELSE
   BEGIN
     { Statuszeile fr einen Nicht-Monitor-Kanal }
     WITH K[show]^ DO
      BEGIN
        putBuffer(2,neg_high,int_str(show));
        IF connected THEN putBuffer(5,neg_high,Call);
        putBuffer(16,neg_high,RxTxStr(show));
        putBuffer(38,LinkStateStr[LinkState].Attr,LinkStateStr[LinkState].Zeile);
        str(S_Frames:3,subStr);
        putBuffer(52,neg_high,subStr);
        str(T_Frames:2,subStr);
        putBuffer(55,neg_high,subStr);
        str(Tries:3,subStr);
        putBuffer(57,neg_high,subStr);
        FOR i := 1 TO 10 DO
          putBuffer(60+i,Byte(subStr1[10+i]),subStr1[i]);
        putBuffer(72,neg,Time);
      END;
   END;

  Position := PRED(S1Pos) * 2*maxX + 1;

  FOR i := 1 TO 80 DO
   BEGIN
     { Ausgabe der Statuszeile }
     VideoPage^[Position] := Buffer1[i];
     Inc(Position);
     VideoPage^[Position] := Buffer2[i];
     Inc(Position);
   END;

END;


{-----------------------------------------------------------------------------
|  Text auf der ersten Statuszeile darstellen
+----------------------------------------------------------------------------}

PROCEDURE Status1Out(Kanal : INTEGER; XPos : Byte; Attr : Byte; Zeile : Str80);

 VAR   x1, y1, oldAttr   : Byte;

 BEGIN
   IF (Kanal <> show) OR ScreenStby THEN Exit;
   x1 := WhereX;
   y1 := WhereY;
   oldAttr := TextAttr;
   TextAttr := Attr;
   GotoXY(XPos,S1Pos);
   WRITE(Zeile);
   TextAttr := oldAttr;
   GotoXY(x1,y1);
 END;


{------------------------------------------------------------------------------
| Ausgabe der (kompletten) zweiten Statuszeile
+-----------------------------------------------------------------------------}

PROCEDURE Status2;

VAR    Kanal,i   : INTEGER;
       x_Pos     : INTEGER;
       Position  : INTEGER;
       Buffer1   : ARRAY [1..80] OF Char;   { Zeichen-Buffer }
       Buffer2   : ARRAY [1..80] OF Char;   { Attribut-Buffer }

 {-----------------------------------------------------------------------------
 | String in die Buffervariablen schreiben (Text und Attribute)
 +----------------------------------------------------------------------------}
 PROCEDURE putBuffer (X_Pos,Attr:INTEGER ; Zeile:Str80);
  VAR    i          : INTEGER;
         Position   : INTEGER;
  BEGIN
    Position := X_Pos;
    FOR i := 1 TO Length(Zeile) DO
     BEGIN
       Buffer1[Position] := Zeile[i];      { Text }
       Buffer2[Position] := Chr(Attr);     { zugehriges Attribut }
       Inc(Position);
     END;
  END;

BEGIN   { Status2 }

  IF ScreenStby THEN Exit;

  Fillchar(Buffer1,80,' ');     { Spaces }
  Fillchar(Buffer2,80,neg);     { Attribut "Invers" }

  IF (K[show]^.Trenn <= (MaxY)) OR (show = 0) THEN
   BEGIN
     { Trennstriche in die Statuszeile einfgen }
     FOR Kanal := 1 TO PRED(maxLink) DO
      BEGIN
        x_Pos := PRED(Kanal)*8 + 9;
        IF (K[Kanal]^.TNCNummer <> K[Kanal+1]^.TNCNummer)
          THEN putBuffer(x_Pos,neg,'')
          ELSE putBuffer(x_Pos,neg,'');
      END;

     FOR Kanal := 1 TO Kanal_Anzahl DO WITH K[Kanal]^ DO BEGIN
       x_Pos := PRED(Kanal)*8+2;
       IF (Kanal = show) THEN putBuffer(x_Pos,neg_high,#16);
       IF connected THEN
        BEGIN
          { Call ohne SSID }
          i := Pos('-',Call);
          IF (i = 0) THEN i := Length(Call) + 1;
          IF newText
            THEN putBuffer(SUCC(x_Pos),neg_blink,Copy(Call,1,PRED(i)))
            ELSE putBuffer(SUCC(x_Pos),neg_high,Copy(Call,1,PRED(i)));
        END
       ELSE
        BEGIN
          { Channel not connected }
          IF (Kanal = ScanChannel) THEN
            putBuffer(SUCC(x_Pos),neg_high,'Scan ')
          ELSE
            IF newText
              THEN putBuffer(SUCC(x_Pos),neg_blink,' msg')
              ELSE putBuffer(SUCC(x_Pos),neg,' dis');
        END;
     END;

     IF (show = 0) THEN
       Position := S1Pos * 2*maxX + 1
     ELSE
       Position := PRED(K[show]^.Trenn) * 2*maxX + 1;

     FOR i := 1 TO 80 DO
      BEGIN
        { Ausgabe der Statuszeile }
        VideoPage^[Position] := Buffer1[i];
        Inc(Position);
        VideoPage^[Position] := Buffer2[i];
        Inc(Position);
      END;

   END;

END;


{-----------------------------------------------------------------------------
|  Das Hintergrund-Attribut an der Cursorposition toggeln
+----------------------------------------------------------------------------}

PROCEDURE ShowEditCursor;

 VAR   Position       : Word;
       Hintergrund    : Byte;
       Attribut       : Byte;

 BEGIN
   EditCursorToggle := NOT EditCursorToggle;
   WITH K[show]^ DO
    BEGIN
      Position := Pred(Y1)*2*maxX + Pred(X1 SHL 1) + 1;  { Attribut-Position }
      Attribut := Ord(VideoPage^[Position]);
      Hintergrund := (Attribut AND $70) SHR 4;
      Hintergrund := 7 - Hintergrund;
      Attribut := Attribut AND $8F;  { Hintergrund ausmaskieren }
      Attribut := Attribut + (Hintergrund SHL 4);
      VideoPage^[Position] := Chr(Attribut);
    END;
 END;


PROCEDURE ClearEditCursor;

 VAR   Position       : Word;
       Hintergrund    : Byte;
       Attribut       : Byte;

 BEGIN
   IF EditCursorToggle THEN
     WITH K[show]^ DO
      BEGIN
        Position := Pred(Y1)*2*maxX + Pred(X1 SHL 1) + 1;  { Attribut-Position }
        Attribut := Ord(VideoPage^[Position]);
        Hintergrund := (Attribut AND $70) SHR 4;
        Hintergrund := 7 - Hintergrund;
        Attribut := Attribut AND $8F;  { Hintergrund ausmaskieren }
        Attribut := Attribut + (Hintergrund SHL 4);
        VideoPage^[Position] := Chr(Attribut);
        EditCursorToggle := FALSE;
      END;
 END;


PROCEDURE WriteEditStr (Zeile : Str80);

 VAR  i         : INTEGER;
      oldAttr   : Byte;

 BEGIN
   oldAttr := TextAttr;
   FOR i := 1 TO Length(Zeile) DO
    BEGIN
      IF Zeile[i] < #32 THEN
       BEGIN
         TextAttr := ctrlAttrib;
         WRITE(Chr(Ord(Zeile[i])+64));
       END
      ELSE
       BEGIN
         TextAttr := low;
         WRITE(Zeile[i]);
       END;
    END;
   TextAttr := OldAttr;
 END;


PROCEDURE restoreEditLines;

 VAR  i      : INTEGER;

 BEGIN
   WITH K[show]^ DO
    BEGIN
      FOR i := 1 TO Pred(S1Pos) DO
       BEGIN
         GotoXY(1,i);
         WriteEditStr(EditLine^[TopEditLine+i-1]);
         TextAttr := low;
         ClrEOL;
       END;
    END;
 END;


{-----------------------------------------------------------------------------
|  Setzen des maximal mglichen Bildschirm-Fensters
+----------------------------------------------------------------------------}

PROCEDURE maxWindow;
 BEGIN
   Window(1,1,80,maxY);
 END;


{-----------------------------------------------------------------------------
|  Aufbau eines zeitabhngigen Fensters
+----------------------------------------------------------------------------}

PROCEDURE timedWindow (minTime, maxTime : INTEGER; Farbe : Byte; Zeile : String);

 VAR   i1, i2        : INTEGER;
       FXPos, FYPos  : INTEGER;
       ch            : Char;

 BEGIN
   i1 := Length(Zeile) + 4;
   IF (i1 < 27) THEN
     i1 := 27;
   IF (i1 > 80) THEN
     i1 := 80;
   i2 := Length(Zeile) DIV 76 + 1;
   FXPos := (80-i1) DIV 2 + 1;
   FYPos := (MaxY-5-i2) DIV 2;
   Fenster(FXPos,FYPos,i1,i2+5,'TNC-Response');
   TextAttr := Farbe;
   Window(FXPos+2,FYPos+2,FXPos+i1-3,FYPos+i2+3);
   GotoXY(1,1);
   WRITE(Zeile);
   GotoXY(1,i2+2);
   TextAttr := FNormAttr;
   WRITE('Weiter (max. ',maxTime,' Sek) > ');
   Cursor_ein;

   i1 := 10*maxTime;
   i2 := 10*minTime;
   REPEAT
     Dec(i1);
     Dec(i2);
     Delay(10*DelayCorr);
   UNTIL (KeyPressed AND (i2 <= 0)) OR (i1 <= 0);
{
   IF KeyPressed THEN
    BEGIN
      ch := ReadKey;
      IF (ch = #0) THEN
        ch := ReadKey;
    END;
}
   maxWindow;

   Cursor_aus;
   Restore_Screen;
 END;


{-----------------------------------------------------------------------------
|  Aufbau des zeitabhngigen Copyright-Fensters
+----------------------------------------------------------------------------}

PROCEDURE CopyrightWindow;

 VAR    i1, i2        : INTEGER;
        FXPos, FYPos  : INTEGER;
        ch            : Char;
        minTime       : INTEGER;
        maxTime       : INTEGER;

 BEGIN
   minTime := 1;
   IF (gesMin < 600) THEN
     maxTime := 20
   ELSE
     maxTime := 3;
   i1 := 41;   { Fensterbreite }
   i2 := 7;    { Anzahl Zeilen }
{$IFDEF DEBUG}
   Inc(i2,2);    { 2 Zeilen mehr fr Ausgabe }
{$ENDIF}
{$IFDEF OS2}
   Inc(i2);    { 1 Zeile mehr fr Ausgabe }
{$ENDIF}
   FXPos := (80-i1) DIV 2 + 1;
   FYPos := (MaxY-5-i2) DIV 2;
   Fenster(FXPos,FYPos,i1,i2+5,'Copyright');
   TextAttr := FNormAttr;
   Window(FXPos+2,FYPos+2,FXPos+i1-3,FYPos+i2+3);
   GotoXY(1,1);
   TextAttr := FHighAttr;
   WRITELN(V1_Str);
   TextAttr := FNormAttr;
   WRITELN;
   WRITELN('Copyright by Reiner Schmidt (DL1BHO)');
   TextAttr := FHighAttr;
   WRITELN;
   WRITELN('Es gilt die Allgemeine Lizenz fr');
   WRITE(  'Amateurfunk Software (');
   TextAttr := FBlinkAttr;
   WRITE('ALAS');
   TextAttr := FHighAttr;
   WRITELN(')!');
   TextAttr := FNormAttr;
   WRITELN;
{$IFOPT G+}
   WRITELN('80286-Mode');
{$ELSE}
   WRITELN('8086/88-Mode !!!');
{$ENDIF}
{$IFDEF DEBUG}
   WRITELN('Debug-Mode verfgbar!');
   WRITELN('MemAvail = ',MemAvail);
{$ENDIF}
{$IFDEF OS2}
   TextAttr := FBlinkAttr;
   WRITELN('O S / 2 - V e r s i o n  !');
   TextAttr := FNormAttr;
{$ENDIF}
   GotoXY(1,i2+2);
   IF (gesMin < 600) THEN
    BEGIN
      TextAttr := FNormAttr;
      WRITE('Weiter (max. ',maxTime,' Sek) > ');
      Cursor_ein;
    END;

   Timer[ms55_4] := minTime*Sec1;
   Timer[ms55_5] := maxTime*Sec1;
   REPEAT       { warten bis (minTime AND KeyPressed) ODER maxTime }
     Dec_Timer;
   UNTIL (Timer[ms55_5]=0) OR ((Timer[ms55_4]=0) AND KeyPressed);

   WHILE KeyPressed DO
    BEGIN
      ch := ReadKey;
      IF (ch = #0) THEN
        ch := ReadKey;
    END;

   maxWindow;

   Cursor_aus;
   Restore_Screen;
 END;


{-----------------------------------------------------------------------------
| Bei VGA-Karten die Randfarbe setzen
+----------------------------------------------------------------------------}

PROCEDURE SetBorderColor (Farbe : Byte);
VAR
  r :REGISTERS;
BEGIN
  IF VGA AND (Farbe >= 0) AND (Farbe <= 63) THEN
   BEGIN
     r.AH := $10;
     r.AL := $01;
     r.BH := Farbe;
     Intr($10,r);
   END;
END;


BEGIN

  {---------------------------------------------------------------------------
  | keine Initialisierung erforderlich
  +--------------------------------------------------------------------------}

END.
