
{-----------------------------------------------------------------------------
|
|  P R S C R O L L . P A S
|
|  DL1BHO  04/1992
|
|  Blttern im Backscroll- und Notiz-Buffer,
|  Read- und Erase-Generator fr Mailbox List- und Check-Ausgaben
|
|  04/94:  Maximale Speicherausnutzung bei den Rckholspeichern
|
|  do_BackScroll gendert: 24.5.96, Chris Kuhr, DG5OAC
|  8stellige Rubriken mit Filenummern ber 1000 wurden nicht korrekt erkannt
|  aus einer CHECK Liste (DieBox 1.9).
|
+----------------------------------------------------------------------------}


Unit  PRScroll;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


PROCEDURE Init_BackScrollBuffer;
PROCEDURE Save_ScrollBuffer;
PROCEDURE Restore_ScrollBuffer;
PROCEDURE do_BackScroll(Kanal : Byte; BPointer : Pointer;
                        BufferP : INTEGER; BufferPmax : INTEGER);
FUNCTION  checkEmptyLines(Kanal : Byte) : INTEGER;


IMPLEMENTATION


USES
       Dos,
       Crt,
       PRDefs,
       PRPass,
       PRLIB,
       PRLIB4,
       PRKBD,
       PRScreen,
       PRMouse;


CONST
       SaveName       = 'PRBUFFER.SAV';

TYPE
       TaggType       = RECORD
                          markiert    : Byte;    { 0,1 oder 2 }
                          ListLine    : INTEGER;
                        END;

VAR
       ScrollBufferSaveOK    : BOOLEAN;


{------------------------------------------------------------------------------
| Alle Backscroll-Buffer und den Notizbuffer initialisieren.
| Die Chx-Buffer werden mit Leerzeichen beschrieben, die Attr-Buffer
| mit dem erforderlichen Attribut
| Neu: Maximale Speicherausnutzung!
+-----------------------------------------------------------------------------}

PROCEDURE Init_BackscrollBuffer;

 VAR    Kanal         : BYTE;
        StdAttr       : Char;
        minBuffer     : INTEGER;       { kleinster Wert fr ChxBufferPmax }
        LinesPerChannel : INTEGER;     { Rckholbuffer pro Kanal }
        MinDosMem     : LongInt;

 BEGIN
   minBuffer := maxY-3;

   IF (ScrollBufferSavePfad <> '') THEN
     minDosMem := 30000
   ELSE
     minDosMem := 150000;

   { Speicherbelegung festlegen }
   LinesPerChannel := (MemAvail - MinDosMem - 80*AttrBufferPmax*(Kanal_Anzahl+1))
                                         DIV (80*(Kanal_Anzahl + 2));
   IF LinesPerChannel > 800 THEN
     LinesPerChannel := 800;
   IF LinesPerChannel < (MaxY -3) THEN
     BEGIN
       { Auweia, der Speicher reicht wohl nicht zum Minimum aus... }
       WRITELN;
       WRITELN;
       WRITELN('Zu wenig Speicher fr TurboPR (Kanle reduzieren)... Sorry...');
       Halt;
     END;

   FOR Kanal := 0 TO maxLink DO
    BEGIN                           { Attribut-Buffer fr jeden Kanal }
      IF (Kanal = 0) THEN
        StdAttr := Chr(MoniInfoAttr)
      ELSE
        StdAttr := Chr(ConRXAttrib);
      IF K[Kanal]^.poll THEN WITH K[Kanal]^ DO
       BEGIN
         GetMem(AttrBuffer,80*AttrBufferPmax);
         FillChar(AttrBuffer^,80*AttrBufferPmax,StdAttr);
       END
      ELSE
       BEGIN
         K[Kanal]^.AttrBuffer := K[0]^.AttrBuffer;
         K[Kanal]^.ChxBuffer := K[0]^.ChxBuffer;
       END;
    END;

   NotizBufferPmax := LinesPerChannel;
   GetMem(NotizBuffer,80*NotizBufferPmax);          { NotizBuffer }
   FillChar(NotizBuffer^[1],80*NotizBufferPmax,' '); { Notizspeicher lschen }

   FOR Kanal := 0 TO Kanal_Anzahl DO WITH K[Kanal]^ DO
    BEGIN                            { Rckholbuffer fr jeden Kanal }
      ChxBufferPmax := LinesPerChannel;
      GetMem(ChxBuffer,80*ChxBufferPmax);
      FillChar(ChxBuffer^,80*ChxBufferPmax,' ');
    END;

 END;


{-----------------------------------------------------------------------------
|  dynamische Buffer ins File speichern, Speicherbereich freigeben, dabei
|  REIHENFOLGE BEACHTEN!!
+----------------------------------------------------------------------------}

PROCEDURE Save_ScrollBuffer;

 VAR
       SaveFile   : File;
       i,Kanal    : INTEGER;
       IO_OK      : BOOLEAN;

 BEGIN

   ScrollBufferSaveOK := FALSE;

   IF (ScrollBufferSavePfad <> '') THEN
    BEGIN
      Assign(SaveFile,ScrollBufferSavePfad+SaveName);
      {$I-}
      Rewrite(SaveFile,80);

      FOR Kanal := 0 TO maxLink DO WITH K[Kanal]^ DO IF poll THEN
        BlockWRITE(SaveFile,AttrBuffer^,AttrBufferPmax);

      BlockWRITE(SaveFile,NotizBuffer^,NotizBufferPmax);

      FOR Kanal := 0 TO maxLink DO WITH K[Kanal]^ DO IF poll THEN
        BlockWRITE(SaveFile,ChxBuffer^,ChxBufferPmax);

      IO_OK := (IOResult = 0);
      Close(SaveFile);

      IF IO_OK THEN
       BEGIN
         { Speichern hat geklappt, also Speicher freigeben }
         FOR Kanal := maxLink DOWNTO 0 DO WITH K[Kanal]^ DO IF poll THEN
           FreeMem(ChxBuffer,80*ChxBufferPmax);
         FreeMem(NotizBuffer,80*NotizBufferPmax);
         ScrollBufferSaveOK := TRUE;
         FOR Kanal := maxLink DOWNTO 0 DO WITH K[Kanal]^ DO IF poll THEN
           FreeMem(AttrBuffer,80*AttrBufferPmax);
       END
      ELSE
       BEGIN
         { irgendwie hat das Speichern nicht geklappt... }
         Erase(SaveFile);
       END;

      {$I+}
    END;
 END;


PROCEDURE Restore_ScrollBuffer;

 VAR
       SaveFile   : File;
       i,Kanal    : INTEGER;
       IO_OK      : BOOLEAN;

 BEGIN
   IF ScrollBufferSaveOK THEN
    BEGIN
      Assign(SaveFile,ScrollBufferSavePfad+SaveName);
      {$I-}
      Reset(SaveFile,80);    {$I+}
      IO_OK := (IOResult = 0);

      FOR Kanal := 0 TO maxLink DO
       BEGIN
         IF K[Kanal]^.poll THEN WITH K[Kanal]^ DO
          BEGIN
            GetMem(AttrBuffer,80*AttrBufferPmax);
            IF IO_OK THEN BlockREAD(SaveFile,AttrBuffer^,AttrBufferPmax);
          END;
       END;

      GetMem(NotizBuffer,80*NotizBufferPmax);
      IF IO_OK THEN BlockREAD(SaveFile,NotizBuffer^,NotizBufferPmax);

      FOR Kanal := 0 TO maxLink DO
       BEGIN
         IF K[Kanal]^.poll THEN WITH K[Kanal]^ DO
          BEGIN
            GetMem(ChxBuffer,80*ChxBufferPmax);
            IF IO_OK THEN BlockREAD(SaveFile,ChxBuffer^,ChxBufferPmax);
          END
         ELSE
          BEGIN
            K[Kanal]^.AttrBuffer := K[0]^.AttrBuffer;
            K[Kanal]^.ChxBuffer := K[0]^.ChxBuffer;
          END;
       END;

      IF NOT IO_OK THEN
       BEGIN
         { irgendein Dussel hat die Save-Datei gelscht... na warte... }
         FillChar(NotizBuffer^,80*NotizBufferPmax,'.');
         FOR Kanal := 0 TO maxLink DO
          IF K[Kanal]^.poll THEN WITH K[Kanal]^ DO BEGIN
            FillChar(ChxBuffer^,80*ChxBufferPmax,'.');
            Fillchar(AttrBuffer^,80*AttrBufferPmax,Chr(blinkAttr));
          END;
       END;

      {$I-}
      Close(SaveFile);
      Erase(SaveFile);   {$I+}
      IO_OK := (IOResult = 0);

    END;
 END;


{-----------------------------------------------------------------------------
|  Blttern im BackScroll- oder Notiz-Buffer,
|  Read/Erase/SetLT-Generator fr Check- und List-Ausgabe
|
|  erforderliche Parameter:
|
|    - Kanal       (aufrufender Kanal)
|    - BPointer    (entweder ChxBuffer oder NotizBuffer)
|    - BufferP     (entweder ChxBufferP oder NotizBufferP)
|    - BufferPmax  (entweder ChxBufferPmax oder NotizBufferPmax)
+----------------------------------------------------------------------------}

PROCEDURE do_BackScroll(Kanal : Byte; BPointer : Pointer;
                        BufferP : INTEGER; BufferPmax : INTEGER);

 VAR   AMerk         : Byte;
       chx           : Char;
       kc            : KeyCodes;
       XPos,YPos     : Byte;
       Buffer        : ^AttrChxBType;
       maxTopLine    : INTEGER;   { hchste mgliche TopLine }
       actLine       : INTEGER;
       Differenz     : INTEGER;
       BZeile        : INTEGER;
       TopLine       : INTEGER;   { oberste dargestellte Zeile }
       Lines         : INTEGER;   { darstellbare Zeilen auf dem Schirm }
       tagg          : ARRAY [1..800] OF TaggType;
       XBuffer       : ARRAY [1..1024] OF Char;
       XBufferP      : INTEGER;
       a,i,i1,i2     : INTEGER;
       Zeile         : String;
       subStr        : Str20;
       subStr1       : Str20;
       Mode          : INTEGER;   { 1 = Read, 2 = Erase, 3 = SETL }
       update        : BOOLEAN;
       ModeStr       : Str10;
       BoxRemote     : BOOLEAN;

 FUNCTION Adjust (Z : INTEGER) : INTEGER;
  BEGIN
    z := z - Differenz;
    IF (z < 1) THEN z := z + BufferPmax;
    Adjust := z;
  END;

 PROCEDURE show_Lines(L1,L2 : INTEGER);
  VAR   Zeile    : Str80;
        i,i1     : INTEGER;
        z,za     : INTEGER;
        yPos     : Byte;
  BEGIN
    TextAttr := neg;
    GotoXY(40,1);
    WRITE(TopLine,'-',(TopLine+Lines-1),'   ');
    TextAttr := low;
    Zeile[0] := #80;            { Lnge festlegen }
    yPos := L1-TopLine+2;
    FOR i := L1 TO L2 DO
     BEGIN
       GotoXY(1,yPos);
       z := adjust(i);
       Move(Buffer^[z,1],Zeile[1],80);
       IF (tagg[i].markiert > 0) THEN
         TextAttr := norm
       ELSE
         TextAttr := low;
       WRITE(Zeile);
       Inc(yPos);
     END;
  END;

 FUNCTION GetListHeaderLine(Zeile : INTEGER) : INTEGER;
  VAR   i          : INTEGER;
        gefunden   : BOOLEAN;
        BZeile     : INTEGER;
 BEGIN
   gefunden := FALSE;
   REPEAT
     BZeile := adjust(Zeile);
     IF (Buffer^[BZeile,5]='-') THEN
       IF (Buffer^[BZeile,6]='F') THEN
         IF (Buffer^[BZeile,7]='i') THEN
           IF (Buffer^[BZeile,8]='l') THEN
             IF (Buffer^[BZeile,9]='e') THEN
               IF (Buffer^[BZeile,10]=':') THEN
                 IF (Buffer^[BZeile,11]=' ') THEN gefunden := TRUE;
     IF NOT gefunden THEN Dec(Zeile);
   UNTIL gefunden OR (Zeile < 1);
   IF gefunden THEN
     GetListHeaderLine := Zeile
   ELSE
     GetListHeaderLine := 0;
 END;

 PROCEDURE PutXBuffer (Zeile : String);
  VAR   i      : INTEGER;
  BEGIN
    IF ((Length(Zeile) + XBufferP) < 1024) THEN
      { noch Platz im Buffer fr das komplette Kommando }
      FOR i := 1 TO Length(Zeile) DO
        IF (XBufferP <= 1024) THEN
         BEGIN
           XBuffer[XBufferP] := Zeile[i];
           Inc(XBufferP);
         END;
  END;

 PROCEDURE do_CheckTagg (actLine : INTEGER);
  VAR   cb    : INTEGER;
        Rubrik : String[8];
  BEGIN
    IF (tagg[actLine].markiert = 1) THEN
     BEGIN
       { Check-Tagg bearbeiten, dabei auf BOX V1.9 Rcksicht nehmen }
       BZeile := adjust(actLine);
       subStr[0] := #13;
       IF (Buffer^[BZeile,5]=' ') THEN
         cb := 15                              { Check 4 stellig }
       ELSE
         cb := 16;                             { Check 5 stellig }
       Move(Buffer^[BZeile,cb],subStr[1],13);  { Lnge war mal 12 }

       { Check-Read Befehl gendert !
         DG5OAC, Chris Kuhr am 24.5.96
         Problem: Rubriken wurden nicht mehr erkannt, wenn die Eintrags-
                  zahl grsser als 1000 wurde und die Rubrik 8 Zeichen
                  gross war }

       {----------------------------------------}
       { Original von DL1BHO                    }
       {----------------------------------------}
    {   i1 := Pos('.',subStr);

       subStr[i1] := ' ';
       i1 := Pos('.',subStr);
       WHILE (i1 > 0) DO
        BEGIN
          Delete(subStr,i1,1);
          i1 := Pos('.',subStr);
        END; }
        {---------------------------------------}

        {---------------------------------------}
        { Neu von DG5OAC                        }
        {---------------------------------------}
        { Rubriken namen bestimmen. Muss in den ersten 8 Zeichen stecken }


        Rubrik:='';
        Rubrik := Copy(substr,1,8);
        i1 := Pos('.',Rubrik);
        While (i1 > 0) Do
         Begin
          Delete(Rubrik,i1,1);          { Punkte killen }
          i1 := Pos('.',Rubrik);
         End;

        Delete(subStr,1,8);             { die ersten 8 Zeichen lschen }

        i1 := Pos('.',subStr);          { Punkte killen }
        While (i1 > 0) Do
         Begin
          Delete(subStr,i1,1);
          i1:=Pos('.',subStr);          { subStr sollte die Nummer enthalten }
         End;

         i1 := Pos(' ',subStr);         { Letztes Leerzeichen killen }
         While (i1 > 0) Do
          Begin
           Delete(substr,i1,1);
           i1:=pos(' ',subStr);
          End;

         subStr:=Rubrik+' '+subStr;     { auf addieren mit Leerzeichen }
         

         {------------------------}

       PutXBuffer(ModeStr+' '+subStr+';');
     END;
  END;

 PROCEDURE do_ListTagg(actLine : INTEGER);
  BEGIN
    IF (tagg[actLine].markiert = 2) THEN
     BEGIN
       BZeile := adjust(tagg[actLine].ListLine);
       subStr1[0] := #8;
       Move(Buffer^[BZeile,12],subStr1[1],8);
       i1 := Pos(' ',subStr1);
       IF (i1 > 0) THEN Delete(subStr1,i1,8);
       i1 := Pos(#13,subStr1);
       IF (i1 > 0) THEN Delete(subStr1,i1,8);   { subStr1 ist Filename }
       BZeile := adjust(actLine);
       subStr[0] := #4;
       Move(Buffer^[BZeile,1],subStr[1],4);
       WHILE (Copy(subStr,1,1) = ' ') DO      { subStr ist die File-Nummer }
         Delete(subStr,1,1);
       PutXBuffer(ModeStr+' '+subStr1+' '+subStr+';');
     END;
  END;

 PROCEDURE do_SetLTagg(actLine : INTEGER);
  CONST  LT    = '#5';
  VAR    cb    : INTEGER;
  BEGIN
    IF (tagg[actLine].markiert = 1) THEN
     BEGIN
       { Check-Markierung }
       BZeile := adjust(actLine);
       subStr[0] := #12;
       IF (Buffer^[BZeile,5]=' ') THEN
         cb := 15                              { Check 4 stellig }
       ELSE
         cb := 16;                             { Check 5 stellig }
       Move(Buffer^[BZeile,cb],subStr[1],12);
       i1 := Pos('.',subStr);
       subStr[i1] := ' ';
       i1 := Pos('.',subStr);
       WHILE (i1 > 0) DO
        BEGIN
          Delete(subStr,i1,1);
          i1 := Pos('.',subStr);
        END;
       PutXBuffer(ModeStr+' '+subStr+' '+LT+';');
     END;
    IF (tagg[actLine].markiert = 2) THEN
     BEGIN
       { List-Markierung }
       BZeile := adjust(tagg[actLine].ListLine);
       subStr1[0] := #8;
       Move(Buffer^[BZeile,12],subStr1[1],8);
       i1 := Pos(' ',subStr1);
       IF (i1 > 0) THEN Delete(subStr1,i1,8);
       i1 := Pos(#13,subStr1);
       IF (i1 > 0) THEN Delete(subStr1,i1,8);   { subStr1 ist Filename }
       BZeile := adjust(actLine);
       subStr[0] := #4;
       Move(Buffer^[BZeile,1],subStr[1],4);
       WHILE (Copy(subStr,1,1) = ' ') DO      { subStr ist die File-Nummer }
         Delete(subStr,1,1);
       PutXBuffer(ModeStr+' '+subStr1+' '+subStr+' '+LT+';');
     END;
  END;

 PROCEDURE show_HelpLine;
  BEGIN
    TextAttr := norm;
    GotoXY(1,MaxY);
    ClrEOL;
    WRITE('>>>   CuUp  CuDn  PgUp  PgDn  Home  End  Esc');
    IF M_ok THEN
     BEGIN
       TextAttr := low;
       WRITE('  Maus-Tasten');
     END;
    TextAttr := low;
  END;


 BEGIN

   Moni_OFF;

   Fillchar(XBuffer,SizeOf(XBuffer),#0);
   XBufferP := 1;

   Buffer := BPointer;      { Pointer auf den zu bearbeitenden Buffer }

   AMerk := TextAttr;
   TextAttr := norm;
   ClrScr;

   Mode := 1;   { Read-Mode einstellen }
   BoxRemote := (MBX_remote_Call(Kanal) <> '');

   GotoXY(1,MaxY-1);
   WRITE(ConstStr('',MaxX));

   show_HelpLine;

   TextAttr := neg_high;
   GotoXY(1,1);
   WRITE(Space(MaxX));
   GotoXY(1,1);
   WRITE(Kanal:3,'  BackScroll (max. ',BufferPmax,' Zeilen)');
   TextAttr := neg;
   GotoXY(69,1);
   WRITE('Mode: ');
   TextAttr := neg_high;
   WRITE('Read ');
   TextAttr := low;

   Differenz := BufferPmax - BufferP;
   maxTopLine := BufferPmax - (maxY-3) + 1;
   Lines := MaxY - 3;
   TopLine := maxTopLine;

   FOR i := 1 TO 800 DO    { Tagg-Liste lschen }
    BEGIN
      tagg[i].markiert := 0;
      tagg[i].ListLine := 0;
    END;

   M_setCursorPos(1,MaxY-1);
   M_Cursor_on;
   show_Lines(TopLine,TopLine+Lines-1);
   REPEAT UNTIL M_noButton;

   REPEAT

     update := TRUE;
     GotoXY(4,MaxY);
     Cursor_ein;
     M_Cursor_on;
     REPEAT UNTIL Keypressed OR M_anyButton;;
     M_Cursor_off;
     Cursor_aus;

     IF Keypressed THEN
      BEGIN
        GetKey(chx,KC);
      END
     ELSE
      BEGIN
        { Mouse-Handling }
        IF M_Button(2) THEN
         BEGIN
           KC := _Escape;
         END
        ELSE
         BEGIN
           KC := _Sonstige;
           M_getCursorPos(XPos,YPos);
           IF (YPos >= 2) AND (YPos <= (MaxY-2)) THEN
            BEGIN
              { Taggen ... }
              actLine := TopLine + YPos -2;
              BZeile := adjust(actLine);
              IF (tagg[actLine].markiert > 0) THEN
                tagg[actLine].markiert := 0     { Markierung lschen }
              ELSE
                BEGIN
                  { Check-Zeile prfen, dabei vier- UND fnfstellige
                    Check-Nummern bercksichtigen (BOX 1.9)           }
                  IF (Buffer^[BZeile,5]=' ') THEN
                    i := 5
                  ELSE
                    i := 6;
                  IF (Buffer^[BZeile,i]=' ') THEN
                    IF (Buffer^[BZeile,i+7]=' ') THEN
                      IF (Buffer^[BZeile,i+8]='>') THEN
                        IF (Buffer^[BZeile,i+9]=' ') THEN
{                         IF (Buffer^[BZeile,i+18]='.') THEN     }
                   BEGIN
                     { Pattern der Check-Liste gefunden }
                     tagg[actLine].markiert := 1;
                   END;
                  IF (tagg[actLine].markiert = 0) THEN
                   BEGIN
                     { Check-Pattern war's nicht, also List-Pattern versuchen }
                     IF (Buffer^[BZeile,15]='.') THEN
                       IF (Buffer^[BZeile,18]='.') THEN
                         IF (Buffer^[BZeile,21]=' ') THEN
                           IF (Buffer^[BZeile,24]=':') THEN
                             IF (Buffer^[BZeile,27]=' ') THEN
                      BEGIN
                        { Pattern des List-Befehls gefunden, also    }
                        { zugehrigen List-Header suchen             }
                        i := GetListHeaderLine(actLine);
                        IF (i > 0) THEN
                         BEGIN
                           { List-Pattern ok UND List-Header ok }
                           tagg[actLine].markiert := 2;
                           tagg[actLine].ListLine := i;
                         END;
                      END;
                   END;
                  IF (tagg[actLine].markiert = 0) THEN
                   BEGIN
                     { kein passendes Pattern gefunden... }
                     IF Klingel THEN Sound(200);
                     GotoXY(1,MaxY); ClrEOL;
                     TextAttr := neg_blink;
                     WRITE(Space(25),'Keine Check- oder List-Zeile! ',Space(24));
                     REPEAT UNTIL M_noButton;
                     NoSound;
                     show_HelpLine;
                   END;
                END;
            END
           ELSE
            BEGIN
              IF YPos = MaxY THEN
               BEGIN
                 { Maus-Zeiger auf unterster Zeile }
                 IF (XPos >= 6) AND (XPos <= 11) THEN KC := CUp ELSE
                 IF (XPos >= 12) AND (XPos <= 17) THEN KC := CDown ELSE
                 IF (XPos >= 18) AND (XPos <= 23) THEN KC := PgUp ELSE
                 IF (XPos >= 24) AND (XPos <= 30) THEN KC := PgDn ELSE
                 IF (XPos >= 31) AND (XPos <= 35) THEN KC := CHome ELSE
                 IF (XPos >= 36) AND (XPos <= 40) THEN KC := CEnd ELSE
                 IF (XPos >= 41) AND (XPos <= 45) THEN KC := _Escape ELSE
                   KC := PgDn;
               END;
              IF (YPos = 1) THEN
               BEGIN
                 IF (XPos >= 69) AND (XPos <= 80) THEN
                   BEGIN
                     update := FALSE;
                     { Mode-Toggle }
                     IF NOT BoxRemote THEN
                      BEGIN
                        IF (Mode = 1) THEN
                          Mode := 2
                        ELSE
                          Mode := 1;
                      END
                     ELSE
                      BEGIN
                        { Box-Remote, also auch SETLT zulassen }
                        Inc(Mode);
                        IF (Mode > 3) THEN Mode := 1;
                      END;
                     GotoXY(75,1);
                     CASE Mode OF
                      1 : BEGIN
                            TextAttr := neg_high;
                            WRITE('Read ');
                          END;
                      2 : BEGIN
                            TextAttr := neg_blink;
                            WRITE('Erase');
                          END;
                      3 : BEGIN
                            TextAttr := neg_high;
                            WRITE('SetL ');
                          END;
                     END;
                   END
                 ELSE
                   KC := PgUp;
               END;
              IF (YPos = (MaxY-1)) THEN KC := PgDn;
            END;
         END;
      END;         { Mouse-Handling }

     CASE KC OF
      _Escape
          : update := FALSE;
      CUp : BEGIN
              update := FALSE;
              IF (TopLine > 1) THEN
               BEGIN
                 Dec(TopLine);
                 scroll_down(2,maxY-2);
                 show_Lines(TopLine,TopLine);
               END;
            END;
      CDown
          : BEGIN
              update := FALSE;
              IF (TopLine < maxTopLine) THEN
               BEGIN
                 Inc(TopLine);
                 scroll_up(2,maxY-2);
                 show_Lines(TopLine+Lines-1,TopLine+Lines-1);
               END;
            END;
      PgUp
          : BEGIN
              TopLine := TopLine - Lines + 1;
              IF (TopLine < 1) THEN TopLine := 1;
            END;
      PgDn
          : BEGIN
              TopLine := TopLine + Lines - 1;
              IF (TopLine > maxTopLine) THEN TopLine := maxTopLine;
            END;
      CHome
          : BEGIN
              TopLine := 1;
            END;
      CEnd
          : BEGIN
              TopLine := maxTopLine;
            END;
     END;

     IF update THEN
       show_Lines(TopLine,TopLine+Lines-1);

     REPEAT UNTIL M_noButton;

   UNTIL (KC = _Escape);

   { Ausgabe fr den Read/Erase/SetL-Generator aufbereiten }

   CASE Mode OF
    1 : BEGIN
          { Read-Mode }
          ModeStr := 'R';
          FOR actLine := BufferPmax DOWNTO 1 DO
           BEGIN
             { Check-Read-Taggs RCKWRTS bearbeiten }
             do_CheckTagg(actLine);
           END;
          FOR actLine := 1 TO BufferPmax DO
           BEGIN
             { List-Read-Taggs VORWRTS bearbeiten }
             do_ListTagg(actLine);
           END;
        END;
    2 : BEGIN
          { Erase-Mode }
          ModeStr := 'E';
          FOR actLine := 1 TO BufferPmax DO
           BEGIN
             { Check-Erase-Taggs VORWRTS bearbeiten }
             do_CheckTagg(actLine);
           END;
          FOR actLine := BufferPmax DOWNTO 1 DO
           BEGIN
             { List-Erase-Taggs RCKWRTS bearbeiten }
             do_ListTagg(actLine);
           END;
        END;
    3 : BEGIN
          { SetL-Mode }
          ModeStr := 'SetL';
          { Reihenfolge ist egal... }
          FOR actLine := 1 TO BufferPmax DO
           BEGIN
             do_SetLTagg(actLine);
           END;
        END;
   END;

   IF (XBufferP > 1) THEN
    BEGIN
      TextAttr := low;
      Window(1,2,MaxX,MaxY);
      ClrScr;
      maxWindow;
      GotoXY(1,4);
      CASE Mode OF
       1 : WRITE('Read');
       2 : WRITE('ERASE');
       3 : WRITE('SetLifetime');
      END;
      WRITELN('-Generator:');
      WRITELN;
      TextAttr := norm;

      a := 0;
      FOR i := 1 TO (XBufferP-2) DO
        WRITE(XBuffer[i]);

      GotoXY(1,MaxY-1);
      WRITE(ConstStr('',MaxX));
      GotoXY(1,MaxY);
      WRITE('>>>   ESC (bzw. rechte Maustaste), oder  ENTER (bzw. linke Maustaste)');
      GotoXY(4,MaxY);
      Cursor_ein;
      a := 0;
      REPEAT
        IF M_Button(1) THEN a := 1;
        IF M_Button(2) THEN a := 2;
        IF Keypressed THEN a := 3;
      UNTIL (a > 0);
      Cursor_aus;
      chx := #0;
      IF Keypressed THEN GetKey(chx,KC);
      restore_Screen;
      restore_MoniStatus;
      TextAttr := AMerk;
      IF ((a = 1) OR (chx = #13)) AND (Kanal <> 0) THEN
       BEGIN
         { Text zeilenweise senden, weil sonst die Box holpert... }
         IF K[Kanal]^.localEcho THEN _aus(Kanal,#13);
         Zeile := '';
         FOR i := 1 TO (XBufferP-1) DO
          BEGIN
            Inc(a);
            IF (XBuffer[i] = ';') THEN
              BEGIN
                TX_Out(Kanal,Zeile+#13);
                Zeile := '';
              END
            ELSE
              BEGIN
                Zeile := Zeile + XBuffer[i];
              END;
          END;
         IF (Length(Zeile) > 0) THEN
          BEGIN
            Zeile := Zeile + #13;
            TX_Out(Kanal,Zeile);
          END;
       END;
    END

   ELSE

    BEGIN
      { kein Text fr den Read-Generator }
      TextAttr := AMerk;
      restore_Screen;
      restore_MoniStatus;
    END;

 END;


{-----------------------------------------------------------------------------
|  Anzahl der leeren Zeilen am Ende des RckholBuffers von Kanal feststellen,
|  dabei die berprfung auf die letzten maxY-3 Zeilen beschrnken
+----------------------------------------------------------------------------}

FUNCTION  checkEmptyLines(Kanal : Byte) : INTEGER;

 VAR   Differenz   : INTEGER;
       Zeile       : Str80;
       LeerZeile   : Str80;
       i,L1,L2,z   : INTEGER;

 FUNCTION Adjust (Z : INTEGER) : INTEGER;
  BEGIN
    z := z - Differenz;
    IF (z < 1) THEN z := z + K[Kanal]^.ChxBufferPmax;
    Adjust := z;
  END;

 BEGIN
   Zeile[0] := #80;      { Lngenangabe setzen }
   LeerZeile := ConstStr(' ',80);
   WITH K[Kanal]^ DO
    BEGIN
      Differenz := ChxBufferPmax - ChxBufferP;
      i := ChxBufferPmax;
      REPEAT
        z := adjust(i);
        Move(ChxBuffer^[z,1],Zeile[1],80);
        Dec(i);
      UNTIL (i < (ChxBufferPmax-maxY+3)) OR (Zeile <> LeerZeile);
      checkEmptyLines := ChxBufferPmax-i;
    END;
 END;



BEGIN

  ScrollBufferSaveOK := FALSE;

END.
