
{------------------------------------------------------------------------------
|
|  P R T A S T . P A S
|
|  Bearbeitung der Tastatureingaben
|
|  DL1BHO  01/1994
|
+-----------------------------------------------------------------------------}


UNIT  PRTast;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


USES
       PRMouse,
       PRKBD,
       PRCW;



PROCEDURE msg_out (Kanal : BYTE ; msgNummer : BYTE);
PROCEDURE AuswertTaste (ch_Tast : CHAR; kc : KeyCodes);
PROCEDURE poll_Tastatur;


IMPLEMENTATION


USES
       Crt,
       Dos,
       PRDefs,
       PRLib,
       PRLib1,
       PRLib2,
       PRLib3,
       PRLib4,
{$IFDEF OS2}
       PRV24OS2,
{$ELSE}
       PRV24,
{$ENDIF}
       PRScreen,
       PRPass,
       PRScroll,
       PRRemote;



PROCEDURE EditErrorSound;
 VAR  i   : INTEGER;
 BEGIN
   IF NOT Klingel THEN Exit;
   NoSound;
   FOR i := 1 TO 1 DO      { nervt sonst zu sehr... }
    BEGIN
      Sound(800);
      Delay(1*DelayCorr);
      Sound(1200);
      Delay(1*DelayCorr);
    END;
   NoSound;
 END;


{-----------------------------------------------------------------------------
|  kurzer Ton beim Erreichen einer Eingabezeilenlnge von 68 Zeichen
+----------------------------------------------------------------------------}

PROCEDURE EditWarningSound;
 BEGIN
   NoSound;
   Sound(1400);
   Delay(2*DelayCorr);
   NoSound;
 END;


{-----------------------------------------------------------------------------
|
|  Eingabezeile editieren
|
+----------------------------------------------------------------------------}

PROCEDURE do_EditLine (Kanal : BYTE ; chx : CHAR; VAR KC : KeyCodes;
                       VAR LineTooLong : BOOLEAN);

VAR  i1,i2     : INTEGER;
     Zeile     : ^Str80;
     L         : Byte;

 PROCEDURE InsertChar(chxx : Char);
  BEGIN
    WITH K[Kanal]^ DO
     BEGIN
       IF (L < 78) THEN
         BEGIN
           Insert(chxx,Zeile^,X1);
           WriteEditStr(Copy(Zeile^,X1,80));
           Inc(X1);
           L := Length(Zeile^);
           GotoXY(X1,Y1);
           IF (L = 68) THEN EditWarningSound;
         END
       ELSE
         BEGIN
           { Zeile wird zu lang. Wenn Cursor am Zeilenende, dann
             Wrapping signalisieren                              }
           IF (X1 = Succ(L)) THEN
             LineTooLong := TRUE
           ELSE
             EditErrorSound;
         END;
     END;
  END;

BEGIN
  WITH K[Kanal]^ DO
  BEGIN
    Zeile := @EditLine^[actEditLine];
    L := Length(Zeile^);
    GotoXY(X1,Y1);
    LineTooLong := FALSE;

    CASE kc OF

     CLeft
       : BEGIN
           IF (X1 > 1) THEN
             Dec(X1)
           ELSE
             BEGIN
               IF (actEditLine > 1) THEN
                BEGIN
                  X1 := 80;
                  KC := CUp;
                END;
             END;
         END;
     CRight
       : BEGIN
           IF (X1 < SUCC(L)) THEN
             Inc(X1)
           ELSE
             BEGIN
               IF (actEditLine < maxEditLine) THEN
                BEGIN
                  X1 := 1;
                  KC := CDown;
                END;
             END;
         END;
     CHome
       : BEGIN
           X1 := 1;
         END;
     CEnd
       : BEGIN
           X1 := SUCC(L);
         END;
     _Backstep
       : BEGIN
           IF (X1 >= 2) THEN
             BEGIN
               Dec(X1);
               Delete(Zeile^,X1,1);
               GotoXY(X1,Y1);
               WriteEditStr(Copy(Zeile^,X1,80)+' ');
             END;
         END;
     Del
       : BEGIN
           IF (X1 < SUCC(L)) THEN
             BEGIN
               Delete(Zeile^,X1,1);
               WriteEditStr(Copy(Zeile^,X1,80)+' ');
             END;
         END;
     Alt_Y
       : BEGIN
           { EingabeZeile lschen }
           Zeile^ := '';
           X1 := 1;
           GotoXY(1,Y1);
           ClrEOL;
         END;
     _Escape
       : BEGIN
           IF (X1 = 1) THEN
             BEGIN
               { Kommando-Eingabe }
               InsertChar('');
               InsertChar(' ');
             END
           ELSE
             InsertChar(chx);
         END;
     _Sonstige
       : BEGIN
           CASE chx OF
             #255: ;
             '' : BEGIN
                     CASE Umlaut OF
                      0 : BEGIN
                            InsertChar('a');
                            InsertChar('e');
                          END;
                      1 : InsertChar('{');
                      2 : InsertChar(chx);
                     END;
                   END;
             '' : BEGIN
                     CASE Umlaut OF
                      0 : BEGIN
                            InsertChar('o');
                            InsertChar('e');
                          END;
                      1 : InsertChar('|');
                      2 : InsertChar(chx);
                     END;
                   END;
             '' : BEGIN
                     CASE Umlaut OF
                      0 : BEGIN
                            InsertChar('u');
                            InsertChar('e');
                          END;
                      1 : InsertChar('}');
                      2 : InsertChar(chx);
                     END;
                   END;
             '' : BEGIN
                     CASE Umlaut OF
                      0 : BEGIN
                            InsertChar('A');
                            InsertChar('e');
                          END;
                      1 : InsertChar('[');
                      2 : InsertChar(chx);
                     END;
                   END;
             '' : BEGIN
                     CASE Umlaut OF
                      0 : BEGIN
                            InsertChar('O');
                            InsertChar('e');
                          END;
                      1 : InsertChar('\');
                      2 : InsertChar(chx);
                     END;
                   END;
             '' : BEGIN
                     CASE Umlaut OF
                      0 : BEGIN
                            InsertChar('U');
                            InsertChar('e');
                          END;
                      1 : InsertChar(']');
                      2 : InsertChar(chx);
                     END;
                   END;
             '' : BEGIN
                     CASE Umlaut OF
                      0 : BEGIN
                            InsertChar('s');
                            InsertChar('s');
                          END;
                      1 : InsertChar('~');
                      2 : InsertChar(chx);
                     END;
                   END;
             ELSE  BEGIN
                     InsertChar(chx);
                   END;
           END;
         END;
     ELSE
         BEGIN
           { Naja, so schlimm wird's schon nicht gewesen sein... }
         END;
     END;   { CASE }

  END;
END;


{-----------------------------------------------------------------------------
| einen Festspeichertext untersuchen, $-Kommandos parsen, Text ausgeben
+----------------------------------------------------------------------------}

PROCEDURE msg_out(Kanal : BYTE ; msgNummer : BYTE);

VAR  msgZeiger   : INTEGER;
     chx         : CHAR;
     b           : BYTE;
     subStr      : String[20];
     i           : INTEGER;
     Zeile       : String;

BEGIN
  WITH K[Kanal]^ DO BEGIN
    Zeile := '';
    msgZeiger := 1;
    REPEAT
      chx := msg[msgNummer]^[msgZeiger];
      IF (chx <> #0) THEN
       BEGIN
         { Ende des Festspeichers ist noch nicht erreicht }
         IF (chx = '$') THEN
          BEGIN
            { $-Kommando parsen }
            Inc(msgZeiger);
            chx := msg[msgNummer]^[msgZeiger];
            CASE chx OF
             'T','Z' : subStr := Time;
             't','z' : subStr := Copy(Time,1,5);
             'D'     : subStr := Date;
             'd'     : subStr := Copy(Date,4,8);
             'C','c' : BEGIN
                         IF connected
                          THEN subStr := Call
                          ELSE subStr := '';
                         IF (chx = 'c') THEN subStr := onlyCall(subStr);
                       END;
             'M','m' : BEGIN
                         {Call des TNC erfragen}
                         IF (Kanal = 0) THEN switch_TNC(unproto);
                         Ausgabe := FALSE;
                         S_Com(Kanal,'I');
                         subStr := Copy(ResponseStr,1,Length(ResponseStr)-1);
                         IF (chx = 'm') THEN subStr := onlyCall(subStr);
                       END;
             'V','v' : subStr := 'V' + Version;
             'U','u' : subStr := Update;
             'P','p' : subStr := int_Str(Kanal);
             '$'     : subStr := '$';
             ELSE      subStr := '$' + msg[msgNummer]^[msgZeiger];
            END;
            FOR b := 1 TO Length(subStr) DO
             BEGIN
               Zeile := Zeile + subStr[b];
               IF Length(Zeile) = 255 THEN
                BEGIN
                  IF NOT FileSend THEN TX_out(Kanal,Zeile);
                  Zeile := '';
                END;
             END;
          END
         ELSE
          BEGIN
            { kein $-Kommando }
            IF (Umlaut < 2) THEN
             BEGIN
               CASE chx OF
                '' : chx := '[';
                '' : chx := '\';
                '' : chx := ']';
                '' : chx := '{';
                '' : chx := '|';
                '' : chx := '}';
                '' : chx := '~';
               END;
               chx := Chr(Ord(chx) AND $7F);
             END;
            Zeile := Zeile + chx;
            IF Length(Zeile) = 255 THEN
             BEGIN
               IF NOT FileSend THEN TX_out(Kanal,Zeile);
               Zeile := '';
             END;
          END;
       END
      ELSE
       BEGIN
         { Ende erzwingen }
         msgZeiger := maxMsgLaenge;
       END;
      Inc(msgZeiger);
    UNTIL (msgZeiger > maxMsgLaenge);
    IF (Length(Zeile) > 0) AND NOT FileSend THEN TX_out(Kanal,Zeile);
  END;
END;    { msg_out }


PROCEDURE FileMenue (Art : Byte; VAR chx : CHAR; FXPos, FYPos : INTEGER);

 VAR   AMerk    : BYTE;

 BEGIN
   AMerk := TextAttr;
   TextAttr := FNormAttr;
   gotoxy(FXpos+3,FYPos+2);
   WRITELN('(T)extdatei');
   gotoxy(FXPos+3,wherey);
   WRITELN('(B)inrdatei');
   gotoxy(FXPos+3,wherey);
   WRITELN('(A)uto-Binrdatei');
   gotoxy(FXPos+3,whereY);
   IF (Art = 1) THEN
     WRITELN('e(X)tended Bin-RX')
   ELSE
     WRITELN;
   GotoXY(FXPos+3,WhereY);
   WRITELN('<ESC> fr Abbruch');
   TextAttr := FHighAttr;
   GotoXY(FXPos+4,FYPos+2); WRITELN('T');
   GotoXY(FXPos+4,WhereY); WRITELN('B');
   GotoXY(FXPos+4,WhereY); WRITELN('A');
   GotoXY(FXPos+5,WhereY);
{
   IF (Art = 1) THEN
     WRITELN('X')
   ELSE
}
     WRITELN;
   GotoXY(FXPos+3,WhereY); WRITELN('<ESC>');
   WRITELN;

   TextAttr := FNormAttr;
   gotoxy(FXPos+3,WhereY);
   WRITE('Eingabe >>>  T,B,A,X,<ESC> ');
   Cursor_ein;
   REPEAT
     chx := Upcase(ReadKey);
   UNTIL chx in ['T','B','A',#13,#27];
   Cursor_aus;
   IF (chx = #13) THEN chx := 'T';
   TextAttr := FHighAttr;
   CASE chx OF
    'T' : BEGIN
            gotoxy(FXPos+3,FYPos+2);
            WRITELN('(T)extdatei');
          END;
    'B' : BEGIN
            gotoxy(FXPos+3,FYPos+3);
            WRITELN('(B)inrdatei');
          END;
    'A' : BEGIN
            gotoxy(FXPos+3,FYPos+4);
            WRITELN('(A)uto-Binrdatei');
          END;
   END;
   TextAttr := AMerk;
 END;




{------------------------------------------------------------------------------
|  T a s t a t u r d e k o d e r
+-----------------------------------------------------------------------------}

PROCEDURE AuswertTaste (ch_Tast : CHAR; KC : KeyCodes);

 LABEL FileSendNochmal;

 VAR   i,i1,i2       : INTEGER;
       Fehler        : INTEGER;
       AMerk         : BYTE;
       command       : INTEGER;
       D_ON          : BOOLEAN;
       UMerk         : Byte;
       gefunden      : BOOLEAN;
       upcaseLine    : Str80;
       inputLine     : Str80;
       subStr        : Str80;
       chx           : CHAR;
       LineTooLong   : BOOLEAN;
       Net_Par       : String [2];
       Net_Wert      : String [5];
       IO_OK         : INTEGER;
       FXPos,FYPos   : INTEGER;
       Sync          : BOOLEAN;

BEGIN                { of AuswertTaste }

  WITH K[show]^ DO
  BEGIN
    AMerk := TextAttr;
    TextAttr := low;
    IF Neu_Bild_if_keypressed THEN restore_Screen;

    IF ScreenSTBY THEN
    BEGIN
      ScreenSTBY := false;
      restore_Screen;
      IF (kc <> Alt_X) THEN
       BEGIN
         { jede Taste (auer Alt-X) lschen }
         ch_Tast := #255;
         kc := _Sonstige;
       END;
    END;

    ScreenTimer := ScreenInit;  { Bildschirm-Schoner wieder hochsetzen }

    ClearEditCursor;
    do_EditLine(show,ch_Tast,KC,LineTooLong);

    IF LineTooLong THEN
     BEGIN
       { Teile des Word-Wrappings durchfhren }
       subStr := EditLine^[actEditLine];
       i1 := Length(subStr);
       { das letzte Trennzeichen (Space oder -) im String suchen }
       WHILE (subStr[i1] <> ' ') AND (subStr[i1] <> '-') AND (i1 > 1) DO
         Dec(i1);
       IF (i1 = 1) THEN i1 := Succ(Length(subStr));   { kein Trennzeichen }
       IF (Copy(subStr,i1,1) = ' ') THEN
         Delete(EditLine^[actEditLine],i1,80)
       ELSE
         Delete(EditLine^[actEditLine],i1+1,80);
       Delete(subStr,1,i1);          { Rest nach dem Trennzeichen }
       KC := _Return;
       subStr := subStr + ch_Tast;
     END;

    CASE kc OF
      _Return
        : BEGIN
            inputLine := EditLine^[actEditLine];
            upcaseLine := upcaseStr(inputLine);
            IF Auto_cmd THEN
             BEGIN
               Auto_cmd := FALSE;
               Status1(show);
             END;
            X1 := 1;
            IF Copy(inputLine,1,2) = ' ' THEN
            BEGIN
              { Kommando-Modus }
              Delete(upcaseLine,1,2);
              Delete(inputLine,1,2);

              IF (Copy(upcaseLine,1,2) = 'CL')   THEN command := 22 ELSE
              IF (copy(upcaseLine,1,1) = 'C')    THEN command := 3  ELSE
              IF (copy(upcaseLine,1,2) = 'DI')   THEN command := 4  ELSE
              IF (Copy(upcaseLine,1,2) = 'DO')   THEN command := 17 ELSE
              IF (Copy(upcaseLine,1,2) = 'ED')   THEN command := 21 ELSE
              IF (Copy(upcaseLine,1,4) = 'EXIT') THEN command := 15 ELSE
              IF upcaseLine            = 'H'     THEN command := 8  ELSE
              IF (copy(upcaseLine,1,2) = 'HE')   THEN command := 12 ELSE
              IF (Copy(upcaseLine,1,1) = 'I')    THEN command := 13 ELSE
              IF (Copy(upcaseLine,1,2) = 'LI')   THEN command := 20 ELSE
              IF (copy(upcaseLine,1,2) = 'LO')   THEN command := 6  ELSE
              IF (copy(upcaseLine,1,2) = 'MH')   THEN command := 1  ELSE
              IF (copy(upcaseLine,1,3) = 'PAR')  THEN command := 7  ELSE
              IF (copy(upcaseLine,1,2) = 'PA')   THEN command := 2  ELSE
              IF (copy(upcaseLine,1,4) = 'PRIV') THEN command := 11 ELSE
              IF (Copy(upcaseLine,1,4) = 'QRES') THEN command := 14 ELSE
              IF (Copy(upcaseLine,1,4) = 'QUIT') THEN command := 15 ELSE
              IF (Copy(upcaseLine,1,2) = 'SC')   THEN command := 18 ELSE
              IF (copy(upcaseLine,1,1) = 'U')    THEN command := 5  ELSE
              IF (copy(upcaseLine,1,1) = '?')    THEN command := 12 ELSE
              IF (copy(upcaseLine,1,2) = '//')   THEN command := 9  ELSE
                command := 99;

              CASE command OF

               1 : BEGIN
                     { MHeard-Kommando }
                     i := Pos(' ',upcaseLine);
                     IF (i <> 0)
                       THEN MH_darstellen(Copy(upcaseLine,i+1,9))
                       ELSE MH_darstellen('');
                   END;

               2 : BEGIN
                     { PAClen-Kommando }
                     do_PACcommand(show,upcaseLine);
                   END;

               3 : BEGIN
                     { Connect-Kommando }
                     Delete(upcaseLine,1,1);
                     upcaseLine := CutLeftStr(upcaseLine);
                     gefunden := FALSE;
                     i := 0;
                     REPEAT
                       Inc(i);
                       IF (AutoCmd[i]^.Handle = upcaseLine)
                         THEN gefunden := TRUE;
                     UNTIL gefunden OR (i = 10);
                     IF (Length(upcaseLine) = 0) THEN gefunden := FALSE;
                     IF (LinkState = 0) AND (show <> 0) AND gefunden THEN
                      BEGIN
                        cmd_Nummer := i;
                        Auto_cmd := TRUE;
                        S_Com(show,Auto_Command(show,cmd_Nummer,1));
                        cmd_Stufe := 2;
                      END
                     ELSE
                      BEGIN
                        IF (show = 0) THEN switch_TNC(unproto);
                        S_Com(show,inputLine);
                        Status1(show);
                      END;
                   END;

               4 : BEGIN
                     { DIr-Kommando }
                     Catalog(upcaseLine);
                   END;

               5 : BEGIN
                     { U-Kommando }
                     do_Ucommand(inputLine,unproto);  { PRLib4 }
                   END;

               6 : BEGIN
                     do_LOGcommand;
                   END;

               7 : BEGIN
                     { PARameter-Kommando }
                     IF NetPWFileOK THEN
                      BEGIN
                        { Netz-Password-Datei ist vorhanden }
                        Net_Par := '';
                        Net_Wert := '';
                        delete(upcaseLine,1,3);
                        WHILE (upcaseLine[1] <> ' ')
                          and (length(upcaseLine) > 0) DO
                          delete(upcaseLine,1,1);
                        upcaseLine := CutLeftStr(upcaseLine);
                        WHILE (upcaseLine[1] IN ['0'..'9'])
                          AND (Length(upcaseLine) > 0 ) DO
                          BEGIN
                            Net_Par := Net_Par + upcaseLine[1];
                            Delete(upcaseLine,1,1);
                          END;
                        upcaseLine := CutLeftStr(upcaseLine);
                        WHILE (upcaseLine[1] IN ['0'..'9'])
                          AND (Length(upcaseLine) > 0 ) DO
                          BEGIN
                            Net_Wert := Net_Wert + upcaseLine[1];
                            delete(upcaseLine,1,1);
                          END;

                        Val(Net_Par,i1,i);
                        IF (i <> 0) OR (i1 > 38) THEN i1 := 0;
                        UpcaseLine := 'p ';
                        FOR i := 2 TO i1 DO UpcaseLine := UpcaseLine + '* ';
                        UpcaseLine := UpcaseLine + Net_Wert + ^M;
                        IF NOT FileSend THEN TX_Out(show,UpcaseLine);
                      END
                     ELSE
                      BEGIN
                        { garkein Net-Passwortfile vorhanden! }
                        { erstmal garnichts machen. }
                      END
                   END;

               8 : BEGIN
                     { Heard-Kommando, nur bis TheFirmware 2.6 !!! }
                     IF (show = 0) THEN
                      BEGIN
                        switch_TNC(unproto);
                        Ausgabe := FALSE;
                      END;
                     S_Com(show,'H');
                     IF (show = 0) AND
                        (Pos('- heard',ResponseStr) <> 0) AND
                        (Pos(' 0',ResponseStr) = 0) THEN
                     BEGIN
                       { auf Kanal 0 die Heard-Liste auslesen }
                       Moni_off;
                       TextAttr := MoniInfoAttr;
                       M_aus(' '^M);
                       UMerk := Umlaut;
                       Umlaut := 2;
                       M_aus('Rufzeichen   zuerst gehrt      zuletzt gehrt');
                       M_aus('   I-Frames     RR    REJ    RNR' + ^M);
                       M_aus(ConstStr('-',78) + #13);
                       REPEAT
                         KbdLock;
                         SendTNC(0,1,'G');
                         READaux(chx,Sync);  { KanalNummer }
                         READaux(chx,Sync);  { Code }
                         i2 := Ord(chx);
                         i := 0;
                         REPEAT
                           READaux(chx,Sync);
                           Inc(i);
                           upcaseLine[i] := chx;
                         UNTIL chx = #0;
                         KbdFree;
                         upcaseLine[0] := Chr(i);       { Der String      }
                         upcaseLine[i] := #13;          { upcaseLine    }
                         M_aus(upcaseLine);             { wird nur als    }
                         Uhr_aus;                       { Hilfsstring ben.}
                         check_Scroll_Lock;
                       UNTIL (i2 <> 5) or keypressed;
                       IF keypressed THEN
                       BEGIN
                         chx := READkey;
                         IF chx = #0 THEN chx := READkey;
                         S_Text(0,#13);  { Ausgabe stoppen }
                       END;
                       M_aus(' '^M);
                       restore_MoniStatus;
                       Umlaut := UMerk;
                     END;
                   END;

               9 : BEGIN
                     { Remote-Bedienung am Terminal }
                     IF (show <> 0) AND NOT connected THEN
                      BEGIN                 { nicht Monitorkanal }
                        RemStatus := 0;
                        RemDecode(show,inputLine,1,TRUE);
                      END;
                   END;

               11: BEGIN
                     { Bei Mailboxsystemen vom Typ DieBox privilegiert einloggen }
                     IF (MBX_remote_Call(show) <> '') AND connected THEN
                       TX_Out(show,'PRIV '+PassWort+#13)
                     ELSE
                       Beep(220,200);
                   END;

               12: BEGIN
                     { ?-Kommando , wird auch mit Alt-H ausgelst }
                     i := Pos(' ',upcaseLine);
                     IF (i = 0) THEN i := Length(upcaseLine);
                     Delete(upcaseLine,1,i);
                     upcaseLine := cutLeftStr(upcaseLine);
                     do_HelpCommand(upcaseLine);
                   END;

               13: BEGIN
                     { I - Befehl }
                     IF (show = 0) THEN switch_TNC(unproto);
                     S_Com(show,InputLine);
                     IF (show = 0) THEN
                      BEGIN
                        FOR i := 0 TO maxLink DO
                         BEGIN
                           IF K[i]^.poll THEN
                            BEGIN
                              Ausgabe := FALSE;
                              S_Com(i,'I');
                              k[i]^.TNCCall :=
                                 Copy(ResponseStr,1,Length(ResponseStr)-1);
                            END;
                         END;
                      END
                     ELSE
                      BEGIN
                        Ausgabe := FALSE;
                        S_Com(show,'I');
                        TNCCall := Copy(ResponseStr,1,Length(ResponseStr)-1);
                      END;
                   END;

               14: ;   { QRES-Kommando abfangen }

               15: BEGIN
                     { Quit / Exit }
                     QRT := TRUE;
                   END;

               16: ;

               17: Begin
                     { DOs - Kommando }
                     do_DOScommand(upcaseLine,TRUE,TRUE,TRUE,BSave);  { in PRLIB2 }
                   End;

               18: BEGIN
                     { SCan - Kommando }
                     i := Pos(' ',upcaseLine);
                     IF (i = 0) THEN i := Length(upcaseLine);
                     Delete(upcaseLine,1,i);
                     upcaseLine := cutLeftStr(upcaseLine);
                     do_ScanCommand(upcaseLine);
                   END;

               20: BEGIN     { LIst }
                     i := Pos(' ',upcaseLine);
                     IF (i = 0) THEN i := Length(upcaseLine);
                     Delete(upcaseLine,1,i);
                     upcaseLine := cutLeftStr(upcaseLine);
                     IF (upcaseLine = '') THEN upcaseLine := RX_Name;
                     IF (Pos('.',upcaseLine) = 0) THEN
                       upcaseLine := upcaseLine + '.TXT';
                     IF (Pos(':',upcaseLine) = 0) AND
                        (Pos('\',upcaseLine) = 0) THEN
                       upcaseLine := TextPfad + upcaseLine;
                     IF File_exists(upcaseLine) THEN
                       do_DOScommand('DOS '+ListPgm+' '+upcaseLine+' /8',FALSE,TRUE,TRUE,BSave);
                   END;

               21: BEGIN     { EDit }
                     i := Pos(' ',upcaseLine);
                     IF (i = 0) THEN i := Length(upcaseLine);
                     Delete(upcaseLine,1,i);
                     upcaseLine := cutLeftStr(upcaseLine);
                     IF (upcaseLine = '') THEN upcaseLine := RX_Name;
                     IF (Pos('.',upcaseLine) = 0) THEN
                       upcaseLine := upcaseLine + '.TXT';
                     IF (Pos(':',upcaseLine) = 0) AND
                        (Pos('\',upcaseLine) = 0) THEN
                       upcaseLine := TextPfad + upcaseLine;
                     do_DOScommand('DOS '+EditPgm+' '+upcaseLine,FALSE,TRUE,TRUE,BSave);
                   END;

               22: BEGIN
                     { CLs-Kommando }
                     do_CLScommand;
                   END;

              ELSE BEGIN
                     IF (show = 0) THEN switch_TNC(unproto);
                     S_Com(show,InputLine)
                   END;

              END; { CASE }

            END     { Ende Kommando-Modus nach Enter }

            ELSE

            BEGIN
              { Enter nach Texteingabe }
              InputLine := InputLine + #13;
              IF NOT FileSend THEN
                TX_Out(show,InputLine);
            END;

            IF (actEditLine = maxEditLine) THEN
             BEGIN
               FOR i := 1 TO (maxEditLine-1) DO
                 EditLine^[i] := EditLine^[i+1];
               EditLine^[actEditLine] := '';
             END
            ELSE
             BEGIN
               Inc(actEditLine);
               Inc(Y1);
               IF (Y1 >= S1Pos) THEN
                BEGIN
                  Y1 := Pred(S1Pos);
                  Inc(TopEditLine);
                END;
             END;

            IF LineTooLong THEN
             BEGIN
               { Rest der Zeile in neue Zeile packen }
               EditLine^[actEditLine] := subStr;
               X1 := Succ(Length(subStr));
             END;

            restoreEditLines;

          END;  { Return }

      CUp
        : BEGIN
            Dec(Y1);
            Dec(actEditLine);
            IF (actEditLine < 1) THEN
             BEGIN
               actEditLine := 1;
               Y1 := 1;
               EditErrorSound;
             END
            ELSE
             BEGIN
               IF (Y1 <= 0) THEN
                BEGIN
                  Y1 := 1;
                  Dec(TopEditLine);
                  IF (TopEditLine < 1) THEN TopEditLine := 1;
                END;
               restoreEditLines;
             END;
            IF (X1 > Succ(Length(EditLine^[actEditLine]))) THEN
              X1 := Succ(Length(EditLine^[actEditLine]));
          END;

      CDown
        : BEGIN
            i1 := maxEditLine-S1Pos+2;
            Inc(Y1);
            Inc(actEditLine);
            IF (actEditLine > maxEditLine) THEN
             BEGIN
               actEditLine := maxEditLine;
               Y1 := Pred(S1Pos);
               EditErrorSound;
             END
            ELSE
             BEGIN
               IF (Y1 >= S1Pos) THEN
                BEGIN
                  Y1 := Pred(S1Pos);
                  Inc(TopEditLine);
                  IF (TopEditLine > i1) THEN TopEditLine := i1;
                END;
               restoreEditLines;
             END;
            IF (X1 > Succ(Length(EditLine^[actEditLine]))) THEN
              X1 := Succ(Length(EditLine^[actEditLine]));
          END;

      Alt_A
        : BEGIN
            { Notiz-Buffer bearbeiten }
            do_BackScroll(show,NotizBuffer,NotizBufferP,NotizBufferPmax);
          END;

       Alt_B
           : BEGIN
               Ansi := NOT Ansi;
               Show_Flags(show);
             END;

       Alt_C
           : BEGIN
               { Telegrafie-Ausgabe toggeln }
               IF show <> 0 THEN
                BEGIN
                  CW := NOT CW;
                  show_Flags(show);
                  IF CW THEN Telegrafie('ok');
                END;
             END;

       Alt_D
           : BEGIN
               { Drucker toggle }
               IF (Drucker = show) THEN
                BEGIN
                  { Drucker ausschalten }
                  Drucker := -1;
                  WRITElst(Printer1[10]);
                  FOR i := 0 TO maxLink DO show_Flags(i);
                END
               ELSE
                BEGIN
                  { Drucker einschalten }
                  IF LPT1_vorhanden THEN
                   BEGIN
                     IF (Drucker <> -1) THEN
                      BEGIN
                        { Drucker ist schon eingeschaltet }
                        IF Klingel THEN WRITE(^G);
                      END
                     ELSE
                      BEGIN
                        IF NOT LPT1_Error THEN
                         BEGIN
                           Drucker := show;
                           WRITElst(Printer1[9]);   {Printer-Init}
                           FOR i := 0 TO maxLink DO show_Flags(i);
                         END
                        ELSE
                         BEGIN
                           { Irgendwas ist am Drucker faul ... }
                           WRITE(^G);
                           FXPos := (80-26) DIV 2;
                           FYPos := (MaxY-7) DIV 2;
                           Fenster(FXPos,FYPos,26,7,'Drucker-Fehler');
                           Gotoxy(FXPos+2,FYPos+2);
                           TextAttr := FHighAttr;
                           WRITELN('LPT1-Status: ',Bin(Port[LPT1_Base+1],8));
                           WRITELN;
                           Gotoxy(FXPos+2,WhereY);
                           WRITE('Enter >>> ');
                           Cursor_ein;
                           WaitKey(0);
                           Cursor_aus;
                           restore_Screen;
                         END;
                      END;
                   END;
                END;
             END;
       Alt_E
           : BEGIN           { Alt_E = File-EMPFANGS-Menue }
               Save := NOT Save;
               IF Save THEN
                BEGIN
                  FXPos := (80-40) DIV 2;
                  FYPos := (MaxY-10) DIV 2;
                  Fenster(FXPos,FYPos,40,10,'Datei EMPFANGEN');
                  FileMenue(1,chx,FXPos,FYPos);
                  IF (chx <> #27) THEN
                  BEGIN
                    CASE chx of
                     'T' : RX_Mode := 0;
                     'B' : RX_Mode := 1;
                     'A' : RX_Mode := 2; { Vorstadium fr Auto-Send }
                     'X' : BEGIN
                             RX_Mode := 2;     { extended RX-Bin }
                             RX_XBin := TRUE;
                             Save := TRUE;
                           END;
                    END;

                    IF NOT RX_XBin THEN
                     BEGIN
                       Gotoxy(FXPos+3,FYPos+8);
                       TextAttr := FHighAttr;
                       WRITE(ConstStr(' ',31));
                       Gotoxy(FXPos+3,FYPos+8);
                       WRITE('Name: ');
                       {$V-}
                       EditStr(RX_Name,60,FXPos+9,FYPos+8,chx);
                       {$V+}
                       IF (chx <> #27) THEN
                       BEGIN
                         IF RX_Name = '' THEN
                           RX_Name := StdFilename(show);
                         IF Pos('.',RX_Name) = 0 THEN
                           RX_Name := RX_Name + '.TXT';
                         IF (Pos(':',RX_Name) = 0) AND
                            (Pos('\',RX_Name) = 0) THEN
                           RX_Name := TextPfad + RX_Name;
                         GotoXY(FXPos+9,FYPos+8);
                         WRITE(RX_Name);
                         Assign(RXFile,RX_Name);
                         SetTextBuf(RXFile,RXFileBuffer^);
                         RX_Count := 0;
                         IF (RX_Mode = 0) THEN
                         BEGIN
                           { Textfile }
                           OpenRXFile(show);
                         END
                         ELSE
                         BEGIN
                           { Binrfile }
                           FiFoStr := ConstStr(#13,80);
                           RX_expectCheck := 0;
                           {$I-}
                           Reset(RXFile);
                           {$I+}
                           IO_OK := IOResult;
                           IF (IO_OK = 3) THEN
                            BEGIN
                              { Path not found, also neuer Versuch }
                              RX_Name := SysPfad + onlyFName(RX_Name);
                              Assign(RXFile,RX_Name);
                              SetTextBuf(RXFile,RXFileBuffer^);
                              {$I-}
                              Reset(RXFile);
                              {$I+}
                              IO_OK := IOResult;
                            END;
                           IF (IO_OK = 0) THEN
                           BEGIN
                             { File vorhanden !!! }
                             Close(RXFile);
                             Fenster(FXPos,FYPos,40,10,'Datei EMPFANGEN');
                             GotoXY(FXPos+2,FYPos+3);
                             TextAttr := FBlinkAttr;
                             WRITELN('File ''',RX_Name,'''');
                             gotoxy(FXPos+2,WhereY);
                             WRITELN('ist vorhanden !!');
                             WRITELN;
                             gotoxy(FXPos+2,WhereY);
                             TextAttr := FHighAttr;
                             WRITE('File berschreiben?  J/N '^G);
                             REPEAT
                               chx := upcase(READKey);
                             UNTIL chx in ['J','N'];
                             IF (chx = 'J')
                               THEN Rewrite(RXFile)
                               ELSE save := FALSE;
                           END
                           ELSE
                           BEGIN
                             { File konnte nicht geffnet werden, also ok }
                             Rewrite(RXFile);
                           END;
                         END; { binr }
                       END
                       ELSE save := FALSE;
                     END;

                  END
                  ELSE Save := FALSE;

                  restore_Screen;
                END
               ELSE
                BEGIN
                  CloseRXFile(show);
                  IF (RX_Mode = 3) THEN
                   BEGIN
                     InputLine := '#STOP# Manual Aborted !' + ^M;
                     TX_out(show,InputLine);
                     {$I-} Erase(RXFile); {$I+}
                     i := IOResult;
                   END;
                  IF (RX_Mode <> 0) THEN
                    RX_Name := StdFilename(show);   { alten Namen einstellen }
                  RX_XBin := FALSE;
                  IF Remote = 2 THEN
                    IF RemStatus > 0 THEN
                      BEGIN
                        RemStatus := 0;   { neue Kommandoeingabe ermglichen }
                        RemSendBuffered(show,RemPrompt(show));
                      END;
                  Status1(show);
                END;
             END;

       Alt_F
           : ;

       Alt_G
           : ;

       Alt_H
           : do_HelpCommand('');

       Alt_I
           : ;

       Alt_J
           : ;

       Alt_K
           : BEGIN
               IF (show = 0) THEN
                BEGIN
                  Klingel := NOT Klingel;
                  Show_Flags(0);
                END;
             END;

       Alt_L
           : BEGIN
               do_LOGcommand;
             END;

       Alt_M
           : ;

       Alt_N
           : BEGIN            { Notiz toggle }
               notice := NOT notice;
               Show_Flags(show);
             END;

       Alt_O
           : ;

       Alt_P
           : BEGIN
               { Bei 'DieBox' privilegiert einloggen }
               IF (MBX_remote_Call(show) <> '') AND connected THEN
                 TX_Out(show,'PRIV '+PassWort+#13)
               ELSE
                 Beep(220,200);
             END;

       Alt_Q
           : ;

       Alt_R
           : BEGIN
               IF (show > 0) THEN
                BEGIN
                  RemStatus := -1;    { Remote sperren }
                  RemPriv := 0;
                  Inc(Remote);
                  IF (Remote > 2) THEN Remote := 0;
                  IF (Remote = 2) AND NOT RemCfgOK THEN Remote := 0;
                  IF (Remote = 2) THEN
                    BEGIN
                      RemStatus := 0;    { Remote freigeben }
                      IF RemPrivOK(Call) THEN
                        RemPriv := 1;
                    END;
                  IF simplex THEN
                    BEGIN
                      IF Remote >= 1 THEN
                        S_Com(show,'@M1')    { Mailbox-Mode ein (Test!) }
                      ELSE
                        S_Com(show,'@M0');   { Mailbox-Mode aus (Test!) }
                    END;
                  Show_Flags(show);
                END;
             END;

       Alt_S
           : BEGIN                      { Alt_S = File-Sende-Menue }
               IF (show <> 0) THEN
               BEGIN
                 IF FileSend THEN
                  BEGIN
                    FileSend := FALSE;
                    Close(TXFile);
                  END
                 ELSE
                  BEGIN

                    FileSendNochmal:

                    FXPos := (80-40) DIV 2;
                    FYPos := (MaxY-10) DIV 2;
                    Fenster(FXPos,FYPos,40,10,'Datei SENDEN');
                    FileMenue(0,chx,FXPos,FYPos);
                    IF chx <> #27 THEN
                    BEGIN
                      CASE chx OF
                       'T' : TX_Mode := 0;
                       'B' : TX_Mode := 1;
                       'A' : TX_Mode := 2;
                      END;
                      gotoxy(FXPos+3,FYPos+8);
                      TextAttr := FHighAttr;
                      WRITE(CONSTStr(' ',31));
                      gotoxy(FXPos+3,FYPos+8);
                      Cursor_ein;
                      WRITE('Name: ');
                      {$V-}
                      EditStr(TX_Name,60,FXPos+9,FYPos+8,chx);
                      {$V+}
                      IF chx <> #27 THEN
                      BEGIN
                        IF pos('.',TX_Name) = 0 THEN
                          TX_Name := TX_Name + '.TXT';
                        IF (Pos(':',TX_Name) = 0) AND
                           (Pos('\',TX_Name) = 0) THEN
                          TX_Name := TextPfad + TX_Name;
                        TX_Name := FExpand(TX_Name);
                        gotoxy(FXPos+9,FYPos+8);
                        WRITE(TX_Name);
                        assign(TXFile,TX_Name);
                        {$I-}
                        reset(TXFile,1);
                        {$I+}
                        IF IOResult = 0 THEN
                        BEGIN
                          { File vorhanden }
                          TX_Laenge := FileSize(TXFile);
                          close(TXFile);
                          reset(TXFile);
                          blockREAD(TXFile,TXFileBuffer^,8,i);
                          TX_Count := 0;
                          TX_Buffer_Count := 1;
                          TX_CRC := 0;
                          TX_Sum := 0;
                          IF (TX_Mode = 2) THEN
                          BEGIN
                            { Bei Auto-Bin-Send SP-konformen Header bertragen }
                            Fenster(FXPos,FYPos,40,10,'Datei SENDEN');
                            TextAttr := FHighAttr;
                            GotoXY(FXPos+6,FYPos+5);
                            WRITE('calculating CRC-checksum...');
                            InputLine := '#BIN#'
                                         + int_Str(TX_Laenge) + '#'
                                         + '|'+int_Str(GetChecksum(TX_Name,TRUE))+'#'
                                         + '$'+Hex(packedFTime(TXFile),8)+'#'
                                         + onlyFName(TX_Name)
                                         + #13;
                            TX_Out(show,InputLine);
                          END;
                          FileSend := TRUE;
                        END
                        ELSE
                        BEGIN
                          { File nicht vorhanden }
                          Fenster(FXPos,FYPos,40,10,'Datei SENDEN');
                          gotoxy(FXPos+2,FYPos+3);
                          TextAttr := FBlinkAttr;
                          WRITELN('File ''',TX_Name,'''');
                          gotoxy(FXPos+2,WhereY);
                          WRITELN('nicht gefunden !');
                          WRITELN;
                          gotoxy(FXPos+2,WhereY);
                          TextAttr := FHighAttr;
                          WRITE('Weiter mit <RETURN>  ');
                          READLN;
                          Goto FileSendnochmal;
                        END;
                      END
                      ELSE goto FileSendnochmal;
                    END;

                    Cursor_aus;
                    restore_Screen;
                  END;
                 Status1(show);
               END;
             END;

       Alt_T
           : BEGIN
               IF (show = 0) THEN
                BEGIN
                  Time_stamp := NOT Time_stamp;
                  Show_Flags(0);
                END;
             END;

       Alt_U
           : BEGIN
               Inc(Umlaut);
               IF (Umlaut > 2) THEN Umlaut := 0;
               Show_Flags(show);
             END;

       Alt_V
           : BEGIN
               localEcho := NOT localEcho;
               show_Flags(show);
             END;

       Alt_W
           : ;

       Alt_X
           : QRT := TRUE;

       Alt_Y       { Eingabezeile lschen in Do_EditLine }
           : ;

       Alt_Z
           : ;

       Alt_8
           : ;

       F1..F10
           : BEGIN
               i := ORD(kc) - ORD(Alt_M);
               IF (i = show) OR (NOT K[i]^.poll) THEN i := 0;
               IF K[i]^.poll THEN
                BEGIN
                  show := i;
                  K[show]^.newText := FALSE;
                  restore_Screen;
                END;
             END;

       PgUp,PgDn
           : BEGIN
               Do_BackScroll(show,ChxBuffer,ChxBufferP,ChxBufferPmax);
             END;

       Ctrl_PgDn
           : BEGIN                 { TrennZeile nach unten }
               IF (Trenn <= MaxY) and (show <> 0) THEN
                 BEGIN
                   Inc(Trenn);
                   restore_Screen;
                   FOR i := 1 TO maxLink DO K[i]^.Trenn := Trenn;
                 END;
             END;

       Ctrl_PgUp
           : BEGIN                 { TrennZeile nach oben }
               IF (Trenn > (S1Pos+3)) and (show <> 0) THEN
                 BEGIN
                   Dec(Trenn);
                   restore_Screen;
                   FOR i := 1 TO maxLink DO
                     K[i]^.Trenn := Trenn;
                 END;
             END;

       Sh_F1..Sh_F10
           : BEGIN
               { Festspeicher ausgeben }
               Msg_out(show,Ord(kc) - Ord(Del));
             END;

       Alt_F1..Alt_F10
           : BEGIN
               { Kommando-Folge auslsen }
               IF (LinkState = 0) AND (show <> 0) THEN
                BEGIN
                  cmd_Nummer := ORD(kc) - ORD(Ctrl_F10);
                  Auto_cmd_darstellen;
                  IF Auto_cmd THEN
                   BEGIN
                     S_Com(show,Auto_Command(show,cmd_Nummer,1));
                     cmd_Stufe := 2;   { nchstes zu sendendes Kommando }
{                     PollChannel := show;   }
                     Pause := 1;
                     SysDelay(Sec05);       { auf Link-Setup warten }
                   END;
                END;
             END;

       Ins
           : BEGIN
               IF multiTNC AND (show = 0) THEN
                BEGIN
                  REPEAT
                    Inc(unproto);
                    IF (unproto > 4) THEN unproto := 1;
                  UNTIL TNC[unproto].used;
                  Status1(show);
                END
               ELSE
                Beep(880,100);
             END;

       _Sonstige
           : BEGIN
               { Tja, mal sehen... }
             END;

    END;  { CASE kc OF ... }

{    SetEditCursor;   }
    Timer[CursorTmr] := 1;    { Cursor mglichst schnell wieder zeigen }

    TextAttr := AMerk;

  END;  { WITH K[show]^ }

END;


{------------------------------------------------------------------------------
| Tastatur so lange abfragen, bis kein Zeichen mehr kommt
+-----------------------------------------------------------------------------}

PROCEDURE poll_Tastatur;

 VAR  ch_Tast     : CHAR;
      KeyCode     : KeyCodes;

 BEGIN

   check_Scroll_Lock;

   IF M_Button(1) OR M_Button(2) THEN
    BEGIN
      IF ScreenSTBY THEN
       BEGIN
         ScreenSTBY := false;
         restore_Screen;
       END;
      ScreenTimer := ScreenInit;  { Bildschirm-Schoner wieder hochsetzen }
      IF M_Button(1) AND M_Button(2) THEN
        Do_BackScroll(show,K[show]^.ChxBuffer,K[show]^.ChxBufferP,
                      K[show]^.ChxBufferPmax);
    END;

   WHILE Keypressed DO
    BEGIN
      GetKey (ch_Tast,KeyCode);
      AuswertTaste (ch_Tast,KeyCode);
    END;

 END;


BEGIN

  { keine Initialisierung erforderlich }

END.
