
{-----------------------------------------------------------------------------
|
|  P R T F P C R . P A S
|
|  Interface zum TFPCR-Treiber von DL1MEN
|
|  Es wird nach dem passenden Software-Interrupt im Bereich
|  $80 bis $FF gesucht!
|
|  ReSch (DL1BHO)  04/1992
|
+----------------------------------------------------------------------------}

Unit  PRTFPCR;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


Interface


VAR
       TFPCR_installed           : BOOLEAN;


FUNCTION  TFPCR_Zeichen : BOOLEAN;
PROCEDURE TFPCR_Write (Zeile : String);
FUNCTION  TFPCR_Read : CHAR;


Implementation


USES
       Dos;

TYPE
       Kiss_Array_Type  = ARRAY [1..10] OF Char;

CONST
       MatchStr         : ARRAY [4..7] OF Char = ('N','5','N','X');

VAR
       dummy            : INTEGER;
       KPointer         : Pointer;
       Kiss_Int         : INTEGER;
       Kiss_Array       : ^Kiss_Array_Type;


FUNCTION  TFPCR_Zeichen : BOOLEAN;

 VAR   r     : Registers;

 BEGIN
   r.AH := 1;
   r.AL := 0;
   Intr(Kiss_Int,r);
   TFPCR_Zeichen := (r.AL > 0);
 END;


PROCEDURE TFPCR_Write (Zeile : String);

 VAR   r       : Registers;
       Count   : INTEGER;

 BEGIN
   FOR Count := 1 TO Length(Zeile) DO
    BEGIN
      r.AH := 3;
      r.AL := Ord(Zeile[Count]);
      Intr(Kiss_Int,r);
    END;
 END;


FUNCTION TFPCR_Read : CHAR;

 VAR   r     : Registers;

 BEGIN
   r.AH := 2;
   r.AL := 0;
   Intr(Kiss_Int,r);
   TFPCR_Read := Chr(r.AL);
 END;


BEGIN

  { beim Start feststellen ob TFPCR installiert ist }
  { Suche nach dem Software-Interrupt               }

  TFPCR_installed := FALSE;
  Kiss_Int := $80;

  WHILE NOT TFPCR_installed AND (Kiss_Int < $100) DO
   BEGIN
     GetIntVec(Kiss_Int,KPointer);
     Kiss_Array := KPointer;
     TFPCR_installed := TRUE;
     FOR dummy := 4 TO 7 DO
       IF Kiss_Array^[dummy] <> matchStr[dummy] THEN
         TFPCR_installed := FALSE;
     IF NOT TFPCR_installed THEN Inc(Kiss_Int);
   END;
END.
