
{------------------------------------------------------------------------------
|
|  P R V 2 4 . P A S
|
|  Bedienung der bis zu 4 Schnittstellen + Hardware-Umschaltung + TFPCR/X
|
|  Teile der AT-IRQ-Behandlung nach DL5OBC
|
|  DL1BHO  12/1992
|
+-----------------------------------------------------------------------------}

UNIT PRV24;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


CONST
       MaxBuf       = 512;

       CLI          = $FA;
       STI          = $FB;

       MasterIntCtl = $20;
       SlaveIntCtl  = $A0;

TYPE
       ComType      = RECORD
                        active      : BOOLEAN;
                        Base        : INTEGER;
                        BaudRate    : LongInt;
                        V24Buffer   : ARRAY [1..MaxBuf] OF BYTE;
                        BufferPos   : INTEGER;
                        UserPos     : INTEGER;
                        IntNummer   : BYTE;
                        SlaveIRQ    : BOOLEAN;   { AT-Interrupt? }
                        FiFoMode    : BOOLEAN;   { 16550 installiert? }
                        RS232_Error : Word;
                        Neu_IRQ_Adr : Pointer;
                        Old_Vector  : POINTER;
                        Old_IER     : BYTE;      {Old InterruptEnableRegister}
                      END;

VAR
       Com          : ARRAY [1..4] OF ComType;
       active_Com   : Byte;
       ComPortBase  : ARRAY [1..4] OF WORD ABSOLUTE $0:$0400;
                              { Adressen der ComPorts stehen im Ram }
       Old_Master_IntMask  : BYTE;
       Old_Slave_IntMask   : Byte;
       Slave_IntMask_save  : BOOLEAN;


  PROCEDURE V24_Init (ComNummer : Byte; re_Init : BOOLEAN);
  FUNCTION  Zeichen : BOOLEAN;
  PROCEDURE WRITEaux(Zeile : STRING);
  FUNCTION  ReSync:BOOLEAN;
  PROCEDURE READaux(VAR ch232 : CHAR; VAR Sync_OK : BOOLEAN);
  PROCEDURE V24_Close;
  PROCEDURE switch_TNC(TNCNummer : Byte);

{------------------------------------------------------------------------------
| Ende Interface
+-----------------------------------------------------------------------------}


IMPLEMENTATION


USES
       Dos,
       Crt,
       PRDefs,
       PRLib,
       PRLib2,
{$IFDEF DEBUG}
       PRDebug,
{$ENDIF}
       PRTFPCR;

CONST
       LoBaud    = 0;   { Baudraten-Teiler }
       HiBaud    = 1;
       IER       = 1;   { Interrupt Enable Register }
       IIR       = 2;   { Interrupt Ident Register }
       FCR       = 2;   { FiFo Control Register }
       LCR       = 3;   { Line Control Register }
       MCR       = 4;   { Modem Control Register }
       LSR       = 5;   { Line Status Register }
       MSR       = 6;   { Modem Status Register }

VAR
       i         : INTEGER;
       IRQ_Adr   : ARRAY [1..2,1..4] OF Pointer;


{$F+}
PROCEDURE Com1_Int;  { wird vom V24-Interrupt (COM1:) angesprochen }
{$F-}
interrupt;
BEGIN
  WITH Com[1] DO BEGIN
    V24Buffer[BufferPos] := Port[Base];
    IF (BufferPos < MaxBuf) THEN
      Inc(BufferPos)
    ELSE
      BufferPos := 1;
  END;
  Port[MasterIntCtl] := $20;
END;


{$F+}
PROCEDURE Com2_Int;  { wird vom V24-Interrupt (COM2:) angesprochen }
{$F-}
interrupt;
BEGIN
  WITH Com[2] DO BEGIN
    V24Buffer[BufferPos] := Port[Base];
    IF (BufferPos < MaxBuf) THEN
      Inc(BufferPos)
    ELSE
      BufferPos := 1;
  END;
  Port[MasterIntCtl] := $20;
END;


{$F+}
PROCEDURE Com3_Int;  { wird vom V24-Interrupt (COM3:) angesprochen }
{$F-}
interrupt;
BEGIN
  WITH Com[3] DO BEGIN
    V24Buffer[BufferPos] := Port[Base];
    IF (BufferPos < MaxBuf) THEN
      Inc(BufferPos)
    ELSE
      BufferPos := 1;
    Port[MasterIntCtl] := $20;
    IF SlaveIRQ THEN
      Port[SlaveIntCtl] := $20;  { EOI fr Slave-Controller }
  END;
END;


{$F+}
PROCEDURE Com4_Int;  { wird vom V24-Interrupt (COM4:) angesprochen }
{$F-}
interrupt;
BEGIN
  WITH Com[4] DO BEGIN
    V24Buffer[BufferPos] := Port[Base];
    IF (BufferPos < MaxBuf) THEN
      Inc(BufferPos)
    ELSE
      BufferPos := 1;
    Port[MasterIntCtl] := $20;
    IF SlaveIRQ THEN
      Port[SlaveIntCtl] := $20;  { EOI fr Slave-Controller }
  END;
END;


{$F+}
PROCEDURE Com1_FiFo_Int;  { wird vom V24-Interrupt (COM1:) angesprochen }
{$F-}
interrupt;

VAR  IIReg     : Byte;    { Inhalt des IIR }

BEGIN
  WITH Com[1] DO BEGIN
    IIReg := Port[Base+IIR];
    WHILE (IIReg <> $C1) DO
     BEGIN

       CASE IIReg OF
        $C4,$CC  : WHILE ((Port[Base+LSR] AND $01) = $01) DO
                    BEGIN
                      V24Buffer[BufferPos] := Port[Base];
                      IF (BufferPos < MaxBuf) THEN
                        Inc(BufferPos)
                      ELSE
                        BufferPos := 1;
                    END;
        $C2      :  BEGIN
                      Inc(RS232_Error);
                    END;
        $C6      :  BEGIN
                      i := Port[Base+LSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
        $C0      :  BEGIN
                      i := Port[Base+MSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
       END;

       IIReg := Port[Base+IIR];
     END;
  END;
  Port[MasterIntCtl] := $20;
END;


{$F+}
PROCEDURE Com2_FiFo_Int;  { wird vom V24-Interrupt (COM2:) angesprochen }
{$F-}
interrupt;

VAR  IIReg     : Byte;    { Inhalt des IIR }

BEGIN
  WITH Com[2] DO BEGIN
    IIReg := Port[Base+IIR];
    WHILE (IIReg <> $C1) DO
     BEGIN

       CASE IIReg OF
        $C4,$CC  : WHILE ((Port[Base+LSR] AND $01) = $01) DO
                    BEGIN
                      V24Buffer[BufferPos] := Port[Base];
                      IF (BufferPos < MaxBuf) THEN
                        Inc(BufferPos)
                      ELSE
                        BufferPos := 1;
                    END;
        $C2      :  BEGIN
                      Inc(RS232_Error);
                    END;
        $C6      :  BEGIN
                      i := Port[Base+LSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
        $C0      :  BEGIN
                      i := Port[Base+MSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
       END;

       IIReg := Port[Base+IIR];
     END;
  END;
  Port[MasterIntCtl] := $20;
END;


{$F+}
PROCEDURE Com3_FiFo_Int;  { wird vom V24-Interrupt (COM3:) angesprochen }
{$F-}
interrupt;

VAR  IIReg     : Byte;    { Inhalt des IIR }

BEGIN
  WITH Com[3] DO BEGIN
    IIReg := Port[Base+IIR];
    WHILE (IIReg <> $C1) DO
     BEGIN

       CASE IIReg OF
        $C4,$CC  : WHILE ((Port[Base+LSR] AND $01) = $01) DO
                    BEGIN
                      V24Buffer[BufferPos] := Port[Base];
                      IF (BufferPos < MaxBuf) THEN
                        Inc(BufferPos)
                      ELSE
                        BufferPos := 1;
                    END;
        $C2      :  BEGIN
                      Inc(RS232_Error);
                    END;
        $C6      :  BEGIN
                      i := Port[Base+LSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
        $C0      :  BEGIN
                      i := Port[Base+MSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
       END;

       IIReg := Port[Base+IIR];
     END;
    Port[MasterIntCtl] := $20;
    IF SlaveIRQ THEN
      Port[SlaveIntCtl] := $20;  { EOI fr Slave-Controller }
  END;
END;


{$F+}
PROCEDURE Com4_FiFo_Int;  { wird vom V24-Interrupt (COM4:) angesprochen }
{$F-}
interrupt;

VAR  IIReg     : Byte;    { Inhalt des IIR }

BEGIN
  WITH Com[4] DO BEGIN
    IIReg := Port[Base+IIR];
    WHILE (IIReg <> $C1) DO
     BEGIN

       CASE IIReg OF
        $C4,$CC  : WHILE ((Port[Base+LSR] AND $01) = $01) DO
                    BEGIN
                      V24Buffer[BufferPos] := Port[Base];
                      IF (BufferPos < MaxBuf) THEN
                        Inc(BufferPos)
                      ELSE
                        BufferPos := 1;
                    END;
        $C2      :  BEGIN
                      Inc(RS232_Error);
                    END;
        $C6      :  BEGIN
                      i := Port[Base+LSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
        $C0      :  BEGIN
                      i := Port[Base+MSR];   { Interrupt lschen }
                      Inc(RS232_Error);
                    END;
       END;

       IIReg := Port[Base+IIR];
     END;
    Port[MasterIntCtl] := $20;
    IF SlaveIRQ THEN
      Port[SlaveIntCtl] := $20;  { EOI fr Slave-Controller }
  END;
END;


{-----------------------------------------------------------------------------
|  V24_Close  setzt alle Vektoren wieder zurck
+----------------------------------------------------------------------------}

PROCEDURE V24_Close;

 VAR i   : BYTE;

BEGIN
  Inline(CLI);
  FOR i := 1 TO 4 DO
   IF Com[i].active THEN
    BEGIN
      Port[Com[i].Base+IER] := Com[i].Old_IER;
      Port[Com[i].Base+MCR] := Port[Com[i].Base+MCR] AND $F7;
      SetIntVec(Com[i].IntNummer,Com[i].Old_Vector);
      IF Com[i].FiFoMode THEN
        Port[Com[i].Base+FCR] := $00;      { FiFo aus }
      Com[i].active := FALSE;
    END;
  Port[MasterIntCtl+1] := Old_Master_IntMask;
  IF Slave_IntMask_save THEN
   BEGIN
     Port[SlaveIntCtl+1] := Old_Slave_IntMask;
     Slave_IntMask_save := FALSE;
   END;
  Inline(STI);
END;


{-----------------------------------------------------------------------------
|  Eine der V24-Schnittstellen initialisieren
+----------------------------------------------------------------------------}

PROCEDURE V24_Init(ComNummer : Byte; re_Init : BOOLEAN);

VAR   b       : INTEGER;
      Dummy   : Byte;

BEGIN
  IF (ComNummer = 5) THEN
   BEGIN
     IF NOT TFPCR_installed THEN BEGIN
       WRITELN;
       WRITELN(^G'TFPCR/TFPCX-Treiber nicht installiert !!!');
       Halt;
     END;
     Exit;
   END;
  WITH Com[ComNummer] DO BEGIN
    IF active AND NOT re_Init THEN Exit;
    IF (Base = 0) THEN BEGIN
      { Schnittstelle nicht installiert ! }
      WRITELN;
      WRITELN(^G'Schnittstelle fr COM',ComNummer,': nicht installiert !!!');
      Halt;
    END;

    b := Round(115200 / BaudRate);

    Inline(CLI);

    Port[Base+FCR] := $01;     { FiFo-Mode des 16550 einschalten }
    IF ((Port[Base+FCR] AND $C0) = $C0) THEN
     BEGIN
       { FiFo ist noch eingeschaltet, also 16550 vorhanden }
       FiFoMode := TRUE;
       Port[Base+FCR] := $C7;  { FiFo ein, clear RX and TX FiFo }
       Port[Base+FCR] := $C1;  { trigger level 14 bytes }
     END;

    Dummy := Port[Base];       { Dummy-Lesen der Schnitte gegen Hnger... }
    Dummy := Port[Base];
    Port[Base+LCR]:=$80;       { LCR : DLAB=1 }
    Port[Base+LoBaud]:=Lo(b);  { $06 = 19200 bd, $0C = 9600, $18 = 4800 }
    Port[Base+HiBaud]:=Hi(b);  { HI Baud }
    Port[Base+LCR]:=$03;       { LCR NoParity 8Data 1Stop : DLAB=0 }
    Port[Base+MCR]:=$0B;       { MCR rts und dtr = H }
    IF NOT re_Init THEN
      Old_IER := Port[Base+IER]; { Alten Interruptstatus speichern }
    Port[Base+IER]:=$01;       { Interrupt bei Empfangsdaten }
    BufferPos := 1;
    UserPos := 1;

    IF (IntNummer >= $70) THEN
      SlaveIRQ := TRUE;

    IF FiFoMode THEN
      Neu_IRQ_Adr := IRQ_Adr[2,ComNummer]
    ELSE
      Neu_IRQ_Adr := IRQ_Adr[1,ComNummer];

    IF NOT re_Init THEN
      GetIntVec(IntNummer,Old_Vector);
    SetIntVec(IntNummer,Neu_IRQ_Adr);

    active := TRUE;
    active_Com := ComNummer;

    { das entsprechende Bit im Interrupt-Mask-Register zu Null setzen }
    IF (NOT SlaveIRQ) THEN
      { XT-Interrupt ($08..$0F) }
      Port[MasterIntCtl+1] :=
         Port[MasterIntCtl+1] AND ($FF - (1 SHL (Com[ComNummer].IntNummer - 8)))
    ELSE
      BEGIN
        { AT-Interrupt ($70..$77) }
        Port[SlaveIntCtl+1] :=
          Port[SlaveIntCtl+1] AND ($FF - (1 SHL (Com[ComNummer].IntNummer - $70)));
      END;

    Inline(STI);

  END;  { WITH Com[ComNummer] ... }
END;


FUNCTION Zeichen : BOOLEAN;
 BEGIN
   IF (active_Com = 5) THEN
     Zeichen := TFPCR_Zeichen
   ELSE
     Zeichen := (Com[active_Com].BufferPos <> Com[active_Com].UserPos);
 END;


PROCEDURE WRITEAux (Zeile : String);
 VAR   i  : INTEGER;
 BEGIN
{$IFDEF DEBUG}
   IF Debug.Status > 0 THEN
     IF Debug.ScanPort = active_Com THEN
       Debug_Put(0,0,94,Zeile);
{$ENDIF}
   IF (active_Com = 5) THEN
     TFPCR_Write(Zeile)
   ELSE
     WITH Com[active_Com] DO BEGIN
       FOR i := 1 TO Length(Zeile) DO BEGIN
         REPEAT UNTIL (Port[Base+LSR] AND 32) = 32;
         Port[Base] := Ord(Zeile[i]);
       END;
     END;
 END;


FUNCTION ReadV24 : CHAR;

{$IFDEF DEBUG}
 VAR    chx        : CHAR;
{$ENDIF}

 BEGIN
{$IFDEF DEBUG}
   IF (active_Com = 5) THEN
     chx := TFPCR_Read
   ELSE
     WITH Com[active_Com] DO BEGIN
       chx := Chr(V24Buffer[UserPos]);
       IF (UserPos >= MaxBuf) THEN
         UserPos := 1
       ELSE
         Inc(UserPos);
     END;
   IF Debug.Status > 0 THEN
     IF Debug.ScanPort = active_Com THEN
       Debug_Put(0,0,23,chx);
   ReadV24 := chx;
{$ELSE}
   IF (active_Com = 5) THEN
     ReadV24 := TFPCR_Read
   ELSE
     WITH Com[active_Com] DO BEGIN
       ReadV24 := Chr(V24Buffer[UserPos]);
       IF (UserPos >= MaxBuf) THEN
         UserPos := 1
       ELSE
         Inc(UserPos);
     END;
{$ENDIF}
 END;


PROCEDURE ResyncError;
 VAR   Kanal    : INTEGER;
       xxx      : INTEGER;
 BEGIN
   { ReSync nicht erfolgreich ! }
   KBDfree;
   SetCursorSize (CursorMerker);     { alten Cursor restaurieren }
   NormVideo;
   CLrScr;
   WRITELN;
   WRITELN('Re-Synchronisation war leider nicht erfolgreich!');
   FOR Kanal := 0 TO maxLink DO
   BEGIN
     { Files aller Kanle schlieen, damit nichts verloren geht }
     IF K[Kanal]^.Save THEN BEGIN
       {$I-}
       CLOSE(K[Kanal]^.RXFile);    {$I+}
       xxx := IOResult;
       K[Kanal]^.Save := FALSE;
     END;
   END;

   WRITELN('Alle Files wurden geschlossen.');
   WRITELN('Programm abgebrochen!');
   TextAttr := low;
   WRITELN;
   WRITE('Ende  ');
   TextAttr := norm;
   WRITE('TURBOPR');
   TextAttr := low;
   WRITELN('  ',Date,'  ',Time);
   NormVideo;

   V24_Close;
   HALT(0);
 END;


{------------------------------------------------------------------------------
| Hostmode Synchronisation wiederherstellen (Nach KB5MU Hostmode Guide)
| Zum Teil bernommen aus PCT von Chris, DD6CV
+-----------------------------------------------------------------------------}

FUNCTION ReSync;

VAR     i         : INTEGER;
        ch1       : CHAR;
        AMerk     : BYTE;
        FXPos,
        FYPos     : INTEGER;

BEGIN
  AMerk := TextAttr;
  Inc(Resync_Z);
  IF ScreenStby THEN
    ClrScr;                  { Standby-Logo lschen }
  Beep(1800,150);
  Delay(5*DelayCorr);
  Beep(1800,150);
  FXPos := (80-40) DIV 2;
  FYPos := (MaxY-11) DIV 2;
  Fenster(FXPos,FYPos,40,11,'Hostmode-RESYNCHRONISATION');
  gotoxy(FXPos+2,FYPos+2);
  TextAttr := FBlinkAttr;
  WRITELN('Hostmode-Synchronisation');
  gotoxy(FXPos+2,whereY);
  WRITELN('ist gestrt!');
  WRITELN;
  TextAttr := FHighAttr;
  gotoxy(FXPos+2,whereY);
  WRITELN('Re-Synchronisation wird versucht');
  gotoxy(FXPos+2,whereY);
  WRITELN('Abbruch durch ctrl-C');
  WRITELN;
  TextAttr := FNormAttr;
  gotoxy(FXPos+2,WhereY);
  WRITE('>>> Versuch Nr.     ');
  TextAttr := FHighAttr;

  FOR i:=1 TO 10 DO
   BEGIN
     WHILE Zeichen DO
       ch1 := READV24;
     SysDelay(1);
   END;

  KbdFree;
  i:=0;
  REPEAT
    WRITEaux(^A);                      { CTRL-A schicken                     }
    WRITE(^H^H^H^H,i:4);               { Anzahl der Versuche anzeigen        }
    SysDelay(2);                       { ca. 100 mSek warten                 }
    Inc(i);
    IF Keypressed THEN BEGIN
      ch1 := Readkey;
      IF ch1 = #3 THEN ResyncError;
    END;
  UNTIL (i = 256) OR Zeichen;          { 256 ^A oder bis TNC antwortet       }

  IF Zeichen THEN                      { TNC hat geantwortet, also noch im   }
   BEGIN                               { Hostmode                            }
     FOR i:=1 TO 10 DO
      BEGIN
        WHILE Zeichen DO
          ch1 := READV24;
        SysDelay(1);
      END;
     ReSync:=TRUE;
   END
  ELSE                                 { TNC hat nicht geantwortet, also     }
    ReSync:=FALSE;                     { nicht (mehr) im Hostmode            }
  TextAttr := AMerk;
  IF ScreenStby THEN
   BEGIN
     ClrScr;                           { Bildschirm-Schoner noch aktiv }
     Stby_Logo;
   END
  ELSE
    restore_Screen;                    { Bildschirm wieder aufbauen }
END;


{------------------------------------------------------------------------------
| Zeichen von der Schnittstelle lesen, dabei Timeout beachten.
+-----------------------------------------------------------------------------}

PROCEDURE READaux(VAR ch232 : CHAR; VAR Sync_OK : BOOLEAN);

BEGIN
  Sync_OK := true;
  IF NOT Zeichen THEN
  BEGIN
    Timer[ResyncTmr] := Sec3;    { 3 Sekunden Timeout }
    REPEAT
      Dec_Timer;
    UNTIL Zeichen OR (Timer[ResyncTmr] = 0);   { auf Zeichen oder Timer warten }
    IF Timer[ResyncTmr] = 0 THEN BEGIN
      { TNC hat nicht geantwortet ... }
      Sync_OK := false;
      IF NOT ReSync THEN ResyncError;
    END;
  END;
  IF Sync_OK THEN
    ch232 := READV24
  ELSE
    ch232 := #0;
END;


{------------------------------------------------------------------------------
|  Den gewnschten TNC einschalten
+-----------------------------------------------------------------------------}

PROCEDURE switch_TNC(TNCNummer : Byte);

 BEGIN
   IF (active_TNC <> TNCNummer) THEN
    BEGIN
      { Umschaltung auf anderen TNC erforderlich }
      active_TNC := TNCNummer;
      active_Com := TNC[active_TNC].RS232;

      IF (active_Com = 5) THEN Exit;

      WITH Com[active_Com] DO BEGIN
        CASE TNC[active_TNC].RS232_Switch OF
         1 : Port[Base+MCR] := ($08 + $03);
         2 : Port[Base+MCR] := ($08 + $02);
         3 : Port[Base+MCR] := ($08 + $01);
         4 : Port[Base+MCR] := ($08 + $00);
         ELSE
             BEGIN
               WRITELN;
               WRITELN(^G^G'Falsche TNC-Konfiguration im File CONFIG.PR !!!');
               WRITELN('(active_TNC = ',active_TNC,')');
               V24_Close;
               SysDelay(Sec2);
               halt;
             END;
        END;
        Delay(2);       { fr alle Flle ... knnte sicher auch fehlen... }
      END;
    END;
 END;


BEGIN

  {---------------------------------------------------------------------------
  |  UNIT-Initialisierung
  +--------------------------------------------------------------------------}

  Old_Master_IntMask := Port[MasterIntCtl+1];
  Slave_IntMask_save := FALSE;       { Slave-Int-Maske noch nicht gespeichert }
  FOR i := 1 TO 4 DO WITH Com[i] DO
   BEGIN
     active := FALSE;
     Base := ComPortBase[i];
     SlaveIRQ := FALSE;              { (noch) kein AT-Interrupt }
     FiFoMode := FALSE;              { (noch) kein 16550 detektiert }
     RS232_Error := 0;
   END;
  Com[1].IntNummer := 8 + 4;
  Com[2].IntNummer := 8 + 3;
  Com[3].IntNummer := 8 + 5;         {LPT2:-IRQ}
  Com[4].IntNummer := 8 + 7;         {LPT1:-IRQ}

  IRQ_Adr[1,1] := @Com1_Int;         { Adressen der neuen Interrupt-Routinen }
  IRQ_Adr[1,2] := @Com2_Int;
  IRQ_Adr[1,3] := @Com3_Int;
  IRQ_Adr[1,4] := @Com4_Int;
  IRQ_Adr[2,1] := @Com1_FiFo_Int;
  IRQ_Adr[2,2] := @Com2_FiFo_Int;
  IRQ_Adr[2,3] := @Com3_FiFo_Int;
  IRQ_Adr[2,4] := @Com4_FiFo_Int;

END.
