
{------------------------------------------------------------------------------
|
|  P R V 2 4 O S 2 . P A S
|
|  Bedienung der bis zu 4 Schnittstellen + Hardware-Umschaltung + TFPCR/X
|  Hier als Version fr OS/2 im Polling-Betrieb in Verbindung mit einem
|  OS/2-Sio-Treiber
|
|  DL1BHO  04/1994
|
+-----------------------------------------------------------------------------}

UNIT PRV24OS2;

{$A+}    { WORD-Ausrichtung }
{$B-}    { keine vollstndige bool'sche Auswertung }
{$E-}    { kein 80x87-Emul }
{$X-}    { keine erweiterte Syntax }
{$V-}    { keine berprfung von Var-Strings }
{$I+}    { I/O-Prfung ein }
{$O-}    { keine Overlay-Fhigkeit }

{$IFDEF OS2}
{$G+}           { 80286-Code bei OS/2 }
{$ENDIF}


INTERFACE


CONST
       CLI          = $FA;
       STI          = $FB;

TYPE
       ComType      = RECORD
                        active      : BOOLEAN;
                        Base        : INTEGER;
                        BaudRate    : LongInt;
                      END;

VAR
       Com          : ARRAY [1..4] OF ComType;
       active_Com   : Byte;
       ComPortBase  : ARRAY [1..4] OF WORD ABSOLUTE $0:$0400;
                              { Adressen der ComPorts stehen im Ram }


  PROCEDURE V24_Init (ComNummer : Byte; re_Init : BOOLEAN);
  FUNCTION  Zeichen : BOOLEAN;
  PROCEDURE WRITEaux(Zeile : STRING);
  FUNCTION  ReSync:BOOLEAN;
  PROCEDURE READaux(VAR ch232 : CHAR; VAR Sync_OK : BOOLEAN);
  PROCEDURE V24_Close;
  PROCEDURE switch_TNC(TNCNummer : Byte);

{------------------------------------------------------------------------------
| Ende Interface
+-----------------------------------------------------------------------------}


IMPLEMENTATION


USES
       Dos,
       Crt,
       PRDefs,
       PRLib,
       PRLib2,
{$IFDEF DEBUG}
       PRDebug,
{$ENDIF}
       PRTFPCR;

CONST
       LoBaud    = 0;   { Baudraten-Teiler }
       HiBaud    = 1;
       IER       = 1;   { Interrupt Enable Register }
       IIR       = 2;   { Interrupt Ident Register }
       FCR       = 2;   { FiFo Control Register }
       LCR       = 3;   { Line Control Register }
       MCR       = 4;   { Modem Control Register }
       LSR       = 5;   { Line Status Register }
       MSR       = 6;   { Modem Status Register }

VAR
       i         : INTEGER;


{-----------------------------------------------------------------------------
|  V24_Close  setzt alle Vektoren wieder zurck
+----------------------------------------------------------------------------}

PROCEDURE V24_Close;

 VAR i   : BYTE;

BEGIN
  Inline(CLI);
  FOR i := 1 TO 4 DO
   IF Com[i].active THEN
    BEGIN
      Port[Com[i].Base+MCR] := Port[Com[i].Base+MCR] AND $F7;
      Com[i].active := FALSE;
    END;
  Inline(STI);
END;


{-----------------------------------------------------------------------------
|  Eine der V24-Schnittstellen initialisieren
+----------------------------------------------------------------------------}

PROCEDURE V24_Init(ComNummer : Byte; re_Init : BOOLEAN);

VAR   b       : INTEGER;
      Dummy   : Byte;

BEGIN
  IF (ComNummer = 5) THEN
   BEGIN
     IF NOT TFPCR_installed THEN BEGIN
       WRITELN;
       WRITELN(^G'TFPCR/TFPCX-Treiber nicht installiert !!!');
       Halt;
     END;
     Exit;
   END;
  WITH Com[ComNummer] DO BEGIN
    IF active AND NOT re_Init THEN Exit;
    IF (Base = 0) THEN BEGIN
      { Schnittstelle nicht installiert ! }
      WRITELN;
      WRITELN(^G'Schnittstelle fr COM',ComNummer,': nicht installiert !!!');
      Halt;
    END;

    b := Round(115200 / BaudRate);

    Inline(CLI);

    Dummy := Port[Base];       { Dummy-Lesen der Schnitte gegen Hnger... }
    Dummy := Port[Base];
    Port[Base+LCR]:=$80;       { LCR : DLAB=1 }
    Port[Base+LoBaud]:=Lo(b);  { $06 = 19200 bd, $0C = 9600, $18 = 4800 }
    Port[Base+HiBaud]:=Hi(b);  { HI Baud }
    Port[Base+LCR]:=$03;       { LCR NoParity 8Data 1Stop : DLAB=0 }
    Port[Base+MCR]:=$0B;       { MCR rts und dtr = H }

    active := TRUE;
    active_Com := ComNummer;

    Inline(STI);

  END;  { WITH Com[ComNummer] ... }
END;


FUNCTION Zeichen : BOOLEAN;
 BEGIN
   IF (active_Com = 5) THEN
     Zeichen := TFPCR_Zeichen
   ELSE
     Zeichen := (Port[Com[active_Com].Base+LSR] AND $01) = $01;
 END;


PROCEDURE WRITEAux (Zeile : String);
 VAR   i  : INTEGER;
 BEGIN
{$IFDEF DEBUG}
   IF Debug.Status > 0 THEN
     IF Debug.ScanPort = active_Com THEN
       Debug_Put(0,0,94,Zeile);
{$ENDIF}
   IF (active_Com = 5) THEN
     TFPCR_Write(Zeile)
   ELSE
     WITH Com[active_Com] DO BEGIN
       FOR i := 1 TO Length(Zeile) DO BEGIN
         REPEAT UNTIL (Port[Base+LSR] AND 32) = 32;
         Port[Base] := Ord(Zeile[i]);
       END;
     END;
 END;


FUNCTION ReadV24 : CHAR;

{$IFDEF DEBUG}
 VAR    chx        : CHAR;
{$ENDIF}

 BEGIN
{$IFDEF DEBUG}
   IF (active_Com = 5) THEN
     chx := TFPCR_Read
   ELSE
     WITH Com[active_Com] DO BEGIN
       chx := Chr(Port[Base]);
     END;
   IF Debug.Status > 0 THEN
     IF Debug.ScanPort = active_Com THEN
       Debug_Put(0,0,23,chx);
   ReadV24 := chx;
{$ELSE}
   IF (active_Com = 5) THEN
     ReadV24 := TFPCR_Read
   ELSE
     WITH Com[active_Com] DO BEGIN
       ReadV24 := Chr(Port[Base]);
     END;
{$ENDIF}
 END;


PROCEDURE ResyncError;
 VAR    Kanal    : INTEGER;
        xxx      : INTEGER;
 BEGIN
   { ReSync nicht erfolgreich ! }
   KBDfree;
   SetCursorSize (CursorMerker);     { alten Cursor restaurieren }
   NormVideo;
   CLrScr;
   WRITELN;
   WRITELN('Re-Synchronisation war leider nicht erfolgreich!');
   FOR Kanal := 0 TO maxLink DO
   BEGIN
     { Files aller Kanle schlieen, damit nichts verloren geht }
     IF K[Kanal]^.Save THEN BEGIN
       {$I-}
       CLOSE(K[Kanal]^.RXFile);    {$I+}
       xxx := IOResult;
       K[Kanal]^.Save := FALSE;
     END;
   END;

   WRITELN('Alle Files wurden geschlossen.');
   WRITELN('Programm abgebrochen!');
   TextAttr := low;
   WRITELN;
   WRITE('Ende  ');
   TextAttr := norm;
   WRITE('TURBOPR');
   TextAttr := low;
   WRITELN('  ',Date,'  ',Time);
   NormVideo;

   V24_Close;
   HALT(0);
 END;


{------------------------------------------------------------------------------
| Hostmode Synchronisation wiederherstellen (Nach KB5MU Hostmode Guide)
| Zum Teil bernommen aus PCT von Chris, DD6CV
+-----------------------------------------------------------------------------}

FUNCTION ReSync;

VAR     i         : INTEGER;
        ch1       : CHAR;
        AMerk     : BYTE;
        FXPos,
        FYPos     : INTEGER;

BEGIN
  AMerk := TextAttr;
  Inc(Resync_Z);
  IF ScreenStby THEN
    ClrScr;                  { Standby-Logo lschen }
  Beep(1800,150);
  Delay(5*DelayCorr);
  Beep(1800,150);
  FXPos := (80-40) DIV 2;
  FYPos := (MaxY-11) DIV 2;
  Fenster(FXPos,FYPos,40,11,'Hostmode-RESYNCHRONISATION');
  gotoxy(FXPos+2,FYPos+2);
  TextAttr := FBlinkAttr;
  WRITELN('Hostmode-Synchronisation');
  gotoxy(FXPos+2,whereY);
  WRITELN('ist gestrt!');
  WRITELN;
  TextAttr := FHighAttr;
  gotoxy(FXPos+2,whereY);
  WRITELN('Re-Synchronisation wird versucht');
  gotoxy(FXPos+2,whereY);
  WRITELN('Abbruch durch ctrl-C');
  WRITELN;
  TextAttr := FNormAttr;
  gotoxy(FXPos+2,WhereY);
  WRITE('>>> Versuch Nr.     ');
  TextAttr := FHighAttr;

  FOR i:=1 TO 10 DO
   BEGIN
     WHILE Zeichen DO
       ch1 := READV24;
     SysDelay(1);
   END;

  KbdFree;
  i:=0;
  REPEAT
    WRITEaux(^A);                      { CTRL-A schicken                     }
    WRITE(^H^H^H^H,i:4);               { Anzahl der Versuche anzeigen        }
    SysDelay(2);                       { ca. 100 mSek warten                 }
    Inc(i);
    IF Keypressed THEN BEGIN
      ch1 := Readkey;
      IF ch1 = #3 THEN ResyncError;
    END;
  UNTIL (i = 256) OR Zeichen;          { 256 ^A oder bis TNC antwortet       }

  IF Zeichen THEN                      { TNC hat geantwortet, also noch im   }
   BEGIN                               { Hostmode                            }
     FOR i:=1 TO 10 DO
      BEGIN
        WHILE Zeichen DO
          ch1 := READV24;
        SysDelay(1);
      END;
     ReSync:=TRUE;
   END
  ELSE                                 { TNC hat nicht geantwortet, also     }
    ReSync:=FALSE;                     { nicht (mehr) im Hostmode            }
  TextAttr := AMerk;
  IF ScreenStby THEN
   BEGIN
     ClrScr;                           { Bildschirm-Schoner noch aktiv }
     Stby_Logo;
   END
  ELSE
    restore_Screen;                    { Bildschirm wieder aufbauen }
END;


{------------------------------------------------------------------------------
| Zeichen von der Schnittstelle lesen, dabei Timeout beachten.
+-----------------------------------------------------------------------------}

PROCEDURE READaux(VAR ch232 : CHAR; VAR Sync_OK : BOOLEAN);

BEGIN
  Sync_OK := true;
  IF NOT Zeichen THEN
  BEGIN
    Timer[ResyncTmr] := Sec3;    { 3 Sekunden Timeout }
    REPEAT
      Dec_Timer;
    UNTIL Zeichen OR (Timer[ResyncTmr] = 0);   { auf Zeichen oder Timer warten }
    IF Timer[ResyncTmr] = 0 THEN BEGIN
      { TNC hat nicht im Timeout geantwortet ... }
      Sync_OK := false;
      IF NOT ReSync THEN ResyncError;
    END;
  END;
  IF Sync_OK THEN
    ch232 := READV24
  ELSE
    ch232 := #0;
END;


{------------------------------------------------------------------------------
|  Den gewnschten TNC einschalten
+-----------------------------------------------------------------------------}

PROCEDURE switch_TNC(TNCNummer : Byte);

 BEGIN
   IF (active_TNC <> TNCNummer) THEN
    BEGIN
      { Umschaltung auf anderen TNC erforderlich }
      active_TNC := TNCNummer;
      active_Com := TNC[active_TNC].RS232;

      IF (active_Com = 5) THEN Exit;

      WITH Com[active_Com] DO BEGIN
        CASE TNC[active_TNC].RS232_Switch OF
         1 : Port[Base+MCR] := ($08 + $03);
         2 : Port[Base+MCR] := ($08 + $02);
         3 : Port[Base+MCR] := ($08 + $01);
         4 : Port[Base+MCR] := ($08 + $00);
         ELSE
             BEGIN
               WRITELN;
               WRITELN(^G^G'Falsche TNC-Konfiguration im File CONFIG.PR !!!');
               WRITELN('(active_TNC = ',active_TNC,')');
               V24_Close;
               SysDelay(Sec2);
               halt;
             END;
        END;
        Delay(2);       { fr alle Flle ... knnte sicher auch fehlen... }
      END;
    END;
 END;


BEGIN

  {---------------------------------------------------------------------------
  |  UNIT-Initialisierung
  +--------------------------------------------------------------------------}
  FOR i := 1 TO 4 DO WITH Com[i] DO
   BEGIN
     active := FALSE;
{$IFNDEF OS2}
     Base := ComPortBase[i];
{$ENDIF}
   END;
END.
