
{------------------------------------------------------------------------------
|
|   P W G E N . P A S
|
|   Passwort-Files generieren
|
|   ACHTUNG !!!  Neue Version !  Der Filename fuer TurboPR stimmt nur
|   fuer TurboPR ab Version 2.7 !!
|
|   bersetzung dieses Files nur noch mit Turbo Pascal ab V4.0 mglich !!
|
|   Es werden 3 Files generiert:
|
|     - PWLIST.TXT         fr 'DIE BOX' von DF3AV
|     - PW<BoxCall>.PR     fr 'TurboPR' von DL1BHO
|     - PW<BoxCall>.TXT    als 'anwenderfreundliche' Liste
|
|   DL1BHO, im November 1990
|
+-----------------------------------------------------------------------------}


Uses
       Crt;

CONST
       WerteVorrat : SET OF CHAR = ['0'..'9','A'..'Z','a'..'z'];

TYPE
       Str80       = STRING [80];

VAR
       DieBox      : TEXT;
       TurboPR     : TEXT;
       User        : TEXT;
       TPName      : String [20];
       UserName    : String [20];
       Zeile       : String [30];
       BoxCall     : String [6];
       i,S,Z,k     : INTEGER;
       ch          : CHAR;


FUNCTION UpcaseStr (Zeile : STRING) : STRING;
VAR i   : BYTE;
BEGIN
  FOR i := 1 TO Length(Zeile) DO
    Zeile [i] := Upcase(Zeile[i]);
  UpcaseStr := Zeile;
END;


PROCEDURE File_vorhanden (VAR ZielFile : Text ; Zeile : Str80);
VAR   ch   : char;
BEGIN
  CLOSE(ZielFile);
  WRITE(^G,'Das File ',Zeile,' ist schon vorhanden! Lschen (J/N) ?  ');
  REPEAT
    ch := UPCASE(ReadKey);
  UNTIL ch IN ['J','N'];
  WRITELN;

  IF ch = 'N' THEN
  BEGIN
    WRITELN; WRITELN ('Passwort-Routine abgebrochen !');
    halt;
  END;
END;


BEGIN

  Assign(Output,'');
  Rewrite(Output);

  WRITELN;
  WRITELN;
  WRITELN('P W G E N');
  WRITELN('');
  WRITELN;
  WRITELN('Generierung der Passwort-Dateien fr DieBox und TurboPR');
  WRITELN(^M^J^J);

  WRITE('Rufzeichen der Mailbox (ohne SSID): ');
  READLN(BoxCall);
  BoxCall := UpcaseStr(BoxCall);

  Assign(DieBox,'PWLIST.TXT');
  (*$I-*) Reset(DieBox); (*$I+*)
  IF IOResult = 0 THEN File_vorhanden(DieBox,'PWLIST.TXT (fr DieBox)');
  REWRITE(DieBox);

  TPName := 'PW' + BoxCall + '.PR';
  Assign(TurboPR,TPName);
  (*$I-*) Reset(TurboPR); (*$I+*)
  IF IOResult = 0 THEN File_vorhanden(TurboPR,TPName+' (fr TurboPR)');
  REWRITE(TurboPR);

  UserName := 'PW' + BoxCall + '.TXT';
  Assign(User,UserName);
  (*$I-*) Reset(User); (*$I+*)
  IF IOResult = 0 THEN File_vorhanden(User,UserName);
  REWRITE(User);

  WRITELN(User);
  WRITELN(User,'          0                  10                  20');
  WRITELN(User,'          0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3');
  WRITELN(User,'     ----------------------------------------------------------');

  WRITELN;

  Zeile[0] := #27;

  Randomize;            { Zufallsgenerator verwirren }

  FOR Z := 0 TO 59 DO
  BEGIN
    FOR S := 1 TO 27 DO
    BEGIN
      REPEAT
        ch := CHR(random(256));
      UNTIL ch IN WerteVorrat;
      Zeile[S] := ch;
    END;
    (* fuer TurboPR mit CR/LF, fuer DieBox ohne CR/LF *)
    WRITELN(Z:2,' ',Zeile);
    WRITE(DieBox,Zeile);
    WRITELN(TurboPR,Zeile);
    WRITE(User,z:7,'   ');
    FOR k := 1 TO 26 DO WRITE(User,Zeile[k],' ');
    WRITELN(User,Zeile[27]);
  END;

  CLOSE(TurboPR);
  CLOSE(DieBox);
  CLOSE(User);

  WRITELN;
  WRITELN('PWGEN OK !');
  WRITELN;
  WRITELN(' - PWLIST.TXT    fr ''DieBox'' von DF3AV');
  WRITELN(' - ',TPName,'    fr ''TurboPR'' (ab V2.7) von DL1BHO');
  WRITELN(' - ',UserName,'   fr den ''normalen'' Benutzer');
  WRITELN;
END.


{

Anleitung zur Auswahl des Passwortes:

Das Passwort besteht aus 4 Zeichen, die von der Uhrzeit und dem Datum des
Logins in 'DIE BOX' abhngen. Im Passwortfile (am besten nimmt man PW.TXT)
whlt man die SPALTE, die den STUNDEN des Logins entspricht. Fr die ZEILE
ist diejenige mageblich, die den MINUTEN entspricht. Von diesem Punkt in
der Tabelle wandert man nun soviele ZEILEN herunter, wie TAGE im Login-Datum
angezeigt werden. Beim Datum '23.03.88' wandert man also 23 Zeilen herunter,
dabei aber immer in derselben SPALTE bleiben. Beim Erreichen des Tabellenendes
macht man einfach in Zeile '0' weiter. Das Zeichen an dieser Stelle zusammen
mit den 3 nachfolgenden (waagerechten) Zeichen bilden das Passwort.

}
